/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.data.dao.impl.DAOAutomaticWarning;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Societe
extends MainElement {
    public static final String table = "t_societe";
    private int cleSociete = 0;
    private String nomSociete = null;
    private String code = null;
    private String nomBase = null;
    private String directorFirstName = null;
    private String directorLastName = null;
    private String phone = null;
    private String fax = null;
    private String mail = null;
    private String address = null;
    private String city = null;
    private String postalCode = null;
    private String userDBPwd = null;
    private String ftpDirectory = null;
    private int country = 0;
    private ArrayList<AutomaticWarning> automaticWarnings = null;
    private ArrayList<Utilisateur> users = null;

    public Societe() {
    }

    public Societe(String nomSociete, String nomBase) {
        this.nomBase = nomBase;
        this.nomSociete = nomSociete;
    }

    public Societe(int cleSociete, String nomSociete, String code, String nomBase, String phone, String fax, String mail, String address, String city, String postalCode, int country, String directorFirstName, String directorLastName, String ftpDirectory, String userDBPwd) {
        this.cleSociete = cleSociete;
        this.nomSociete = nomSociete;
        this.code = code;
        this.nomBase = nomBase;
        this.phone = phone;
        this.fax = fax;
        this.mail = mail;
        this.address = address;
        this.city = city;
        this.postalCode = postalCode;
        this.country = country;
        this.directorFirstName = directorFirstName;
        this.directorLastName = directorLastName;
        this.ftpDirectory = ftpDirectory;
        this.userDBPwd = userDBPwd;
    }

    public String toString() {
        return this.nomSociete;
    }

    public boolean loadById(int id) {
        TimsLogger.debug("#Soci\u00e9t\u00e9.loadById()# load id = " + id);
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table + " WHERE CLE_SOCIETE = " + id;
        return this.genericLoad(sql);
    }

    public boolean loadByName(String companyName) {
        TimsLogger.debug("#Soci\u00e9t\u00e9.loadByName()# load name = " + companyName);
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table + " WHERE COMPANY_NAME = '" + companyName + "'";
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean retour = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Societe.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String ftpDirectory = null;
                    try {
                        ftpDirectory = rs.getString("FTP_DIRECTORY");
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("#Societe.getAll# FTP_DIRECTORY not found");
                    }
                    this.cleSociete = rs.getInt("CLE_SOCIETE");
                    this.nomSociete = rs.getString("COMPANY_NAME");
                    this.code = rs.getString("CODE");
                    this.nomBase = rs.getString("BASE_NAME");
                    this.phone = rs.getString("PHONE");
                    this.fax = rs.getString("FAX");
                    this.mail = rs.getString("mail");
                    this.address = rs.getString("ADDRESS");
                    this.city = rs.getString("CITY");
                    this.postalCode = rs.getString("POSTAL_CODE");
                    this.country = rs.getInt("COUNTRY");
                    this.directorFirstName = rs.getString("FIRST_NAME");
                    this.directorLastName = rs.getString("LAST_NAME");
                    this.ftpDirectory = ftpDirectory;
                    this.userDBPwd = rs.getString("USER_DB_PWD");
                    if (retour) {
                        TimsLogger.warn("#Societe.genericLoad# WARNING : 2 companies with the same name... conflict may appears !");
                    }
                    retour = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Societe.load() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public int getCleSociete() {
        return this.cleSociete;
    }

    public void setCleSociete(int cleSociete) {
        this.cleSociete = cleSociete;
    }

    public String getNomBase() {
        return this.nomBase;
    }

    public void setNomBase(String nomBase) {
        this.nomBase = nomBase;
    }

    public String getNomSociete() {
        return this.nomSociete;
    }

    public void setNomSociete(String nomSociete) {
        this.nomSociete = nomSociete;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public int getCountry() {
        return this.country;
    }

    public void setCountry(int country) {
        this.country = country;
    }

    public String getDirectorFirstName() {
        return this.directorFirstName;
    }

    public void setDirectorFirstName(String directorFirstName) {
        this.directorFirstName = directorFirstName;
    }

    public String getDirectorLastName() {
        return this.directorLastName;
    }

    public void setDirectorLastName(String directorLastName) {
        this.directorLastName = directorLastName;
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String ftpDirectory) {
        this.ftpDirectory = ftpDirectory;
    }

    public ArrayList<AutomaticWarning> getAutomaticWarnings() {
        if (this.automaticWarnings == null) {
            new DAOAutomaticWarning().getAll();
        }
        return this.automaticWarnings;
    }

    public void setAutomaticWarnings(ArrayList<AutomaticWarning> automaticWarnings) {
        this.automaticWarnings = automaticWarnings;
    }

    public String getUserDBPwd() {
        return this.userDBPwd;
    }

    public void setUserDBPwd(String userDBPwd) {
        this.userDBPwd = userDBPwd;
    }

    public ArrayList<Utilisateur> getUsers() {
        if (this.users == null) {
            Utilisateur.list(this.nomSociete);
        }
        return this.users;
    }

    public void setUsers(ArrayList<Utilisateur> users) {
        this.users = users;
    }

    public boolean update() {
        if (this.cleSociete != 0) {
            return this.updateValue();
        }
        return this.insert();
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (CLE_SOCIETE, COMPANY_NAME, CODE, BASE_NAME, PHONE, FAX, MAIL, ADDRESS, CITY, POSTAL_CODE, COUNTRY, FIRST_NAME, LAST_NAME, USER_DB_PWD)" + " VALUES (GEN_T_SOCIETE.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (COMPANY_NAME, CODE, BASE_NAME, PHONE, FAX, MAIL, ADDRESS, CITY, POSTAL_CODE, COUNTRY, FIRST_NAME, LAST_NAME, USER_DB_PWD)" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = Societe.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.nomSociete, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.nomBase, 12);
            this.statement.setObject(4, (Object)this.phone, 12);
            this.statement.setObject(5, (Object)this.fax, 12);
            this.statement.setObject(6, (Object)this.mail, 12);
            this.statement.setObject(7, (Object)this.address, 12);
            this.statement.setObject(8, (Object)this.city, 12);
            this.statement.setObject(9, (Object)this.postalCode, 12);
            this.statement.setObject(10, (Object)this.country, 4);
            this.statement.setObject(11, (Object)this.directorFirstName, 12);
            this.statement.setObject(12, (Object)this.directorLastName, 12);
            this.statement.setObject(13, (Object)this.userDBPwd, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean updateValue() {
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET" + " COMPANY_NAME=? ," + " CODE=? ," + " BASE_NAME=? ," + " PHONE=? ," + " FAX=? ," + " MAIL=? ," + " ADDRESS=? ," + " CITY=? ," + " POSTAL_CODE=? ," + " COUNTRY=? ," + " FIRST_NAME=? ," + " LAST_NAME=?" + " WHERE CLE_SOCIETE=?";
        try {
            this.statement = Societe.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.nomSociete, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.nomBase, 12);
            this.statement.setObject(4, (Object)this.phone, 12);
            this.statement.setObject(5, (Object)this.fax, 12);
            this.statement.setObject(6, (Object)this.mail, 12);
            this.statement.setObject(7, (Object)this.address, 12);
            this.statement.setObject(8, (Object)this.city, 12);
            this.statement.setObject(9, (Object)this.postalCode, 12);
            this.statement.setObject(10, (Object)this.country, 4);
            this.statement.setObject(11, (Object)this.directorFirstName, 12);
            this.statement.setObject(12, (Object)this.directorLastName, 12);
            this.statement.setObject(13, (Object)this.cleSociete, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean updateDBPassword(String pwd) {
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET" + " USER_DB_PWD = ? " + " WHERE CLE_SOCIETE=?";
        try {
            this.statement = Societe.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)pwd, 12);
            this.statement.setObject(2, (Object)this.cleSociete, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean compareAndUpdate(String nomSociete, String code, String phone, String fax, String mail, String address, String city, String postalCode, int country, String directorFirstName, String directorLastName) {
        if (this.cleSociete == 0) {
            TimsLogger.debug("#Societe.compareAndUpdate# Pas de soci\u00e9t\u00e9 associ\u00e9e \u00e0 l'objet");
            return false;
        }
        String tracer = String.valueOf(LanguageTranslator.getString("generics.company")) + " n\u00b0 " + this.cleSociete + " (" + this.getNomSociete() + ") \n";
        if (Fonctions.fieldChange(this.nomSociete, nomSociete)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("company.name") + " '" + this.nomSociete + "' => '" + nomSociete + "'\n";
            this.setNomSociete(nomSociete);
        }
        if (Fonctions.fieldChange(this.code, code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (Fonctions.fieldChange(this.phone, phone)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.phone") + " '" + this.phone + "' => '" + phone + "'\n";
            this.setPhone(phone);
        }
        if (Fonctions.fieldChange(this.fax, fax)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.fax") + " '" + this.fax + "' => '" + fax + "'\n";
            this.setFax(fax);
        }
        if (Fonctions.fieldChange(this.mail, mail)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.mail") + " '" + this.mail + "' => '" + mail + "'\n";
            this.setMail(mail);
        }
        if (Fonctions.fieldChange(this.address, address)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.address") + " '" + this.address + "' => '" + address + "'\n";
            this.setAddress(address);
        }
        if (Fonctions.fieldChange(this.city, city)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.city") + " '" + this.city + "' => '" + city + "'\n";
            this.setCity(city);
        }
        if (Fonctions.fieldChange(this.postalCode, postalCode)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.postalCode") + " '" + this.postalCode + "' => '" + postalCode + "'\n";
            this.setPostalCode(postalCode);
        }
        if (country != this.country) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.country") + " '" + this.country + "' => '" + country + "'\n";
            this.setCountry(country);
        }
        if (Fonctions.fieldChange(this.directorFirstName, directorFirstName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("company.directorFirstName") + " '" + this.directorFirstName + "' => '" + directorFirstName + "'\n";
            this.setDirectorFirstName(directorFirstName);
        }
        if (Fonctions.fieldChange(this.directorLastName, directorLastName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("company.directorLastName") + " '" + this.directorLastName + "' => '" + directorLastName + "'\n";
            this.setDirectorLastName(directorLastName);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.company")) + " n\u00b0 " + this.cleSociete + " (" + this.getNomSociete() + ") \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#Societe.compareAndUpdate# no changes");
        return true;
    }

    public static Vector<Societe> loadList(String companyName) {
        Vector<Societe> result = new Vector<Societe>();
        String sql = "";
        try {
            sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table;
            String filter = "";
            if (ConnexionSettings.getInstance().user != null && ConnexionSettings.getInstance().isUserRestreintSociete()) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(filter)).append(" AND COMPANY_NAME = '");
                BddTransport.getInstance();
                filter = stringBuilder.append(BddTransport.addSlashes(ConnexionSettings.getInstance().getUserSociete())).append("'").toString();
            } else if (companyName != null) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(filter)).append(" AND COMPANY_NAME = '");
                BddTransport.getInstance();
                filter = stringBuilder.append(BddTransport.addSlashes(companyName)).append("'").toString();
            }
            if (!filter.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + filter.substring(4);
            }
            sql = String.valueOf(sql) + " ORDER BY COMPANY_NAME";
            Statement stm = Societe.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                String ftpDirectory = null;
                try {
                    ftpDirectory = rs.getString("FTP_DIRECTORY");
                }
                catch (Exception ex) {
                    TimsLogger.warn("#Societe.getAll# FTP_DIRECTORY not found");
                }
                result.add(new Societe(rs.getInt("CLE_SOCIETE"), rs.getString("COMPANY_NAME"), rs.getString("CODE"), rs.getString("BASE_NAME"), rs.getString("PHONE"), rs.getString("FAX"), rs.getString("mail"), rs.getString("ADDRESS"), rs.getString("CITY"), rs.getString("POSTAL_CODE"), rs.getInt("COUNTRY"), rs.getString("FIRST_NAME"), rs.getString("LAST_NAME"), ftpDirectory, rs.getString("USER_DB_PWD")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#Societe.getList()# Exception : " + ex);
            ex.printStackTrace();
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }
}

