/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class TaskActivation
extends MainElement {
    public static final String table = "TASK_ACTIVATION";
    private int id = 0;
    private int connectorId = 0;
    private int companyId = 0;
    private String url = null;
    private String user = null;
    private String password = null;
    private boolean active = false;
    private int processType = 0;

    public TaskActivation(int id, int connectorId, int companyId, String url, String user, String password, boolean active, int processType) {
        this.id = id;
        this.connectorId = connectorId;
        this.companyId = companyId;
        this.url = url;
        this.user = user;
        this.password = password;
        this.active = active;
        this.processType = processType;
    }

    public boolean equals(Object obj) {
        return obj instanceof TaskActivation && ((TaskActivation)obj).getConnectorId() == this.connectorId && ((TaskActivation)obj).getCompanyId() == this.companyId;
    }

    public int hashCode() {
        return Integer.valueOf(this.companyId).hashCode() + Integer.valueOf(this.connectorId).hashCode();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(int taskId) {
        this.connectorId = taskId;
    }

    public int getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(int companyId) {
        this.companyId = companyId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getProcessType() {
        return this.processType;
    }

    public void setProcessType(int processType) {
        this.processType = processType;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        Statement statement = null;
        String sql = null;
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO TASK_ACTIVATION (" + TaskActivation.getAllFields() + ")" + "(GEN_" + table + ".nextval,?,?,?,?,?,?,?)";
                } else if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + "(" + TaskActivation.getAllFields().substring(TaskActivation.getAllFields().indexOf(",") + 1) + ") VALUES " + "(?,?,?,?,?,?,?)";
                }
                statement = TaskActivation.getConnection().prepareStatement(sql);
                statement.setObject(1, this.connectorId, 4);
                statement.setObject(2, this.companyId, 4);
                statement.setObject(3, this.url, 12);
                statement.setObject(4, this.user, 12);
                statement.setObject(5, this.password, 12);
                statement.setObject(6, this.active ? 1 : 0, 4);
                statement.setObject(7, this.processType, 4);
                if (statement.executeUpdate() == 1) {
                    retour = true;
                }
                statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " CONNECTOR_ID=?, " + " COMPANY_ID=?, " + " URL=?, " + " USER=?, " + " PASSWORD=?, " + " ACTIVE=?, " + " PROCESS_TYPE=? " + " WHERE ID=?";
        try {
            try {
                this.statement = TaskActivation.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.connectorId, 4);
                this.statement.setObject(2, (Object)this.companyId, 4);
                this.statement.setObject(3, (Object)this.url, 12);
                this.statement.setObject(4, (Object)this.user, 12);
                this.statement.setObject(5, (Object)this.password, 12);
                this.statement.setObject(6, (Object)(this.active ? 1 : 0), 4);
                this.statement.setObject(7, (Object)this.processType, 4);
                this.statement.setObject(8, (Object)this.id, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = TaskActivation.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private static String getAllFields() {
        return "ID, CONNECTOR_ID, COMPANY_ID, URL, USER, PASSWORD, ACTIVE, PROCESS_TYPE";
    }

    public static boolean multipleDelete(int companyId, Vector<AutomaticWarning> toDelete) {
        boolean toReturn = false;
        String where = "";
        if (toDelete != null) {
            for (AutomaticWarning iter : toDelete) {
                where = String.valueOf(where) + "," + iter.getId();
            }
        }
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table;
        if (!where.equals("")) {
            sql = String.valueOf(sql) + " WHERE ID_WARNING IN (" + where.substring(1) + ")";
        }
        Statement stm = null;
        try {
            try {
                stm = TaskActivation.getConnection().createStatement();
                stm.executeUpdate(sql);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static ArrayList<TaskActivation> getList(int companyId) {
        ArrayList<TaskActivation> toReturn = new ArrayList<TaskActivation>();
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table;
        if (companyId != -1) {
            sql = String.valueOf(sql) + " WHERE COMPANY_ID = " + companyId;
        }
        TimsLogger.debug("#CAT.getList# soci\u00e9t\u00e9 : " + companyId + " => " + sql);
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = TaskActivation.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new TaskActivation(rs.getInt("ID"), rs.getInt("CONNECTOR_ID"), rs.getInt("COMPANY_ID"), rs.getString("URL"), rs.getString("USER"), rs.getString("PASSWORD"), rs.getBoolean("ACTIVE"), rs.getInt("PROCESS_TYPE")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

