/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class TaskConnector
extends MainElement {
    public static String table = "task_connector";
    public static ArrayList<TaskConnector> list = null;
    private int id = 0;
    private String name = null;
    private String connectorClass = "NONE";
    private int processAvailable = 0;

    public TaskConnector(int cle, String name, String connectorClass, int processAvailable) {
        this.id = cle;
        this.name = name;
        this.connectorClass = connectorClass;
        this.processAvailable = processAvailable;
    }

    public boolean equals(Object obj) {
        return obj instanceof TaskConnector && this.id == ((TaskConnector)obj).getId() && this.name.equals(((TaskConnector)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#TaskConnector.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (" + TaskConnector.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (" + TaskConnector.getAllFields().substring(TaskConnector.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = TaskConnector.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.connectorClass, 12);
            this.statement.setObject(3, (Object)this.processAvailable, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + table + " SET " + " NAME=? ," + " CONNECTOR_CLASS=? ," + " TYPE=?" + " WHERE ID=?";
        try {
            this.statement = TaskConnector.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.connectorClass, 12);
            this.statement.setObject(3, (Object)this.processAvailable, 4);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(String name, String taskClass, int processAvailable) {
        String tracer = String.valueOf(LanguageTranslator.getString("TaskConnector")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (Fonctions.fieldChange(taskClass, this.connectorClass)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.class") + " '" + this.connectorClass + "' => '" + taskClass + "'\n";
            this.setConnectorClass(name);
        }
        if (processAvailable != this.processAvailable) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.processAvailable") + " '" + this.processAvailable + "' => '" + processAvailable + "'\n";
            this.setProcessAvailable(processAvailable);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("TaskConnector")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#TaskConnector# no changes");
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConnectorClass() {
        return this.connectorClass;
    }

    public void setConnectorClass(String connectorClass) {
        this.connectorClass = connectorClass;
    }

    public int getProcessAvailable() {
        return this.processAvailable;
    }

    public void setProcessAvailable(int processAvailable) {
        this.processAvailable = processAvailable;
    }

    public void print() {
        TimsLogger.info("#TaskConnector.print# id = " + this.id + ", name = " + this.name + ", taskClass = " + this.connectorClass);
    }

    private static String getAllFields() {
        return "ID, NAME, CONNECTOR_CLASS, PROCESS_AVAILABLE";
    }

    public static ArrayList<TaskConnector> getList() {
        if (list == null) {
            list = new ArrayList();
            String sql = "SELECT " + TaskConnector.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table;
            Statement stm = null;
            ResultSet rs = null;
            try {
                try {
                    stm = TaskConnector.getConnection().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        list.add(new TaskConnector(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CONNECTOR_CLASS"), rs.getInt("PROCESS_AVAILABLE")));
                    }
                }
                catch (CommunicationsException ex) {
                    BddTransport.getInstance().showTimeout();
                    try {
                        if (stm != null) {
                            stm.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    try {
                        if (stm != null) {
                            stm.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return list;
    }

    public static TaskConnector find(ArrayList<TaskConnector> list, int taskId) throws DBObjectNotFoundException {
        if (list == null) {
            list = TaskConnector.getList();
        }
        for (TaskConnector tmp : list) {
            if (tmp.getId() != taskId) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException(TaskConnector.class.getName());
    }
}

