/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class TaskReport
extends MainElement {
    public static final String table = "TASK_REPORT";
    public static final int FILE_RETRIEVED = 0;
    public static final int FILE_RECEIVED = 1;
    public static final int READ_DONE = 2;
    public static final int REPORT_SEND = 3;
    private int id = 0;
    private int taskActivationId = 0;
    private int reportType = 0;
    private String report = null;
    private Date reportDate = null;

    public TaskReport(int id, int taskActivationId, int reportType, String report, Date reportDate) {
        this.id = id;
        this.taskActivationId = taskActivationId;
        this.reportType = reportType;
        this.report = report;
        this.reportDate = reportDate;
    }

    public boolean equals(Object obj) {
        return obj instanceof TaskReport && ((TaskReport)obj).getTaskActivationId() == this.taskActivationId && ((TaskReport)obj).getReport() == this.report;
    }

    public int hashCode() {
        return this.report.hashCode() + Integer.valueOf(this.taskActivationId).hashCode();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public int getTaskActivationId() {
        return this.taskActivationId;
    }

    public void setTaskActivationId(int taskActivationId) {
        this.taskActivationId = taskActivationId;
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public Date getReportDate() {
        return this.reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        Statement statement = null;
        String sql = null;
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO TASK_REPORT (" + TaskReport.getAllFields() + ")" + "(GEN_" + table + ".nextval,?,?,?,?)";
                } else if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + "(" + TaskReport.getAllFields().substring(TaskReport.getAllFields().indexOf(",") + 1) + ") VALUES " + "(?,?,?,?)";
                }
                statement = TaskReport.getConnection().prepareStatement(sql);
                statement.setObject(1, this.taskActivationId, 4);
                statement.setObject(2, this.reportType, 4);
                statement.setObject(3, this.report, 12);
                statement.setTimestamp(4, this.reportDate != null ? new Timestamp(this.reportDate.getTime()) : null);
                if (statement.executeUpdate() == 1) {
                    retour = true;
                }
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " TASK_ACTIVATION_ID=?, " + " REPORT_TYPE=?, " + " REPORT=?, " + " REPORT_DATETIME=? " + " WHERE ID=?";
        try {
            try {
                this.statement = TaskReport.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.taskActivationId, 4);
                this.statement.setObject(2, (Object)this.reportType, 4);
                this.statement.setObject(3, (Object)this.report, 12);
                this.statement.setTimestamp(4, new Timestamp(this.reportDate.getTime()));
                this.statement.setObject(5, (Object)this.id, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = TaskReport.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private static String getAllFields() {
        return "ID, TASK_ACTIVATION_ID, REPORT_TYPE, REPORT, REPORT_DATETIME";
    }

    public static ArrayList<TaskReport> getList(int activationTaskId) {
        ArrayList<TaskReport> toReturn = new ArrayList<TaskReport>();
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table;
        if (activationTaskId != -1) {
            sql = String.valueOf(sql) + " WHERE TASK_ACTIVATION_ID = " + activationTaskId;
        }
        TimsLogger.debug("#TaskReport.getList# activationTaskId : " + activationTaskId + " => " + sql);
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = TaskReport.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new TaskReport(rs.getInt("ID"), rs.getInt("TASK_ACTIVATION_ID"), rs.getInt("REPORT_TYPE"), rs.getString("REPORT"), rs.getDate("REPORT_DATETIME")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

