/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.ActivityTypeNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class TypeActivite
extends MainElement {
    public static final int UPDATE_NEVER = 0;
    public static final int UPDATE_WITH_COMMENT = 1;
    public static final int UPDATE_ALWAYS = 2;
    public static final int UPDATABLE = 0;
    public static final int DELETABLE = 1;
    public static final int CLE_CONDUITE = 1;
    public static final int CLE_TRAVAIL = 2;
    public static final int CLE_DISPOSITION = 3;
    public static final int CLE_REPOS = 4;
    public static final int CLE_DE = 5;
    public static final int CLE_AA = 6;
    public static final int CLE_INCONNU = 7;
    public static String table = "t_type_activite";
    private static Vector<TypeActivite> list = null;
    private int cle = 0;
    private int color = 0;
    private String name = null;
    private String code = null;
    private boolean hsGenerator = false;
    private boolean rcGenerator = false;
    private boolean rest = false;
    private boolean showPaid = false;
    private boolean updatable = false;
    private int paidPercentage = 0;
    private int modificationLevel = 0;

    public TypeActivite() {
    }

    public TypeActivite(int cle, String name, String code, int color, boolean updatable, boolean hsGenerator, boolean rcGenerator, int percentage, boolean rest, int modificationLevel, boolean showPaid) {
        this.cle = cle;
        this.color = color;
        this.name = name;
        this.code = code;
        this.showPaid = showPaid;
        this.updatable = updatable;
        this.hsGenerator = hsGenerator;
        this.rcGenerator = rcGenerator;
        this.paidPercentage = percentage;
        this.rest = rest;
        this.modificationLevel = modificationLevel;
    }

    public Object clone() {
        return new TypeActivite(this.cle, this.name, this.code, this.color, this.updatable, this.hsGenerator, this.rcGenerator, this.paidPercentage, this.rest, this.modificationLevel, this.showPaid);
    }

    public boolean loadByCode(String code) {
        String sql = "SELECT " + TypeActivite.getAllFields() + " FROM " + table + " WHERE CODE = '" + code + "'";
        return this.genericLoad(sql);
    }

    public boolean loadById(int id) {
        String sql = "SELECT " + TypeActivite.getAllFields() + " FROM " + table + " WHERE ID = " + id;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = TypeActivite.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.cle = rs.getInt("ID");
                    this.name = rs.getString("DESIGNATION");
                    this.code = rs.getString("CODE");
                    this.color = rs.getInt("COULEUR");
                    this.paidPercentage = rs.getInt("PERCENTAGE");
                    this.modificationLevel = rs.getInt("MODIFICATION_LEVEL");
                    this.hsGenerator = rs.getBoolean("GENERE_HS");
                    this.rcGenerator = rs.getBoolean("GENERE_RC");
                    this.showPaid = rs.getBoolean("SHOW_PAID");
                    this.rest = rs.getBoolean("REST");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#JourType.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        Statement statement = null;
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO " + table + " (ID, CODE, DESIGNATION, COULEUR, PERCENTAGE, MODIFICATION_LEVEL, GENERE_HS, GENERE_RC, REST, SHOW_PAID)" + " VALUES (GEN_T_TYPE_ACTIVITE.nextval,?,?,?,?,?,?,?,?,?)";
                    statement = TypeActivite.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO " + table + " (CODE, DESIGNATION, COULEUR, PERCENTAGE, MODIFICATION_LEVEL, GENERE_HS, GENERE_RC, REST, SHOW_PAID)" + " VALUES (?,?,?,?,?,?,?,?,?)";
                    statement = TypeActivite.getConnection().prepareStatement(sql, 1);
                }
                statement.setObject(1, this.code, 12);
                statement.setObject(2, this.name, 12);
                statement.setObject(3, this.color, 4);
                statement.setObject(4, this.paidPercentage, 4);
                statement.setObject(5, this.modificationLevel, 4);
                statement.setObject(6, this.hsGenerator, 4);
                statement.setObject(7, this.rcGenerator, 4);
                statement.setObject(8, this.rest, 4);
                statement.setObject(9, this.showPaid, 4);
                statement.executeUpdate();
                this.loadId((PreparedStatement)statement);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                String tracer = String.valueOf(LanguageTranslator.getString("generics.activity")) + " (" + this.getName() + ") \n";
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                toReturn = true;
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (statement == null) return toReturn;
                try {
                    statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (statement == null) return toReturn;
                try {
                    statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean loadId(PreparedStatement fromStatement) throws SQLException {
        boolean retour = false;
        ResultSet rs = null;
        if (fromStatement != null && System.getProperty("SGBDR", "mysql").equals("mysql")) {
            rs = fromStatement.getGeneratedKeys();
            if (!rs.next()) {
                TimsLogger.debug("#TypeActivite.loadId# no auto generated key availaible");
            } else {
                TimsLogger.debug("#TypeActivite.loadId# auto generated key value = " + rs.getInt(1));
                this.cle = rs.getInt(1);
                retour = true;
            }
            rs.close();
        }
        if (retour) {
            return retour;
        }
        String sql = "SELECT MAX(ID) AS ID FROM " + table + " WHERE CODE = ?";
        try {
            try {
                this.statement = TypeActivite.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.code, 12);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.cle = rs.getInt("ID");
                    TimsLogger.debug("#TypeActivite.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#TypeActivite.loadId()#  : " + ex);
                ex.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean update() {
        if (this.cle != 0) {
            return this.updateValue();
        }
        return this.insert();
    }

    public boolean compareAndUpdate(String name, String code, int couleur, boolean hsGenerator, boolean rcGenerator, int percentage, boolean rest, int modificationLevel, boolean showPaid) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.activity")) + " n\u00b0 " + this.cle + " (" + this.getName() + ") \n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (Fonctions.fieldChange(code, this.code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (couleur != this.color) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.color") + " '" + this.color + "' => '" + couleur + "'\n";
            this.setColor(couleur);
        }
        if (hsGenerator != this.hsGenerator) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("activity.HS") + " '" + this.hsGenerator + "' => '" + hsGenerator + "'\n";
            this.setHsGenerator(hsGenerator);
        }
        if (rcGenerator != this.rcGenerator) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("activity.RC") + " '" + this.rcGenerator + "' => '" + rcGenerator + "'\n";
            this.setModificationLevel(modificationLevel);
        }
        if (percentage != this.paidPercentage) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.percentage") + " '" + this.paidPercentage + "' => '" + percentage + "'\n";
            this.setPaidPercentage(percentage);
        }
        if (rest != this.rest) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.rest") + " '" + this.rest + "' => '" + rest + "'\n";
            this.setRest(rest);
        }
        if (showPaid != this.showPaid) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.showPaid") + " '" + this.showPaid + "' => '" + showPaid + "'\n";
            this.setShowPaid(showPaid);
        }
        if (modificationLevel != this.modificationLevel) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.modification") + " '" + this.modificationLevel + "' => '" + modificationLevel + "'\n";
            this.setModificationLevel(modificationLevel);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.activity")) + " n\u00b0 " + this.cle + " (" + this.getName() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#TypeActivite# no changes");
        return true;
    }

    public void affiche() {
        TimsLogger.info("#TypeActivite# " + this.code + ", " + this.name + ", " + this.color + ", " + this.paidPercentage + ", rest = " + this.rest + ", " + this.hsGenerator + ", " + this.cle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateValue() {
        boolean toReturn = false;
        this.affiche();
        String sql = "UPDATE " + table + " SET " + " CODE=? ," + " DESIGNATION=? ," + " COULEUR=? ," + " PERCENTAGE=? ," + " REST=? ," + " GENERE_HS=? ," + " GENERE_RC=? ," + " MODIFICATION_LEVEL=?, " + " SHOW_PAID=?" + " WHERE ID=?";
        PreparedStatement statement = null;
        try {
            try {
                statement = TypeActivite.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.code, 12);
                statement.setObject(2, (Object)this.name, 12);
                statement.setObject(3, (Object)this.color, 4);
                statement.setObject(4, (Object)this.paidPercentage, 6);
                statement.setObject(5, (Object)this.rest, 4);
                statement.setObject(6, (Object)this.hsGenerator, 4);
                statement.setObject(7, (Object)this.rcGenerator, 4);
                statement.setObject(8, (Object)this.modificationLevel, 4);
                statement.setObject(9, (Object)(this.showPaid ? 1 : 0), 4);
                statement.setObject(10, (Object)this.cle, 4);
                statement.executeUpdate();
                statement.close();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (statement == null) return toReturn;
                try {
                    statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                TimsLogger.debug("sql = " + sql);
                e.printStackTrace();
                if (statement == null) return toReturn;
                try {
                    statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean delete() {
        String sql = "UPDATE " + table + " SET DELETED = 1" + " WHERE ID =?";
        PreparedStatement statement = null;
        try {
            statement = TypeActivite.getConnection().prepareStatement(sql);
            statement.setObject(1, this.cle);
            statement.executeUpdate();
            statement.close();
            String tracer = String.valueOf(LanguageTranslator.getString("generics.activity")) + " n\u00b0 " + this.cle + " (" + this.getName() + ") \n";
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new Date(), tracer).insert();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int couleur) {
        this.color = couleur;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String description) {
        this.name = description;
    }

    public boolean isHsGenerator() {
        return this.hsGenerator;
    }

    public void setHsGenerator(boolean isService) {
        this.hsGenerator = isService;
    }

    public int getPaidPercentage() {
        return this.paidPercentage;
    }

    public void setPaidPercentage(int percentage) {
        this.paidPercentage = percentage;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isRcGenerator() {
        return this.rcGenerator;
    }

    public void setRcGenerator(boolean rcGenerator) {
        this.rcGenerator = rcGenerator;
    }

    public int getModificationLevel() {
        return this.modificationLevel;
    }

    public void setModificationLevel(int modificationLevel) {
        this.modificationLevel = modificationLevel;
    }

    public boolean isShowPaid() {
        return this.showPaid;
    }

    public void setShowPaid(boolean showPaid) {
        this.showPaid = showPaid;
    }

    public boolean isRest() {
        return this.rest;
    }

    public void setRest(boolean rest) {
        this.rest = rest;
    }

    public static Vector<TypeActivite> getList() {
        if (list == null) {
            list = TypeActivite.loadList();
        }
        return list;
    }

    public static void setList(Vector<TypeActivite> list) {
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#TypeActivite.setList# define a new list");
        }
        TypeActivite.list = list;
    }

    public static TypeActivite getActivityType(int activityTypeId) throws ActivityTypeNotFoundException {
        for (TypeActivite tmp : TypeActivite.getList()) {
            if (tmp.getCle() != activityTypeId) continue;
            return tmp;
        }
        TimsLogger.warn("#TypeActivite.getActivityType# not found : " + activityTypeId);
        throw new ActivityTypeNotFoundException();
    }

    private static String getAllFields() {
        return "ID, DESIGNATION, CODE, COULEUR, MODIFIABLE, PAYER, REST, GENERE_HS, GENERE_RC, PERCENTAGE, MODIFICATION_LEVEL, SHOW_PAID";
    }

    private static Vector<TypeActivite> loadList() {
        Vector<TypeActivite> toReturn = new Vector<TypeActivite>();
        String sql = "SELECT " + TypeActivite.getAllFields() + " FROM " + table + " WHERE DELETED = 0";
        try {
            Statement stm = TypeActivite.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                toReturn.add(new TypeActivite(rs.getInt("ID"), rs.getString("DESIGNATION"), rs.getString("CODE"), rs.getInt("COULEUR"), rs.getBoolean("MODIFIABLE"), rs.getBoolean("GENERE_HS"), rs.getBoolean("GENERE_RC"), rs.getInt("PERCENTAGE"), rs.getBoolean("REST"), rs.getInt("MODIFICATION_LEVEL"), rs.getBoolean("SHOW_PAID")));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("#TypeActivity.loadList()# " + ex);
            TimsLogger.debug(sql);
        }
        return toReturn;
    }
}

