/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.exception.ContractNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class TypeContrat
extends MainElement {
    public static final String table = "type_contrat";
    public static final int DAILY = 0;
    public static final int WEEKLY = 1;
    public static final int MONTHLY = 2;
    public static final int QUARTERLY = 3;
    public static final int BIWEEKLY = 4;
    private static Vector<TypeContrat> list = null;
    private int cle = 0;
    private String designation = null;
    private int contractHour = 0;
    private int dailyValue = 0;
    private int maximumHour = 0;
    private int seuilHN = 0;
    private int seuilHE = 0;
    private int seuilHS25 = 0;
    private int calculationType = 2;
    private boolean guaranteed = false;

    public TypeContrat() {
        this.designation = "NOUVEAU CONTRAT";
    }

    public TypeContrat(int cle, String designation, int seuilHN, int seuilHE, int seuilHS25, int calculationType, int contractHour, int dailyValue, int maximumHour, boolean guaranteed) {
        this.cle = cle;
        this.designation = designation;
        this.seuilHN = seuilHN;
        this.seuilHE = seuilHE;
        this.seuilHS25 = seuilHS25;
        this.calculationType = calculationType;
        this.contractHour = contractHour;
        this.dailyValue = dailyValue;
        this.maximumHour = maximumHour;
        this.guaranteed = guaranteed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO type_contrat (CLE, DESIGNATION, SEUIL_HN, SEUIL_HE, SEUIL_HS25, CALCULATION_TYPE, HEURE_CONTRAT, DAILY_VALUE, HEURE_MAXIMUM, GARANTIE) VALUES (GEN_TYPE_CONTRAT.nextval,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO type_contrat (DESIGNATION, SEUIL_HN, SEUIL_HE, SEUIL_HS25, CALCULATION_TYPE, HEURE_CONTRAT, DAILY_VALUE, HEURE_MAXIMUM, GARANTIE) VALUES (?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = TypeContrat.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.designation, 12);
                this.statement.setObject(2, (Object)this.seuilHN, 12);
                this.statement.setObject(3, (Object)this.seuilHE, 12);
                this.statement.setObject(4, (Object)this.seuilHS25, 12);
                this.statement.setObject(5, (Object)this.calculationType, 12);
                this.statement.setObject(6, (Object)this.contractHour, 4);
                this.statement.setObject(7, (Object)this.dailyValue, 4);
                this.statement.setObject(8, (Object)this.maximumHour, 4);
                this.statement.setObject(9, (Object)(this.guaranteed ? 1 : 0), 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean update() {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean updateValue() {
        String sql = "UPDATE type_contrat SET  DESIGNATION =?, SEUIL_HN =?, SEUIL_HE =?, SEUIL_HS25 =?, CALCULATION_TYPE =?, DAILY_VALUE =?, HEURE_CONTRAT =?, HEURE_MAXIMUM =?, GARANTIE =? WHERE CLE=?";
        try {
            this.statement = TypeContrat.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.designation, 12);
            this.statement.setObject(2, (Object)this.seuilHN, 4);
            this.statement.setObject(3, (Object)this.seuilHE, 4);
            this.statement.setObject(4, (Object)this.seuilHS25, 4);
            this.statement.setObject(5, (Object)this.calculationType, 4);
            this.statement.setObject(6, (Object)this.dailyValue, 4);
            this.statement.setObject(7, (Object)this.contractHour, 4);
            this.statement.setObject(8, (Object)this.maximumHour, 4);
            this.statement.setObject(9, (Object)(this.guaranteed ? 1 : 0), 4);
            this.statement.setObject(10, this.cle);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getCle() {
        return this.cle;
    }

    public String getDesignation() {
        return this.designation;
    }

    public int getSeuilHE(int type) {
        if (type == -1) {
            type = this.calculationType;
        }
        return this.getValue(this.seuilHE, this.calculationType, type);
    }

    public void setSeuilHE(int type, int seuilHE) {
        this.seuilHE = this.getValue(seuilHE, type, this.calculationType);
    }

    public int getSeuilHN(int type) {
        if (type == -1) {
            type = this.calculationType;
        }
        return this.getValue(this.seuilHN, this.calculationType, type);
    }

    public void setSeuilHN(int type, int seuilHN) {
        this.seuilHN = this.getValue(seuilHN, type, this.calculationType);
    }

    public int getSeuilHS25(int type) {
        if (type == -1) {
            type = this.calculationType;
        }
        return this.getValue(this.seuilHS25, this.calculationType, type);
    }

    public void setSeuilHS25(int type, int seuilHS25) {
        this.seuilHS25 = this.getValue(seuilHS25, type, this.calculationType);
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public int getCalculationType() {
        return this.calculationType;
    }

    public void setCalculationType(int calculationType) {
        this.calculationType = calculationType;
    }

    public void affiche() {
        TimsLogger.info("#TypeContrat.affiche# " + this.designation + ", " + this.seuilHN + " " + this.seuilHE + " " + this.seuilHS25);
    }

    public int getDailyValue() {
        return this.dailyValue;
    }

    public void setDailyValue(int dailyValue) {
        this.dailyValue = dailyValue;
    }

    private int getValue(int value, int typeValue, int typeQuery) {
        switch (typeQuery) {
            case 0: {
                if (typeValue == 1) {
                    return this.getRoundedValue(value / 5);
                }
                if (typeValue == 4) {
                    return this.getRoundedValue(value / 10);
                }
                if (typeValue == 2) {
                    return this.getRoundedValue((int)((double)value / 21.666666666666664));
                }
                if (typeValue == 3) {
                    return this.getRoundedValue((int)((double)value / 65.0));
                }
            }
            case 1: {
                if (typeValue == 1) {
                    return this.getRoundedValue(value);
                }
                if (typeValue == 4) {
                    return this.getRoundedValue(value / 2);
                }
                if (typeValue == 2) {
                    return this.getRoundedValue(value * 12 / 52);
                }
                if (typeValue == 3) {
                    return this.getRoundedValue(value * 4 / 52);
                }
            }
            case 4: {
                if (typeValue == 1) {
                    return this.getRoundedValue(value) * 2;
                }
                if (typeValue == 4) {
                    return this.getRoundedValue(value);
                }
                if (typeValue == 2) {
                    return this.getRoundedValue(value * 12 / 52 * 2);
                }
                if (typeValue == 3) {
                    return this.getRoundedValue(value * 4 / 52 * 2);
                }
            }
            case 2: {
                if (typeValue == 1) {
                    return this.getRoundedValue(value * 52 / 12);
                }
                if (typeValue == 4) {
                    return this.getRoundedValue(value * 26 / 12);
                }
                if (typeValue == 2) {
                    return this.getRoundedValue(value);
                }
                if (typeValue == 3) {
                    return this.getRoundedValue(value / 3);
                }
            }
            case 3: {
                if (typeValue == 1) {
                    return this.getRoundedValue(value * 52 * 3 / 12);
                }
                if (typeValue == 4) {
                    return this.getRoundedValue(value * 26 * 3 / 12);
                }
                if (typeValue == 2) {
                    return this.getRoundedValue(value * 3);
                }
                if (typeValue != 3) break;
                return this.getRoundedValue(value);
            }
        }
        return 0;
    }

    private int getRoundedValue(int value) {
        return value;
    }

    public int getContractGroup(Date date) {
        switch (this.calculationType) {
            case 1: {
                return Integer.parseInt(ConversionTime.dateToString(date, "w"));
            }
            case 4: {
                return Integer.parseInt(ConversionTime.dateToString(date, "w")) / 2;
            }
            case 2: {
                return Integer.parseInt(ConversionTime.dateToString(date, "M"));
            }
            case 3: {
                return Integer.parseInt(ConversionTime.dateToString(date, "M")) / 3;
            }
        }
        return -1;
    }

    public boolean isGuaranteed() {
        return this.guaranteed;
    }

    public void setGuaranteed(boolean guaranteed) {
        this.guaranteed = guaranteed;
    }

    public int getContractHour() {
        return this.contractHour;
    }

    public void setContractHour(int contractHour) {
        this.contractHour = contractHour;
    }

    public int getMaximumHour() {
        return this.maximumHour;
    }

    public void setMaximumHour(int maximumHour) {
        this.maximumHour = maximumHour;
    }

    public static Vector<TypeContrat> getList() {
        if (list == null) {
            list = TypeContrat.loadList();
        }
        return list;
    }

    public static void setList(Vector<TypeContrat> list) {
        TypeContrat.list = list;
    }

    public static TypeContrat getTypeContrat(int idTypeContrat) throws TypeContratNotFoundException {
        for (TypeContrat tmp : TypeContrat.getList()) {
            if (tmp.getCle() != idTypeContrat) continue;
            return tmp;
        }
        throw new TypeContratNotFoundException();
    }

    public static Vector<TypeContrat> loadList() {
        Vector<TypeContrat> toReturn = new Vector<TypeContrat>();
        ResultSet rs = null;
        String sql = "SELECT CLE, DESIGNATION, SEUIL_HN, SEUIL_HE, SEUIL_HS25, CALCULATION_TYPE, HEURE_CONTRAT, DAILY_VALUE, HEURE_MAXIMUM, GARANTIE FROM type_contrat ORDER BY DESIGNATION";
        try {
            Statement stm = TypeContrat.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                toReturn.add(new TypeContrat(rs.getInt("CLE"), rs.getString("DESIGNATION"), rs.getInt("SEUIL_HN"), rs.getInt("SEUIL_HE"), rs.getInt("SEUIL_HS25"), rs.getInt("CALCULATION_TYPE"), rs.getInt("HEURE_CONTRAT"), rs.getInt("DAILY_VALUE"), rs.getInt("HEURE_MAXIMUM"), rs.getBoolean("GARANTIE")));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("TypeContrat.loadList()  : " + ex);
            TimsLogger.debug(sql);
        }
        return toReturn;
    }

    public static TypeContrat getContractType(Vector<TypeContrat> contractList, int contractId) throws ContractNotFoundException {
        for (TypeContrat tmp : contractList) {
            if (tmp.getCle() != contractId) continue;
            return tmp;
        }
        throw new ContractNotFoundException();
    }
}

