/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Activite;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourUEV;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class UevActivity
extends Activite {
    public static final int OFFSET = 49;
    private int cleVehicule;
    private String dateJour;
    public static final String table = "t_activite_uev";

    public UevActivity() {
    }

    public UevActivity(int cleVehicule, int cleType, String description, String couleur, int heureDebut, int heureFin, int duree, String etatCarte, String etatConduite, String lecteur, String dateJour) {
        this.cleVehicule = cleVehicule;
        this.cleType = cleType;
        this.description = description;
        this.couleur = couleur;
        this.heureDebut = heureDebut;
        this.heureFin = heureFin;
        this.duree = duree;
        this.etatCarte = etatCarte;
        this.etatConduite = etatConduite;
        this.lecteur = lecteur;
        this.dateJour = dateJour;
    }

    public UevActivity(byte[] one, String date, int vehicleId) {
        this.dateJour = date;
        this.cleVehicule = vehicleId;
        this.loadCondensedRepresentation(one);
    }

    public void setActivite(int cleVehicule, int cleType, String description, String couleur, int heureDebut, int heureFin, int duree, String etatCarte, String etatConduite, String lecteur, String dateJour) {
        this.cleVehicule = cleVehicule;
        this.cleType = cleType;
        this.description = description;
        this.couleur = couleur;
        this.heureDebut = heureDebut;
        this.heureFin = heureFin;
        this.duree = duree;
        this.etatCarte = etatCarte;
        this.etatConduite = etatConduite;
        this.lecteur = lecteur;
        this.dateJour = dateJour;
    }

    public void clone(UevActivity activ) {
        this.cleVehicule = activ.getCleVehicule();
        this.cleType = activ.getCleType();
        this.description = activ.getDescription();
        this.couleur = activ.getCouleur();
        this.heureDebut = activ.getHeureDebut();
        this.heureFin = activ.getHeureFin();
        this.duree = activ.getDuree();
        this.etatCarte = activ.getEtatCarte();
        this.etatConduite = activ.getEtatConduite();
        this.lecteur = activ.getLecteur();
        this.dateJour = activ.getDateJour();
    }

    public byte[] getCondensedRepresentation() {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        String activite = Integer.toBinaryString(this.heureDebut + (int)Math.pow(2.0, 11.0)).substring(1);
        activite = String.valueOf(activite) + Integer.toBinaryString(this.heureFin + (int)Math.pow(2.0, 11.0)).substring(1);
        activite = String.valueOf(activite) + Integer.toBinaryString(this.cleType + (int)Math.pow(2.0, 5.0)).substring(1);
        activite = String.valueOf(activite) + "00";
        activite = String.valueOf(activite) + ("CONVOYEUR".equals(this.lecteur) ? "1" : "0");
        activite = String.valueOf(activite) + ("SEUL".equals(this.etatConduite) || "INCONNU".equals(this.etatConduite) ? "0" : "1");
        activite = String.valueOf(activite) + ("INSEREE".equals(this.etatCarte) ? "0" : "1");
        int x = 0;
        while (x < 4) {
            tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
            ++x;
        }
        return tmp.toByteArray();
    }

    public boolean loadCondensedRepresentation(byte[] buffer) {
        String tmp = "";
        int x = 0;
        while (x < 4) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (buffer[x] < 0 ? buffer[x] + 256 : buffer[x])).substring(1);
            ++x;
        }
        this.heureDebut = Integer.parseInt(tmp.substring(0, 11), 2);
        this.heureFin = Integer.parseInt(tmp.substring(11, 22), 2);
        this.duree = this.heureFin - this.heureDebut;
        this.cleType = Integer.parseInt(tmp.substring(22, 27), 2);
        this.lecteur = tmp.substring(29, 30).equals("0") ? "CONDUCTEUR" : "CONVOYEUR";
        int eConduite = Integer.parseInt(tmp.substring(30, 31));
        int eCarte = Integer.parseInt(tmp.substring(31, 32));
        this.etatConduite = eCarte == 0 ? (eConduite == 1 ? "EQUIPAGE" : "SEUL") : (eConduite == 1 ? "S. MAN" : "INCONNU");
        this.etatCarte = eCarte == 0 ? "INSEREE" : "NON INSEREE";
        return true;
    }

    public void insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_activite_uev (CLE_ACTIVITE_UEV,CLE_VEHICULE,TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE,ETAT_CARTE,JOUR_TELECHARGE,ETAT_CONDUITE,LECTEUR) VALUES (GEN_" + table.toUpperCase() + ".nextval,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_activite_uev (CLE_VEHICULE,TYPE_ACTIV,HEURE_DEBUT,HEURE_FIN,DUREE,ETAT_CARTE,JOUR_TELECHARGE,ETAT_CONDUITE,LECTEUR) VALUES (?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = UevActivity.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleVehicule, 4);
                this.statement.setObject(2, (Object)this.cleType, 4);
                this.statement.setObject(3, (Object)this.heureDebut, 4);
                this.statement.setObject(4, (Object)this.heureFin, 4);
                this.statement.setObject(5, (Object)this.duree, 4);
                this.statement.setObject(6, (Object)this.etatCarte, 12);
                this.statement.setDate(7, Date.valueOf(this.dateJour));
                this.statement.setObject(8, (Object)this.etatConduite, 12);
                this.statement.setObject(9, (Object)this.lecteur, 12);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                System.err.println("#ActiviteUEV.insert# erreur");
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void delete() {
        String sql = "DELETE FROM t_activite_uev WHERE CLE_ACTIVITE_UEV=?";
        try {
            try {
                this.statement = UevActivity.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleActivite, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public int getCleVehicule() {
        return this.cleVehicule;
    }

    public void setCleVehicule(int cleVehicule) {
        this.cleVehicule = cleVehicule;
    }

    public String getDateJour() {
        return this.dateJour;
    }

    public void setDateJour(String dateJour) {
        this.dateJour = dateJour;
    }

    public ActiviteConducteur toDriverActivity(Conducteur driver) {
        return new ActiviteConducteur(driver.getCleConducteur(), driver.getCleAgence(), this.getCleType(), "", this.getHeureDebut(), this.getHeureFin(), this.getHeureFin() - this.getHeureDebut(), this.getDateJour(), "VEHICULE", String.valueOf(this.getCleVehicule()), "", "", "", 0);
    }

    public void affiche() {
        TimsLogger.info(String.valueOf(this.getDateJour()) + " " + this.getHeureDebut() + ", " + this.getHeureFin() + ", " + this.getDescription() + ", " + this.getCouleur());
    }

    public byte[] write(OutputStream out) {
        this.affiche();
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(this.dateJour);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.heureDebut + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.heureFin + (int)Math.pow(2.0, 11.0)).substring(1);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.modification + (int)Math.pow(2.0, 4.0)).substring(1);
            activite = String.valueOf(activite) + this.suppression;
            activite = String.valueOf(activite) + (this.lecteur.equals("CONDUCTEUR") ? "0" : "1");
            activite = String.valueOf(activite) + (this.etatConduite.equals("SEUL") ? "0" : "1");
            activite = String.valueOf(activite) + (this.etatCarte.equals("INSEREE") ? "0" : "1");
            activite = this.cleType < 7 ? String.valueOf(activite) + Integer.toBinaryString(this.cleType + (int)Math.pow(2.0, 3.0)).substring(1) : String.valueOf(activite) + "000";
            while (activite.length() < 48) {
                activite = String.valueOf(activite) + "0";
            }
            int x = 0;
            while (x < 6) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            out.write(49);
            out.write((byte)(tmp.toByteArray().length / 255 + 1));
            out.write((byte)tmp.toByteArray().length);
            out.write(tmp.toByteArray());
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#UevActivity.write# " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 6) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            ++x;
        }
        this.dateJour = ConversionTime.binaryToDateString(tmp);
        this.heureDebut = Integer.parseInt(tmp.substring(13, 24), 2);
        this.heureFin = Integer.parseInt(tmp.substring(24, 35), 2);
        this.duree = this.heureFin - this.heureDebut;
        this.modification = Integer.parseInt(tmp.substring(35, 39), 2);
        this.suppression = Integer.parseInt(tmp.substring(39, 40), 2);
        this.lecteur = tmp.substring(40, 41).equals("0") ? "CONDUCTEUR" : "CONVOYEUR";
        this.etatConduite = tmp.substring(41, 42).equals("0") ? "SEUL" : "EQUIPAGE";
        this.etatCarte = tmp.substring(42, 43).equals("0") ? "INSEREE" : "NON INSEREE";
        this.cleType = Integer.parseInt(tmp.substring(43, 46), 2) == 0 ? 8 : Integer.parseInt(tmp.substring(43, 46), 2);
    }

    public static Vector<UevActivity> load(int cleVehicule, String debut, String fin) {
        Vector<UevActivity> liste = new Vector<UevActivity>();
        String res = "";
        if (debut != null && !debut.equals("")) {
            res = fin != null && !fin.equals("") ? String.valueOf(res) + " AND JOUR_TELECHARGE BETWEEN " + BddTransport.getDateStringToSGBDR(debut, false) + " AND " + BddTransport.getDateStringToSGBDR(fin, false) : String.valueOf(res) + " AND JOUR_TELECHARGE =" + BddTransport.getDateStringToSGBDR(debut, false);
        }
        if (cleVehicule != 0) {
            res = String.valueOf(res) + " AND CLE_VEHICULE = " + cleVehicule;
        }
        String sql = "SELECT CLE_VEHICULE, TYPE_ACTIV," + BddTransport.getDateSGBDRToString("JOUR_TELECHARGE", false, "") + " ,HEURE_DEBUT," + " HEURE_FIN," + " ETAT_CARTE," + " ETAT_CONDUITE," + " LECTEUR, " + "t_type_activite" + ".DESIGNATION," + " COULEUR" + " FROM " + table + " activite" + " JOIN " + "t_type_activite" + " ON TYPE_ACTIV=ID" + " WHERE LECTEUR='" + "CONDUCTEUR" + "'";
        if (res.length() != 0) {
            sql = String.valueOf(sql) + res;
        }
        sql = String.valueOf(sql) + " ORDER BY JOUR_TELECHARGE,HEURE_DEBUT";
        ResultSet rs = null;
        try {
            Statement stm = UevActivity.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                liste.add(new UevActivity(cleVehicule, rs.getInt(2), rs.getString(9), rs.getString(10), rs.getInt(4), rs.getInt(5), rs.getInt(5) - rs.getInt(4), rs.getString(6), rs.getString(7), rs.getString(8), rs.getString(3)));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("UevActivity.load()  : " + ex);
            if (Transport.debug >= 1) {
                ex.printStackTrace();
            }
            TimsLogger.debug("sql = " + sql);
        }
        return liste;
    }

    public static byte[] toCondensed(Vector<UevActivity> tmp, String source) {
        if (tmp == null) {
            return null;
        }
        byte[] toReturn = new byte[tmp.size() * 4];
        int offset = 0;
        for (UevActivity activite : tmp) {
            byte[] activity = activite.getCondensedRepresentation();
            System.arraycopy(activity, 0, toReturn, offset, 4);
            offset += 4;
        }
        return toReturn;
    }

    public static Vector<UevActivity> fromCondensed(byte[] tmp, JourUEV from) {
        Vector<UevActivity> toReturn = new Vector<UevActivity>();
        int x = 0;
        while (x < tmp.length) {
            byte[] one = new byte[4];
            System.arraycopy(tmp, x, one, 0, 4);
            toReturn.add(new UevActivity(one, ConversionTime.dateToString(from.getDay(), "yyyy-MM-dd"), from.getVehicleId()));
            x += 4;
        }
        return toReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean delete(int vehicleId, java.util.Date date) {
        boolean toReturn = false;
        String sql = "DELETE FROM t_activite_uev WHERE CLE_VEHICULE  = ? AND JOUR_TELECHARGE = ?";
        PreparedStatement stm = null;
        try {
            try {
                stm = UevActivity.getConnection().prepareStatement(sql);
                stm = UevActivity.getConnection().prepareStatement(sql);
                stm.setObject(1, (Object)vehicleId, 4);
                stm.setDate(2, new Date(date.getTime()));
                stm.executeUpdate();
                stm.close();
                toReturn = true;
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (stm == null) return toReturn;
                try {
                    stm.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (stm == null) return toReturn;
                try {
                    stm.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public long getBeginTimestamp() {
        return ConversionTime.stringToDateDb(String.valueOf(this.dateJour) + " " + ConversionTime.heureIntToString(this.heureDebut, ":") + ":00", true).getTime();
    }

    public long getEndTimestamp() {
        return ConversionTime.stringToDateDb(String.valueOf(this.dateJour) + " " + ConversionTime.heureIntToString(this.heureFin, ":") + ":00", true).getTime();
    }
}

