/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import transpo.system.TimsLogger;
import transpo.system.uev.object.VuCalibration;
import transpo.system.util.Constants;

public class UevCalibration
extends MainElement {
    public static final String[] LIBELLE_TYPE = new String[]{"Valeur reserv\u00e9e.", "Activation : enregistrement des param\u00e8tres d'\u00e9talonnage connus", "Premi\u00e8re installation : \u00e9talonnage apr\u00e8s activation", "Premier \u00e9talonnage de l'UEV sur le v\u00e9hicule", "Inspection p\u00e9riodique", "Entr\u00e9e des VRN par entreprise", "Mise \u00e0 l'heure sans \u00e9talonnage"};
    public static final String[] LIBELLE_TYPE_EQUIPEMENT = new String[]{"Valeur reserv\u00e9e.", "Carte de conducteur.", "Carte d'atelier.", "Carte de controleur.", "Carte d'entreprise.", "Carte de fabrication.", "UEV.", "Capteur de mouvement.", "RFU."};
    private int cleVehicule;
    private int typeEtalonnage;
    private String nom;
    private String adresse;
    private int typeCarte;
    private String numeroCarte;
    private String expirationCarte;
    private String identificationVehicule;
    private int clePaysVehicule;
    private String enregistrementVehicule;
    private int w;
    private int k;
    private int l;
    private String tyreSize;
    private int authorizedSpeed;
    private int ancienKM;
    private int nouveauKM;
    private String ancienneDate;
    private String nouvelleDate;
    private String prochainEtalonnage;

    public UevCalibration() {
    }

    public UevCalibration(int cleVehicule, int typeEtalonnage, String nom, String adresse, int typeCarte, String numeroCarte, String expirationCarte, String identificationVehicule, int clePays, String enregistrementVehicule, int w, int k, int l, String tyreSize, int authorizedSpeed, int ancienKM, int nouveauKM, String ancienneDate, String nouvelleDate, String prochainEtalonnage) {
        this.cleVehicule = cleVehicule;
        this.typeEtalonnage = typeEtalonnage;
        this.nom = nom;
        this.adresse = adresse;
        this.typeCarte = typeCarte;
        this.numeroCarte = numeroCarte;
        this.expirationCarte = expirationCarte;
        this.identificationVehicule = identificationVehicule;
        this.clePaysVehicule = clePays;
        this.enregistrementVehicule = enregistrementVehicule;
        this.w = w;
        this.k = k;
        this.l = l;
        this.tyreSize = tyreSize;
        this.authorizedSpeed = authorizedSpeed;
        this.ancienKM = ancienKM;
        this.nouveauKM = nouveauKM;
        this.ancienneDate = ancienneDate;
        this.nouvelleDate = nouvelleDate;
        this.prochainEtalonnage = prochainEtalonnage;
    }

    public void clone(UevCalibration uevCalibration) {
        this.cleVehicule = uevCalibration.getCleVehicule();
        this.typeEtalonnage = uevCalibration.getTypeEtalonnage();
        this.nom = uevCalibration.getNom();
        this.adresse = uevCalibration.getAdresse();
        this.typeCarte = uevCalibration.getTypeCarte();
        this.numeroCarte = uevCalibration.getNumeroCarte();
        this.expirationCarte = uevCalibration.getExpirationCarte();
        this.identificationVehicule = uevCalibration.getIdentificationVehicule();
        this.clePaysVehicule = uevCalibration.getClePays();
        this.enregistrementVehicule = uevCalibration.getEnregistrementVehicule();
        this.w = uevCalibration.getW();
        this.k = uevCalibration.getK();
        this.l = uevCalibration.getL();
        this.tyreSize = uevCalibration.getTyreSize();
        this.authorizedSpeed = uevCalibration.getAuthorizedSpeed();
        this.ancienKM = uevCalibration.getAncienKM();
        this.nouveauKM = uevCalibration.getNouveauKM();
        this.ancienneDate = uevCalibration.getAncienneDate();
        this.nouvelleDate = uevCalibration.getNouvelleDate();
        this.prochainEtalonnage = uevCalibration.getProchainEtalonnage();
    }

    public boolean equals(Object obj) {
        TimsLogger.debug(String.valueOf(this.typeEtalonnage) + " / " + this.enregistrementVehicule + " / " + this.ancienneDate + " / " + this.nouvelleDate + " ==? " + ((UevCalibration)obj).getTypeEtalonnage() + " / " + ((UevCalibration)obj).getEnregistrementVehicule() + " / " + ((UevCalibration)obj).getAncienneDate() + " / " + ((UevCalibration)obj).getNouvelleDate());
        return obj instanceof UevCalibration && ((UevCalibration)obj).getTypeEtalonnage() == this.typeEtalonnage && ((UevCalibration)obj).getEnregistrementVehicule().equals(this.enregistrementVehicule) && ConversionTime.dateStringEquals(((UevCalibration)obj).getAncienneDate(), this.ancienneDate, false) && ConversionTime.dateStringEquals(((UevCalibration)obj).getNouvelleDate(), this.nouvelleDate, false) && ((UevCalibration)obj).getAncienKM() == this.ancienKM && ((UevCalibration)obj).getNouveauKM() == this.nouveauKM && ((UevCalibration)obj).getW() == this.w && ((UevCalibration)obj).getK() == this.k && ((UevCalibration)obj).getL() == this.l;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public int getAncienKM() {
        return this.ancienKM;
    }

    public void setAncienKM(int ancienKM) {
        this.ancienKM = ancienKM;
    }

    public String getAncienneDate() {
        return this.ancienneDate;
    }

    public void setAncienneDate(String ancienneDate) {
        this.ancienneDate = ancienneDate;
    }

    public int getAuthorizedSpeed() {
        return this.authorizedSpeed;
    }

    public void setAuthorizedSpeed(int authorizedSpeed) {
        this.authorizedSpeed = authorizedSpeed;
    }

    public int getClePays() {
        return this.clePaysVehicule;
    }

    public void setClePaysVehicule(int clePaysVehicule) {
        this.clePaysVehicule = clePaysVehicule;
    }

    public int getCleVehicule() {
        return this.cleVehicule;
    }

    public void setCleVehicule(int cleVehicule) {
        this.cleVehicule = cleVehicule;
    }

    public String getEnregistrementVehicule() {
        return this.enregistrementVehicule;
    }

    public void setEnregistrementVehicule(String enregistrementVehicule) {
        this.enregistrementVehicule = enregistrementVehicule;
    }

    public String getExpirationCarte() {
        return this.expirationCarte;
    }

    public void setExpirationCarte(String expirationCarte) {
        this.expirationCarte = expirationCarte;
    }

    public String getIdentificationVehicule() {
        return this.identificationVehicule;
    }

    public void setIdentificationVehicule(String identificationVehicule) {
        this.identificationVehicule = identificationVehicule;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getL() {
        return this.l;
    }

    public void setL(int l) {
        this.l = l;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public int getNouveauKM() {
        return this.nouveauKM;
    }

    public void setNouveauKM(int nouveauKM) {
        this.nouveauKM = nouveauKM;
    }

    public String getNouvelleDate() {
        return this.nouvelleDate;
    }

    public void setNouvelleDate(String nouvelleDate) {
        this.nouvelleDate = nouvelleDate;
    }

    public String getNumeroCarte() {
        return this.numeroCarte;
    }

    public void setNumeroCarte(String numeroCarte) {
        this.numeroCarte = numeroCarte;
    }

    public String getProchainEtalonnage() {
        return this.prochainEtalonnage;
    }

    public void setProchainEtalonnage(String prochainEtalonnage) {
        this.prochainEtalonnage = prochainEtalonnage;
    }

    public int getTypeCarte() {
        return this.typeCarte;
    }

    public void setTypeCarte(int typeCarte) {
        this.typeCarte = typeCarte;
    }

    public int getTypeEtalonnage() {
        return this.typeEtalonnage;
    }

    public void setTypeEtalonnage(int typeEtalonnage) {
        this.typeEtalonnage = typeEtalonnage;
    }

    public String getTyreSize() {
        return this.tyreSize;
    }

    public void setTyreSize(String tyreSize) {
        this.tyreSize = tyreSize;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void insert() {
        try {
            TimsLogger.debug("insert");
            this.statement = this.getPreparedStatement();
            this.statement.setObject(1, (Object)this.cleVehicule, 4);
            this.statement.setObject(2, (Object)this.typeEtalonnage, 4);
            this.statement.setObject(3, (Object)this.nom, 12);
            this.statement.setObject(4, (Object)this.adresse, 12);
            this.statement.setObject(5, (Object)this.typeCarte, 4);
            this.statement.setObject(6, (Object)this.numeroCarte, 12);
            this.statement.setTimestamp(7, Timestamp.valueOf(this.expirationCarte));
            this.statement.setObject(8, (Object)this.identificationVehicule, 12);
            this.statement.setObject(9, (Object)this.clePaysVehicule, 4);
            this.statement.setObject(10, (Object)this.enregistrementVehicule.trim(), 12);
            this.statement.setObject(11, (Object)this.w, 4);
            this.statement.setObject(12, (Object)this.k, 4);
            this.statement.setObject(13, (Object)this.l, 4);
            this.statement.setObject(14, (Object)this.tyreSize, 12);
            this.statement.setObject(15, (Object)this.authorizedSpeed, 4);
            this.statement.setObject(16, (Object)this.ancienKM, 4);
            this.statement.setObject(17, (Object)this.nouveauKM, 4);
            this.statement.setTimestamp(18, Timestamp.valueOf(this.ancienneDate));
            this.statement.setTimestamp(19, Timestamp.valueOf(this.nouvelleDate));
            this.statement.setTimestamp(20, Timestamp.valueOf(this.prochainEtalonnage));
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent("t_etalonnage", Constants.ACTION_TYPE.CREATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            System.err.println("#Etalonnage.insert# erreur");
            e.printStackTrace();
        }
    }

    public PreparedStatement getPreparedStatement() {
        if (this.statement == null) {
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO t_etalonnage (CLE_ETALONNAGE,CLE_VEHICULE,TYPE,NOM_MAGASIN,ADRESSE_MAGASIN,TYPE_CARTE,NUMERO_CARTE,EXPIRATION_CARTE,IDENTIFICATION_VEHICULE,CLE_PAYS,ENREGISTREMENT_VEHICULE,W_VEHICULE,K_VEHICULE,L_VEHICULE,TYRE_SIZE,AUTHORIZED_SPEED,ANCIEN_KM,NOUVEAU_KM,ANCIENNE_DATE,NOUVELLE_DATE,PROCHAIN_ETALONNAGE) VALUES (GEN_" + "t_etalonnage".toUpperCase() + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO t_etalonnage (CLE_VEHICULE,TYPE,NOM_MAGASIN,ADRESSE_MAGASIN,TYPE_CARTE,NUMERO_CARTE,EXPIRATION_CARTE,IDENTIFICATION_VEHICULE,CLE_PAYS,ENREGISTREMENT_VEHICULE,W_VEHICULE,K_VEHICULE,L_VEHICULE,TYRE_SIZE,AUTHORIZED_SPEED,ANCIEN_KM,NOUVEAU_KM,ANCIENNE_DATE,NOUVELLE_DATE,PROCHAIN_ETALONNAGE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }
            try {
                this.statement = UevCalibration.getConnection().prepareStatement(sql);
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                System.err.println("#Etalonnage.getPreparedStatement# erreur");
                ex.printStackTrace();
            }
        }
        return this.statement;
    }

    public void closeStatement() {
        try {
            this.getPreparedStatement().close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            System.err.println("#Etalonnage.closeStatement# erreur");
            ex.printStackTrace();
        }
    }

    public String getSQLString() {
        return String.valueOf(this.getCleVehicule()) + "\t" + this.getTypeEtalonnage() + "\t" + this.getNom() + "\t" + this.getAdresse() + "\t" + this.getTypeCarte() + "\t" + this.getNumeroCarte() + "\t" + this.getExpirationCarte() + "\t" + this.getIdentificationVehicule() + "\t" + this.getClePays() + "\t" + this.getEnregistrementVehicule() + "\t" + this.getW() + "\t" + this.getK() + "\t" + this.getL() + "\t" + this.getTyreSize() + "\t" + this.getAuthorizedSpeed() + "\t" + this.getAncienKM() + "\t" + this.getNouveauKM() + "\t" + this.getAncienneDate() + "\t" + this.getNouvelleDate() + "\t" + this.getProchainEtalonnage();
    }

    public void print() {
        TimsLogger.debug(this.getSQLString());
    }

    public static UevCalibration createFromVuCalibration(VuCalibration c, int vehicleId) {
        return new UevCalibration(vehicleId, c.getPurpose(), c.getName(), c.getAddress(), c.getCard().getCardType(), c.getCard().getCardNumber(), ConversionTime.dateToStringDb(c.getCardExpiry()), c.getVehicleIdentificationNumber(), c.getVehicleRegistrationIdentification().getNationNumeric(), c.getVehicleRegistrationIdentification().getVrn().getVehicleRegistrationNumber(), c.getW(), c.getK(), c.getL(), c.getTyreSize(), c.getAuthorizedSpeed(), c.getOldOdometer(), c.getNewOdometer(), ConversionTime.dateToStringDb(c.getOldDate()), ConversionTime.dateToStringDb(c.getNewDate()), ConversionTime.dateToStringDb(c.getNextDate()));
    }
}

