/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Vehicule;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Constants;

public class UevDownload
extends MainElement {
    public static final int OFFSET = 54;
    private Vehicule vehicle = null;
    private java.util.Date downloadDate;
    private String fileName;
    private java.util.Date beginActivity = null;
    private java.util.Date endActivity = null;
    private java.util.Date previousDownload = null;
    private int userId;

    public UevDownload() {
    }

    public UevDownload(Vehicule vehicle, int userId, java.util.Date date, String fichier, java.util.Date beginActivity, java.util.Date endActivity, java.util.Date previousDownload) {
        this.vehicle = vehicle;
        this.downloadDate = date;
        this.fileName = fichier;
        this.beginActivity = beginActivity;
        this.endActivity = endActivity;
        this.previousDownload = previousDownload;
        this.userId = userId;
    }

    public java.util.Date getTelechargement() {
        return this.downloadDate;
    }

    public String getFichier() {
        return this.fileName;
    }

    public Vehicule getVehicle() {
        return this.vehicle;
    }

    public java.util.Date getBeginActivity() {
        return this.beginActivity;
    }

    public java.util.Date getEndActivity() {
        return this.endActivity;
    }

    public java.util.Date getPreviousDownload() {
        return this.previousDownload;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void affiche() {
        TimsLogger.info("#UevDownload.affiche# file " + this.fileName + ", date " + this.downloadDate + ", beginActivity=" + this.beginActivity + ", endActivity=" + this.endActivity + ", previousDownload=" + this.previousDownload);
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_telechargement_UEV (CLE_TELECHARGEMENT ,CLE_VEHICULE, CLE_USER, DATE_TELECHARGEMENT,NOM_FICHIER,BEGIN_ACTIVITY,END_ACTIVITY,PREVIOUS_DOWNLOAD) VALUES (GEN_T_TELECHARGEMENT_UEV.nextval,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_telechargement_UEV (CLE_VEHICULE, CLE_USER, DATE_TELECHARGEMENT,NOM_FICHIER,BEGIN_ACTIVITY,END_ACTIVITY,PREVIOUS_DOWNLOAD) VALUES (?,?,?,?,?,?,?)";
        }
        try {
            this.statement = UevDownload.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.vehicle.getCle(), 4);
            this.statement.setObject(2, (Object)this.userId, 4);
            this.statement.setTimestamp(3, new Timestamp(this.downloadDate.getTime()));
            this.statement.setObject(4, (Object)this.fileName, 12);
            this.statement.setDate(5, this.beginActivity != null ? new Date(this.beginActivity.getTime()) : null);
            this.statement.setDate(6, this.endActivity != null ? new Date(this.endActivity.getTime()) : null);
            this.statement.setTimestamp(7, new Timestamp(this.previousDownload != null ? Long.valueOf(this.previousDownload.getTime()) : null));
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("t_telechargement_UEV", Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        boolean retour = false;
        String sql = "DELETE FROM t_telechargement_UEV WHERE NOM_FICHIER=?";
        try {
            try {
                this.statement = UevDownload.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.fileName, 12);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_telechargement_UEV", Constants.ACTION_TYPE.DELETE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(ConversionTime.dateToString(this.downloadDate, "yyyy-MM-dd"));
            activite = String.valueOf(activite) + Integer.toBinaryString(this.userId + (int)Math.pow(2.0, 11.0)).substring(1);
            int x = 0;
            while (x < 3) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            if (this.fileName != null) {
                tmp.write(this.fileName.getBytes());
            }
            TimsLogger.debug("#UevDownload.write# toByteArray() " + new String(tmp.toByteArray()));
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#UevDownload.write# " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 3) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            TimsLogger.debug("#UEVDownLoad.read#" + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x]) + " => " + tmp.substring(x * 8));
            ++x;
        }
        this.downloadDate = ConversionTime.stringToDate(ConversionTime.binaryToDateString(tmp), "yyyy-MM-dd");
        this.userId = Integer.parseInt(tmp.substring(13, 24), 2);
        this.fileName = new String(fileBuffer).substring(3);
    }

    public static Vector<UevDownload> getTelechargementUEV(int cleAgence, int cleVehicule, String dateDebut, String dateFin) {
        Vector<UevDownload> result = new Vector<UevDownload>();
        String sql = "";
        try {
            String restriction;
            sql = "SELECT v.CLE_VEHICULE, CLE_AGENCE, CLE_USER, N_IMMATRICULATION, IDENTIFICATION, DESIGNATION_VEHICULE, " + BddTransport.getDateSGBDRToString("DATE_TELECHARGEMENT", true, "") + ", NOM_FICHIER,BEGIN_ACTIVITY,END_ACTIVITY,PREVIOUS_DOWNLOAD" + " FROM " + "t_vehicule" + " v JOIN " + "t_telechargement_UEV" + " t ON v.CLE_VEHICULE = t.CLE_VEHICULE";
            if (cleAgence != 0) {
                sql = String.valueOf(sql) + " AND v.CLE_AGENCE = " + cleAgence;
            }
            if (cleVehicule != 0) {
                sql = String.valueOf(sql) + " AND t.CLE_VEHICULE = " + cleVehicule;
            }
            if (dateDebut != null && !dateDebut.equals("")) {
                sql = String.valueOf(sql) + " AND t.DATE_TELECHARGEMENT >= " + BddTransport.getDateStringToSGBDR(dateDebut, false);
            }
            if (dateFin != null && !dateFin.equals("")) {
                sql = String.valueOf(sql) + " AND t.DATE_TELECHARGEMENT <= " + BddTransport.getDateStringToSGBDR(dateFin, false);
            }
            if ((restriction = BddTransport.addRestriction("v", "")) != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DATE_TELECHARGEMENT";
            TimsLogger.debug(sql);
            Statement stm = UevDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule tmp = new Vehicule(rs.getInt("CLE_VEHICULE"), rs.getInt("CLE_AGENCE"), rs.getString("N_IMMATRICULATION"), rs.getString("DESIGNATION_VEHICULE"));
                result.add(new UevDownload(tmp, rs.getInt("CLE_USER"), rs.getTimestamp("DATE_TELECHARGEMENT"), rs.getString("NOM_FICHIER"), rs.getTimestamp("BEGIN_ACTIVITY"), rs.getTimestamp("END_ACTIVITY"), rs.getTimestamp("PREVIOUS_DOWNLOAD")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.data.BddTransport.getTelechargementUEV(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Vector<UevDownload> getTelechargementUEV(int cleAgence, int cleVehicule, String dateDebut, String dateFin, String more) {
        Vector<UevDownload> result = new Vector<UevDownload>();
        String sql = "";
        try {
            String restriction;
            sql = "SELECT v.CLE_VEHICULE, CLE_AGENCE, CLE_USER, N_IMMATRICULATION, IDENTIFICATION, DESIGNATION_VEHICULE, " + BddTransport.getDateSGBDRToString("DATE_TELECHARGEMENT", true, "") + ", NOM_FICHIER,BEGIN_ACTIVITY,END_ACTIVITY,PREVIOUS_DOWNLOAD" + " FROM " + "t_vehicule" + " v JOIN " + "t_telechargement_UEV" + " t ON v.CLE_VEHICULE = t.CLE_VEHICULE" + " WHERE ARCHIVAGE=" + (MainFrameTransport.archivage ? "1" : "0");
            if (cleAgence != 0) {
                sql = String.valueOf(sql) + " AND v.CLE_AGENCE = " + cleAgence;
            }
            if (cleVehicule != 0) {
                sql = String.valueOf(sql) + " AND t.CLE_VEHICULE = " + cleVehicule;
            }
            if (dateDebut != null && !dateDebut.equals("")) {
                sql = String.valueOf(sql) + " AND t.DATE_TELECHARGEMENT >= " + BddTransport.getDateStringToSGBDR(dateDebut, false);
            }
            if (dateFin != null && !dateFin.equals("")) {
                sql = String.valueOf(sql) + " AND t.DATE_TELECHARGEMENT <= " + BddTransport.getDateStringToSGBDR(dateFin, false);
            }
            if (more != null && !more.equals("")) {
                sql = String.valueOf(sql) + " AND " + more;
            }
            if ((restriction = BddTransport.addRestriction("v", "")) != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DATE_TELECHARGEMENT";
            Statement stm = UevDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule tmp = new Vehicule(rs.getInt("CLE_VEHICULE"), rs.getInt("CLE_AGENCE"), rs.getString("N_IMMATRICULATION"), rs.getString("DESIGNATION_VEHICULE"));
                result.add(new UevDownload(tmp, rs.getInt("CLE_USER"), rs.getTimestamp("DATE_TELECHARGEMENT"), rs.getString("NOM_FICHIER"), rs.getTimestamp("BEGIN_ACTIVITY"), rs.getTimestamp("END_ACTIVITY"), rs.getTimestamp("PREVIOUS_DOWNLOAD")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.data.BddTransport.getTelechargementUEV(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Vector<UevDownload> getAllTelechargementUEV() {
        Vector<UevDownload> result = new Vector<UevDownload>();
        String sql = "";
        try {
            sql = "SELECT v.CLE_VEHICULE, CLE_AGENCE, CLE_USER, N_IMMATRICULATION, IDENTIFICATION, DESIGNATION_VEHICULE, " + BddTransport.getDateSGBDRToString("DATE_TELECHARGEMENT", true, "") + ", NOM_FICHIER,BEGIN_ACTIVITY,END_ACTIVITY,PREVIOUS_DOWNLOAD" + " FROM " + "t_vehicule" + " v INNER JOIN " + "t_telechargement_UEV" + " t ON v.CLE_VEHICULE = t.CLE_VEHICULE";
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DATE_TELECHARGEMENT";
            Statement stm = UevDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule tmp = new Vehicule(rs.getInt("CLE_VEHICULE"), rs.getInt("CLE_AGENCE"), rs.getString("N_IMMATRICULATION"), rs.getString("DESIGNATION_VEHICULE"));
                result.add(new UevDownload(tmp, rs.getInt("CLE_USER"), rs.getTimestamp("DATE_TELECHARGEMENT"), rs.getString("NOM_FICHIER"), rs.getTimestamp("BEGIN_ACTIVITY"), rs.getTimestamp("END_ACTIVITY"), rs.getTimestamp("PREVIOUS_DOWNLOAD")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.data.UevDownload.getAllTelechargementUEV(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Vector<UevDownload> loadList(String filters) {
        Vector<UevDownload> result = new Vector<UevDownload>();
        String sql = "";
        try {
            sql = "SELECT v.CLE_VEHICULE, CLE_AGENCE, CLE_USER, N_IMMATRICULATION, IDENTIFICATION, DESIGNATION_VEHICULE," + BddTransport.getDateSGBDRToString("DATE_TELECHARGEMENT", true, "") + ", NOM_FICHIER,BEGIN_ACTIVITY,END_ACTIVITY,PREVIOUS_DOWNLOAD" + " FROM " + "t_vehicule" + " v INNER JOIN " + "t_telechargement_UEV" + " t ON v.CLE_VEHICULE = t.CLE_VEHICULE";
            if (filters != null && !filters.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + filters;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION, DATE_TELECHARGEMENT";
            Statement stm = UevDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule tmp = new Vehicule(rs.getInt("CLE_VEHICULE"), rs.getInt("CLE_AGENCE"), rs.getString("N_IMMATRICULATION"), rs.getString("DESIGNATION_VEHICULE"));
                result.add(new UevDownload(tmp, rs.getInt("CLE_USER"), rs.getTimestamp("DATE_TELECHARGEMENT"), rs.getString("NOM_FICHIER"), rs.getTimestamp("BEGIN_ACTIVITY"), rs.getTimestamp("END_ACTIVITY"), rs.getTimestamp("PREVIOUS_DOWNLOAD")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.data.UevDownload.getAllTelechargementUEV(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Vector<UevDownload> loadLastList(int agencyId) {
        Vector<UevDownload> result = new Vector<UevDownload>();
        String sql = "";
        try {
            sql = "SELECT v.CLE_VEHICULE, CLE_AGENCE, CLE_USER, N_IMMATRICULATION, IDENTIFICATION, DESIGNATION_VEHICULE, " + BddTransport.getDateSGBDRToString("DATE_TELECHARGEMENT", true, "") + ", NOM_FICHIER,BEGIN_ACTIVITY,END_ACTIVITY,PREVIOUS_DOWNLOAD" + " FROM " + "t_vehicule" + " v INNER JOIN " + "t_telechargement_UEV" + " t ON v.CLE_VEHICULE = t.CLE_VEHICULE" + " WHERE   EXISTS " + "(   SELECT  1" + "    FROM    " + "t_telechargement_UEV" + " t2" + "    WHERE   t2.CLE_VEHICULE = t.CLE_VEHICULE" + "    HAVING  MAX(t2.DATE_TELECHARGEMENT) = t.DATE_TELECHARGEMENT" + ") ";
            if (agencyId != 0) {
                sql = String.valueOf(sql) + "AND CLE_AGENCE=" + agencyId;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION";
            Statement stm = UevDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule tmp = new Vehicule(rs.getInt("CLE_VEHICULE"), rs.getInt("CLE_AGENCE"), rs.getString("N_IMMATRICULATION"), rs.getString("DESIGNATION_VEHICULE"));
                result.add(new UevDownload(tmp, rs.getInt("CLE_USER"), rs.getTimestamp("DATE_TELECHARGEMENT"), rs.getString("NOM_FICHIER"), rs.getTimestamp("BEGIN_ACTIVITY"), rs.getTimestamp("END_ACTIVITY"), rs.getTimestamp("PREVIOUS_DOWNLOAD")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.data.UevDownload.getAllTelechargementUEV(  )  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        TimsLogger.debug("#UevDownload.loadLastList# returns " + result.size() + " vehicle files");
        return result;
    }
}

