/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.data.bdd.UevSpeed;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class UevEventsFaults
extends MainElement {
    public static final int OFFSET = 51;
    public static final String table = "UEV_EVENT_FAULT";
    private int id;
    private int vehicleId;
    private Date begin;
    private Date end;
    private int typeId;
    private int purposeId;
    private String driverCardBegin;
    private String codriverCardBegin;
    private String driverCardEnd;
    private String codriverCardEnd;
    private int similar = 0;

    public UevEventsFaults() {
    }

    public UevEventsFaults(int id, int vehicleId, Date begin, Date end, int typeId, int purposeId, String driverCardBegin, String codriverCardBegin, String driverCardEnd, String codriverCardEnd, int similar) {
        this.id = id;
        this.vehicleId = vehicleId;
        this.begin = begin;
        this.end = end;
        this.typeId = typeId;
        this.purposeId = purposeId;
        this.driverCardBegin = driverCardBegin;
        this.codriverCardBegin = codriverCardBegin;
        this.driverCardEnd = driverCardEnd;
        this.codriverCardEnd = codriverCardEnd;
        this.similar = similar;
    }

    public void set(int vehicleId, Date begin, Date end, int typeId, int purposeId, String driverCardBegin, String codriverCardBegin, String driverCardEnd, String codriverCardEnd, int similar) {
        this.vehicleId = vehicleId;
        this.begin = begin;
        this.end = end;
        this.typeId = typeId;
        this.purposeId = purposeId;
        this.driverCardBegin = driverCardBegin;
        this.codriverCardBegin = codriverCardBegin;
        this.driverCardEnd = driverCardEnd;
        this.codriverCardEnd = codriverCardEnd;
        this.similar = similar;
    }

    public boolean equals(Object object) {
        return object instanceof UevEventsFaults && ((UevEventsFaults)object).getBegin().equals(this.begin) && ((UevEventsFaults)object).getTypeId() == this.typeId && ((UevEventsFaults)object).getVehicleId() == this.vehicleId;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * (hash + this.vehicleId + this.begin.hashCode());
        return hash;
    }

    public boolean load(int cle, Date day) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT " + UevEventsFaults.getAllFields() + " FROM " + table + " WHERE VEHICLE_ID=? AND BEGIN = ?";
        try {
            try {
                this.statement = UevEventsFaults.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)cle, 4);
                this.statement.setObject(2, (Object)day, 93);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    this.vehicleId = rs.getInt("VEHICLE_ID");
                    this.begin = rs.getDate("BEGIN");
                    this.end = rs.getDate("END");
                    this.typeId = rs.getInt("TYPE_ID");
                    this.purposeId = rs.getInt("PURPOSE_ID");
                    this.driverCardBegin = rs.getString("DRIVER_CARD_BEGIN");
                    this.driverCardEnd = rs.getString("DRIVER_CARD_END");
                    this.codriverCardBegin = rs.getString("CODRIVER_CARD_BEGIN");
                    this.codriverCardEnd = rs.getString("CODRIVER_CARD_END");
                    this.similar = rs.getInt("SIMILAR");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#EventsFaultUev.load()# " + ex);
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public void insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO UEV_EVENT_FAULT (" + UevEventsFaults.getAllFields() + ") " + "VALUES (GEN_" + table.toUpperCase() + ".nextval,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO UEV_EVENT_FAULT (" + UevEventsFaults.getAllFields().substring(UevEventsFaults.getAllFields().indexOf(",") + 1) + ") " + "VALUES (?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = UevEventsFaults.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.vehicleId, 4);
                this.statement.setObject(2, (Object)this.typeId, 4);
                this.statement.setObject(3, (Object)this.purposeId, 4);
                this.statement.setTimestamp(4, new Timestamp(this.begin.getTime()));
                this.statement.setTimestamp(5, new Timestamp(this.end.getTime()));
                this.statement.setObject(6, (Object)this.driverCardBegin, 12);
                this.statement.setObject(7, (Object)this.driverCardEnd, 12);
                this.statement.setObject(8, (Object)this.codriverCardBegin, 12);
                this.statement.setObject(9, (Object)this.codriverCardEnd, 12);
                this.statement.setObject(10, (Object)this.similar, 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (SQLException e) {
                System.err.println("#EventsFaultUev.insert# erreur");
                System.err.print("VehicleId : " + this.vehicleId + " typeId : " + this.typeId + " purposeId : " + this.purposeId + " driverCardBegin : " + this.driverCardBegin + " driverCardEnd : " + this.driverCardEnd + " codriverCardBegin : " + this.codriverCardBegin + " codriverCardEnd : " + this.codriverCardEnd);
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean updateCard() {
        String sql = "UPDATE UEV_EVENT_FAULT SET  DRIVER_CARD_BEGIN=?  WHERE ID=?";
        try {
            this.statement = UevEventsFaults.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverCardBegin, 12);
            this.statement.setObject(2, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("update()#  sql = " + sql + " => " + ex);
        }
        return false;
    }

    public boolean compareAndUpdateCard(Conducteur driver) {
        String cardNumber = driver == null ? null : driver.getNumeroCarte();
        String tracer = String.valueOf(LanguageTranslator.getString("vehicle.event.type")) + " n\u00b0 " + this.id + " (" + this.begin + ") \n";
        if (Fonctions.fieldChange(this.driverCardBegin, cardNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.cardNumber") + " '" + this.driverCardBegin + "' => '" + "*" + cardNumber + "'\n";
            this.setDriverCardBegin(cardNumber == null ? null : "*" + cardNumber);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("vehicle.event.type")) + " n\u00b0 " + this.id + " (" + this.begin + ") \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
            if (this.updateCard()) {
                if (Fonctions.getLibelleEventFault(this.getTypeId()).equals(LanguageTranslator.getString("eventType.04"))) {
                    for (UevOffence toUpdate : UevOffence.load(this.vehicleId, this.begin, this.end)) {
                        toUpdate.setDriverId(driver == null ? 0 : driver.getCleConducteur());
                        toUpdate.update();
                    }
                    for (UevSpeed speedy : UevSpeed.load(this.vehicleId, this.begin, this.end, 0)) {
                        speedy.compareAndUpdateCard(driver);
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int cleVehicule) {
        this.vehicleId = cleVehicule;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public int getSimilar() {
        return this.similar;
    }

    public void setSimilar(int nbSimilaire) {
        this.similar = nbSimilaire;
    }

    public String getDriverCardBegin() {
        return this.driverCardBegin;
    }

    public void setDriverCardBegin(String numeroCarteConducteurDebut) {
        this.driverCardBegin = numeroCarteConducteurDebut;
    }

    public String getDriverCardEnd() {
        return this.driverCardEnd;
    }

    public void setDriverCardEnd(String numeroCarteConducteurFin) {
        this.driverCardEnd = numeroCarteConducteurFin;
    }

    public String getCodriverCardBegin() {
        return this.codriverCardBegin;
    }

    public void setCodriverCardBegin(String numeroCarteConvoyeurDebut) {
        this.codriverCardBegin = numeroCarteConvoyeurDebut;
    }

    public String getCodriverCardEnd() {
        return this.codriverCardEnd;
    }

    public void setCodriverCardEnd(String numeroCarteConvoyeurFin) {
        this.codriverCardEnd = numeroCarteConvoyeurFin;
    }

    public int getPurposeId() {
        return this.purposeId;
    }

    public void setPurposeId(int raisonEvenement) {
        this.purposeId = raisonEvenement;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeEvenement) {
        this.typeId = typeEvenement;
    }

    public String getSQLString() {
        return String.valueOf(this.vehicleId) + "\t" + this.typeId + "\t" + this.purposeId + "\t" + ConversionTime.dateToString(this.begin, "yyyy-MM-dd HH:mm:ss") + "\t" + ConversionTime.dateToString(this.end, "yyyy-MM-dd HH:mm:ss") + "\t" + this.driverCardBegin + "\t" + this.codriverCardBegin + "\t" + this.driverCardEnd + "\t" + this.codriverCardEnd + "\t" + this.similar;
    }

    private static String getAllFields() {
        return "ID, VEHICLE_ID, TYPE_ID, PURPOSE_ID, BEGIN, END, DRIVER_CARD_BEGIN, DRIVER_CARD_END, CODRIVER_CARD_BEGIN, CODRIVER_CARD_END, SIMILAR";
    }

    public static ArrayList<UevEventsFaults> load(int vehicleId, String begin, String end) {
        ArrayList<UevEventsFaults> liste = new ArrayList<UevEventsFaults>();
        String restriction = "";
        restriction = vehicleId != 0 ? String.valueOf(restriction) + " AND VEHICLE_ID = " + vehicleId : String.valueOf(restriction) + " AND VEHICLE_ID IN (SELECT CLE_VEHICULE FROM t_vehicule WHERE ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + ")";
        if (begin != null && !begin.equals("")) {
            restriction = String.valueOf(restriction) + " AND BEGIN >= " + BddTransport.getDateStringToSGBDR(begin, false);
        }
        if (end != null && !end.equals("")) {
            restriction = String.valueOf(restriction) + " AND BEGIN <= " + BddTransport.getDateStringToSGBDR(end, false);
        }
        String sql = "SELECT " + UevEventsFaults.getAllFields() + " FROM " + table;
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
        }
        sql = String.valueOf(sql) + " ORDER BY VEHICLE_ID, BEGIN";
        ResultSet rs = null;
        try {
            Transport.ps.startOperation();
            Statement stm = UevEventsFaults.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate evenements/anomalie uev", "#UevEventsFaults.load() => %s# sql = " + sql, 1);
            while (rs.next()) {
                liste.add(new UevEventsFaults(rs.getInt("ID"), rs.getInt("VEHICLE_ID"), rs.getTimestamp("BEGIN"), rs.getTimestamp("END"), rs.getInt("TYPE_ID"), rs.getInt("PURPOSE_ID"), rs.getString("DRIVER_CARD_BEGIN"), rs.getString("DRIVER_CARD_END"), rs.getString("CODRIVER_CARD_BEGIN"), rs.getString("CODRIVER_CARD_END"), rs.getInt("SIMILAR")));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("UevEventsFaults.load()  : " + ex);
            ex.printStackTrace();
            TimsLogger.debug("sql = " + sql);
        }
        return liste;
    }
}

