/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.bdd.UevOffence;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class UevSpeed
extends MainElement {
    public static final String table = "t_speed_uev";
    public static final int OFFSET = 53;
    public static final int ALL = 0;
    public static final int EVENT_ONLY = 1;
    private int id;
    private int cleVehicule;
    private Date dateDebut;
    private Date dateFin;
    private int typeSpeed;
    private int raisonSpeed;
    private int vitesseMax;
    private int vitesseMoyenne;
    private String numeroCarteConducteur;
    private int driverId = 0;
    private int nbSimilaire;

    public UevSpeed() {
    }

    public UevSpeed(int id, int cleVehicule, Date dateDebut, Date dateFin, int typeAnomalie, int raisonAnomalie, int vitesseMax, int vitesseMoyenne, String numeroCarteConducteur, int nbSimilaire) {
        this.id = id;
        this.cleVehicule = cleVehicule;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.typeSpeed = typeAnomalie;
        this.raisonSpeed = raisonAnomalie;
        this.vitesseMax = vitesseMax;
        this.vitesseMoyenne = vitesseMoyenne;
        this.numeroCarteConducteur = numeroCarteConducteur;
        this.nbSimilaire = nbSimilaire;
    }

    public void set(int cleVehicule, Date dateDebut, Date dateFin, int typeAnomalie, int raisonAnomalie, int vitesseMax, int vitesseMoyenne, String numeroCarteConducteur, int nbSimilaire) {
        this.cleVehicule = cleVehicule;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.typeSpeed = typeAnomalie;
        this.raisonSpeed = raisonAnomalie;
        this.vitesseMax = vitesseMax;
        this.vitesseMoyenne = vitesseMoyenne;
        this.numeroCarteConducteur = numeroCarteConducteur;
        this.nbSimilaire = nbSimilaire;
    }

    public boolean equals(Object object) {
        return object instanceof UevSpeed && ((UevSpeed)object).getDateDebut().equals(this.dateDebut) && ((UevSpeed)object).getCleVehicule() == this.cleVehicule;
    }

    public int hashCode() {
        int hash = 3;
        hash = 22 * (hash + this.cleVehicule + this.dateDebut.hashCode());
        return hash;
    }

    public boolean load(int cle, Date day) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT CLE_SPEED_UEV,CLE_VEHICULE,TYPE_SPEED,RAISON_SPEED,DATE_DEBUT,DATE_FIN,NUM_CARTE_COND,SPEED_MAX,SPEED_MOY,NBR_SIMILAIRE FROM t_speed_uev WHERE CLE_VEHICULE=? AND DATE_DEBUT = ?";
        try {
            try {
                this.statement = UevSpeed.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)cle, 4);
                this.statement.setTimestamp(2, new Timestamp(day.getTime()));
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("CLE_SPEED_UEV");
                    this.cleVehicule = rs.getInt("CLE_VEHICULE");
                    this.dateDebut = rs.getDate("DATE_DEBUT");
                    this.dateFin = rs.getDate("DATE_FIN");
                    this.typeSpeed = rs.getInt("TYPE_SPEED");
                    this.raisonSpeed = rs.getInt("RAISON_SPEED");
                    this.vitesseMax = rs.getInt("SPEED_MAX");
                    this.vitesseMoyenne = rs.getInt("SPEED_MOY");
                    this.numeroCarteConducteur = rs.getString("NUM_CARTE_COND");
                    this.nbSimilaire = rs.getInt("NBR_SIMILAIRE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#UevSpeed.load()# " + ex);
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public void insert() {
        try {
            this.statement = this.getPreparedStatement();
            this.statement.setObject(1, (Object)this.cleVehicule, 4);
            this.statement.setObject(2, (Object)this.typeSpeed, 4);
            this.statement.setObject(3, (Object)this.raisonSpeed, 4);
            this.statement.setTimestamp(4, new Timestamp(this.dateDebut.getTime()));
            this.statement.setTimestamp(5, new Timestamp(this.dateFin.getTime()));
            this.statement.setObject(6, (Object)this.numeroCarteConducteur, 12);
            this.statement.setObject(7, (Object)this.vitesseMax, 4);
            this.statement.setObject(8, (Object)this.vitesseMoyenne, 4);
            this.statement.setObject(9, (Object)this.nbSimilaire, 4);
            this.statement.executeUpdate();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            System.err.println("#SpeedUEV.insert# erreur");
            e.printStackTrace();
        }
    }

    public PreparedStatement getPreparedStatement() {
        if (this.statement == null) {
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO t_speed_uev (CLE_SPEED_UEV,CLE_VEHICULE,TYPE_SPEED,RAISON_SPEED,DATE_DEBUT,DATE_FIN,NUM_CARTE_COND,SPEED_MAX,SPEED_MOY,NBR_SIMILAIRE) VALUES (GEN_" + table.toUpperCase() + ".nextval,?,?,?,?,?,?,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO t_speed_uev (CLE_VEHICULE,TYPE_SPEED,RAISON_SPEED,DATE_DEBUT,DATE_FIN,NUM_CARTE_COND,SPEED_MAX,SPEED_MOY,NBR_SIMILAIRE) VALUES (?,?,?,?,?,?,?,?,?)";
            }
            try {
                this.statement = UevSpeed.getConnection().prepareStatement(sql);
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                System.err.println("#SpeedUEV.getPreparedStatement# erreur");
                ex.printStackTrace();
            }
        }
        return this.statement;
    }

    public void closeStatement() {
        try {
            this.getPreparedStatement().close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            System.err.println("#SpeedUEV.closeStatement# erreur");
            ex.printStackTrace();
        }
    }

    public int getCleVehicule() {
        return this.cleVehicule;
    }

    public void setCleVehicule(int cleVehicule) {
        this.cleVehicule = cleVehicule;
    }

    public Date getDateDebut() {
        return this.dateDebut;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public int getNbSimilaire() {
        return this.nbSimilaire;
    }

    public String getNumeroCarteConducteur() {
        return this.numeroCarteConducteur;
    }

    public void setNumeroCarteConducteur(String numeroCarteConducteur) {
        this.numeroCarteConducteur = numeroCarteConducteur;
    }

    public int getRaisonSpeed() {
        return this.raisonSpeed;
    }

    public int getTypeSpeed() {
        return this.typeSpeed;
    }

    public int getVitesseMax() {
        return this.vitesseMax;
    }

    public int getVitesseMoyenne() {
        return this.vitesseMoyenne;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = null;
            activite = String.valueOf(activite);
            int x = 0;
            while (x < 6) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            tmp.write((byte)this.typeSpeed);
            tmp.write((byte)this.raisonSpeed);
            tmp.write((byte)this.vitesseMax);
            tmp.write((byte)this.vitesseMoyenne);
            tmp.write((byte)this.nbSimilaire);
            tmp.write((byte)this.numeroCarteConducteur.length());
            tmp.write(this.numeroCarteConducteur.getBytes());
            out.write(53);
            out.write((byte)(tmp.toByteArray().length / 255 + 1));
            out.write((byte)tmp.toByteArray().length);
            out.write(tmp.toByteArray());
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#UevSpeed.write# " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 6) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            ++x;
        }
        this.dateDebut = null;
        this.dateFin = null;
        int offset = 6;
        this.typeSpeed = fileBuffer[offset];
        this.raisonSpeed = fileBuffer[++offset];
        this.vitesseMax = fileBuffer[++offset];
        this.vitesseMoyenne = fileBuffer[++offset];
        this.nbSimilaire = fileBuffer[++offset];
        int length = fileBuffer[++offset] >= 0 ? fileBuffer[offset] : fileBuffer[offset] + 256;
        this.numeroCarteConducteur = new String(fileBuffer).substring(++offset, offset + length);
        offset += length;
    }

    public String getSQLString() {
        return String.valueOf(this.cleVehicule) + "\t" + this.typeSpeed + "\t" + this.raisonSpeed + "\t" + ConversionTime.dateToString(this.dateDebut, "yyyy-MM-dd HH:mm:ss") + "\t" + ConversionTime.dateToString(this.dateFin, "yyyy-MM-dd HH:mm:ss") + "\t" + this.vitesseMax + "\t" + this.vitesseMoyenne + "\t" + this.numeroCarteConducteur + "\t" + this.nbSimilaire;
    }

    public boolean compareAndUpdateCard(Conducteur driver) {
        String cardNumber = driver == null ? null : driver.getNumeroCarte();
        String tracer = String.valueOf(LanguageTranslator.getString("vehicle.event.speed")) + " n\u00b0 " + this.id + " \n";
        if (Fonctions.fieldChange(this.numeroCarteConducteur, cardNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("driver.cardNumber") + " '" + this.numeroCarteConducteur + "' => '" + "*" + cardNumber + "'\n";
            this.setNumeroCarteConducteur(cardNumber == null ? null : "*" + cardNumber);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("vehicle.event.speed")) + " n\u00b0 " + this.id + " \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
            if (this.updateCard()) {
                for (UevOffence toUpdate : UevOffence.load(this.cleVehicule, this.dateDebut, this.dateFin)) {
                    toUpdate.setDriverId(driver == null ? 0 : driver.getCleConducteur());
                    toUpdate.update();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean updateCard() {
        String sql = "UPDATE t_speed_uev SET  NUM_CARTE_COND=?  WHERE CLE_SPEED_UEV=?";
        try {
            this.statement = UevSpeed.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.numeroCarteConducteur, 12);
            this.statement.setObject(2, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("UEVSpeed.updateCard()#  sql = " + sql + " => " + ex);
        }
        return false;
    }

    private static String getAllFields() {
        return "CLE_SPEED_UEV, CLE_VEHICULE, DATE_DEBUT, DATE_FIN, TYPE_SPEED, RAISON_SPEED, SPEED_MAX, SPEED_MOY, NUM_CARTE_COND, NBR_SIMILAIRE";
    }

    public static ArrayList<UevSpeed> load(int vehicleId, Date begin, Date end, int type) {
        return UevSpeed.load(vehicleId, ConversionTime.dateToString(begin, "yyyy-MM-dd HH:mm:ss"), ConversionTime.dateToString(end, "yyyy-MM-dd HH:mm:ss"), type);
    }

    public static ArrayList<UevSpeed> load(int vehicleId, String begin, String end, int type) {
        String restriction = "";
        restriction = vehicleId != 0 ? String.valueOf(restriction) + " AND CLE_VEHICULE = " + vehicleId : String.valueOf(restriction) + " AND CLE_VEHICULE IN (SELECT CLE_VEHICULE FROM t_vehicule WHERE ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + ")";
        if (begin != null && !begin.equals("")) {
            restriction = String.valueOf(restriction) + " AND DATE_DEBUT >= " + BddTransport.getDateStringToSGBDR(begin, false);
        }
        if (end != null && !end.equals("")) {
            restriction = String.valueOf(restriction) + " AND DATE_DEBUT <= " + BddTransport.getDateStringToSGBDR(end, false);
        }
        if (type == 1) {
            restriction = String.valueOf(restriction) + " AND TYPE_SPEED !=99 ";
        }
        if (!restriction.equals("")) {
            restriction = restriction.substring(5);
        }
        return UevSpeed.loadList(restriction);
    }

    public static ArrayList<UevSpeed> loadList(String filters) {
        ArrayList<UevSpeed> liste = new ArrayList<UevSpeed>();
        String sql = "SELECT " + UevSpeed.getAllFields() + " FROM " + table + (filters == null || filters.equals("") ? "" : " WHERE " + filters) + " ORDER BY DATE_DEBUT";
        ResultSet rs = null;
        try {
            Transport.ps.startOperation();
            Statement stm = UevSpeed.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate infraction uev", "#UevSpeed.load() => %s# sql = " + sql, 1);
            while (rs.next()) {
                UevSpeed toAdd = new UevSpeed(rs.getInt("CLE_SPEED_UEV"), rs.getInt("CLE_VEHICULE"), rs.getTimestamp("DATE_DEBUT"), rs.getTimestamp("DATE_FIN"), 0, 0, rs.getInt("SPEED_MAX"), rs.getInt("SPEED_MOY"), rs.getString("NUM_CARTE_COND"), rs.getInt("NBR_SIMILAIRE"));
                liste.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("UevSpeed.load()  : " + ex);
            ex.printStackTrace();
            TimsLogger.error("sql = " + sql);
        }
        return liste;
    }

    public boolean like(UevSpeed object) {
        return (object.getDateDebut().equals(this.dateDebut) || object.getDateFin().equals(this.dateFin)) && object.getCleVehicule() == this.cleVehicule && object.getVitesseMax() == this.vitesseMax;
    }
}

