/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class UserMessage
extends MainElement {
    public static final String table = "USER_MESSAGE";
    int id = 0;
    String name = null;
    String message = null;
    Date creationDate = null;

    public String toString() {
        return String.valueOf(this.message.length()) + " characters for message " + this.id;
    }

    public UserMessage() {
        this.creationDate = new Date();
    }

    public UserMessage(int id, String name, String message, Date creationDate) {
        this.id = id;
        this.name = name;
        this.message = message;
        this.creationDate = creationDate;
    }

    public boolean equals(Object object) {
        boolean toReturn = object instanceof UserMessage && ((UserMessage)object).getMessage() != null && this.getMessage() != null;
        return toReturn;
    }

    public int hashCode() {
        int hash = (this.message == null ? 0 : this.message.hashCode()) + "user_message".hashCode();
        return hash;
    }

    public boolean insert() {
        boolean toReturn = true;
        String sql = "";
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (" + UserMessage.getAllFields() + ")" + " VALUES (GEN_USER_MESSAGE.nextval,?,?,?)";
                    this.statement = UserMessage.getConnection().prepareStatement(sql, 1);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (" + UserMessage.getAllFields().substring(UserMessage.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
                    this.statement = UserMessage.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.name, 12);
                this.statement.setObject(2, (Object)this.message, 12);
                this.statement.setTimestamp(3, new Timestamp(this.creationDate.getTime()));
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    try {
                        ResultSet rs = this.statement.getGeneratedKeys();
                        if (!rs.next()) {
                            TimsLogger.warn("#UserMessage.insert# no auto generated key availaible");
                        } else {
                            TimsLogger.debug("#UserMessage.insert# auto generated key value = " + rs.getInt(1));
                            this.id = rs.getInt(1);
                        }
                        rs.close();
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("UserrMessage# generatedKeys unavailable");
                    }
                }
                if (this.id == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#Conducteur.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.warn("#Conducteur.insert# loadId failed");
                    }
                }
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                toReturn = false;
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                toReturn = false;
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID)  FROM " + BddTransport.getBaseDefault(true) + table + " WHERE NAME = ?";
        PreparedStatement statement = null;
        try {
            try {
                statement = UserMessage.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.name, 12);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("UserMessage.loadId()#  sql = " + sql);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean update() {
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET" + " NAME=?, " + " MESSAGE=? " + " WHERE ID=?";
        try {
            this.statement = UserMessage.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.message, 12);
            this.statement.setObject(3, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean compareAndUpdate(String name, String message) {
        TimsLogger.info("#UserMessage# name = " + name + ", message = " + message);
        if (this.id == 0) {
            this.name = name;
            this.message = message;
            return this.insert();
        }
        String tracer = String.valueOf(LanguageTranslator.getString("user.message")) + " : n\u00b0 " + this.id;
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.name") + " '" + this.name + "' => '" + name.length() + "'\n";
            this.setMessage(message);
        }
        if (Fonctions.fieldChange(message, this.message)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.message") + " '" + this.message.length() + " car message' => '" + message.length() + " car message'\n";
            this.setMessage(message);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("user.message")) + " : n\u00b0 " + this.id)) {
            if (this.update()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.info("#UserMessage# no changes");
        return true;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = UserMessage.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean load(int id) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT " + UserMessage.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID=?";
        try {
            try {
                this.statement = UserMessage.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)id, 4);
                rs = this.statement.executeQuery();
                if (rs.next()) {
                    this.id = id;
                    this.name = rs.getString("NAME");
                    this.message = rs.getString("MESSAGE");
                } else {
                    TimsLogger.info("#UserMessage.load# no data for message n\u00b0" + id);
                }
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                block24: {
                    TimsLogger.debug("#UserMessage.load(String id)# : " + ex);
                    if (Transport.debug < 2) break block24;
                    ex.printStackTrace();
                }
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public static Vector<UserMessage> loadList() {
        Vector<UserMessage> toReturn = new Vector<UserMessage>();
        ResultSet rs = null;
        Statement stm = null;
        String sql = "SELECT " + UserMessage.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table;
        try {
            try {
                stm = UserMessage.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new UserMessage(rs.getInt("ID"), rs.getString("NAME"), rs.getString("MESSAGE"), rs.getDate("CREATION_DATE")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("UserMessage.loadList()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    private static String getAllFields() {
        return "ID, NAME, MESSAGE, CREATION_DATE";
    }
}

