/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.CompanyWarningActivation;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class UserWarningActivation
extends MainElement {
    public static final String table = "USER_WARNING_ACTIVATION";
    private int id = 0;
    private int autoWarningId = 0;
    private int userId = 0;

    public UserWarningActivation(int id, int autoWarningId, int userId) {
        this.id = id;
        this.autoWarningId = autoWarningId;
        this.userId = userId;
    }

    public boolean equals(Object obj) {
        return obj instanceof CompanyWarningActivation && ((CompanyWarningActivation)obj).getAutoWarningId() == this.autoWarningId && ((CompanyWarningActivation)obj).getCompanyId() == this.userId;
    }

    public int hashCode() {
        return Integer.valueOf(this.userId).hashCode() + Integer.valueOf(this.autoWarningId).hashCode();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getAutoWarningId() {
        return this.autoWarningId;
    }

    public void setAutoWarningId(int autoWarningId) {
        this.autoWarningId = autoWarningId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int companyId) {
        this.userId = companyId;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        Statement statement = null;
        String sql = null;
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO USER_WARNING_ACTIVATION(ID, ID_WARNING, ID_USER) VALUES (GEN_USER_WARNING_ACTIVATION.nextval,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + "(ID_WARNING, ID_USER) VALUES " + "(?,?)";
            }
            if (sql == null) {
                TimsLogger.warn("#UserWarningActivation.insert# unknown database " + System.getProperty("SGBDR", "mysql"));
                return false;
            }
            try {
                statement = UserWarningActivation.getConnection().prepareStatement(sql);
                statement.setObject(1, this.autoWarningId, 4);
                statement.setObject(2, this.userId, 4);
                if (statement.executeUpdate() == 1) {
                    retour = true;
                }
                statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " ID_WARNING=?, " + " ID_USER=? " + " WHERE ID=?";
        try {
            try {
                this.statement = UserWarningActivation.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.autoWarningId, 4);
                this.statement.setObject(2, (Object)this.userId, 4);
                this.statement.setObject(3, (Object)this.id, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = UserWarningActivation.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static boolean multipleCreate(int userId, Vector<AutomaticWarning> toUpdate) {
        BddTransport.getInstance().startTransaction();
        for (AutomaticWarning iter : toUpdate) {
            if (new CompanyWarningActivation(0, iter.getId(), userId).insert()) continue;
            BddTransport.getInstance().rollback();
            return false;
        }
        BddTransport.getInstance().commit();
        return true;
    }

    public static boolean multipleDelete(int userId, Vector<AutomaticWarning> toDelete) {
        boolean toReturn = false;
        String where = "";
        if (userId != 0) {
            where = String.valueOf(where) + " AND ID_USER = " + userId;
        }
        if (toDelete != null) {
            where = String.valueOf(where) + " AND ID_WARNING IN (";
            String list = "";
            for (AutomaticWarning iter : toDelete) {
                list = String.valueOf(list) + "," + iter.getId();
            }
            where = String.valueOf(where) + list.substring(1) + ")";
        }
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table;
        if (!where.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + where.substring(5);
        }
        Statement stm = null;
        try {
            try {
                stm = UserWarningActivation.getConnection().createStatement();
                stm.executeUpdate(sql);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                TimsLogger.warn("#UWA.multipleDelete# sql error (" + sql + ")");
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static ArrayList<UserWarningActivation> getList(int userId) {
        ArrayList<UserWarningActivation> toReturn = new ArrayList<UserWarningActivation>();
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table;
        if (userId != -1) {
            sql = String.valueOf(sql) + " WHERE ID_USER = " + userId;
        }
        TimsLogger.info("#UWA.getList# soci\u00e9t\u00e9 : " + userId + " => " + sql);
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = UserWarningActivation.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new UserWarningActivation(rs.getInt("ID"), rs.getInt("ID_WARNING"), rs.getInt("ID_USER")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

