/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.dao.factory.DAOFactory;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Utilisateur
extends MainElement {
    public static final String table = "t_utilisateur";
    private int cleUser = 0;
    private int cleAgence = 0;
    private String nom = null;
    private String prenom = null;
    private String function = null;
    private String adresse = null;
    private String cp = null;
    private String ville = null;
    private String telephone = null;
    private String login = null;
    private String mdp = null;
    private int cleProfil = 0;
    private String societe = null;
    private Vector<Integer> resAgence = null;
    private int cleConducteur = 0;
    private String email = null;
    private String[] passe = null;
    private int nbJours;
    private boolean restreintSociete = true;
    private boolean restreintAgence = true;
    private boolean restreintConducteur = true;
    private boolean enable = false;
    private boolean alerted = false;
    private java.util.Date lastActivationAction = null;
    private String lastVersion = null;
    private ArrayList<AutomaticWarning> alerts = null;
    private static Vector<Utilisateur> list = null;

    public Utilisateur(int cleUser, int cleAgence, String nomUtilisateur, String prenomUtilisateur, String function, String adresse, String cp, String ville, String telephone, String login, String mdp, int cleProfil, String nomSociete, Vector<Integer> resAgence, int cleConducteur, String email, String[] passe, int nbJours, boolean restreintSociete, boolean restreintAgence, boolean restreintConducteur, boolean enable, boolean alerted, java.util.Date lastActivationAction) {
        this.cleUser = cleUser;
        this.cleAgence = cleAgence;
        this.nom = nomUtilisateur;
        this.prenom = prenomUtilisateur;
        this.function = function;
        this.adresse = adresse;
        this.cp = cp;
        this.ville = ville;
        this.telephone = telephone;
        this.login = login;
        this.mdp = mdp;
        this.cleProfil = cleProfil;
        this.societe = nomSociete;
        this.resAgence = resAgence;
        this.cleConducteur = cleConducteur;
        this.email = email;
        this.passe = passe;
        this.nbJours = nbJours;
        this.restreintSociete = restreintSociete;
        this.restreintAgence = restreintAgence;
        this.restreintConducteur = restreintConducteur;
        this.enable = enable;
        this.alerted = alerted;
        this.lastActivationAction = lastActivationAction;
    }

    public Utilisateur() {
        this.cleUser = 0;
        this.cleAgence = 0;
        this.nom = "Admin";
        this.prenom = "Admin";
        this.function = "Responsable";
        this.adresse = "Admin";
        this.cp = "Admin";
        this.ville = "Admin";
        this.telephone = "Admin";
        this.login = "Administrateur";
        this.mdp = "Admin";
        this.cleProfil = 1;
        this.societe = "AUCUNE";
        this.resAgence = new Vector();
        this.cleConducteur = 0;
        this.restreintSociete = false;
        this.restreintAgence = false;
        this.restreintConducteur = false;
        this.nbJours = 0;
        this.enable = true;
    }

    public Utilisateur(Utilisateur toCopy) {
        this.cleUser = toCopy.getCleUser();
        this.cleAgence = toCopy.getCleAgence();
        this.nom = toCopy.getNom();
        this.prenom = toCopy.getPrenom();
        this.function = toCopy.getFunction();
        this.adresse = toCopy.getAdresse();
        this.cp = toCopy.getCp();
        this.ville = toCopy.getVille();
        this.telephone = toCopy.getTelephone();
        this.login = toCopy.getLogin();
        this.mdp = toCopy.getMdp();
        this.cleProfil = toCopy.getCleProfil();
        this.societe = toCopy.getSociete();
        this.resAgence = toCopy.getResAgence();
        this.cleConducteur = toCopy.getCleConducteur();
        this.email = toCopy.getEmail();
        this.passe = toCopy.getPasse();
        this.nbJours = toCopy.getNbJours();
        this.restreintSociete = toCopy.isRestreintSociete();
        this.restreintAgence = toCopy.isRestreintAgence();
        this.restreintConducteur = toCopy.isRestreintConducteur();
        this.enable = toCopy.isEnable();
        this.alerted = toCopy.isAlerted();
        this.lastActivationAction = toCopy.lastActivationAction;
    }

    public Utilisateur(String nom, String prenom, int cleP, String nomS, int cleAgence, int cleConducteur, boolean enable) {
        this.nom = nom;
        this.prenom = prenom;
        this.cleProfil = cleP;
        this.societe = nomS;
        this.cleAgence = cleAgence;
        this.cleConducteur = cleConducteur;
        this.enable = enable;
    }

    public Utilisateur(String nom, String prenom) {
        this.nom = nom;
        this.prenom = prenom;
    }

    public boolean equals(Object o) {
        return o instanceof Utilisateur && this.login.equals(((Utilisateur)o).getLogin()) && this.nom.equals(((Utilisateur)o).getNom()) && this.prenom.equals(((Utilisateur)o).getPrenom());
    }

    public String toString() {
        return String.valueOf(this.getNom()) + " " + this.getPrenom() + " (" + this.getLogin() + ")";
    }

    public void afficheUser() {
        TimsLogger.info("Affichage de l'utilisateur " + (this.enable ? "(actif" + (this.lastActivationAction != null ? " depuis le " + this.lastActivationAction : "") + ")" : "(inactif" + (this.lastActivationAction != null ? " depuis le " + this.lastActivationAction : "") + ")"));
        TimsLogger.info("\t Nom : " + this.getNom() + "\t Prenom : " + this.getPrenom() + "\t Clep : " + this.getCleProfil() + "\t Soci\u00e9t\u00e9 : " + this.getSociete() + " +\t Mdp : " + this.getMdp().length() + "\t Login : " + this.getLogin() + "\t CleC : " + this.getCleConducteur() + "\t nbJours : " + this.getNbJours() + "\t Restreint : " + this.isRestreintAgence() + ", " + this.isRestreintConducteur() + ", " + this.isRestreintConducteur());
        TimsLogger.info("\t Restriction agence : " + this.getResAgence().size() + " agences : ");
        int x = 0;
        while (x < this.getResAgence().size()) {
            TimsLogger.info(this.getResAgence().get(x) + " ");
            ++x;
        }
    }

    public void insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (CLE_UTILISATEUR,NOM_UTILISATEUR, PRENOM_UTILISATEUR, LOGIN_UTILISATEUR," + " PASSWORD_UTILISATEUR,CLE_PROFIL, CLE_AGENCE, CLE_CHAUFFEUR, NOM_SOCIETE,ANCIEN_PASSE, ENABLE, ALERTED, EMAIL," + " RESTRICTION_SOCIETE, RESTRICTION_AGENCE, RESTRICTION_CONDUCTEUR)" + " VALUES (GEN_T_UTILISATEUR.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (NOM_UTILISATEUR, PRENOM_UTILISATEUR, LOGIN_UTILISATEUR," + " PASSWORD_UTILISATEUR,CLE_PROFIL, CLE_AGENCE, CLE_CHAUFFEUR, NOM_SOCIETE, ANCIEN_PASSE, ENABLE, ALERTED, EMAIL," + " RESTRICTION_SOCIETE, RESTRICTION_AGENCE, RESTRICTION_CONDUCTEUR)" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = Utilisateur.getConnection().prepareStatement(sql, 1);
                this.statement.setObject(1, (Object)this.nom, 12);
                this.statement.setObject(2, (Object)this.prenom, 12);
                this.statement.setObject(3, (Object)this.login, 12);
                this.statement.setObject(4, (Object)this.mdp, 12);
                this.statement.setObject(5, (Object)this.cleProfil, 4);
                this.statement.setObject(6, (Object)this.cleAgence, 12);
                this.statement.setObject(7, (Object)this.cleConducteur, 12);
                this.statement.setObject(8, (Object)this.societe, 12);
                this.statement.setObject(9, (Object)(String.valueOf(this.mdp) + ";"), 12);
                this.statement.setObject(10, (Object)(this.enable ? 1 : 0), 4);
                this.statement.setObject(11, (Object)(this.alerted ? 1 : 0), 4);
                this.statement.setObject(12, (Object)this.email, 12);
                this.statement.setObject(13, (Object)(this.restreintSociete ? 1 : 0), 4);
                this.statement.setObject(14, (Object)(this.restreintAgence ? 1 : 0), 4);
                this.statement.setObject(15, (Object)(this.restreintConducteur ? 1 : 0), 4);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    try {
                        ResultSet rs = this.statement.getGeneratedKeys();
                        if (!rs.next()) {
                            TimsLogger.warn("#Utilisateur.insert# no auto generated key availaible");
                        } else {
                            TimsLogger.debug("#Utilisateur.insert# auto generated key value = " + rs.getInt(1));
                            this.cleUser = rs.getInt(1);
                        }
                        rs.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (this.cleUser == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#Utilisateur.insert# generated key value = " + this.cleConducteur);
                    } else {
                        TimsLogger.warn("#Utilisateur.insert# no generated key availaible");
                    }
                }
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    this.statement.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(CLE_USER) AS CLE_USER FROM t_utilisateur WHERE LOGIN_UTILISATEUR = ? AND ARCHIVAGE=0";
        PreparedStatement statement = null;
        try {
            try {
                statement = Utilisateur.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.login, 12);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.cleUser = rs.getInt("CLE_USER");
                    TimsLogger.debug("#Utilisateur.loadId# id found " + rs.getInt("CLE_USER"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("#Utilisateur.loadId()#  sql = " + sql);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " NOM_UTILISATEUR=?," + " PRENOM_UTILISATEUR=?," + " LOGIN_UTILISATEUR=?," + " EMAIL=?," + " VILLE=?," + " ADRESSE=?," + " TELEPHONE=?," + " CODE_POSTAL=?," + " CLE_PROFIL=?," + " CLE_AGENCE=?," + " CLE_CHAUFFEUR=?," + " NOM_SOCIETE=?," + " ENABLE=?," + " ALERTED=?," + " LAST_ACTIVATION_ACTION=?," + " RESTRICTION_SOCIETE=?," + " RESTRICTION_AGENCE=?," + " RESTRICTION_CONDUCTEUR=?" + " WHERE CLE_UTILISATEUR=?";
        try {
            this.statement = Utilisateur.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.nom, 12);
            this.statement.setObject(2, (Object)this.prenom, 12);
            this.statement.setObject(3, (Object)this.login, 12);
            this.statement.setObject(4, (Object)this.email, 12);
            this.statement.setObject(5, (Object)this.ville, 12);
            this.statement.setObject(6, (Object)this.adresse, 12);
            this.statement.setObject(7, (Object)this.telephone, 12);
            this.statement.setObject(8, (Object)this.cp, 12);
            this.statement.setObject(9, (Object)this.cleProfil, 4);
            this.statement.setObject(10, (Object)this.cleAgence, 4);
            this.statement.setObject(11, (Object)this.cleConducteur, 4);
            this.statement.setObject(12, (Object)this.societe, 12);
            this.statement.setObject(13, (Object)(this.enable ? 1 : 0), 4);
            this.statement.setObject(14, (Object)(this.alerted ? 1 : 0), 4);
            this.statement.setTimestamp(15, this.lastActivationAction != null ? new Timestamp(this.lastActivationAction.getTime()) : null);
            this.statement.setObject(16, (Object)(this.restreintSociete ? 1 : 0), 4);
            this.statement.setObject(17, (Object)(this.restreintAgence ? 1 : 0), 4);
            this.statement.setObject(18, (Object)(this.restreintConducteur ? 1 : 0), 4);
            this.statement.setObject(19, (Object)this.cleUser, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public void updatePassword() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " PASSWORD_UTILISATEUR=? ," + " CHANGEMENT_PASSE=? ," + " ANCIEN_PASSE=CONCAT(?,';',ANCIEN_PASSE)" + " WHERE CLE_UTILISATEUR=?";
        }
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " PASSWORD_UTILISATEUR=? ," + " CHANGEMENT_PASSE=? ," + " ANCIEN_PASSE=?||';'||ANCIEN_PASSE" + " WHERE CLE_UTILISATEUR=?";
        }
        try {
            this.statement = Utilisateur.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.mdp, 12);
            java.util.Date date = new java.util.Date();
            Date dateSQL = new Date(date.getTime());
            this.statement.setDate(2, dateSQL);
            this.statement.setObject(3, (Object)this.mdp, 12);
            this.statement.setObject(4, (Object)this.cleUser, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean compareAndUpdate(String lastName, String firstName, String mail, String companyName, boolean companyRestriction, boolean agencyRestriction, boolean driverRestriction, int profilId, int driverId, boolean enable, java.util.Date lastActivationAction, boolean alerted) {
        String tracer = String.valueOf(LanguageTranslator.getString("user")) + " : n\u00b0 " + this.cleUser + " (" + this.getNom() + ") \n";
        if (Fonctions.fieldChange(lastName, this.nom)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.lastName") + " '" + this.nom + "' => '" + lastName + "'\n";
            this.setNom(lastName);
        }
        if (Fonctions.fieldChange(firstName, this.prenom)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.firstName") + " '" + this.prenom + "' => '" + firstName + "'\n";
            this.setPrenom(firstName);
        }
        if (Fonctions.fieldChange(mail, this.email)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.email") + " '" + this.email + "' => '" + mail + "'\n";
            this.setEmail(mail);
        }
        if (Fonctions.fieldChange(companyName, this.societe)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.email") + " '" + this.societe + "' => '" + companyName + "'\n";
            this.setSociete(companyName);
        }
        if (companyRestriction != this.restreintSociete) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.company") + " '" + this.restreintSociete + "' => '" + companyRestriction + "'\n";
            this.setRestreintSociete(companyRestriction);
        }
        if (agencyRestriction != this.restreintAgence) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.agency") + " '" + this.restreintAgence + "' => '" + agencyRestriction + "'\n";
            this.setRestreintAgence(agencyRestriction);
        }
        if (driverRestriction != this.restreintConducteur) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.driver") + " '" + this.restreintConducteur + "' => '" + driverRestriction + "'\n";
            this.setRestreintConducteur(driverRestriction);
        }
        if (profilId != this.cleProfil) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.profil") + " '" + this.cleProfil + "' => '" + profilId + "'\n";
            this.setCleProfil(profilId);
        }
        if (driverId != this.cleConducteur) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.driver") + " '" + this.cleConducteur + "' => '" + driverId + "'\n";
            this.setCleConducteur(driverId);
        }
        if (enable != this.enable) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.enable") + " '" + this.enable + "' => '" + enable + "'\n";
            this.setEnable(enable);
        }
        if (Fonctions.fieldChange(lastActivationAction, this.lastActivationAction)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.lastActivationAction") + " '" + this.lastActivationAction + "' => '" + lastActivationAction + "'\n";
            this.setLastActivationAction(lastActivationAction);
        }
        if (alerted != this.alerted) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.alert") + " '" + this.alerted + "' => '" + alerted + "'\n";
            this.setAlerted(alerted);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("user")) + " : n\u00b0 " + this.cleUser + " (" + this.getNom() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.info("#TypeActivite# no changes");
        return true;
    }

    public void setRestreint(boolean restreint2, boolean restreint3) {
        this.restreintAgence = restreint2;
        this.restreintConducteur = restreint3;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public int getCleAgence() {
        return this.cleAgence;
    }

    public void setCleAgence(int cleAgence) {
        this.cleAgence = cleAgence;
    }

    public int getCleConducteur() {
        return this.cleConducteur;
    }

    public void setCleConducteur(int cleConducteur) {
        this.cleConducteur = cleConducteur;
    }

    public int getCleProfil() {
        return this.cleProfil;
    }

    public void setCleProfil(int cleProfil) {
        this.cleProfil = cleProfil;
    }

    public int getCleUser() {
        return this.cleUser;
    }

    public void setCleUser(int cleUser) {
        this.cleUser = cleUser;
    }

    public String getCp() {
        return this.cp;
    }

    public void setCp(String cp) {
        this.cp = cp;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getMdp() {
        return this.mdp;
    }

    public void setMdp(String mdp) {
        this.mdp = mdp;
    }

    public int getNbJours() {
        return this.nbJours;
    }

    public void setNbJours(int nbJours) {
        this.nbJours = nbJours;
    }

    public String getSociete() {
        return this.societe;
    }

    public void setSociete(String nomSociete) {
        this.societe = nomSociete;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String[] getPasse() {
        return this.passe;
    }

    public void setPasse(String[] passe) {
        this.passe = passe;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String prenomUtilisateur) {
        this.prenom = prenomUtilisateur;
    }

    public Vector<Integer> getResAgence() {
        return this.resAgence;
    }

    public void setResAgence(Vector<Integer> resAgence) {
        this.resAgence = resAgence;
    }

    public boolean isRestreintAgence() {
        return this.restreintAgence;
    }

    public void setRestreintAgence(boolean restreintAgence) {
        this.restreintAgence = restreintAgence;
    }

    public boolean isRestreintConducteur() {
        return this.restreintConducteur;
    }

    public void setRestreintConducteur(boolean restreintConducteur) {
        this.restreintConducteur = restreintConducteur;
    }

    public boolean isRestreintSociete() {
        return this.restreintSociete;
    }

    public void setRestreintSociete(boolean restreintSociete) {
        this.restreintSociete = restreintSociete;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getVille() {
        return this.ville;
    }

    public void setVille(String ville) {
        this.ville = ville;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isAlerted() {
        return this.alerted;
    }

    public void setAlerted(boolean alerted) {
        this.alerted = alerted;
    }

    public java.util.Date getLastActivationAction() {
        return this.lastActivationAction;
    }

    public void setLastActivationAction(java.util.Date lastActivationAction) {
        this.lastActivationAction = lastActivationAction;
    }

    public String getLastVersion() {
        return this.lastVersion;
    }

    public void setLastVersion(String lastVersion) {
        this.lastVersion = lastVersion;
    }

    public ArrayList<AutomaticWarning> getAlerts() {
        if (!this.isAlerted() || this.getCleUser() == 0) {
            return null;
        }
        if (this.alerts == null) {
            this.alerts = DAOFactory.getDAOAutomaticWarning().getCompanyAll(this.getCleUser());
        }
        return this.alerts;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE CLE_UTILISATEUR =?";
        try {
            this.statement = Utilisateur.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.cleUser);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static Utilisateur getUser(int cleUser) {
        String sql = "";
        Statement statement = null;
        ResultSet rs = null;
        Utilisateur user = null;
        try {
            try {
                sql = "SELECT " + Utilisateur.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " LEFT JOIN " + BddTransport.getBaseDefault(true) + "t_restriction" + " ON " + table + ".CLE_UTILISATEUR = " + "t_restriction" + ".CLE_USER" + " WHERE CLE_UTILISATEUR = " + cleUser + " ORDER BY LOGIN_UTILISATEUR";
                statement = Utilisateur.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                Vector<Integer> resAgence = new Vector<Integer>();
                while (rs.next()) {
                    user = new Utilisateur(rs.getInt("CLE_UTILISATEUR"), rs.getInt("t_utilisateur.CLE_AGENCE"), rs.getString("NOM_UTILISATEUR"), rs.getString("PRENOM_UTILISATEUR"), rs.getString("USER_FUNCTION"), rs.getString("ADRESSE"), rs.getString("CODE_POSTAL"), rs.getString("VILLE"), rs.getString("TELEPHONE"), rs.getString("LOGIN_UTILISATEUR"), rs.getString("PASSWORD_UTILISATEUR"), rs.getInt("CLE_PROFIL"), rs.getString("NOM_SOCIETE"), new Vector<Integer>(), rs.getInt("CLE_CHAUFFEUR"), rs.getString("EMAIL"), rs.getString("ANCIEN_PASSE").split(";"), rs.getInt("NB_JOUR"), rs.getBoolean("RESTRICTION_SOCIETE"), rs.getBoolean("RESTRICTION_AGENCE"), rs.getBoolean("RESTRICTION_CONDUCTEUR"), rs.getBoolean("ENABLE"), rs.getBoolean("ALERTED"), rs.getDate("LAST_ACTIVATION_ACTION"));
                    int cleAgence = rs.getInt("AGENCE_RES");
                    if (cleAgence != 0) {
                        resAgence.add(rs.getInt("AGENCE_RES"));
                    }
                    user.setResAgence(resAgence);
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception ex) {
                TimsLogger.warn("transpo.data.BddTransport.getUserList()");
                ex.printStackTrace();
                TimsLogger.info("sql = " + sql);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return user;
    }

    public static void setList(Vector<Utilisateur> list) {
        Utilisateur.list = list;
    }

    public static Vector<Utilisateur> list(String companyName) {
        if ((companyName == null || companyName.equals("")) && list != null) {
            return list;
        }
        Vector<Utilisateur> result = new Vector<Utilisateur>();
        String sql = "";
        try {
            sql = "SELECT " + Utilisateur.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " LEFT JOIN " + BddTransport.getBaseDefault(true) + "t_restriction" + " ON " + table + ".CLE_UTILISATEUR = " + "t_restriction" + ".CLE_USER";
            if (companyName != null && !companyName.equals("")) {
                sql = String.valueOf(sql) + " WHERE NOM_SOCIETE = '" + BddTransport.addSlashes(companyName) + "'";
            }
            sql = String.valueOf(sql) + " ORDER BY NOM_UTILISATEUR";
            Statement stm = Utilisateur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Utilisateur precUser = null;
            while (rs.next()) {
                int cleAgence;
                Utilisateur lineUser = new Utilisateur(rs.getInt("CLE_UTILISATEUR"), rs.getInt("t_utilisateur.CLE_AGENCE"), rs.getString("NOM_UTILISATEUR"), rs.getString("PRENOM_UTILISATEUR"), rs.getString("USER_FUNCTION"), rs.getString("ADRESSE"), rs.getString("CODE_POSTAL"), rs.getString("VILLE"), rs.getString("TELEPHONE"), rs.getString("LOGIN_UTILISATEUR"), rs.getString("PASSWORD_UTILISATEUR"), rs.getInt("CLE_PROFIL"), rs.getString("NOM_SOCIETE"), new Vector<Integer>(), rs.getInt("CLE_CHAUFFEUR"), rs.getString("EMAIL"), rs.getString("ANCIEN_PASSE").split(";"), rs.getInt("NB_JOUR"), rs.getBoolean("RESTRICTION_SOCIETE"), rs.getBoolean("RESTRICTION_AGENCE"), rs.getBoolean("RESTRICTION_CONDUCTEUR"), rs.getBoolean("ENABLE"), rs.getBoolean("ALERTED"), rs.getDate("LAST_ACTIVATION_ACTION"));
                if (precUser == null || lineUser.getCleUser() != precUser.getCleUser()) {
                    result.add(new Utilisateur(lineUser));
                    precUser = lineUser;
                }
                if ((cleAgence = rs.getInt("AGENCE_RES")) == 0) continue;
                precUser.getResAgence().add(rs.getInt("AGENCE_RES"));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Utilisteur.getUserList()");
            ex.printStackTrace();
            TimsLogger.info("sql = " + sql);
        }
        if ((companyName == null || companyName.equals("")) && list == null) {
            list = result;
        }
        return result;
    }

    public static String getAllFields() {
        return "LOGIN_UTILISATEUR, PASSWORD_UTILISATEUR, NOM_UTILISATEUR, PRENOM_UTILISATEUR, USER_FUNCTION, CLE_UTILISATEUR, CLE_PROFIL, NOM_SOCIETE, t_utilisateur.CLE_AGENCE, CLE_CHAUFFEUR, ADRESSE, CODE_POSTAL, VILLE, TELEPHONE, EMAIL,t_restriction.CLE_AGENCE AS AGENCE_RES, ANCIEN_PASSE, " + BddTransport.getDateDiff(BddTransport.getCurrentDate(), "CHANGEMENT_PASSE") + " as NB_JOUR" + " ,RESTRICTION_SOCIETE,RESTRICTION_AGENCE, RESTRICTION_CONDUCTEUR, ENABLE, ALERTED, LAST_ACTIVATION_ACTION";
    }

    public boolean loadById(int id) {
        boolean toReturn = false;
        String sql = "";
        try {
            sql = "SELECT LOGIN_UTILISATEUR, PASSWORD_UTILISATEUR, NOM_UTILISATEUR, PRENOM_UTILISATEUR, USER_FUNCTION,  CLE_UTILISATEUR, CLE_PROFIL, NOM_SOCIETE, t_utilisateur.CLE_AGENCE, CLE_CHAUFFEUR, ADRESSE, CODE_POSTAL, VILLE, TELEPHONE, EMAIL, ANCIEN_PASSE, " + BddTransport.getDateDiff(BddTransport.getCurrentDate(), "CHANGEMENT_PASSE") + " as NB_JOUR" + " ,RESTRICTION_SOCIETE,RESTRICTION_AGENCE, RESTRICTION_CONDUCTEUR, ENABLE, ALERTED, LAST_ACTIVATION_ACTION" + " FROM " + BddTransport.getBaseDefault(true) + table + " WHERE CLE_UTILISATEUR = " + id + " ORDER BY LOGIN_UTILISATEUR";
            Statement stm = Utilisateur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                this.cleUser = rs.getInt("CLE_UTILISATEUR");
                this.cleAgence = rs.getInt("CLE_AGENCE");
                this.nom = rs.getString("NOM_UTILISATEUR");
                this.prenom = rs.getString("PRENOM_UTILISATEUR");
                this.function = rs.getString("USER_FUNCTION");
                this.adresse = rs.getString("ADRESSE");
                this.cp = rs.getString("CODE_POSTAL");
                this.ville = rs.getString("VILLE");
                this.telephone = rs.getString("TELEPHONE");
                this.login = rs.getString("LOGIN_UTILISATEUR");
                this.mdp = rs.getString("PASSWORD_UTILISATEUR");
                this.cleProfil = rs.getInt("CLE_PROFIL");
                this.societe = rs.getString("NOM_SOCIETE");
                this.cleConducteur = rs.getInt("CLE_CHAUFFEUR");
                this.email = rs.getString("EMAIL");
                this.passe = rs.getString("ANCIEN_PASSE").split(";");
                this.nbJours = rs.getInt("NB_JOUR");
                this.restreintSociete = rs.getBoolean("RESTRICTION_SOCIETE");
                this.restreintAgence = rs.getBoolean("RESTRICTION_AGENCE");
                this.restreintConducteur = rs.getBoolean("RESTRICTION_CONDUCTEUR");
                this.enable = rs.getBoolean("ENABLE");
                this.alerted = rs.getBoolean("ALERTED");
                this.lastActivationAction = rs.getDate("LAST_ACTIVATION_ACTION");
                toReturn = true;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Utilisteur.loadById()");
            ex.printStackTrace();
            TimsLogger.info("sql = " + sql);
        }
        return toReturn;
    }

    public static Utilisateur loadByLogin(String login, String mdp) {
        Utilisateur result = null;
        String sql = "";
        try {
            sql = "SELECT " + Utilisateur.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " LEFT JOIN " + BddTransport.getBaseDefault(true) + "t_restriction" + " ON " + table + ".CLE_UTILISATEUR = " + "t_restriction" + ".CLE_USER" + " WHERE lower(" + table + ".LOGIN_UTILISATEUR) ='" + login.toLowerCase() + "'" + " AND " + table + ".PASSWORD_UTILISATEUR ='" + mdp + "' " + " ORDER BY LOGIN_UTILISATEUR";
            Statement stm = Utilisateur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Vector<Integer> resAgence = new Vector<Integer>();
            while (rs.next()) {
                int cleAgence;
                if (result == null) {
                    result = new Utilisateur(rs.getInt("CLE_UTILISATEUR"), rs.getInt("t_utilisateur.CLE_AGENCE"), rs.getString("NOM_UTILISATEUR"), rs.getString("PRENOM_UTILISATEUR"), rs.getString("USER_FUNCTION"), rs.getString("ADRESSE"), rs.getString("CODE_POSTAL"), rs.getString("VILLE"), rs.getString("TELEPHONE"), rs.getString("LOGIN_UTILISATEUR"), rs.getString("PASSWORD_UTILISATEUR"), rs.getInt("CLE_PROFIL"), rs.getString("NOM_SOCIETE"), resAgence, rs.getInt("CLE_CHAUFFEUR"), rs.getString("EMAIL"), rs.getString("ANCIEN_PASSE").split(";"), rs.getInt("NB_JOUR"), rs.getBoolean("RESTRICTION_SOCIETE"), rs.getBoolean("RESTRICTION_AGENCE"), rs.getBoolean("RESTRICTION_CONDUCTEUR"), rs.getBoolean("ENABLE"), rs.getBoolean("ALERTED"), rs.getDate("LAST_ACTIVATION_ACTION"));
                }
                if ((cleAgence = rs.getInt("AGENCE_RES")) == 0) continue;
                resAgence.add(rs.getInt("AGENCE_RES"));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Utilisteur.getUserList()");
            ex.printStackTrace();
            TimsLogger.info("sql = " + sql);
        }
        return result;
    }

    public static Vector<?> list(Integer[] companiesId) {
        Vector<Utilisateur> result = new Vector<Utilisateur>();
        String sql = "";
        try {
            sql = "SELECT " + Utilisateur.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " LEFT JOIN " + BddTransport.getBaseDefault(true) + "t_restriction" + " ON " + table + ".CLE_UTILISATEUR = " + "t_restriction" + ".CLE_USER";
            String companies = "";
            if (companiesId.length != 0 && companiesId[0] != 0) {
                Integer[] integerArray = companiesId;
                int n = companiesId.length;
                int n2 = 0;
                while (n2 < n) {
                    int cle = integerArray[n2];
                    if (cle != 0) {
                        companies = String.valueOf(companies) + "," + cle;
                    }
                    ++n2;
                }
            }
            if (!companies.equals("")) {
                sql = String.valueOf(sql) + " WHERE NOM_SOCIETE IN (SELECT COMPANY_NAME FROM " + BddTransport.getBaseDefault(true) + "t_societe" + " WHERE CLE_SOCIETE IN (" + companies.substring(1) + "))";
            }
            sql = String.valueOf(sql) + " ORDER BY LOGIN_UTILISATEUR";
            Statement stm = Utilisateur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Utilisateur precUser = null;
            TimsLogger.debug(sql);
            while (rs.next()) {
                int cleAgence;
                Utilisateur lineUser = new Utilisateur(rs.getInt("CLE_UTILISATEUR"), rs.getInt("t_utilisateur.CLE_AGENCE"), rs.getString("NOM_UTILISATEUR"), rs.getString("PRENOM_UTILISATEUR"), rs.getString("USER_FUNCTION"), rs.getString("ADRESSE"), rs.getString("CODE_POSTAL"), rs.getString("VILLE"), rs.getString("TELEPHONE"), rs.getString("LOGIN_UTILISATEUR"), rs.getString("PASSWORD_UTILISATEUR"), rs.getInt("CLE_PROFIL"), rs.getString("NOM_SOCIETE"), new Vector<Integer>(), rs.getInt("CLE_CHAUFFEUR"), rs.getString("EMAIL"), rs.getString("ANCIEN_PASSE").split(";"), rs.getInt("NB_JOUR"), rs.getBoolean("RESTRICTION_SOCIETE"), rs.getBoolean("RESTRICTION_AGENCE"), rs.getBoolean("RESTRICTION_CONDUCTEUR"), rs.getBoolean("ENABLE"), rs.getBoolean("ALERTED"), rs.getDate("LAST_ACTIVATION_ACTION"));
                if (!lineUser.equals(precUser)) {
                    result.add(new Utilisateur(lineUser));
                    precUser = lineUser;
                }
                if ((cleAgence = rs.getInt("AGENCE_RES")) == 0) continue;
                precUser.getResAgence().add(rs.getInt("AGENCE_RES"));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Utilisteur.getUserList()");
            ex.printStackTrace();
            TimsLogger.info("sql = " + sql);
        }
        return result;
    }

    public static Vector<Utilisateur> listAdmin() {
        Vector<Utilisateur> result = new Vector<Utilisateur>();
        String sql = "";
        try {
            sql = "SELECT " + Utilisateur.getAllFields() + " FROM " + BddTransport.getBaseDefault(true) + table + " LEFT JOIN " + BddTransport.getBaseDefault(true) + "t_restriction" + " ON " + table + ".CLE_UTILISATEUR = " + "t_restriction" + ".CLE_USER";
            sql = String.valueOf(sql) + " WHERE CLE_PROFIL = 1 AND ENABLE = 1";
            sql = String.valueOf(sql) + " ORDER BY LOGIN_UTILISATEUR";
            Statement stm = Utilisateur.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            Utilisateur precUser = null;
            while (rs.next()) {
                int cleAgence;
                Utilisateur lineUser = new Utilisateur(rs.getInt("CLE_UTILISATEUR"), rs.getInt("t_utilisateur.CLE_AGENCE"), rs.getString("NOM_UTILISATEUR"), rs.getString("PRENOM_UTILISATEUR"), rs.getString("USER_FUNCTION"), rs.getString("ADRESSE"), rs.getString("CODE_POSTAL"), rs.getString("VILLE"), rs.getString("TELEPHONE"), rs.getString("LOGIN_UTILISATEUR"), rs.getString("PASSWORD_UTILISATEUR"), rs.getInt("CLE_PROFIL"), rs.getString("NOM_SOCIETE"), new Vector<Integer>(), rs.getInt("CLE_CHAUFFEUR"), rs.getString("EMAIL"), rs.getString("ANCIEN_PASSE").split(";"), rs.getInt("NB_JOUR"), rs.getBoolean("RESTRICTION_SOCIETE"), rs.getBoolean("RESTRICTION_AGENCE"), rs.getBoolean("RESTRICTION_CONDUCTEUR"), rs.getBoolean("ENABLE"), rs.getBoolean("ALERTED"), rs.getDate("LAST_ACTIVATION_ACTION"));
                if (!lineUser.equals(precUser)) {
                    result.add(new Utilisateur(lineUser));
                    precUser = lineUser;
                }
                if ((cleAgence = rs.getInt("AGENCE_RES")) == 0) continue;
                precUser.getResAgence().add(rs.getInt("AGENCE_RES"));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Utilisteur.getUserList()");
            ex.printStackTrace();
            TimsLogger.info("sql = " + sql);
        }
        return result;
    }

    public static Utilisateur find(int userId) throws DBObjectNotFoundException {
        if (list == null) {
            Utilisateur.list("");
        }
        for (Utilisateur tmp : list) {
            if (tmp.getCleUser() != userId) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("Utilisateur");
    }
}

