/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class VehicleAttachment
extends MainElement {
    public static final String table = "VEHICLE_ATTACHMENT";
    private static Vector<VehicleAttachment> list = null;
    private int id = 0;
    private int vehicleId = 0;
    private String documentName = null;

    public VehicleAttachment() {
    }

    public VehicleAttachment(int id, int vehicleId, String documentName) {
        this.id = id;
        this.vehicleId = vehicleId;
        this.documentName = documentName;
    }

    public boolean equals(Object o) {
        return o instanceof VehicleAttachment && this.documentName.equals(((VehicleAttachment)o).getDocumentName());
    }

    public String toString() {
        return this.getDocumentName();
    }

    public boolean loadByName(String designation) {
        String sql = "SELECT " + VehicleAttachment.getAllFields() + " FROM " + table + " WHERE DOCUMENT_NAME='" + BddTransport.addSlashes(designation) + "'";
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        String sql = "SELECT " + VehicleAttachment.getAllFields() + " FROM " + table + " WHERE CODE='" + BddTransport.addSlashes(code) + "'";
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + VehicleAttachment.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = VehicleAttachment.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#VehicleAttachment.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#VehicleAttachment.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.vehicleId = rs.getInt("VEHICLE_ID");
                    this.documentName = rs.getString("DOCUMENT_NAME");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#VehicleAttachment.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#VehicleAttachment.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO VEHICLE_ATTACHMENT (" + VehicleAttachment.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO VEHICLE_ATTACHMENT (" + VehicleAttachment.getAllFields().substring(VehicleAttachment.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?)";
        }
        try {
            this.statement = VehicleAttachment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.vehicleId, 4);
            this.statement.setObject(2, (Object)this.documentName, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE VEHICLE_ATTACHMENT SET  VEHICLE_ID=? , DOCUMENT_NAME=?  WHERE ID=?";
        try {
            this.statement = VehicleAttachment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.vehicleId, 4);
            this.statement.setObject(2, (Object)this.documentName, 12);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    private static String getAllFields() {
        return "ID, VEHICLE_ID, DOCUMENT_NAME";
    }

    public boolean compareAndUpdate(int id, int vehicleId, String documentName) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.name")) + " n\u00b0 " + id + " (" + this.getDocumentName() + ") \n";
        if (Fonctions.fieldChange(documentName, this.documentName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.documentName + "' => '" + documentName + "'\n";
            this.setDocumentName(documentName);
        }
        if (vehicleId != this.vehicleId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.archive") + " '" + this.vehicleId + "' => '" + vehicleId + "'\n";
            this.setVehicleId(vehicleId);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.name")) + " n\u00b0 " + id + " (" + this.getDocumentName() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#VehicleAttachment# no changes");
        return true;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM VEHICLE_ATTACHMENT WHERE ID=?";
        try {
            this.statement = VehicleAttachment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public static Vector<VehicleAttachment> loadList(int vehicleId) {
        Vector<VehicleAttachment> liste = new Vector<VehicleAttachment>();
        String sql = "SELECT " + VehicleAttachment.getAllFields() + " FROM " + table + (vehicleId != -1 ? " WHERE VEHICLE_ID = " + vehicleId : "") + " ORDER BY DOCUMENT_NAME";
        try {
            ResultSet rs = null;
            Statement stm = VehicleAttachment.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                VehicleAttachment tmp = new VehicleAttachment(rs.getInt("ID"), rs.getInt("VEHICLE_ID"), rs.getString("DOCUMENT_NAME"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("VehicleAttachment.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<VehicleAttachment> loadList(String documentRegExp) {
        Vector<VehicleAttachment> liste = new Vector<VehicleAttachment>();
        String sql = "SELECT " + VehicleAttachment.getAllFields() + " FROM " + table + " WHERE DOCUMENT_NAME LIKE \"%" + documentRegExp + "%\"" + " ORDER BY DOCUMENT_NAME";
        try {
            ResultSet rs = null;
            Statement stm = VehicleAttachment.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                VehicleAttachment tmp = new VehicleAttachment(rs.getInt("ID"), rs.getInt("VEHICLE_ID"), rs.getString("DOCUMENT_NAME"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("VehicleAttachment.loadList()  : " + ex);
            TimsLogger.error("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<VehicleAttachment> getList() {
        if (list == null) {
            list = VehicleAttachment.loadList(-1);
        }
        return list;
    }

    public static void setList(Vector<VehicleAttachment> list) {
        VehicleAttachment.list = list;
    }

    public static VehicleAttachment get(int id) throws DBObjectNotFoundException {
        for (VehicleAttachment tmp : VehicleAttachment.getList()) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("VehicleAttachment " + id);
    }
}

