/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ElementArbre;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.MultiBoxItem;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.DBObjectNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;

public class Vehicule
extends MainElement
implements ElementArbre,
MultiBoxItem {
    public static final String table = "t_vehicule";
    public static final int OFFSET = 48;
    public static final int STATUS_ORANGE = 60;
    public static final int STATUS_ROUGE = 90;
    public static Vector<Vehicule> fullList = null;
    private int cleVehicule = 0;
    private int agencyId = 0;
    private String designation = null;
    private String registrationNumber = null;
    private String identificationNumber;
    private String brand = null;
    private String category = null;
    private String dateEntree = null;
    private String dateSortie = null;
    private String comment = null;
    private boolean archive = false;
    private int nbEtalonnage;
    private String dateTelechargement;
    private String dateTechnical = null;
    private java.util.Date guarantee = null;
    private String owner = null;
    private java.util.Date locationLimit = null;
    private int locationKm = 0;
    private float locationPrice = 0.0f;
    private int averageDailyKm = 0;
    private int lastKnownKm = 0;
    private int typeId = 0;
    private int affectationId = 0;
    private int bodyId = 0;
    private int modelId = 0;
    private int analyticCodeId = 0;
    private float targetConsumption = 0.0f;
    private String vuBrand = null;
    private String vuVersion = null;

    public Vehicule(int cleVehicule, int cleAgence, String immatriculation, String designation, String marque, String famille) {
        this.cleVehicule = cleVehicule;
        this.registrationNumber = immatriculation;
        this.designation = designation;
        this.brand = marque;
        this.category = famille;
        this.agencyId = cleAgence;
    }

    public Vehicule(int cleVehicule, int cleAgence, String immatriculation, String designation) {
        this.cleVehicule = cleVehicule;
        this.registrationNumber = immatriculation;
        this.designation = designation;
        this.agencyId = cleAgence;
    }

    public Vehicule(int cleVehicule, String designation, String immatriculation, String marque, String famille, String dateEntree, String dateSortie, String remarque, int cleAgence, String dateTechnical) {
        this.cleVehicule = cleVehicule;
        this.designation = designation;
        this.registrationNumber = immatriculation;
        this.brand = marque;
        this.category = famille;
        this.dateEntree = dateEntree;
        this.dateSortie = dateSortie;
        this.comment = remarque;
        this.agencyId = cleAgence;
        this.dateTechnical = dateTechnical;
    }

    public Vehicule() {
    }

    public Vehicule(String immatriculation) {
        this.loadByImmat(immatriculation, false);
    }

    public Vehicule(String designation, String immatriculation, String dateTelechargement) {
        this.designation = designation;
        this.registrationNumber = immatriculation;
        this.dateTelechargement = dateTelechargement;
    }

    public Vehicule(int cle, String immat, String design, String dateTelechargement, boolean archive) {
        this.cleVehicule = cle;
        this.registrationNumber = immat;
        this.designation = design;
        this.archive = archive;
        this.dateTelechargement = dateTelechargement;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Vehicule && ((Vehicule)object).getRegistrationNumber().equals(this.registrationNumber) && ((Vehicule)object).getCle() == this.cleVehicule;
    }

    public String toString() {
        return String.valueOf(this.registrationNumber) + (this.designation != null && !this.designation.equals("") ? " - " + this.designation : "");
    }

    @Override
    public String getLibelle() {
        TimsLogger.debug("#Vehicle.getLibelle# " + this.registrationNumber + " " + this.designation);
        return String.valueOf(this.registrationNumber) + (this.designation != null && !this.designation.equals("") ? " - " + this.designation : "");
    }

    @Override
    public int getStatus() {
        TimsLogger.debug("#Vehicule.getStatus# Date T\u00e9l\u00e9chargement " + this.dateTelechargement);
        if (this.archive) {
            return 5;
        }
        if (this.dateTelechargement != null && !this.dateTelechargement.startsWith("1970-01-01") && !this.dateTelechargement.equals("")) {
            String day = ConversionTime.dateToString(new java.util.Date(), "yyyy-MM-dd");
            int numberOfDaySinceLastDownload = ConversionTime.getNbJourBetween(this.dateTelechargement, day, "yyyy-MM-dd");
            if (numberOfDaySinceLastDownload > Integer.parseInt(System.getProperty("vehicle.orange.threshold", String.valueOf(60)))) {
                if (numberOfDaySinceLastDownload > Integer.parseInt(System.getProperty("vehicle.red.threshold", String.valueOf(90)))) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }
        return 4;
    }

    @Override
    public int getId() {
        return this.getCleVehicule();
    }

    @Override
    public int getCle() {
        return this.getCleVehicule();
    }

    @Override
    public String getCode() {
        return this.getDesignation();
    }

    public int getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(int cleAgence) {
        this.agencyId = cleAgence;
    }

    public int getCleVehicule() {
        return this.cleVehicule;
    }

    public void setCleVehicule(int cleVehicule) {
        this.cleVehicule = cleVehicule;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String commentaire) {
        this.comment = commentaire;
    }

    public String getDateTelechargement() {
        return this.dateTelechargement;
    }

    public void setDateTelechargement(String dateTelechargement) {
        this.dateTelechargement = dateTelechargement;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String famille) {
        this.category = famille;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String immatriculation) {
        this.registrationNumber = immatriculation;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String marque) {
        this.brand = marque;
    }

    @Override
    public boolean isArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public String getDateEntree() {
        return this.dateEntree;
    }

    public void setDateEntree(String dateEntree) {
        this.dateEntree = dateEntree;
    }

    public String getDateSortie() {
        return this.dateSortie;
    }

    public void setDateSortie(String dateSortie) {
        this.dateSortie = dateSortie;
    }

    public int getNbEtalonnage() {
        return this.nbEtalonnage;
    }

    public void setNbEtalonnage(int nbEtalonnage) {
        this.nbEtalonnage = nbEtalonnage;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public java.util.Date getGuarantee() {
        return this.guarantee;
    }

    public void setGuarantee(java.util.Date guarantee) {
        this.guarantee = guarantee;
    }

    public String getDateTechnical() {
        return this.dateTechnical;
    }

    public void setDateTechnical(String dateTechnical) {
        this.dateTechnical = dateTechnical;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public java.util.Date getLocationLimit() {
        return this.locationLimit;
    }

    public void setLocationLimit(java.util.Date locationLimit) {
        this.locationLimit = locationLimit;
    }

    public int getLocationKm() {
        return this.locationKm;
    }

    public void setLocationKm(int locationKm) {
        this.locationKm = locationKm;
    }

    public float getLocationPrice() {
        return this.locationPrice;
    }

    public void setLocationPrice(float locationPrice) {
        this.locationPrice = locationPrice;
    }

    public int getAverageDailyKm() {
        return this.averageDailyKm;
    }

    public void setAverageDailyKm(int averageDailyKm) {
        this.averageDailyKm = averageDailyKm;
    }

    public int getLastKnownKm() {
        return this.lastKnownKm;
    }

    public void setLastKnownKm(int lastKnownKm) {
        this.lastKnownKm = lastKnownKm;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public int getAffectationId() {
        return this.affectationId;
    }

    public void setAffectationId(int affectationId) {
        this.affectationId = affectationId;
    }

    public int getBodyId() {
        return this.bodyId;
    }

    public void setBodyId(int bodyId) {
        this.bodyId = bodyId;
    }

    public int getModelId() {
        return this.modelId;
    }

    public void setModelId(int modelId) {
        this.modelId = modelId;
    }

    public int getAnalyticCodeId() {
        return this.analyticCodeId;
    }

    public void setAnalyticCodeId(int analyticCodeId) {
        this.analyticCodeId = analyticCodeId;
    }

    public float getTargetConsumption() {
        return this.targetConsumption;
    }

    public void setTargetConsumption(float targetConsumption) {
        this.targetConsumption = targetConsumption;
    }

    public String getVuBrand() {
        return this.vuBrand;
    }

    public void setVuBrand(String vuBrand) {
        this.vuBrand = vuBrand;
    }

    public String getVuVersion() {
        return this.vuVersion;
    }

    public void setVuVersion(String vuVersion) {
        this.vuVersion = vuVersion;
    }

    public String getDataDirName() {
        return this.getDataDirName(true);
    }

    public String getDataDirName(boolean withLastSeparator) {
        String separator = "/";
        if (System.getProperty("URL") == null) {
            separator = "\\";
        }
        return String.valueOf(BddTransport.getInstance().getCompany().getNomBase()) + separator + String.valueOf(this.agencyId) + separator + (this.registrationNumber == null ? "" : this.registrationNumber) + " - " + this.cleVehicule + (withLastSeparator ? separator : "");
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#Vehicule.insert()");
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO t_vehicule (CLE_VEHICULE, N_IMMATRICULATION, IDENTIFICATION, DESIGNATION_VEHICULE, FAMILLE,  DATE_ENTREE, DATE_SORTIE, MARQUE, COMMENTAIRE, ARCHIVAGE, CLE_AGENCE, GUARANTEE, DATE_TECHNICAL, OWNER, LOCATION_LIMIT, LOCATION_KM, LOCATION_PRICE, DAILY_KM, TYPE_ID, AFFECTATION_ID, BODY_ID, MODEL_ID, ANALYTIC_CODE_ID, VU_BRAND, VU_VERSION) VALUES (GEN_T_VEHICULE.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = Vehicule.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO t_vehicule (N_IMMATRICULATION, IDENTIFICATION, DESIGNATION_VEHICULE, FAMILLE, DATE_ENTREE,  DATE_SORTIE, MARQUE, COMMENTAIRE, ARCHIVAGE, CLE_AGENCE, GUARANTEE, DATE_TECHNICAL,  OWNER, LOCATION_LIMIT, LOCATION_KM, LOCATION_PRICE, DAILY_KM, TYPE_ID, AFFECTATION_ID, BODY_ID, MODEL_ID, ANALYTIC_CODE_ID, VU_BRAND, VU_VERSION) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = Vehicule.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.registrationNumber, 12);
                this.statement.setObject(2, (Object)this.identificationNumber, 12);
                this.statement.setObject(3, (Object)this.designation, 12);
                this.statement.setObject(4, (Object)this.category, 12);
                this.statement.setDate(5, Date.valueOf(Vehicule.getDateToSGBD(this.dateEntree)));
                this.statement.setDate(6, Date.valueOf(Vehicule.getDateToSGBD(this.dateSortie)));
                this.statement.setObject(7, (Object)this.brand, 12);
                this.statement.setObject(8, (Object)this.comment, 12);
                this.statement.setObject(9, (Object)this.archive, 4);
                this.statement.setObject(10, (Object)this.agencyId, 4);
                this.statement.setDate(11, this.guarantee == null ? null : new Date(this.guarantee.getTime()));
                this.statement.setDate(12, Date.valueOf(Vehicule.getDateToSGBD(this.dateTechnical)));
                this.statement.setObject(13, (Object)this.owner, 12);
                this.statement.setDate(14, this.locationLimit == null ? null : new Date(this.locationLimit.getTime()));
                this.statement.setObject(15, (Object)this.locationKm, 4);
                this.statement.setObject(16, (Object)Float.valueOf(this.locationPrice), 6);
                this.statement.setObject(17, (Object)this.averageDailyKm, 4);
                this.statement.setObject(18, (Object)this.typeId, 4);
                this.statement.setObject(19, (Object)this.affectationId, 4);
                this.statement.setObject(20, (Object)this.bodyId, 4);
                this.statement.setObject(21, (Object)this.modelId, 4);
                this.statement.setObject(22, (Object)this.analyticCodeId, 4);
                this.statement.setObject(23, (Object)this.vuBrand, 12);
                this.statement.setObject(24, (Object)this.vuVersion, 12);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.debug("#Vehicule.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#Vehicule.insert# auto generated key value = " + rs.getInt(1));
                        this.cleVehicule = rs.getInt(1);
                    }
                    rs.close();
                }
                if (this.cleVehicule == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#Vehicule.insert# generated key value = " + this.cleVehicule);
                    } else {
                        TimsLogger.debug("#Vehicule.insert# no generated key availaible");
                    }
                }
                if (!FileManager.createDirectory(this.getDataDirName())) {
                    TimsLogger.warn("impossible de cr\u00e9er le repertoire");
                }
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new java.util.Date(), this.affiche()).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                VehicleUsed.updateVehicule(this.registrationNumber);
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT CLE_VEHICULE FROM t_vehicule WHERE N_IMMATRICULATION = ? AND ARCHIVAGE=0";
        PreparedStatement statement = null;
        try {
            try {
                statement = Vehicule.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.registrationNumber, 12);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.cleVehicule = rs.getInt("CLE_VEHICULE");
                    TimsLogger.info("#Vehicule.loadId# id found " + rs.getInt("CLE_VEHICULE"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("transpo.data.Vechiule.loadId()  : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean update() {
        String sql = "UPDATE t_vehicule SET  N_IMMATRICULATION=? , IDENTIFICATION=? , DESIGNATION_VEHICULE=? , FAMILLE=? , DATE_ENTREE=? , DATE_SORTIE=? , MARQUE=? , COMMENTAIRE=? , ARCHIVAGE=? , CLE_AGENCE=?,  DERNIER_TELECHARGEMENT=?,  GUARANTEE=?,  DATE_TECHNICAL=?,  OWNER=?,  LOCATION_LIMIT=?,  LOCATION_KM=?,  LOCATION_PRICE=?,  DAILY_KM=?,  LAST_KNOWN_KM=?,  TYPE_ID=?,  AFFECTATION_ID=?,  BODY_ID=?,  MODEL_ID=?,  ANALYTIC_CODE_ID=?,  CONSUMPTION_TARGET =?,  VU_BRAND=?,  VU_VERSION =?  WHERE CLE_VEHICULE=?";
        try {
            this.statement = Vehicule.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.registrationNumber, 12);
            this.statement.setObject(2, (Object)this.identificationNumber, 12);
            this.statement.setObject(3, (Object)this.designation, 12);
            this.statement.setObject(4, (Object)this.category, 12);
            this.statement.setDate(5, Date.valueOf(Vehicule.getDateToSGBD(this.dateEntree)));
            this.statement.setDate(6, Date.valueOf(Vehicule.getDateToSGBD(this.dateSortie)));
            this.statement.setObject(7, (Object)this.brand, 12);
            this.statement.setObject(8, (Object)this.comment, 12);
            this.statement.setObject(9, (Object)this.archive, 4);
            this.statement.setObject(10, (Object)this.agencyId, 4);
            this.statement.setTimestamp(11, Timestamp.valueOf(Vehicule.getTimestampToSGBD(this.dateTelechargement)));
            this.statement.setDate(12, this.guarantee == null ? null : new Date(this.guarantee.getTime()));
            this.statement.setDate(13, Date.valueOf(Vehicule.getDateToSGBD(this.dateTechnical)));
            this.statement.setObject(14, (Object)this.owner, 12);
            this.statement.setDate(15, this.locationLimit == null ? null : new Date(this.locationLimit.getTime()));
            this.statement.setObject(16, (Object)this.locationKm, 4);
            this.statement.setObject(17, (Object)Float.valueOf(this.locationPrice), 6);
            this.statement.setObject(18, (Object)this.averageDailyKm, 4);
            this.statement.setObject(19, (Object)this.lastKnownKm, 4);
            this.statement.setObject(20, (Object)this.typeId, 4);
            this.statement.setObject(21, (Object)this.affectationId, 4);
            this.statement.setObject(22, (Object)this.bodyId, 4);
            this.statement.setObject(23, (Object)this.modelId, 4);
            this.statement.setObject(24, (Object)this.analyticCodeId, 4);
            this.statement.setObject(25, (Object)Float.valueOf(this.targetConsumption), 6);
            this.statement.setObject(26, (Object)this.vuBrand, 12);
            this.statement.setObject(27, (Object)this.vuVersion, 12);
            this.statement.setObject(28, (Object)this.cleVehicule, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean compareAndUpdate(int agency, String designation, String brand, String category, String immatriculation, String identification, String begin, String end, String comm, java.util.Date guarantee, String owner, java.util.Date locationLimit, int locationKm, float locationPrice, int averageDailyKm, int typeId, int affectationId, int bodyId, int modelId, int analyticCodeId) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.vehicle")) + " n\u00b0 " + this.cleVehicule + " \n";
        String fromRename = null;
        if (agency != this.agencyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.agency") + " '" + this.agencyId + "' => '" + agency + "'\n";
            if (fromRename == null) {
                fromRename = this.getDataDirName();
            }
            this.setAgencyId(agency);
        }
        if (Fonctions.fieldChange(this.designation, designation)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.designation + "' => '" + designation + "'\n";
            this.setDesignation(designation);
        }
        if (Fonctions.fieldChange(this.brand, brand)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.brand") + " '" + this.brand + "' => '" + brand + "'\n";
            this.setBrand(brand);
        }
        if (Fonctions.fieldChange(this.category, category)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.category") + " '" + this.category + "' => '" + category + "'\n";
            this.setCategory(category);
        }
        if (Fonctions.fieldChange(this.registrationNumber, immatriculation)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.registrationNumber") + " '" + this.registrationNumber + "' => '" + immatriculation + "'\n";
            if (fromRename == null) {
                fromRename = this.getDataDirName();
            }
            this.setRegistrationNumber(immatriculation);
        }
        if (Fonctions.fieldChange(this.identificationNumber, identification)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.identificationNumber") + " '" + this.identificationNumber + "' => '" + identification + "'\n";
            if (fromRename == null) {
                fromRename = this.getDataDirName();
            }
            this.setIdentificationNumber(identification);
        }
        if (!Vehicule.getDateFromSGBD(begin).equals(this.dateEntree)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.enterDate") + " '" + this.dateEntree + "' => '" + Vehicule.getDateFromSGBD(begin) + "'\n";
            this.setDateEntree(Vehicule.getDateFromSGBD(begin));
        }
        if (!Vehicule.getDateFromSGBD(end).equals(this.dateSortie)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.exitDate") + " '" + this.dateSortie + "' => '" + Vehicule.getDateFromSGBD(end) + "'\n";
            this.setDateSortie(Vehicule.getDateFromSGBD(end));
            if (!Vehicule.getDateFromSGBD(end).equals("")) {
                this.setArchive(ConversionTime.stringToDate(end, "yyyy-MM-dd").before(new java.util.Date()));
            } else {
                this.setArchive(false);
            }
        } else {
            this.setArchive(false);
        }
        if (Fonctions.fieldChange(guarantee, this.guarantee)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.guarantee") + " '" + this.guarantee + "' => '" + guarantee + "'\n";
            this.setGuarantee(guarantee);
        }
        if (Fonctions.fieldChange(this.comment, comm)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.comment") + " '" + this.comment + "' => '" + comm + "'\n";
            this.setComment(comm);
        }
        if (Fonctions.fieldChange(this.owner, owner)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.owner") + " '" + this.owner + "' => '" + owner + "'\n";
            this.setOwner(owner);
        }
        if (Fonctions.fieldChange(locationLimit, this.locationLimit)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.locationLimit") + " '" + this.locationLimit + "' => '" + locationLimit + "'\n";
            this.setLocationLimit(locationLimit);
        }
        if (locationKm != this.locationKm) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.locationKm") + " '" + this.locationKm + "' => '" + locationKm + "'\n";
            this.setLocationKm(locationKm);
        }
        if (locationPrice != this.locationPrice) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.locationPrice") + " '" + this.locationPrice + "' => '" + locationPrice + "'\n";
            this.setLocationPrice(locationPrice);
        }
        if (averageDailyKm != this.averageDailyKm) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.averageDailyKm") + " '" + this.averageDailyKm + "' => '" + averageDailyKm + "'\n";
            this.setAverageDailyKm(averageDailyKm);
        }
        if (typeId != this.typeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.type") + " '" + this.typeId + "' => '" + typeId + "'\n";
            this.setTypeId(typeId);
        }
        if (affectationId != this.affectationId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.affectation") + " '" + this.affectationId + "' => '" + affectationId + "'\n";
            this.setAffectationId(affectationId);
        }
        if (bodyId != this.bodyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.body") + " '" + this.bodyId + "' => '" + bodyId + "'\n";
            this.setBodyId(bodyId);
        }
        if (modelId != this.modelId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.model") + " '" + this.modelId + "' => '" + modelId + "'\n";
            this.setModelId(modelId);
        }
        if (analyticCodeId != this.analyticCodeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.analyticCode") + " '" + this.analyticCodeId + "' => '" + analyticCodeId + "'\n";
            this.setAnalyticCodeId(analyticCodeId);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.vehicle")) + " n\u00b0 " + this.cleVehicule + " \n")) {
            if (fromRename != null && !FileManager.moveDirectory(fromRename, this.getDataDirName())) {
                TimsLogger.warn("#Vehicule.c&u# erreur renommage repertoire " + fromRename + " to " + this.getDataDirName());
            }
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        return true;
    }

    public boolean compareAndUpdateConsumption(float target) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.vehicle")) + " n\u00b0 " + this.cleVehicule + " \n";
        if (target != this.targetConsumption) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("consumption.target") + " : '" + this.targetConsumption + "' => '" + target + "'\n";
            this.setTargetConsumption(target);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.vehicle")) + " n\u00b0 " + this.cleVehicule + " \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#Conducteur.compareAndUpdate# no changes");
        return true;
    }

    public boolean updateTechnical(String identificationNumber, String registrationNumber, String brand, String vuBrand, String vuVersion) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.vehicle")) + " n\u00b0 " + this.cleVehicule + " \n";
        if (Fonctions.fieldChange(identificationNumber, this.identificationNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.identificationNumber") + " : '" + this.identificationNumber + "' => '" + identificationNumber + "'\n";
            this.setIdentificationNumber(identificationNumber);
        }
        if (Fonctions.fieldChange(registrationNumber, this.registrationNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.registrationNumber") + " : '" + this.registrationNumber + "' => '" + registrationNumber + "'\n";
            this.setRegistrationNumber(registrationNumber);
        }
        if (brand != this.brand) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.brand") + " : '" + this.brand + "' => '" + brand + "'\n";
            this.setBrand(brand);
        }
        if (vuBrand != this.vuBrand) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.vuBrand") + " : '" + this.vuBrand + "' => '" + vuBrand + "'\n";
            this.setVuBrand(vuBrand);
        }
        if (vuVersion != this.vuVersion) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("vehicle.vuVersion") + " : '" + this.vuVersion + "' => '" + vuVersion + "'\n";
            this.setVuVersion(vuVersion);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.vehicle")) + " n\u00b0 " + this.cleVehicule + " \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#Conducteur.compareAndUpdate# no changes");
        return true;
    }

    public boolean updateTechnical() {
        String sql = "UPDATE t_vehicule SET  IDENTIFICATION=? , MARQUE=? , VU_BRAND=?,  VU_VERSION =?  WHERE CLE_VEHICULE=?";
        try {
            this.statement = Vehicule.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.identificationNumber, 12);
            this.statement.setObject(2, (Object)this.brand, 12);
            this.statement.setObject(3, (Object)this.vuBrand, 12);
            this.statement.setObject(4, (Object)this.vuVersion, 12);
            this.statement.setObject(5, (Object)this.cleVehicule, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean delete() {
        boolean retour = false;
        String sql = "DELETE FROM t_vehicule WHERE CLE_VEHICULE=?";
        try {
            try {
                this.statement = Vehicule.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleVehicule, 4);
                this.statement.executeUpdate();
                this.statement.close();
                FileManager.moveDirectory(this.getDataDirName(), String.valueOf(this.getDataDirName(false)) + " - DELETED");
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new java.util.Date(), this.affiche()).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean loadById(int id) {
        String sql = "SELECT " + Vehicule.getAllFields() + " FROM " + table + " WHERE CLE_VEHICULE= " + id;
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        String sql = "SELECT " + Vehicule.getAllFields() + " FROM " + table + " WHERE DESIGNATION= '" + code + "'";
        return this.genericLoad(sql);
    }

    public boolean loadByIdentification(String identification) {
        return this.loadGroupedWithFilter("IDENTIFICATION='" + identification + "'");
    }

    public boolean loadByImmat(String immatriculation, boolean lookInArchive) {
        return this.loadGroupedWithFilter(String.valueOf(BddTransport.getClearedImmat(null)) + " = " + BddTransport.getClearedImmat("\"" + immatriculation + "\"") + (lookInArchive ? "" : " AND ARCHIVAGE=0"));
    }

    /*
     * Loose catch block
     */
    private boolean loadGroupedWithFilter(String filter) {
        boolean toReturn = false;
        Statement statement = null;
        ResultSet rs = null;
        String sql = "SELECT v.CLE_VEHICULE, DESIGNATION_VEHICULE, FAMILLE, MARQUE, N_IMMATRICULATION, IDENTIFICATION, DATE_ENTREE, DATE_SORTIE,COMMENTAIRE, CLE_AGENCE, " + BddTransport.getDateSGBDRToString("DERNIER_TELECHARGEMENT", true, "") + ", COUNT(CLE_ETALONNAGE) as NB, GUARANTEE, DATE_TECHNICAL, " + "OWNER, LOCATION_LIMIT, LOCATION_KM, LOCATION_PRICE, DAILY_KM, LAST_KNOWN_KM, TYPE_ID, AFFECTATION_ID, BODY_ID, " + "MODEL_ID, ANALYTIC_CODE_ID, VU_BRAND, VU_VERSION" + " FROM " + table + " v LEFT JOIN " + "t_etalonnage" + " e ON v.CLE_VEHICULE = e.CLE_VEHICULE" + " WHERE " + filter + " GROUP BY v.CLE_VEHICULE, DESIGNATION_VEHICULE, FAMILLE, MARQUE, N_IMMATRICULATION,IDENTIFICATION, " + " DATE_ENTREE, DATE_SORTIE,COMMENTAIRE, CLE_AGENCE, DERNIER_TELECHARGEMENT, GUARANTEE, DATE_TECHNICAL, " + " OWNER, LOCATION_LIMIT, LOCATION_KM, LOCATION_PRICE, DAILY_KM, LAST_KNOWN_KM, TYPE_ID, AFFECTATION_ID, BODY_ID, MODEL_ID, ANALYTIC_CODE_ID";
        TimsLogger.debug("#Vehicule.load# sql " + sql);
        try {
            try {
                statement = Vehicule.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.cleVehicule = rs.getInt("CLE_VEHICULE");
                    this.agencyId = rs.getInt("CLE_AGENCE");
                    this.designation = rs.getString("DESIGNATION_VEHICULE");
                    this.category = rs.getString("FAMILLE");
                    this.brand = rs.getString("MARQUE");
                    this.registrationNumber = rs.getString("N_IMMATRICULATION");
                    this.identificationNumber = rs.getString("IDENTIFICATION");
                    this.comment = rs.getString("COMMENTAIRE");
                    this.dateEntree = Vehicule.getDateFromSGBD(rs.getString("DATE_ENTREE"));
                    this.dateSortie = Vehicule.getDateFromSGBD(rs.getString("DATE_SORTIE"));
                    this.dateTelechargement = Vehicule.getDateFromSGBD(rs.getString("DERNIER_TELECHARGEMENT"));
                    this.nbEtalonnage = rs.getInt("NB");
                    this.guarantee = rs.getDate("GUARANTEE");
                    this.dateTechnical = Vehicule.getDateFromSGBD(rs.getString("DATE_TECHNICAL"));
                    this.owner = rs.getString("OWNER");
                    this.locationLimit = rs.getDate("LOCATION_LIMIT");
                    this.locationKm = rs.getInt("LOCATION_KM");
                    this.locationPrice = rs.getFloat("LOCATION_PRICE");
                    this.averageDailyKm = rs.getInt("DAILY_KM");
                    this.lastKnownKm = rs.getInt("LAST_KNOWN_KM");
                    this.typeId = rs.getInt("TYPE_ID");
                    this.affectationId = rs.getInt("AFFECTATION_ID");
                    this.bodyId = rs.getInt("BODY_ID");
                    this.modelId = rs.getInt("MODEL_ID");
                    this.analyticCodeId = rs.getInt("ANALYTIC_CODE_ID");
                    this.vuBrand = rs.getString("VU_BRAND");
                    this.vuVersion = rs.getString("VU_VERSION");
                    TimsLogger.debug("#Vehicule.load# loaded");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("transpo.data.Vehicule.load()  : " + ex);
                TimsLogger.error(sql);
                ex.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex4) {
                    ex4.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Vehicule.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.cleVehicule = rs.getInt("CLE_VEHICULE");
                    this.agencyId = rs.getInt("CLE_AGENCE");
                    this.designation = rs.getString("DESIGNATION_VEHICULE");
                    this.category = rs.getString("FAMILLE");
                    this.brand = rs.getString("MARQUE");
                    this.registrationNumber = rs.getString("N_IMMATRICULATION");
                    this.identificationNumber = rs.getString("IDENTIFICATION");
                    this.comment = rs.getString("COMMENTAIRE");
                    this.dateEntree = Vehicule.getDateFromSGBD(rs.getString("DATE_ENTREE"));
                    this.dateSortie = Vehicule.getDateFromSGBD(rs.getString("DATE_SORTIE"));
                    this.dateTelechargement = Vehicule.getDateFromSGBD(rs.getString("DERNIER_TELECHARGEMENT"));
                    this.guarantee = rs.getDate("GUARANTEE");
                    this.dateTechnical = Vehicule.getDateFromSGBD(rs.getString("DATE_TECHNICAL"));
                    this.owner = rs.getString("OWNER");
                    this.locationLimit = rs.getDate("LOCATION_LIMIT");
                    this.locationKm = rs.getInt("LOCATION_KM");
                    this.locationPrice = rs.getFloat("LOCATION_PRICE");
                    this.averageDailyKm = rs.getInt("DAILY_KM");
                    this.lastKnownKm = rs.getInt("LAST_KNOWN_KM");
                    this.typeId = rs.getInt("TYPE_ID");
                    this.affectationId = rs.getInt("AFFECTATION_ID");
                    this.bodyId = rs.getInt("BODY_ID");
                    this.modelId = rs.getInt("MODEL_ID");
                    this.analyticCodeId = rs.getInt("ANALYTIC_CODE_ID");
                    this.vuBrand = rs.getString("VU_BRAND");
                    this.vuVersion = rs.getString("VU_VERSION");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Vehicle.genericLoad() # : " + ex);
                TimsLogger.debug("#Vehicle.genericLoad() # : " + sql);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public java.util.Date getLastDay() {
        java.util.Date toReturn;
        block16: {
            toReturn = null;
            ResultSet rs = null;
            String sql = "SELECT max(DATE_USE) as last FROM t_jour_uev WHERE VEHICLE_ID=?";
            try {
                this.statement = Vehicule.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleVehicule, 4);
                Transport.ps.startOperation();
                rs = this.statement.executeQuery();
                long duration = Transport.ps.endOperation(PerformanceScanner.READING, "Requ\u00eate jour");
                TimsLogger.debug("#Vehicule.getLastDay() => " + duration + " ms# sql : " + sql);
                while (rs.next()) {
                    if (rs.getString("last") == null) continue;
                    toReturn = rs.getDate("last");
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
                break block16;
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.statement.close();
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return toReturn == null ? new java.util.Date() : toReturn;
    }

    public String affiche() {
        String toReturn = "d\u00e9tail v\u00e9hicule : ";
        toReturn = "cl\u00e9 : " + this.cleVehicule + " -- immatriculation : " + this.registrationNumber + " -- d\u00e9signation : " + this.designation;
        return toReturn;
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            tmp.write((byte)this.designation.length());
            tmp.write(this.designation.getBytes());
            tmp.write((byte)this.registrationNumber.length());
            tmp.write(this.registrationNumber.getBytes());
            tmp.write((byte)this.brand.length());
            tmp.write(this.brand.getBytes());
            tmp.write((byte)this.category.length());
            tmp.write(this.category.getBytes());
            if (this.comment != null) {
                tmp.write((byte)this.comment.length());
                tmp.write(this.comment.getBytes());
            }
            tmp.write(Vehicule.getDateToSGBD(this.dateEntree).getBytes());
            tmp.write(Vehicule.getDateToSGBD(this.dateSortie).getBytes());
            tmp.write(Vehicule.getDateToSGBD(this.dateTelechargement).getBytes());
            tmp.write((byte)this.nbEtalonnage);
            out.write(48);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#Conducteur.write# " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public void read(byte[] obj, int offset) {
        if (obj[offset] != 48) {
            TimsLogger.warn("Erreur offset");
            return;
        }
        int length = obj[++offset];
        int dataLength = Fonctions.bytesToInt(obj, ++offset, length);
        TimsLogger.debug("#Vehicule.read# Size of Vehicule = " + dataLength);
        offset += length;
        length = obj[offset];
        this.designation = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] >= 0 ? obj[offset] : obj[offset] + 256;
        this.registrationNumber = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] >= 0 ? obj[offset] : obj[offset] + 256;
        this.brand = new String(obj).substring(++offset, offset + length);
        length = obj[offset += length] >= 0 ? obj[offset] : obj[offset] + 256;
        this.category = Vehicule.getDateFromSGBD(new String(obj).substring(++offset, offset + 10));
        length = obj[offset += 10] >= 0 ? obj[offset] : obj[offset] + 256;
        this.comment = new String(obj).substring(++offset, offset + length);
        this.dateEntree = Vehicule.getDateFromSGBD(new String(obj).substring(offset += length, offset + 10));
        this.dateSortie = Vehicule.getDateFromSGBD(new String(obj).substring(offset += 10, offset + 10));
        this.dateTelechargement = Vehicule.getDateFromSGBD(new String(obj).substring(offset += 10, offset + 10));
        this.nbEtalonnage = obj[offset += 10];
    }

    private static String getAllFields() {
        return "CLE_VEHICULE, CLE_AGENCE, DESIGNATION_VEHICULE, FAMILLE, MARQUE, N_IMMATRICULATION, IDENTIFICATION, COMMENTAIRE,  " + BddTransport.getDateSGBDRToString("DATE_ENTREE", false, table) + ", " + BddTransport.getDateSGBDRToString("DATE_SORTIE", false, table) + ", " + BddTransport.getDateSGBDRToString("DATE_TECHNICAL", false, table) + ", " + BddTransport.getDateSGBDRToString("GUARANTEE", false, table) + ", " + BddTransport.getDateSGBDRToString("DERNIER_TELECHARGEMENT", true, "") + ", OWNER, LOCATION_LIMIT, LOCATION_KM, LOCATION_PRICE, DAILY_KM, LAST_KNOWN_KM, TYPE_ID, AFFECTATION_ID, BODY_ID, MODEL_ID, ANALYTIC_CODE_ID, CONSUMPTION_TARGET" + ", VU_BRAND, VU_VERSION";
    }

    public static Vector<Vehicule> loadList(Integer ... agencyId) {
        return Vehicule.loadList(null, true, agencyId);
    }

    public static Vector<Vehicule> loadUnrestrictedList(Integer ... agencyId) {
        return Vehicule.loadList(null, false, agencyId);
    }

    public static Vector<Vehicule> loadList(String filter, boolean withRestriction, Integer ... agencyId) {
        String sql = "";
        Vector<Vehicule> result = new Vector<Vehicule>();
        try {
            sql = "SELECT " + Vehicule.getAllFields() + " FROM " + table + " WHERE ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            String agencies = "";
            if (agencyId.length != 0 && agencyId[0] != 0) {
                Integer[] integerArray = agencyId;
                int n = agencyId.length;
                int n2 = 0;
                while (n2 < n) {
                    int cle = integerArray[n2];
                    if (cle != 0) {
                        agencies = String.valueOf(agencies) + "," + cle;
                    }
                    ++n2;
                }
            }
            if (!agencies.equals("")) {
                sql = String.valueOf(sql) + " AND CLE_AGENCE IN (" + agencies.substring(1) + ")";
            }
            if (filter != null) {
                sql = System.getProperty("SGBDR", "mysql").equals("oracle") ? String.valueOf(sql) + " AND (UPPER(" + BddTransport.getClearedImmat(null) + ") LIKE UPPER(" + BddTransport.getQuote() + "%" + filter.replace("-", "").replace(" ", "") + "%" + BddTransport.getQuote() + ")" + " OR UPPER(DESIGNATION_VEHICULE) LIKE UPPER(" + BddTransport.getQuote() + "%" + filter + BddTransport.getQuote() + "))" : String.valueOf(sql) + " AND (" + BddTransport.getClearedImmat(null) + " LIKE " + BddTransport.getQuote() + "%" + filter.replace("-", "").replace(" ", "") + "%" + BddTransport.getQuote() + " OR DESIGNATION_VEHICULE LIKE " + BddTransport.getQuote() + "%" + filter + BddTransport.getQuote() + ")";
            }
            String restriction = BddTransport.addRestriction(table, null);
            if (withRestriction && restriction != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY N_IMMATRICULATION";
            Statement stm = Vehicule.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule toAdd = new Vehicule(rs.getInt("CLE_VEHICULE"), rs.getInt("CLE_AGENCE"), rs.getString("N_IMMATRICULATION"), rs.getString("DESIGNATION_VEHICULE"), rs.getString("MARQUE"), rs.getString("FAMILLE"));
                toAdd.setIdentificationNumber(rs.getString("IDENTIFICATION"));
                toAdd.setDateTelechargement(rs.getString("DERNIER_TELECHARGEMENT"));
                toAdd.setDateEntree(Vehicule.getDateFromSGBD(rs.getString("DATE_ENTREE")));
                toAdd.setDateSortie(Vehicule.getDateFromSGBD(rs.getString("DATE_SORTIE")));
                toAdd.setGuarantee(rs.getDate("GUARANTEE"));
                toAdd.setDateTechnical(Vehicule.getDateFromSGBD(rs.getString("DATE_TECHNICAL")));
                toAdd.setAverageDailyKm(rs.getInt("DAILY_KM"));
                toAdd.setLastKnownKm(rs.getInt("LAST_KNOWN_KM"));
                toAdd.setArchive(MainFrameTransport.archivage);
                toAdd.setLocationLimit(rs.getDate("LOCATION_LIMIT"));
                toAdd.setLocationKm(rs.getInt("LOCATION_KM"));
                toAdd.setLocationPrice(rs.getFloat("LOCATION_PRICE"));
                toAdd.setOwner(rs.getString("OWNER"));
                toAdd.setTypeId(rs.getInt("TYPE_ID"));
                toAdd.setBodyId(rs.getInt("BODY_ID"));
                toAdd.setAffectationId(rs.getInt("AFFECTATION_ID"));
                toAdd.setModelId(rs.getInt("MODEL_ID"));
                toAdd.setAnalyticCodeId(rs.getInt("ANALYTIC_CODE_ID"));
                toAdd.setVuBrand(rs.getString("VU_BRAND"));
                toAdd.setVuVersion(rs.getString("VU_VERSION"));
                toAdd.setTargetConsumption(rs.getFloat("CONSUMPTION_TARGET"));
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Vehicule.loadList(int cleAgence)  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Vehicule getVehicule(Vector<Vehicule> list, int vehicleId) throws DBObjectNotFoundException {
        if (list == null) {
            list = Vehicule.getList();
        }
        for (Vehicule tmp : list) {
            if (tmp.getCle() != vehicleId) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException(Vehicule.class.getName());
    }

    public static Vehicule getVehicule(Vector<Vehicule> list, String registrationOrIdentificationNumber) throws DBObjectNotFoundException {
        if (registrationOrIdentificationNumber == null) {
            throw new DBObjectNotFoundException(Vehicule.class.getName());
        }
        if (list == null) {
            list = Vehicule.getList();
        }
        for (Vehicule tmp : list) {
            if (!registrationOrIdentificationNumber.equals(tmp.getRegistrationNumber()) && !registrationOrIdentificationNumber.equals(tmp.getIdentificationNumber())) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException(Vehicule.class.getName());
    }

    public static Vector<Vehicule> getList() {
        if (fullList == null) {
            fullList = Vehicule.loadList(new Integer[0]);
        }
        return fullList;
    }

    public static void setList(Vector<Vehicule> list) {
        fullList = list;
    }

    public static Vector<Vehicule> getDownloadBefore(String date) {
        Vector<Vehicule> result = new Vector<Vehicule>();
        String sql = "";
        try {
            sql = "SELECT CLE_AGENCE, N_IMMATRICULATION, DESIGNATION_VEHICULE, " + BddTransport.getDateSGBDRToString("DERNIER_TELECHARGEMENT", false, "") + " FROM " + table + " WHERE DERNIER_TELECHARGEMENT < " + BddTransport.getDateStringToSGBDR(date, false) + " AND ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0");
            String restriction = BddTransport.addRestriction(table, "");
            if (restriction != "") {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY DESIGNATION_VEHICULE, N_IMMATRICULATION";
            Statement stm = Vehicule.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Vehicule toAdd = new Vehicule(rs.getString("DESIGNATION_VEHICULE"), rs.getString("N_IMMATRICULATION"), rs.getString("DERNIER_TELECHARGEMENT"));
                toAdd.setAgencyId(rs.getInt("CLE_AGENCE"));
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#getVehiculeRougeList()# Erreur sql = " + sql);
            ex.printStackTrace();
        }
        return result;
    }

    public static String getVehicleLibelle(int vehicleId) {
        try {
            Vehicule toReturn = Vehicule.getVehicule(null, vehicleId);
            return toReturn.getLibelle();
        }
        catch (Exception ex) {
            TimsLogger.warn(ex.getMessage());
            return LanguageTranslator.getString("generics.unknown");
        }
    }

    public static boolean registrationExists(String registration) {
        boolean toReturn = false;
        Vehicule check = new Vehicule();
        check.loadByImmat(registration, true);
        if (check.getCleVehicule() != 0) {
            toReturn = true;
        }
        return toReturn;
    }

    public static Vector<String> getRegistrationsList(String baseName) {
        String sql = "";
        Vector<String> result = new Vector<String>();
        try {
            sql = "SELECT N_IMMATRICULATION FROM " + baseName + "." + table + " WHERE ARCHIVAGE = 0";
            Statement stm = Vehicule.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (rs.getString("N_IMMATRICULATION") == null || rs.getString("N_IMMATRICULATION").length() <= 0) continue;
                result.add(rs.getString("N_IMMATRICULATION"));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Vehicule.getRegistrationsList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }
}

