/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class WaitingFile
extends MainElement {
    public static final String table = "WAITING";
    private int cle = 0;
    private int cleUser = 0;
    private String name = null;
    private Timestamp dateScan = null;
    private boolean processed = false;

    public WaitingFile() {
    }

    public WaitingFile(int cle, int cleUser, String name) {
        this.cle = cle;
        this.cleUser = cleUser;
        this.name = name;
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#WaitingFile.insert()#");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO WAITING (CLE, CLE_USER, NOM) VALUES (GEN_WAITING.nextval,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO WAITING (CLE_USER, NOM) VALUES (?,?)";
        }
        try {
            try {
                this.statement = WaitingFile.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleUser, 12);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean update() throws Exception {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean updateValue() throws Exception {
        boolean retour = false;
        TimsLogger.debug("#WaitingFile.update()#");
        String sql = "UPDATE waiting SET CLE_USER = ?, NOM = ?, DATE_SCAN = ?, PROCESSED = ? WHERE CLE = ?";
        try {
            try {
                this.statement = WaitingFile.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cleUser, 4);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.setTimestamp(3, this.dateScan);
                this.statement.setObject(4, (Object)(this.processed ? 1 : 0), 4);
                this.statement.setObject(5, (Object)this.cle, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent("t_scan_image", Constants.ACTION_TYPE.UPDATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                throw ex;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        if (this.cle == 0) {
            return false;
        }
        boolean retour = false;
        String sql = "DELETE FROM waiting WHERE CLE=?";
        try {
            try {
                this.statement = WaitingFile.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.cle, 4);
                this.statement.executeUpdate();
                this.statement.close();
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean load(String name) {
        block4: {
            ResultSet rs = null;
            TimsLogger.debug("#WaitingFile.load()#");
            String sql = "SELECT CLE, CLE_USER, NOM, DATE_SCAN, PROCESSED FROM waiting WHERE NOM = ?";
            this.statement = WaitingFile.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)name, 12);
            rs = this.statement.executeQuery();
            if (!rs.next()) break block4;
            this.cle = rs.getInt("CLE");
            this.cleUser = rs.getInt("CLE_USER");
            this.name = rs.getString("NOM");
            this.dateScan = rs.getTimestamp("DATE_SCAN");
            this.processed = rs.getBoolean("PROCESSED");
            this.statement.close();
            return true;
        }
        try {
            this.statement.close();
            return false;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Timestamp getDateScan() {
        return this.dateScan;
    }

    public void setDateScan(Timestamp dateScan) {
        this.dateScan = dateScan;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProcessed(Boolean processed) {
        this.processed = processed;
    }

    public Boolean getProcessed() {
        return this.processed;
    }

    public static Vector<WaitingFile> searchUnprocessed() {
        ResultSet rs = null;
        Vector<WaitingFile> result = new Vector<WaitingFile>();
        String sql = "SELECT CLE, CLE_USER, NOM, DATE_SCAN FROM waiting WHERE PROCESSED = 0";
        try {
            Statement stm = WaitingFile.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                WaitingFile tmp = new WaitingFile(rs.getInt("CLE"), rs.getInt("CLE_USER"), rs.getString("NOM"));
                tmp.setDateScan(rs.getTimestamp("DATE_SCAN"));
                result.add(tmp);
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("WaitingFile.searchUnprocessed()  : " + ex);
            TimsLogger.debug(sql);
        }
        return result;
    }

    public static String getWaitingName() {
        int result = 0;
        String sql = "";
        try {
            sql = "SELECT max(CLE) FROM waiting";
            Statement stm = WaitingFile.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (rs.getString(1) == null) continue;
                result = rs.getInt(1);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.data.BddTransport.getNumeroDerniereImage()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return "temp " + result + ".jpg";
    }
}

