/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.dao.impl;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.dao.DAOSmallTable;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import transpo.system.TimsLogger;
import transpo.system.Transport;

public class DAOAutomaticWarning
extends DAOSmallTable<AutomaticWarning> {
    private final String table = "AUTOMATIC_WARNING";

    @Override
    public ArrayList<AutomaticWarning> getAll() {
        ArrayList<AutomaticWarning> list = new ArrayList<AutomaticWarning>();
        String sql = "SELECT ID, NAME, CALCULATION_CLASS, FREQUENCY, EXECUTION_DATE FROM " + BddTransport.getBaseDefault(true) + "AUTOMATIC_WARNING" + " ORDER BY NAME";
        ResultSet rs = null;
        Statement stm = null;
        try {
            try {
                stm = this.connexion.createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    list.add(new AutomaticWarning(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CALCULATION_CLASS"), rs.getInt("FREQUENCY"), rs.getInt("EXECUTION_DATE")));
                }
                rs.close();
            }
            catch (Exception ex) {
                TimsLogger.warn("#DAOAutomaticWarning.getAll# error (" + sql + ")");
                if (Transport.debug >= 1) {
                    ex.printStackTrace();
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    public ArrayList<AutomaticWarning> getCompanyAll(int companyId) {
        ArrayList<AutomaticWarning> list = new ArrayList<AutomaticWarning>();
        String sql = "SELECT t.ID, NAME, CALCULATION_CLASS, FREQUENCY, EXECUTION_DATE FROM " + BddTransport.getBaseDefault(true) + "AUTOMATIC_WARNING" + " t" + " JOIN tims.company_warning_activation cwa on t.id = cwa.id_warning";
        if (companyId != -1) {
            sql = String.valueOf(sql) + " WHERE id_company = " + companyId;
        }
        sql = String.valueOf(sql) + " ORDER BY NAME";
        ResultSet rs = null;
        Statement stm = null;
        try {
            try {
                stm = this.connexion.createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    list.add(new AutomaticWarning(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CALCULATION_CLASS"), rs.getInt("FREQUENCY"), rs.getInt("EXECUTION_DATE")));
                }
                rs.close();
            }
            catch (Exception ex) {
                TimsLogger.warn("#DAOAutomaticWarning.getCompanyAll# error (" + sql + ")");
                if (Transport.debug >= 1) {
                    ex.printStackTrace();
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    public ArrayList<AutomaticWarning> getUserAll(int userId) {
        ArrayList<AutomaticWarning> list = new ArrayList<AutomaticWarning>();
        String sql = "SELECT t.ID, NAME, CALCULATION_CLASS, FREQUENCY, EXECUTION_DATE FROM " + BddTransport.getBaseDefault(true) + "AUTOMATIC_WARNING" + " t" + " JOIN tims.user_warning_activation cwa on t.id = cwa.id_warning";
        if (userId != -1) {
            sql = String.valueOf(sql) + " WHERE id_user = " + userId;
        }
        sql = String.valueOf(sql) + " ORDER BY NAME";
        ResultSet rs = null;
        Statement stm = null;
        try {
            try {
                stm = this.connexion.createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    list.add(new AutomaticWarning(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CALCULATION_CLASS"), rs.getInt("FREQUENCY"), rs.getInt("EXECUTION_DATE")));
                }
                rs.close();
            }
            catch (Exception ex) {
                TimsLogger.warn("#DAOAutomaticWarning.getUserAll# error (" + sql + ")");
                if (Transport.debug >= 1) {
                    ex.printStackTrace();
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public int create(AutomaticWarning toCreate) {
        return 0;
    }

    @Override
    public void delete(AutomaticWarning toDelete) {
    }

    @Override
    public AutomaticWarning read(int primaryKey) {
        return null;
    }

    @Override
    public void update(AutomaticWarning toUpdate) {
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + "AUTOMATIC_WARNING" + " SET" + " NAME=" + toUpdate.getName() + ", CALCULATION_CLASS=" + toUpdate.getCalculationClass() + " WHERE ID=?";
        this.executeUpdate(sql);
    }
}

