/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.jxmapviewer.viewer;

import fr.pgh.jxmapviewer.viewer.ClusterWaypoint;
import fr.pgh.jxmapviewer.viewer.ClusterWaypointRenderer;
import fr.pgh.jxmapviewer.viewer.DefaultClusterWaypoint;
import fr.pgh.jxmapviewer.viewer.DefaultClusterWaypointRenderer;
import fr.pgh.jxmapviewer.viewer.TimsWaypoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.AbstractPainter;
import transpo.system.TimsLogger;

public class ClusterWaypointPainter<W extends TimsWaypoint>
extends AbstractPainter<JXMapViewer>
implements PropertyChangeListener,
MouseListener,
MouseMotionListener {
    private final int INSET = 4;
    private ClusterWaypointRenderer renderer = new DefaultClusterWaypointRenderer();
    private Set<W> waypoints = new HashSet<W>();
    private W selected = null;
    private Set<ClusterWaypoint> clusterWaypoints = new HashSet<ClusterWaypoint>();
    private float defaultClusterResolutionAtZoom1 = 9.0f;
    private float currentClusterResolution = 2000.0f;

    public ClusterWaypointPainter() {
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    public void setRenderer(ClusterWaypointRenderer r) {
        this.renderer = r;
    }

    public Set<ClusterWaypoint> getClusters() {
        return Collections.unmodifiableSet(this.clusterWaypoints);
    }

    public void setWaypoints(Set<? extends W> waypoints) {
        this.waypoints.clear();
        this.waypoints.addAll(waypoints);
        this.sortWaypoints();
    }

    private void sortWaypoints() {
        this.clusterWaypoints.clear();
        for (TimsWaypoint wp : this.waypoints) {
            ClusterWaypoint cwp = this.getCluster(wp);
            if (cwp == null) {
                DefaultClusterWaypoint toAdd = new DefaultClusterWaypoint(wp);
                toAdd.getButton().addMouseListener(this);
                toAdd.getButton().addMouseMotionListener(this);
                this.clusterWaypoints.add(toAdd);
                continue;
            }
            cwp.addWayPoint(wp);
        }
        TimsLogger.debug("CWPainter.sortWaypoints# " + this.waypoints.size() + " waypoints sorted in " + this.clusterWaypoints.size() + " clusters");
    }

    private ClusterWaypoint getCluster(TimsWaypoint wp) {
        for (ClusterWaypoint cwp : this.clusterWaypoints) {
            float distance = cwp.getCenter().distanceTo(wp.getPosition());
            TimsLogger.debug("#CWPainter.getCluster# distance between " + wp.getHtmlToolTip(true) + " and " + cwp.getCenter().toString() + " = " + distance);
            if (!(distance < this.currentClusterResolution)) continue;
            return cwp;
        }
        return null;
    }

    @Override
    protected void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        g.translate(-viewportBounds.getX(), -viewportBounds.getY());
        Font oldFont = g.getFont();
        Font regFont = oldFont.deriveFont((float)oldFont.getSize() * 0.8f).deriveFont(oldFont.getStyle() | 1);
        g.setFont(regFont);
        FontMetrics metrics = g.getFontMetrics(regFont);
        int txtH = metrics.getHeight();
        for (ClusterWaypoint w : this.getClusters()) {
            Point2D point = map.getTileFactory().geoToPixel(w.getCenter(), map.getZoom());
            Rectangle rectangle = map.getViewportBounds();
            int buttonX = (int)(point.getX() - rectangle.getX());
            int buttonY = (int)(point.getY() - rectangle.getY());
            JButton button = w.getButton();
            button.setLocation(buttonX - button.getWidth() / 2, buttonY - button.getHeight());
            map.add(button);
            if (w.getWaypoint().size() != 1) continue;
            String text = w.getWaypoint().get(0).getVehicle();
            int txtW = metrics.stringWidth(text) + 2;
            int rectX = (int)point.getX() - txtW / 2 - 2;
            int rectY = (int)point.getY() - button.getHeight() - txtH;
            int txtX = (int)point.getX() - txtW / 2;
            int txtY = (int)point.getY() - button.getHeight() - 2;
            TimsLogger.debug(String.valueOf(text) + " measure " + txtW + " " + txtH + " ");
            g.setColor(Color.WHITE);
            g.fillRoundRect(rectX, rectY, txtW + 4, txtH, 10, 10);
            g.setColor(Color.BLACK);
            g.drawString(text, txtX, txtY);
        }
        g.setFont(oldFont);
        g.translate(viewportBounds.getX(), viewportBounds.getY());
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getPropertyName().equals("zoom")) {
            float zoom = Float.parseFloat(arg0.getNewValue().toString());
            this.currentClusterResolution = this.defaultClusterResolutionAtZoom1 * (float)Math.pow(2.0, zoom - 1.0f);
            TimsLogger.debug("#CWPainter.propertyChange# zoomChanged from " + arg0.getOldValue() + " " + arg0.getNewValue() + " => new cluster resolution is " + this.currentClusterResolution);
            this.sortWaypoints();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JButton src = (JButton)e.getSource();
        TimsLogger.debug("You clicked on " + src.getToolTipText());
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        TimsLogger.debug("entering");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TimsLogger.debug("exiting");
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }
}

