/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.jxmapviewer.viewer;

import fr.pgh.jxmapviewer.viewer.ClusterWaypoint;
import fr.pgh.jxmapviewer.viewer.TimsWaypoint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolTip;
import javax.swing.border.LineBorder;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.beans.AbstractBean;
import org.jxmapviewer.viewer.GeoPosition;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DefaultClusterWaypoint
extends AbstractBean
implements ClusterWaypoint {
    private List<TimsWaypoint> waypoints;
    private ClusterButton btn;

    public DefaultClusterWaypoint(TimsWaypoint ... waypointArray) {
        this.waypoints = new ArrayList<TimsWaypoint>(Arrays.asList(waypointArray));
        this.btn = new ClusterButton();
        if (this.getWayPointCount() > 1) {
            this.btn.setHorizontalTextPosition(0);
            this.btn.setVerticalTextPosition(0);
            this.btn.setText(String.valueOf(this.getWayPointCount()));
            this.btn.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/cluster.png")));
            this.btn.setSize(20, 34);
            this.btn.setPreferredSize(new Dimension(20, 34));
        } else {
            this.btn.setSize(20, 34);
            this.btn.setPreferredSize(new Dimension(20, 34));
            this.btn.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard_waypoint.png")));
        }
        this.btn.setMargin(new Insets(0, 0, 0, 0));
        this.btn.setContentAreaFilled(false);
        this.btn.setBorderPainted(false);
        this.btn.setToolTipText(this.waypoints.get(0).getHtmlToolTip(false));
        this.btn.setVisible(true);
        this.btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (DefaultClusterWaypoint.this.waypoints.size() == 1) {
                        TimsLogger.debug("Loading 1 waypoint " + ((TimsWaypoint)DefaultClusterWaypoint.this.waypoints.get(0)).getHtmlToolTip(false));
                        Integer[] list = new Integer[DefaultClusterWaypoint.this.waypoints.size()];
                        int idx = 0;
                        for (TimsWaypoint tw : DefaultClusterWaypoint.this.waypoints) {
                            list[idx] = tw.getGNSSPlace().getVehicleId();
                            ++idx;
                        }
                        MainFrameTransport.getInstance().getPnlPositionAgency().loadHistoric(false, list);
                    } else {
                        TimsLogger.debug("Zoom on cluster");
                        HashSet<GeoPosition> track = new HashSet<GeoPosition>();
                        for (TimsWaypoint wp : DefaultClusterWaypoint.this.waypoints) {
                            track.add(wp.getPosition());
                        }
                        JButton src = (JButton)e.getSource();
                        JXMapViewer map = (JXMapViewer)src.getParent();
                        map.zoomToBestFit(track, 0.4);
                    }
                }
            }
        });
        this.btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    @Override
    public ClusterButton getButton() {
        return this.btn;
    }

    @Override
    public GeoPosition getCenter() {
        if (this.waypoints.size() == 1) {
            return this.waypoints.get(0).getPosition();
        }
        float lon = 0.0f;
        float lat = 0.0f;
        for (TimsWaypoint wp : this.waypoints) {
            lon = (float)((double)lon + wp.getPosition().getLongitude());
            lat = (float)((double)lat + wp.getPosition().getLatitude());
        }
        return new GeoPosition(lat / (float)this.waypoints.size(), lon / (float)this.waypoints.size());
    }

    @Override
    public int getWayPointCount() {
        return this.waypoints.size();
    }

    @Override
    public List<TimsWaypoint> getWaypoint() {
        return this.waypoints;
    }

    @Override
    public void addWayPoint(TimsWaypoint waypoint) {
        if (this.waypoints == null) {
            this.waypoints = new ArrayList<TimsWaypoint>();
        }
        this.waypoints.add(waypoint);
        String tooltip = "<html>" + this.getWayPointCount() + " " + LanguageTranslator.getString("position.markers") + "<br/>";
        for (TimsWaypoint t : this.waypoints) {
            tooltip = String.valueOf(tooltip) + t.getHtmlToolTip(true) + "<br/>";
        }
        tooltip = String.valueOf(tooltip) + "</html>";
        this.btn.setToolTipText(tooltip);
        if (this.getWayPointCount() > 1) {
            this.btn.setHorizontalTextPosition(0);
            this.btn.setVerticalTextPosition(0);
            this.btn.setText(String.valueOf(this.getWayPointCount()));
            this.btn.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/cluster.png")));
        } else {
            this.btn.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard_waypoint.png")));
        }
    }

    public class ClusterButton
    extends JButton {
        Point toolTipLocation = new Point(100, 0);

        @Override
        public JToolTip createToolTip() {
            JToolTip toto = super.createToolTip();
            toto.setBorder(new LineBorder(Color.blue));
            toto.setBackground(Color.lightGray);
            toto.setTipText(this.getToolTipText());
            this.toolTipLocation = new Point(-((int)toto.getPreferredSize().getWidth()) / 2 + this.getWidth() / 2, (int)(-toto.getPreferredSize().getHeight()) - 5);
            return toto;
        }

        @Override
        public Point getToolTipLocation(MouseEvent e) {
            if (this.getToolTipText(e) == null) {
                return null;
            }
            this.createToolTip();
            return this.toolTipLocation;
        }
    }
}

