/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer;

import org.jxmapviewer.viewer.TileFactoryInfo;

public class VirtualEarthTileFactoryInfo
extends TileFactoryInfo {
    public static final MVEMode MAP = new MVEMode("map", "map", "r", ".png");
    public static final MVEMode SATELLITE = new MVEMode("satellite", "satellite", "a", ".jpeg");
    public static final MVEMode HYBRID = new MVEMode("hybrid", "hybrid", "h", ".jpeg");
    private static final int TOP_ZOOM_LEVEL = 19;
    private static final int MAX_ZOOM_LEVEL = 17;
    private static final int MIN_ZOOM_LEVEL = 2;
    private static final int TILE_SIZE = 256;
    private MVEMode mode;

    public VirtualEarthTileFactoryInfo(MVEMode mode) {
        super("Virtual Earth", 2, 17, 19, 256, false, false, "", "", "", "");
        this.mode = mode;
    }

    public String getModeName() {
        return this.mode.name;
    }

    public String getModeLabel() {
        return this.mode.label;
    }

    @Override
    public String getTileUrl(int x, int y, int zoom) {
        String quad = this.tileToQuadKey(x, y, 19 - zoom);
        return "http://" + this.mode.type + quad.charAt(quad.length() - 1) + ".ortho.tiles.virtualearth.net/tiles/" + this.mode.type + quad + this.mode.ext + "?g=1";
    }

    private String tileToQuadKey(int tx, int ty, int zl) {
        String quad = "";
        int i = zl;
        while (i > 0) {
            int mask = 1 << i - 1;
            int cell = 0;
            if ((tx & mask) != 0) {
                ++cell;
            }
            if ((ty & mask) != 0) {
                cell += 2;
            }
            quad = String.valueOf(quad) + cell;
            --i;
        }
        return quad;
    }

    @Override
    public String getAttribution() {
        return "\u00a9 Microsoft";
    }

    @Override
    public String getLicense() {
        return "https://www.microsoft.com/en-us/maps/licensing";
    }

    public static class MVEMode {
        private String type;
        private String ext;
        private String name;
        private String label;

        private MVEMode(String name, String label, String type, String ext) {
            this.type = type;
            this.ext = ext;
            this.name = name;
            this.label = label;
        }
    }
}

