/*
 * Decompiled with CFR 0.152.
 */
package transpo.system;

import fr.pgh.conversion.ConversionTime;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import transpo.system.RegisterUI;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class LicenceManager {
    public static int STOCKAGE = 1;
    public static int EXPLOITATION = 2;
    public static int RH = 3;
    public static int COMPANY_AUTHORIZED = 10000;
    public static int AGENCY_AUTHORIZED = 10000;
    public static int DRIVER_AUTHORIZED = 10000;
    public static int EVALUATION_LEFT_DAY = 10000;
    public static int UNAUTHORIZED = 0;
    public static int END_EVALUATION = 1;
    public static int AUTHORIZED = 2;
    public static int CHECKSUM_ERROR = 2;
    public static int MODULE_ACCIDENT = 0;
    public static int MODULE_CONSUMPTION = 1;
    public Date date = null;
    public int level = 4;
    public String module = null;
    public int client = 0;
    public int installation = 0;
    public int EVALUATION_DAY = 0;
    public int authorized = UNAUTHORIZED;
    private static LicenceManager single = null;

    public static LicenceManager getInstance() {
        if (single == null) {
            single = new LicenceManager();
        }
        return single;
    }

    public LicenceManager() {
        if (Transport.apiMode == 1 || System.getProperty("URL") != null) {
            this.loadServerConfig();
            return;
        }
        Preferences p = Preferences.userRoot().node("TIMS");
        String licence = p.get("Licence", null);
        String activation = p.get("Activation", null);
        if (licence == null || new File("tims.install").exists()) {
            boolean register = true;
            if (licence != null) {
                boolean bl = register = JOptionPane.showConfirmDialog(null, LanguageTranslator.getString("license.new"), LanguageTranslator.getString("license.reinit"), 0, 3) == 0;
            }
            if (register) {
                new RegisterUI().setVisible(true);
                licence = p.get("Licence", null);
            }
        }
        this.decode(licence, activation);
    }

    public int getAuthorized() {
        return this.authorized;
    }

    public void decode(String cle, String activation) {
        TimsLogger.debug("LicenceManager.decode# licence " + cle + " (" + activation + ")");
        try {
            int offset = 0;
            this.level = Integer.parseInt(cle.substring(offset, offset + 1));
            int companyLength = Integer.parseInt(cle.substring(++offset, offset + 1));
            ++offset;
            if (companyLength != 0) {
                COMPANY_AUTHORIZED = Integer.parseInt(cle.substring(offset, offset + companyLength));
            }
            int agencyLength = Integer.parseInt(cle.substring(offset += companyLength, offset + 1));
            ++offset;
            if (agencyLength != 0) {
                AGENCY_AUTHORIZED = Integer.parseInt(cle.substring(offset, offset + agencyLength));
            }
            int driverLength = Integer.parseInt(cle.substring(offset += agencyLength, offset + 1));
            ++offset;
            if (driverLength != 0) {
                DRIVER_AUTHORIZED = Integer.parseInt(cle.substring(offset, offset + driverLength));
            }
            SimpleDateFormat tmp = new SimpleDateFormat("yyMMdd");
            this.date = tmp.parse(cle.substring(offset += driverLength, offset + 6));
            this.client = Integer.parseInt(cle.substring(offset += 6, offset + 3));
            this.installation = Integer.parseInt(cle.substring(offset += 3, offset + 2));
            int tryLength = Integer.parseInt(cle.substring(offset += 2, offset + 1));
            ++offset;
            if (tryLength != 0) {
                this.EVALUATION_DAY = Integer.parseInt(cle.substring(offset, offset + tryLength));
                Date limite = ConversionTime.addDay(this.date, this.EVALUATION_DAY);
                TimsLogger.info("Install done " + this.date + ", nb of day " + this.EVALUATION_DAY + " limite " + limite);
                if (limite.before(new Date())) {
                    TimsLogger.info(" end of try period.");
                    this.authorized = END_EVALUATION;
                } else {
                    EVALUATION_LEFT_DAY = ConversionTime.getDaysBetween(new Date(), limite);
                    this.authorized = AUTHORIZED;
                }
                offset += tryLength;
            } else {
                this.authorized = AUTHORIZED;
            }
            if (offset + 4 < cle.length()) {
                this.module = "";
                int x = 0;
                while (x < 2) {
                    String car = cle.substring(offset + x, offset + x + 2);
                    int number = 256 + Integer.parseInt(car, 16);
                    this.module = String.valueOf(this.module) + Integer.toBinaryString(number).substring(1);
                    TimsLogger.debug("car " + car + " (" + (offset + x) + ")= " + Integer.toBinaryString(number).substring(1));
                    ++x;
                }
                offset += 2;
                int checksum = 0;
                int i = 0;
                while (i < cle.length() - 2) {
                    checksum ^= cle.charAt(i);
                    ++i;
                }
                String sChecksum = Integer.toHexString(checksum + 256).substring(1);
                TimsLogger.debug("#LicenceManager.decode# checksum " + cle.substring(offset += 2, offset + 2) + " : " + Integer.toHexString(checksum));
                if (!cle.substring(offset, offset + 2).equalsIgnoreCase(sChecksum)) {
                    TimsLogger.debug("#LicenceManager.decode# " + cle.substring(offset, offset + 2) + " differs from " + Integer.toHexString(checksum));
                    this.authorized = CHECKSUM_ERROR;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TimsLogger.debug("#LicenceManager.decode# application level : " + this.level);
        TimsLogger.debug("#LicenceManager.decode# company authorized : " + COMPANY_AUTHORIZED);
        TimsLogger.debug("#LicenceManager.decode# agency authorized : " + AGENCY_AUTHORIZED);
        TimsLogger.debug("#LicenceManager.decode# driver authorized : " + DRIVER_AUTHORIZED);
    }

    public void loadServerConfig() {
        this.level = 4;
        COMPANY_AUTHORIZED = 100000;
        AGENCY_AUTHORIZED = 100000;
        DRIVER_AUTHORIZED = 100000;
        this.authorized = AUTHORIZED;
    }

    public int getApplicationLevel() {
        return this.level;
    }

    public static boolean isModuleEnable(int module) {
        boolean enable = LicenceManager.getInstance().level == 4 || LicenceManager.getInstance().module != null && LicenceManager.getInstance().module.substring(module, module + 1).equals("1");
        TimsLogger.debug("#LicenceManager.isModuleEnable# asking for module " + module + " return " + enable);
        return enable;
    }

    public static String getVersionLevel() {
        return LanguageTranslator.getString("license.version-" + LicenceManager.getInstance().level);
    }

    public static boolean isStorageLevel() {
        return true;
    }

    public static boolean isExploitationLevel() {
        return LicenceManager.getInstance().level >= EXPLOITATION;
    }

    public static boolean isHRLevel() {
        return LicenceManager.getInstance().level >= RH;
    }

    public static boolean isServerLevel() {
        return LicenceManager.getInstance().level >= 4;
    }

    public int getClient() {
        return this.client;
    }
}

