/*
 * Decompiled with CFR 0.152.
 */
package transpo.system;

import java.io.PrintStream;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;

public class PerformanceScanner {
    public static int READING = 1;
    public static int INSERT = 2;
    public static int UPDATE = 3;
    public static int DELETE = 4;
    public static int PROCESS = 5;
    private Vector<Long> askedTime = null;
    private PrintStream ps = null;

    public PerformanceScanner() {
        try {
            this.askedTime = new Vector();
            TimsLogger.info("#PS# cr\u00e9ation du fichier dans " + Transport.savePath + "timeTIMS.log");
            this.ps = new PrintStream(String.valueOf(Transport.savePath) + "timeTIMS.log");
        }
        catch (Exception ex) {
            TimsLogger.warn("erreur");
        }
    }

    public void startOperation() {
        long time = System.currentTimeMillis();
        String tab = "";
        this.askedTime.add(time);
        int x = 0;
        while (x < this.askedTime.size() - 1) {
            tab = String.valueOf(tab) + " ";
            ++x;
        }
        this.ps.println(String.valueOf(tab) + "new operation");
    }

    public long endOperation(int type, String libelle) {
        return this.endOperation(type, libelle, null);
    }

    public long endOperation(int type, String libelle, String printInConsole) {
        return this.endOperation(type, libelle, printInConsole, 0);
    }

    public long endOperation(int type, String libelle, String printInConsole, int debug) {
        long time = System.currentTimeMillis();
        String tab = "";
        int x = 0;
        while (x < this.askedTime.size() - 1) {
            tab = String.valueOf(tab) + " ";
            ++x;
        }
        long duration = time - this.askedTime.get(this.askedTime.size() - 1);
        this.ps.println(String.valueOf(tab) + type + " - operation '" + libelle + "' done in " + duration + " ms");
        this.ps.flush();
        this.askedTime.remove(this.askedTime.size() - 1);
        if (this.askedTime.size() == 0) {
            this.ps.println();
            this.ps.flush();
        }
        if (printInConsole != null && Transport.debug >= debug) {
            TimsLogger.info("#ps# " + printInConsole.replace("%s", String.valueOf(String.valueOf(duration)) + " ms"));
        }
        return duration;
    }

    public long startAbsoluteTime() {
        long time = System.currentTimeMillis();
        this.ps.println("new operation");
        return time;
    }

    public void endAbsoluteTime(int type, String libelle, long start) {
        this.ps.println(String.valueOf(type) + " - operation '" + libelle + "' done in " + (System.currentTimeMillis() - start) + " ms");
        this.ps.flush();
    }

    public void closeAll() {
        int x = 0;
        while (x < this.askedTime.size() - 1) {
            this.ps.println("closeAll " + this.askedTime.get(this.askedTime.size() - 1));
            ++x;
        }
        this.ps.flush();
        this.askedTime.clear();
    }
}

