/*
 * Decompiled with CFR 0.152.
 */
package transpo.system;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.ConnexionUI;
import fr.pgh.connexion.Maintenance;
import fr.pgh.data.BddTransport;
import fr.pgh.data.VersionManager;
import fr.pgh.data.bdd.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import transpo.system.LicenceManager;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.ProgressBarIndetermine;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.GetFile;
import transpo.system.util.messaging.MessageSystemManager;

public class Transport {
    public static Fmresources res = null;
    public static String savePath = null;
    public static BddTransport bdd = null;
    public static ConnexionSettings conn = null;
    public static PerformanceScanner ps = null;
    public static int debug = 0;
    public static int safe = 0;
    public static int apiMode = 0;
    public static boolean init = false;
    public static final String preference = "TIMS";
    private static ProgressBarIndetermine pb = null;
    public static boolean showPopup;

    public static void getArgs(String[] args, String ... sup) {
        String[] merged = new String[args.length + sup.length];
        System.arraycopy(args, 0, merged, 0, args.length);
        System.arraycopy(sup, 0, merged, args.length, sup.length);
        TimsLogger.info("loading " + merged.length + " args");
        if (merged.length > 0) {
            int i = 0;
            while (i < merged.length) {
                String arg = merged[i].toLowerCase();
                String val = merged[i].substring(merged[i].indexOf("=") + 1).trim();
                if (arg.startsWith("lf")) {
                    if (val.compareToIgnoreCase("true") == 0) {
                        Transport.setLFDecorated(true);
                    }
                } else if (arg.startsWith("api")) {
                    apiMode = Integer.parseInt(val);
                    MessageSystemManager.setMessageLevel(2);
                    TimsLogger.info("apiMode mode = " + apiMode + " activ\u00e9");
                } else if (arg.startsWith("debug")) {
                    debug = Integer.parseInt(val);
                    TimsLogger.info("debug mode " + debug + " activ\u00e9");
                } else if (arg.startsWith("safe")) {
                    debug = Integer.parseInt(val);
                    TimsLogger.info("safe mode " + safe + " activ\u00e9");
                } else if (arg.startsWith("local")) {
                    String lg = val;
                    LanguageTranslator.getInstance().setLocale(lg);
                } else if (arg.startsWith("temp")) {
                    savePath = val;
                    TimsLogger.info("temp = " + savePath);
                } else if (arg.startsWith("config")) {
                    String configFile = val;
                    TimsLogger.info("loading configuration file " + configFile);
                    try {
                        FileInputStream in = new FileInputStream(configFile);
                        Properties props = new Properties();
                        props.load(in);
                        for (Map.Entry<Object, Object> param : props.entrySet()) {
                            System.setProperty(param.getKey().toString().trim(), param.getValue().toString().trim());
                            if (param.getKey().toString().trim().startsWith("debug")) {
                                debug = Integer.parseInt(param.getValue().toString().trim());
                                TimsLogger.info("debug mode " + debug + " activ\u00e9 (from config file)");
                            }
                            if (!param.getKey().toString().trim().toUpperCase().startsWith("API")) continue;
                            apiMode = Integer.parseInt(param.getValue().toString().trim());
                            TimsLogger.info("apiMode mode " + apiMode + " activ\u00e9 (from config file)");
                        }
                        TimsLogger.info(String.valueOf(props.entrySet().size()) + " parameters loaded from " + configFile);
                    }
                    catch (Exception e) {
                        TimsLogger.error("unable to load parameters from " + configFile);
                        e.printStackTrace();
                    }
                } else {
                    TimsLogger.info("additional parameter : " + merged[i].split("=")[0].trim() + " = " + val);
                    System.setProperty(merged[i].split("=")[0].trim().toUpperCase(), val);
                }
                ++i;
            }
        }
    }

    public static void init() {
        Date curTime;
        if (init) {
            TimsLogger.warn("#Transport.init()# initialization ever done. Can't be done several times");
            return;
        }
        LanguageTranslator.getInstance();
        if (savePath == null) {
            savePath = System.getProperty("java.io.tmpdir");
        }
        if (System.getProperty("company", "PGH").equals("salvesen")) {
            savePath = "C:/windows/temp/";
        }
        try {
            new TimsLogger();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        res = new Fmresources();
        Transport.checkJavaVersion();
        boolean right = true;
        File tmp = new File(String.valueOf(savePath) + "testTims.txt");
        try {
            if (tmp.exists() && !tmp.delete()) {
                TimsLogger.warn("#Transport.init# impossible de supprimer " + tmp.getAbsolutePath());
                right = false;
            }
            if (!tmp.createNewFile()) {
                TimsLogger.warn("#Transport.init# impossible de cr\u00e9er " + tmp.getAbsolutePath());
                tmp.delete();
                right = false;
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("#Transport.init# impossible de cr\u00e9er testTims.txt ");
            right = false;
        }
        if (!right) {
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("exception.security.temp"), "", 0);
            System.exit(0);
        } else {
            tmp.delete();
        }
        if (apiMode == 0 && System.getProperty("URL") == null) {
            String archivePath;
            Configuration cfg;
            Configuration sv = new Configuration(true);
            if (!sv.load("software_version")) {
                sv = new Configuration(true, 0, "software_version", res.getResourceString("executableVersion"), true, false);
                sv.insert();
            }
            if (!(cfg = new Configuration(true)).load("data.path")) {
                TimsLogger.error("Transport.init# unable to find archive path");
                cfg = new Configuration(true, 0, "data.path", "undefined", true, false);
                cfg.insert();
            }
            if ((archivePath = cfg.getEval()).equals("undefined")) {
                TimsLogger.error("Transport.init# archive path undefined");
                try {
                    SwingUtilities.invokeAndWait(new Thread(){

                        @Override
                        public void run() {
                            String defaultPath = String.valueOf(System.getProperty("user.dir")) + "\\data\\";
                            Object[] choix = new String[]{LanguageTranslator.getString("data.default.path"), LanguageTranslator.getString("data.customize.path")};
                            int intChoix = -1;
                            intChoix = JOptionPane.showOptionDialog(null, LanguageTranslator.getString("data.path.undefined"), LanguageTranslator.getString("generics.configuration"), 0, 2, null, choix, null);
                            while (intChoix == 1) {
                                GetFile gf = new GetFile(LanguageTranslator.getString("data.define.default"), LanguageTranslator.getString("button.defineDefaultPath"), true, null);
                                gf.run();
                                if (gf.getCheminSave() == null) {
                                    intChoix = JOptionPane.showOptionDialog(null, LanguageTranslator.getString("data.path.undefined"), LanguageTranslator.getString("generics.configuration"), 0, 2, null, choix, null);
                                    continue;
                                }
                                String path = String.valueOf(gf.getCheminSave()) + "\\";
                                if (!path.equals(defaultPath)) {
                                    if (!Fonctions.checkAccess(new File(path))) break;
                                    try {
                                        Fonctions.moveDir(defaultPath, path);
                                    }
                                    catch (Exception ex) {
                                        TimsLogger.error("Impossible de d\u00e9placer les fichiers");
                                    }
                                }
                                Configuration cfg = new Configuration(true);
                                cfg.load("data.path");
                                cfg.setEval(path);
                                cfg.update();
                                break;
                            }
                            if (intChoix != 1) {
                                Configuration cfg = new Configuration(true);
                                cfg.load("data.path");
                                cfg.setEval(defaultPath);
                                cfg.update();
                            }
                        }
                    });
                    cfg.load("data.path");
                    archivePath = cfg.getEval();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            FileManager.ARCHIVE_DIRECTORY = archivePath;
            tmp = new File(archivePath);
            right = Fonctions.checkAccess(tmp);
        }
        if (!right) {
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("exception.security.data", tmp.getAbsolutePath()), "", 0);
            System.exit(0);
        }
        TimsLogger.debug("SGBDR is " + System.getProperty("SGBDR", "mysql"));
        if (System.getProperty("horoquartz", "0").equals("1")) {
            TimsLogger.info("Module HOROQUARTZ actif");
        }
        ps = new PerformanceScanner();
        bdd = BddTransport.getInstance();
        conn = ConnexionSettings.getInstance();
        conn.loadDefault(BddTransport.getInstance());
        if (!TimeZone.getDefault().getID().equals("Europe/Paris")) {
            TimsLogger.warn("La timezone n'est pas sur paris (" + TimeZone.getDefault().getID() + ")");
            TimeZone.setDefault(TimeZone.getTimeZone("Europe/Paris"));
        }
        if (Math.abs((curTime = new Date()).getTime() - BddTransport.getInstance().getDate().getTime()) > 7300000L) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            TimsLogger.warn("Heure de la base diff\u00e9rente de plus de 2 h \u00e0 l'heure du PC " + sdf.format(curTime) + ") != " + sdf.format(BddTransport.getInstance().getDate()));
            Object[] options = new String[]{LanguageTranslator.getString("message.keepOnAnyway"), LanguageTranslator.getString("button.quit")};
            SynchronizedOptionDialog t = new SynchronizedOptionDialog(null, LanguageTranslator.getString("message.wrongTime"), LanguageTranslator.getString("message.error"), null, options);
            try {
                SwingUtilities.invokeAndWait(t);
                if (t.getOption() == 1) {
                    System.exit(0);
                } else {
                    TimsLogger.info("Transport.init# on continue avec le d\u00e9calage horaire");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        init = true;
        TimsLogger.info("TIMS VERSION " + res.getResourceString("executableVersion") + ", file data saved in " + savePath);
    }

    private static void checkJavaVersion() {
        int version = Fonctions.getJavaVersion(null);
        TimsLogger.info("#Transport.checkJavaVersion# Java version is " + version);
        if (version <= 7) {
            TimsLogger.warn("#Transport.checkJavaVersion# version 7 ou ant\u00e9rieure");
            if (apiMode == 0) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("java.version.warning"), LanguageTranslator.getString("java.version.message"), 2);
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        Object tmp;
        LicenceManager lm;
        UIManager.put("MultiListBoxUI", "fr.pgh.component.ui.metal.MetalMultiListBoxUI");
        Transport.getArgs(args, new String[0]);
        Transport.init();
        TimsLogger.debug("#Transport.main# init is OK, we now check version...");
        if (System.getProperty("maj") != null && !System.getProperty("maj").equals("")) {
            new Maintenance(System.getProperty("maj"), System.getProperty("dureeMaj"));
        }
        if (System.getProperty("URL") == null && debug < 1 && apiMode == 0 && (lm = LicenceManager.getInstance()).getAuthorized() != LicenceManager.AUTHORIZED) {
            if (lm.getAuthorized() == LicenceManager.END_EVALUATION) {
                if (JOptionPane.showConfirmDialog(null, LanguageTranslator.getString("connexion.evaluationEnd"), LanguageTranslator.getString("connexion.error"), 2) == 0) {
                    tmp = Preferences.userRoot().node(preference);
                    ((Preferences)tmp).remove("Licence");
                    ((Preferences)tmp).remove("Activation");
                }
            } else if (JOptionPane.showConfirmDialog(null, LanguageTranslator.getString("connexion.licenceError"), LanguageTranslator.getString("connexion.error"), 2) == 0) {
                tmp = Preferences.userRoot().node(preference);
                ((Preferences)tmp).remove("Licence");
                ((Preferences)tmp).remove("Activation");
            }
            System.exit(0);
        }
        Configuration cfg = new Configuration(true);
        cfg.load("database_version");
        Configuration.loadList(null, true);
        if (System.getProperty("URL") == null) {
            if (System.getProperty("mysql5", "0").equals("0")) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("connexion.error.mysql4"), LanguageTranslator.getString("connexion.error"), 0);
                            System.exit(0);
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (cfg.getEval() == null || cfg.getEval().equals("*") || !cfg.getEval().equals(res.getResourceString("databaseVersion"))) {
                TimsLogger.debug("#Transport# Version " + cfg.getEval() + " != " + res.getResourceString("databaseVersion"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pb = new ProgressBarIndetermine(null, LanguageTranslator.getString("versionning.processing"));
                        pb.setVisible(true);
                    }
                });
                tmp = new VersionManager(res.getResourceString("databaseVersion"), cfg.getEval());
                if (((VersionManager)tmp).loadFiles() != 1 || ((VersionManager)tmp).isValidFiles() != 1) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                pb.dispose();
                                JOptionPane.showMessageDialog(null, LanguageTranslator.getString("versionning.corrupted"), LanguageTranslator.getString("versionning.corrupted"), 1);
                            }
                        });
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (((VersionManager)tmp).doVersionning() != 1) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                pb.dispose();
                                JOptionPane.showMessageDialog(null, LanguageTranslator.getString("versionning.failed"), LanguageTranslator.getString("versionning.failed"), 0);
                            }
                        });
                        GetFile choix = new GetFile("Sauvegarder les fichiers dans", null, true, null);
                        SwingUtilities.invokeAndWait(choix);
                        if (choix.getCheminSave() != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    pb = new ProgressBarIndetermine(null, LanguageTranslator.getString("download.copy"));
                                    pb.setVisible(true);
                                }
                            });
                            ((VersionManager)tmp).saveVersionFile(String.valueOf(choix.getCheminSave()) + "/");
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    pb.dispose();
                                    JOptionPane.showMessageDialog(null, LanguageTranslator.getString("download.export.succeed"), LanguageTranslator.getString("message.done"), 1);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.exit(0);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                pb.dispose();
                                JOptionPane.showMessageDialog(null, LanguageTranslator.getString("versionning.succeed"), LanguageTranslator.getString("versionning.succeed"), 1);
                            }
                        });
                        showPopup = true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    conn.loadDefault(BddTransport.getInstance());
                }
            }
        } else if (!res.getResourceString("databaseVersion").equals(cfg.getEval())) {
            if (cfg.getEval() == null) {
                tmp = new VersionManager(res.getResourceString("databaseVersion"), cfg.getEval());
                if (((VersionManager)tmp).loadFiles() != 1 || ((VersionManager)tmp).isValidFiles() != 1) {
                    cfg.setEval("unknown version");
                } else {
                    cfg.setEval(((VersionManager)tmp).evaluateDBVersion());
                }
            }
            TimsLogger.error("#Transport# Version " + cfg.getEval() + " is required (" + res.getResourceString("databaseVersion") + " is launched)");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, LanguageTranslator.getString("connexion.master.error"), LanguageTranslator.getString("connexion.error"), 0);
                        if (debug == 0) {
                            System.exit(0);
                        } else {
                            int option = JOptionPane.showConfirmDialog(null, "Mode debug, voulez-vous forcer la connexion (attention, cela peut provoquer des probl\u00e8mes)", LanguageTranslator.getString("connexion.error"), 0);
                            if (option != 0) {
                                System.exit(0);
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (System.getProperty("URL") == null) {
            cfg = new Configuration(true);
            cfg.load("software_version");
            cfg.setEval(res.getResourceString("executableVersion"));
            cfg.update();
        }
        TimsLogger.debug("#Transport.main# ok, we now launch program...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (res.getResourceString("identification").equals("1") && debug <= 1 && System.getProperty("URL") != null) {
                    ConnexionUI.getInstance().setVisible(true);
                } else {
                    MainFrameTransport.getInstance().setVisible(true);
                }
            }
        });
    }

    protected static void setLFDecorated(boolean LFDecorated) {
        if (LFDecorated) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
    }
}

