/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.automatic;

import fr.pgh.component.TableSorter;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.InterventionType;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.automatic.AbstractAutomaticWarning;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.TMInterventionState;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGeneratorWithDateStyle;

public class ARUevIntervention
extends AbstractAutomaticWarning {
    @Override
    public void execute() {
        Vector<Vehicule> vehicles = Vehicule.loadList(0);
        Vector<Color> conditionalColors = new Vector<Color>();
        Vector<Integer> conditionalThresholds = new Vector<Integer>();
        conditionalColors.add(MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT);
        conditionalThresholds.add(-1);
        conditionalColors.add(MainFrameTransport.BG_COLOR_ALERTE_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("intervention_error", "10")));
        conditionalColors.add(MainFrameTransport.BG_COLOR_OK_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("intervention_warning", "60")));
        conditionalThresholds.add(-1);
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.vehicleState"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultVehicleExpirationStateColumn(InterventionType.getList());
        cr.setColumn(columns);
        ArrayList<Map<String, ?>> data = new TableSorter(new TMInterventionState(vehicles, InterventionType.loadList(false), Fonctions.getNextIntervention(Intervention.loadLastList(0, 0), vehicles, false, null, null))).getData();
        boolean generated = Fonctions.tblToReport(cr, new DJGeneratorWithDateStyle(conditionalColors, conditionalThresholds), data, "pdf", Transport.savePath);
        if (generated) {
            if (new File(String.valueOf(Transport.savePath) + LanguageTranslator.getString("generics.vehicleState") + ".pdf").exists()) {
                this.warnContent = "<br/>" + LanguageTranslator.getString("mail.intervention") + "<br/>";
                this.attachment.add(new File(String.valueOf(Transport.savePath) + LanguageTranslator.getString("generics.vehicleState") + ".pdf"));
            } else {
                TimsLogger.warn("Can't find report " + Transport.savePath + LanguageTranslator.getString("generics.vehicleState") + ".pdf");
            }
        } else {
            TimsLogger.error("#ARUevIntervention.execute# generation error");
        }
    }
}

