/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.automatic.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.mail.MailSender;
import transpo.system.util.messaging.MessageSystemManager;

public class FileDetection {
    private static final String SERVER = "imap.pro.cienum.fr";
    private static final String ACCOUNT = "pgh@pgh.fr";
    private static final String PASSWORD = "cis/00";
    private static final String FILE_PATH = "E:/files/MAILTO/";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private MailSender ms = null;
    private static String propertiesFile = "filedetect.properties";
    public static final String RECEIVED_HEADER_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss";
    public static final String RECEIVED_HEADER_REGEXP = "^[^;]+;(.+)$";

    public static void main(String[] args) {
        Transport.apiMode = 1;
        Transport.getArgs(args, new String[0]);
        Transport.init();
        int i = 0;
        while (i < args.length) {
            if (args[i].toLowerCase().startsWith("propertiesfile")) {
                propertiesFile = args[i].substring(args[i].indexOf("=") + 1).trim();
            }
            ++i;
        }
        MessageSystemManager.setMessageLevel(2);
        new FileDetection();
    }

    public FileDetection() {
        try {
            String ligne;
            this.ms = new MailSender();
            FileInputStream in = new FileInputStream(propertiesFile);
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader buffered = new BufferedReader(reader);
            while ((ligne = buffered.readLine()) != null) {
                TimsLogger.info("Processing " + ligne);
                String[] params = ligne.split(";");
                File temp = new File(params[1]);
                ArrayList<File> toJoin = new ArrayList<File>();
                ArrayList<String> bcc = new ArrayList<String>();
                bcc.add("sebastien.gobert@pgh.fr");
                bcc.add(ACCOUNT);
                ArrayList<String> tos = new ArrayList<String>();
                int x = 2;
                while (x < params.length) {
                    tos.add(params[x]);
                    ++x;
                }
                if (!new File(String.valueOf(temp.getAbsolutePath()) + "\\SEND").exists()) {
                    new File(String.valueOf(temp.getAbsolutePath()) + "\\SEND").mkdir();
                }
                String[] stringArray = temp.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (string.toLowerCase().endsWith(".c1b") || string.toLowerCase().endsWith(".v1b")) {
                        TimsLogger.debug("Adding " + temp.getAbsoluteFile() + "\\" + string);
                        toJoin.add(new File(temp.getAbsoluteFile() + "\\" + string));
                    }
                    ++n2;
                }
                if (toJoin.size() != 0) {
                    try {
                        this.ms.sendMessage(tos, null, bcc, "Fichier(s) " + params[0] + " disponible(s)", "nouveau(x) fichier(s) C1B disponible(s)", toJoin, false);
                        for (File file : toJoin) {
                            file.renameTo(new File(String.valueOf(temp.getAbsolutePath()) + "\\SEND\\" + file.getName()));
                        }
                    }
                    catch (MessagingException messagingException) {
                        try {
                            tos.clear();
                            tos.add("sebastien.gobert@pgh.fr");
                            this.ms.sendMessage(tos, null, null, "Erreur envoi fichier", "Probl\u00e8me d'envoi des fichier sur " + params[0], null, false);
                            messagingException.printStackTrace();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    continue;
                }
                TimsLogger.debug("No file to process");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void checkMail() throws IOException {
        block29: {
            Properties properties = new Properties();
            Session session = Session.getInstance((Properties)properties);
            Store store = null;
            Folder defaultFolder = null;
            Folder inbox = null;
            Properties props = new Properties();
            FileInputStream in = new FileInputStream("E:/files/MAILTO/last.txt");
            props.load(in);
            Date lastCheck = null;
            try {
                lastCheck = DATE_FORMAT.parse(props.getProperty("lastCheck", null));
            }
            catch (Exception ex) {
                TimsLogger.debug("can't  parse " + props.getProperty("lastCheck", null));
            }
            TimsLogger.debug("Derni\u00e8re verif " + lastCheck);
            int countFile = 0;
            try {
                try {
                    store = session.getStore("imap");
                    store.connect(SERVER, ACCOUNT, PASSWORD);
                    defaultFolder = store.getDefaultFolder();
                    TimsLogger.debug("defaultFolder : " + defaultFolder.getName());
                    Folder[] folderArray = defaultFolder.list();
                    int n = folderArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Folder folder = folderArray[n2];
                        TimsLogger.debug(folder.getName());
                        ++n2;
                    }
                    inbox = defaultFolder.getFolder("INBOX");
                    try {
                        inbox.open(1);
                        Message[] foundMessages = inbox.search((SearchTerm)new ReceivedDateTerm(5, lastCheck));
                        int count = foundMessages.length;
                        TimsLogger.debug("Il y a " + count + " messages.");
                        int i = 1;
                        while (i < count) {
                            Message message = foundMessages[i];
                            TimsLogger.debug("Message n\u00b0 " + i);
                            TimsLogger.debug("Sujet : " + message.getSubject() + "(" + message.getReceivedDate() + ")");
                            if (lastCheck != null && !message.getReceivedDate().after(lastCheck)) {
                                TimsLogger.debug(String.valueOf(DATE_FORMAT.format(lastCheck)) + " after " + DATE_FORMAT.format(message.getReceivedDate()));
                            } else {
                                if (message.getSubject().startsWith("Fichier carte a puce de ")) {
                                    String companyName = message.getSubject().substring("Fichier carte a puce de ".length());
                                    TimsLogger.debug("Fichier \u00e0 int\u00e9grer sur '" + companyName + "'");
                                    DataSource dataSource = message.getDataHandler().getDataSource();
                                    MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
                                    int multiPartCount = mimeMultipart.getCount();
                                    TimsLogger.debug("Il y a " + multiPartCount + " partie(s) dans ce message.");
                                    int x = 0;
                                    while (x < multiPartCount) {
                                        BodyPart bp = mimeMultipart.getBodyPart(x);
                                        try {
                                            if (!bp.isMimeType("text/plain")) {
                                                String fileName = bp.getFileName();
                                                TimsLogger.debug("FileName : " + fileName);
                                                if (fileName.endsWith("C1B") || fileName.endsWith("V1B")) {
                                                    DataHandler dh = bp.getDataHandler();
                                                    File file = new File("E:/files/MAILTO//" + companyName + "/" + fileName);
                                                    if (!file.getParentFile().exists()) {
                                                        file.getParentFile().mkdir();
                                                    }
                                                    FileOutputStream fos = new FileOutputStream(file);
                                                    dh.writeTo((OutputStream)fos);
                                                    ++countFile;
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        ++x;
                                    }
                                }
                                lastCheck = message.getReceivedDate();
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileDetection.close(inbox);
                    FileDetection.close(defaultFolder);
                    FileOutputStream out = new FileOutputStream("E:/files/MAILTO/last.txt");
                    props.setProperty("lastCheck", DATE_FORMAT.format(lastCheck));
                    props.setProperty("history" + new SimpleDateFormat("ddMMyyHHmmss").format(Calendar.getInstance().getTime()), String.valueOf(countFile));
                    props.store(out, "Fichier de propri\u00e9t\u00e9s de mailTo");
                    try {
                        if (store != null && store.isConnected()) {
                            store.close();
                        }
                        break block29;
                    }
                    catch (MessagingException e2) {
                        e2.printStackTrace();
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                FileDetection.close(inbox);
                FileDetection.close(defaultFolder);
                FileOutputStream out = new FileOutputStream("E:/files/MAILTO/last.txt");
                props.setProperty("lastCheck", DATE_FORMAT.format(lastCheck));
                props.setProperty("history" + new SimpleDateFormat("ddMMyyHHmmss").format(Calendar.getInstance().getTime()), String.valueOf(countFile));
                props.store(out, "Fichier de propri\u00e9t\u00e9s de mailTo");
                try {
                    if (store != null && store.isConnected()) {
                        store.close();
                    }
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            FileDetection.close(inbox);
            FileDetection.close(defaultFolder);
            FileOutputStream out = new FileOutputStream("E:/files/MAILTO/last.txt");
            props.setProperty("lastCheck", DATE_FORMAT.format(lastCheck));
            props.setProperty("history" + new SimpleDateFormat("ddMMyyHHmmss").format(Calendar.getInstance().getTime()), String.valueOf(countFile));
            props.store(out, "Fichier de propri\u00e9t\u00e9s de mailTo");
            try {
                if (store != null && store.isConnected()) {
                    store.close();
                }
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    private static void close(Folder folder) {
        if (folder != null && folder.isOpen()) {
            try {
                folder.close(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static List<String> inputStreamToStrings(InputStream is) {
        InputStreamReader isr = new InputStreamReader(is);
        LinkedList<String> strings = new LinkedList<String>();
        try {
            BufferedReader reader = new BufferedReader(isr);
            String line = reader.readLine();
            while (line != null) {
                strings.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return strings;
    }

    public Date resolveReceivedDate(Message message) throws MessagingException {
        if (message.getReceivedDate() != null) {
            return message.getReceivedDate();
        }
        String[] receivedHeaders = message.getHeader("Received");
        if (receivedHeaders == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(RECEIVED_HEADER_DATE_FORMAT);
        Date finalDate = null;
        String[] stringArray = receivedHeaders;
        int n = receivedHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            String receivedHeader = stringArray[n2];
            Pattern pattern = Pattern.compile(RECEIVED_HEADER_REGEXP);
            Matcher matcher = pattern.matcher(receivedHeader);
            if (matcher.matches()) {
                String regexpMatch = matcher.group(1);
                TimsLogger.debug("Match : " + receivedHeader + "=> " + regexpMatch);
                if (regexpMatch != null) {
                    regexpMatch = regexpMatch.trim();
                    try {
                        Date parsedDate = sdf.parse(regexpMatch);
                        if (parsedDate.after(finalDate)) {
                            finalDate = parsedDate;
                        }
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    TimsLogger.debug("Unable to match received date in header string " + receivedHeader);
                }
            }
            ++n2;
        }
        return finalDate;
    }
}

