/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.automatic.launcher;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.Societe;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.mail.MailSender;
import transpo.system.util.Fonctions;
import transport.offence.CalculInfractionPrincipal;

public class OffenceCalculation {
    public static void main(String[] args) {
        Transport.apiMode = 1;
        Transport.getArgs(args, new String[0]);
        new OffenceCalculation();
    }

    public OffenceCalculation() {
        Fonctions.loadProperty(System.getProperty("offence.properties", "offence.properties"));
        Transport.init();
        MailSender send = null;
        try {
            send = new MailSender();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Date begin = ConversionTime.stringToDate(System.getProperty("date"), "dd/MM/yyyy");
        if (begin == null) {
            int interval = Integer.valueOf(System.getProperty("interval", "0"));
            begin = ConversionTime.addDay(new Date(), -interval);
        }
        Date end = new Date();
        String sBegin = ConversionTime.dateToString(begin, "yyyy-MM-dd");
        String sEnd = ConversionTime.dateToString(end, "yyyy-MM-dd");
        boolean onRaw = System.getProperty("BRUT", "0").equals("1");
        TimsLogger.debug("BRUT = " + onRaw);
        Vector<Societe> tmp = Societe.loadList(null);
        boolean jumped = System.getProperty("JUMP_TO_COMPANY") == null;
        for (Societe current : tmp) {
            TimsLogger.debug("Soci\u00e9t\u00e9 " + current.getNomBase());
            if (!jumped && !System.getProperty("JUMP_TO_COMPANY").equals(current.getNomSociete())) continue;
            jumped = true;
            if (System.getProperty("STOP_AT_COMPANY") != null && current.getNomSociete().equals(System.getProperty("STOP_AT_COMPANY"))) break;
            if (System.getProperty("COMPANY") != null && !current.getNomSociete().equals(System.getProperty("COMPANY"))) continue;
            Transport.bdd.changeDB(current.getNomSociete(), false);
            Offence.delete(0, 0, begin, new Date(), onRaw);
            Transport.bdd.updateDriverOffenceDate(sBegin, 0, 0, onRaw);
            Vector<Conducteur> listeConducteur = Transport.bdd.getConducteurListInfraction(0, 0);
            CalculInfractionPrincipal cip = new CalculInfractionPrincipal(sEnd, listeConducteur, onRaw ? 1 : -1);
            cip.run();
            if (cip.getErrors() != null && cip.getErrors().size() != 0) {
                ArrayList<String> to = new ArrayList<String>();
                to.add(System.getProperty("to", "sebastien.gobert@pgh.fr"));
                String text = "La liste de conducteur(s) suivante a gen\u00e9r\u00e9 une erreur lors du calcul des infractions :\n";
                int x = 0;
                while (x < cip.getErrors().size()) {
                    text = String.valueOf(text) + cip.getErrors().get(x).getNom() + " " + cip.getErrors().get(x).getPrenom() + "\n";
                    ++x;
                }
                try {
                    if (send != null) {
                        send.sendMessage(to, "Erreur de calcul d'infractions sur la soci\u00e9t\u00e9 " + current.getNomSociete(), text, null, false);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            cip = null;
            System.gc();
        }
    }
}

