/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.controller;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.CardDownload;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DCMissingDriverActivity;
import fr.pgh.data.bdd.DCMissingVuActivity;
import fr.pgh.data.bdd.DataRetriever;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.data.bdd.Vehicule;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.uev.UEVProperty;
import transpo.system.uev.VuProcessingG1;
import transpo.system.uev.VuProcessingG2;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.viewable.ProgressViewManager;
import transpo.system.util.FileManager;

public class DataRetrieverController {
    DataRetriever current = null;
    ProgressViewManager pg = null;
    ArrayList<Conducteur> drivers = null;

    public DataRetrieverController(ProgressViewManager pg) {
        this.pg = pg;
    }

    public DataRetriever getCurrent() {
        return this.current;
    }

    public int analyze(Date begin, Date end, ArrayList<Agence> agencies) {
        this.pg.setVisible(true);
        this.current = new DataRetriever(0, "", begin, end, agencies);
        this.pg.setText(LanguageTranslator.getString("Analyse des activit\u00e9s"));
        this.driverProcess();
        this.vehicleProcess();
        this.pg.setVisible(false);
        return 1;
    }

    public void driverProcess() {
        this.drivers = new ArrayList();
        Integer[] agenciesId = new Integer[this.current.getAgencies().size()];
        HashMap<Conducteur, Date> lastDl = new HashMap<Conducteur, Date>();
        int x = 0;
        for (Agence a : this.current.getAgencies()) {
            agenciesId[x++] = a.getCleAgence();
        }
        String driverFilter = "";
        for (Conducteur c : Conducteur.loadList(agenciesId)) {
            if (ConversionTime.stringToDateDb(c.getDateEntree()).compareTo(this.current.getEnd()) >= 0 && ConversionTime.stringToDateDb(c.getDateSortie()).compareTo(this.current.getBegin()) <= 0) continue;
            this.drivers.add(c);
            driverFilter = String.valueOf(driverFilter) + "," + c.getCleConducteur();
            lastDl.put(c, null);
        }
        TimsLogger.debug("#DRC.controlDrivers# " + this.drivers.size() + " conducteurs");
        Vector<CardDownload> dl = CardDownload.loadList("c.CLE_CHAUFFEUR IN (" + driverFilter.substring(1) + ")" + " AND DATE_TELECHARGEMENT BETWEEN \"" + ConversionTime.dateToStringDb(this.current.getBegin()) + "\"" + " AND \"" + ConversionTime.dateToStringDb(ConversionTime.addDay(this.current.getEnd(), 28)) + "\"");
        TimsLogger.debug("#DRC.controlDrivers# " + dl.size() + " t\u00e9l\u00e9chargements");
        int driverId = 0;
        boolean maxReached = true;
        int y = 0;
        while (y < dl.size()) {
            CardDownload toCheck = dl.get(y);
            if (driverId == toCheck.getDriver().getCleConducteur()) {
                if (!maxReached) {
                    dl.remove(y - 1);
                    --y;
                    lastDl.put(toCheck.getDriver(), ConversionTime.stringToDateDb(toCheck.getTelechargement(), true));
                    if (ConversionTime.stringToDateDb(toCheck.getTelechargement()).compareTo(this.current.getEnd()) > 0) {
                        maxReached = true;
                    }
                } else {
                    dl.remove(y);
                    --y;
                }
            }
            if (driverId != toCheck.getDriver().getCleConducteur()) {
                lastDl.put(toCheck.getDriver(), ConversionTime.stringToDateDb(toCheck.getTelechargement(), true));
                driverId = toCheck.getDriver().getCleConducteur();
                maxReached = false;
            }
            ++y;
        }
        ArrayList<DCMissingDriverActivity> missing = new ArrayList<DCMissingDriverActivity>();
        for (Conducteur c : this.drivers) {
            Date last = (Date)lastDl.get(c);
            if (last == null || last.before(this.current.getEnd()) && !ConversionTime.stringToDateDb(c.getDateSortie()).after(last)) {
                Date missBegin = last == null ? this.current.getBegin() : last;
                Date missEnd = this.current.getEnd();
                missing.add(new DCMissingDriverActivity(0, 0, c.getCleConducteur(), missBegin, missEnd));
                TimsLogger.debug("missing " + ConversionTime.dateToStringFr(last == null ? this.current.getBegin() : last) + " to " + c.getDateSortie() + "/" + this.current.getEnd() + " for " + c.getNom());
                continue;
            }
            TimsLogger.debug("ok for " + c.getNom() + " from " + this.current.getBegin() + " to " + ConversionTime.dateToStringFr(last));
        }
        this.current.setCardFiles(new ArrayList<CardDownload>(dl));
        this.current.setDriverMissingActivities(missing);
        Vector<Offence> list = Offence.loadList("DRIVER_ID IN (" + driverFilter.substring(1) + ")" + " AND DAY BETWEEN \"" + ConversionTime.dateToStringDb(this.current.getBegin()) + "\"" + " AND \"" + ConversionTime.dateToStringDb(this.current.getEnd()) + "\"");
        this.current.setDriverOffences(new ArrayList<Offence>(list));
    }

    public void vehicleProcess() {
        ArrayList<Vehicule> finalVehicles = new ArrayList<Vehicule>();
        Integer[] agenciesId = new Integer[this.current.getAgencies().size()];
        HashMap lastDl = new HashMap();
        int x = 0;
        for (Agence a : this.current.getAgencies()) {
            agenciesId[x++] = a.getCleAgence();
        }
        String vehicleFilter = "";
        for (Vehicule v : Vehicule.loadList(agenciesId)) {
            if (ConversionTime.stringToDateDb(v.getDateEntree()).compareTo(this.current.getEnd()) >= 0 && ConversionTime.stringToDateDb(v.getDateSortie()).compareTo(this.current.getBegin()) <= 0) continue;
            finalVehicles.add(v);
            vehicleFilter = String.valueOf(vehicleFilter) + "," + v.getCleVehicule();
        }
        TimsLogger.debug("#DRC.controlVehicles# " + finalVehicles.size() + " vehicles");
        Vector<UevDownload> dl = UevDownload.loadList("v.CLE_VEHICULE IN (" + vehicleFilter.substring(1) + ")" + " AND BEGIN_ACTIVITY < \"" + ConversionTime.dateToStringDb(this.current.getEnd()) + "\"" + " AND END_ACTIVITY > \"" + ConversionTime.dateToStringDb(this.current.getBegin()) + "\"");
        TimsLogger.debug("#DRC.controlVehicles# " + dl.size() + " t\u00e9l\u00e9chargements");
        int vehicleId = 0;
        boolean complete = true;
        ArrayList<Date> toFind = this.getAllDate();
        ArrayList<DCMissingVuActivity> missing = new ArrayList<DCMissingVuActivity>();
        int y = 0;
        while (y < dl.size()) {
            try {
                Object uevdp;
                UevDownload uevFile = dl.get(y);
                uevFile.getFichier();
                TimsLogger.debug("check " + uevFile.getFichier());
                if (vehicleId != uevFile.getVehicle().getCleVehicule()) {
                    if (toFind.size() != 0) {
                        missing.add(new DCMissingVuActivity(0, 0, vehicleId, "", toFind.get(0), toFind.get(toFind.size() - 1)));
                    }
                    vehicleId = uevFile.getVehicle().getCleVehicule();
                    finalVehicles.remove(uevFile.getVehicle());
                    toFind = this.getAllDate();
                }
                File file = FileManager.getFile(uevFile.getVehicle(), uevFile.getFichier());
                HashMap<Date, Integer> days = null;
                if (UEVProperty.getVuGeneration(file.getAbsolutePath()) == 2) {
                    uevdp = new VuProcessingG2(file);
                    days = ((VuProcessingG2)uevdp).getActiveDay();
                } else {
                    uevdp = new VuProcessingG1(file);
                    days = ((VuProcessingG1)uevdp).getActiveDay();
                }
                TimsLogger.debug("contains " + days);
                int count = 0;
                int z = 0;
                while (z < toFind.size()) {
                    TimsLogger.debug("check " + toFind.get(z) + " for " + vehicleId);
                    if (days.containsKey(toFind.get(z))) {
                        toFind.remove(z);
                        --z;
                        ++count;
                    }
                    ++z;
                }
                if (count == 0) {
                    TimsLogger.debug("file " + uevFile.getFichier() + " doesn't contain days");
                    dl.remove(y);
                    --y;
                } else {
                    TimsLogger.debug("file " + uevFile.getFichier() + " contain " + count + " days");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++y;
        }
        for (Vehicule v : finalVehicles) {
            missing.add(new DCMissingVuActivity(0, 0, v.getCleVehicule(), "", this.current.getBegin(), this.current.getEnd()));
        }
        this.current.setVuMissingActivities(missing);
        this.current.setVuFiles(new ArrayList<UevDownload>(dl));
        ArrayList<UevOffence> list = UevOffence.loadList("VEHICLE_ID IN (" + vehicleFilter.substring(1) + ")" + " AND BEGIN BETWEEN \"" + ConversionTime.dateToStringDb(this.current.getBegin()) + "\"" + " AND \"" + ConversionTime.dateToStringDb(this.current.getEnd()) + "\"");
        this.current.setVehicleOffences(list);
    }

    public ArrayList<Conducteur> getDrivers() {
        return this.drivers;
    }

    private ArrayList<Date> getAllDate() {
        ArrayList<Date> list = new ArrayList<Date>();
        Date date = new Date(this.current.getBegin().getTime());
        while (date.compareTo(this.current.getEnd()) <= 0) {
            list.add(date);
            date = ConversionTime.addDay(date, 1);
        }
        TimsLogger.debug("DRC.getAllDate # returns " + list.size() + " days");
        return list;
    }
}

