/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.core.hardness;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Hardness;
import fr.pgh.data.bdd.HardnessAttribution;
import java.util.Date;
import java.util.Vector;
import javax.swing.SwingUtilities;
import transpo.system.TimsLogger;
import transpo.system.core.hardness.exposure.ExposureCalculator;
import transpo.system.ui.views.ProgressBar;

public class GlobalHardnessCalculator {
    private Vector<Conducteur> drivers = null;
    private Date year = null;
    private Vector<HardnessAttribution> toAdd = new Vector();
    private ProgressBar pg = null;

    public GlobalHardnessCalculator(ProgressBar pg, Vector<Conducteur> drivers, Date year) {
        this.pg = pg;
        this.drivers = drivers;
        this.year = year;
    }

    public GlobalHardnessCalculator(ProgressBar pg, Conducteur driver, Date year) {
        this.pg = pg;
        this.drivers = new Vector();
        this.drivers.add(driver);
        this.year = year;
    }

    public void launch() {
        final Vector<Hardness> hardnesses = Hardness.loadList();
        if (this.pg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GlobalHardnessCalculator.this.pg.setVisible(true);
                    GlobalHardnessCalculator.this.pg.setMaximum(hardnesses.size() + 1);
                }
            });
        }
        TimsLogger.info("GlobalHardnessCalculator.launch # Start calculation on " + ConversionTime.dateToString(this.year, "yyyy"));
        for (final Hardness hardness : hardnesses) {
            if (this.pg != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GlobalHardnessCalculator.this.pg.getBar().setValue(GlobalHardnessCalculator.this.pg.getBar().getValue() + 1);
                        GlobalHardnessCalculator.this.pg.getBar().setString(hardness.getName());
                    }
                });
            }
            try {
                if (hardness.getCalculatorClass() != null && !hardness.getCalculatorClass().equals("")) {
                    TimsLogger.info("GlobalHardnessCalculator.launch # Processing calculation for " + hardness.getCalculatorClass());
                    Class<?> c = Class.forName(hardness.getCalculatorClass());
                    ExposureCalculator ec = (ExposureCalculator)c.newInstance();
                    ec.setSupervisor(this);
                    ec.setDrivers(this.drivers);
                    ec.setYear(this.year);
                    ec.setHardness(hardness);
                    ec.initialize();
                    ec.disable();
                    ec.calculate();
                    continue;
                }
                TimsLogger.info("GlobalHardnessCalculator.launch # No calculation class for " + hardness.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.save();
        if (this.pg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GlobalHardnessCalculator.this.pg.dispose();
                }
            });
        }
    }

    public void addHardnessAttribution(HardnessAttribution hToAdd) {
        this.toAdd.add(hToAdd);
    }

    public boolean disable(int hardnessIdToDisable) {
        return HardnessAttribution.disable(0, hardnessIdToDisable, ConversionTime.dateToString(this.year, "yyyy"));
    }

    public boolean save() {
        TimsLogger.debug("GlobalHardnessCalculator.save # Saving " + this.toAdd.size() + " HardnessAttribution");
        BddTransport.getInstance().startTransaction();
        for (HardnessAttribution ha : this.toAdd) {
            if (ha.insert()) continue;
            BddTransport.getInstance().rollback();
            return false;
        }
        BddTransport.getInstance().commit();
        return true;
    }
}

