/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.core.hardness.exposure;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Hardness;
import fr.pgh.data.bdd.HardnessAttribution;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.core.hardness.GlobalHardnessCalculator;

public abstract class ExposureCalculator {
    protected GlobalHardnessCalculator supervisor = null;
    protected Date year = null;
    protected Vector<Conducteur> drivers = null;
    protected Hardness hardness = null;

    public void setDrivers(Vector<Conducteur> drivers) {
        this.drivers = drivers;
    }

    public void setYear(Date year) {
        this.year = year;
    }

    public void setHardness(Hardness hardness) {
        this.hardness = hardness;
    }

    public boolean calculate() {
        TimsLogger.warn("#ExposureCalculator.calculate# No function defined");
        return false;
    }

    public boolean initialize() {
        TimsLogger.warn("#ExposureCalculator.load# No function defined");
        return false;
    }

    public boolean disable() {
        TimsLogger.warn("#ExposureCalculator.disable# No function defined");
        return false;
    }

    protected String getBegin() {
        if (this.year == null) {
            return null;
        }
        return String.valueOf(ConversionTime.dateToString(this.year, "yyyy")) + "-01-01";
    }

    protected String getEnd() {
        if (this.year == null) {
            return null;
        }
        return String.valueOf(ConversionTime.dateToString(this.year, "yyyy")) + "-12-31";
    }

    protected void addHardnessAttribution(int hardnessId, int driverId, int counter) {
        this.supervisor.addHardnessAttribution(new HardnessAttribution(0, hardnessId, driverId, this.year, true, 0, new Date(), true, counter));
    }

    public void setSupervisor(GlobalHardnessCalculator supervisor) {
        this.supervisor = supervisor;
    }
}

