/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.core.hardness.exposure;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Hardness;
import fr.pgh.data.bdd.HardnessAttribution;
import fr.pgh.data.bdd.Service;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.core.hardness.exposure.ExposureCalculator;

public class NightHardness
extends ExposureCalculator {
    private static final int NIGHT_COUNT = 120;
    Vector<Service> serviceList = null;

    @Override
    public boolean disable() {
        int id = this.hardness.getId();
        return this.supervisor.disable(id);
    }

    @Override
    public boolean initialize() {
        this.serviceList = Service.getService(0, (Vector<Conducteur>)this.drivers, this.getBegin(), this.getEnd());
        if (this.hardness == null) {
            this.hardness = Hardness.find(null, "nuit");
        }
        return true;
    }

    @Override
    public boolean calculate() {
        int currentDriver = 0;
        int totalNight = 0;
        for (Service serv : this.serviceList) {
            if (currentDriver == 0) {
                currentDriver = serv.getDriverId();
            }
            if (currentDriver != serv.getDriverId()) {
                TimsLogger.debug("NightHardness.calculate # add hardness attribution for " + currentDriver + " on " + this.getBegin() + " " + this.year + " => " + totalNight);
                HardnessAttribution ha = new HardnessAttribution(0, this.hardness.getId(), currentDriver, ConversionTime.stringToDate(this.getBegin(), "yyyy-MM-dd"), totalNight >= 120, ConnexionSettings.getInstance().getUserCle(), new Date(), true, totalNight);
                this.supervisor.addHardnessAttribution(ha);
                totalNight = 0;
                currentDriver = serv.getDriverId();
            }
            if (serv.getNightHardness() < 60) continue;
            ++totalNight;
        }
        TimsLogger.debug("NightHardness.calculate # last driver add hardness attribution for " + currentDriver + " on " + this.getBegin() + " " + this.year + " => " + totalNight);
        HardnessAttribution ha = new HardnessAttribution(0, this.hardness.getId(), currentDriver, ConversionTime.stringToDate(this.getBegin(), "yyyy-MM-dd"), totalNight >= 120, ConnexionSettings.getInstance().getUserCle(), new Date(), true, totalNight);
        this.supervisor.addHardnessAttribution(ha);
        return true;
    }
}

