/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.exp;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.CardDownload;
import fr.pgh.data.bdd.Comment;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Conflit;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.Offense;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.VehicleUsed;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Fonctions;

public class DriverExport {
    private Vector driverstoExport;
    private Date debutExport;
    private Date finExport;
    boolean delete = false;
    boolean archive = false;
    private BddTransport database = null;

    public DriverExport(BddTransport database) {
        this.database = database;
    }

    public void setParameters(Vector driverstoExport, Date debutExport, Date finExport, boolean delete, boolean archive) {
        this.driverstoExport = driverstoExport;
        this.debutExport = debutExport;
        this.finExport = finExport;
        this.delete = delete;
        this.archive = archive;
    }

    public boolean run() {
        int x = 0;
        while (x < this.driverstoExport.size()) {
            try {
                ((Conducteur)this.driverstoExport.get(x)).loadById(((Conducteur)this.driverstoExport.get(x)).getCleConducteur());
                TimsLogger.debug("pour " + ((Conducteur)this.driverstoExport.get(x)).getCleConducteur() + ", " + ((Conducteur)this.driverstoExport.get(x)).getNom() + " " + ((Conducteur)this.driverstoExport.get(x)).getPrenom());
                FileOutputStream baos = new FileOutputStream(String.valueOf(((Conducteur)this.driverstoExport.get(x)).getNom()) + "  " + ((Conducteur)this.driverstoExport.get(x)).getPrenom() + "  2.8.0.taf");
                this.writeDriver(x, baos);
                this.writeDay(x, baos);
                this.writeUpdatedDay(x, baos);
                this.writeService(x, baos);
                this.writeAnalyzedConflict(x, baos);
                this.writeBaseConflict(x, baos);
                this.writeConflit(x, baos);
                this.writeCardDownload(x, baos);
                this.writeVehicles(x, baos);
                this.writeComment(x, baos);
                this.writeExpenses(x, baos);
                this.writeOffense(x, baos);
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++x;
        }
        return true;
    }

    private void writeDriver(int x, FileOutputStream baos) throws Exception {
        byte[] b = ((Conducteur)this.driverstoExport.get(x)).write(baos);
    }

    private void writeAnalyzedConflict(int x, FileOutputStream baos) throws Exception {
        Vector<ActiviteConducteur> list = BddTransport.getInstance().getActivDetailConflit(((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), this.debutExport, "t_activite_conflit_analyse", false);
        for (ActiviteConducteur tmp : list) {
            byte[] byArray = tmp.write(baos, 115);
        }
    }

    private void writeBaseConflict(int x, FileOutputStream baos) throws Exception {
        Vector<ActiviteConducteur> list = BddTransport.getInstance().getActivDetailConflit(((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), this.debutExport, "t_activite_conflit_base", false);
        for (ActiviteConducteur tmp : list) {
            byte[] byArray = tmp.write(baos, 114);
        }
    }

    private void writeDay(int x, FileOutputStream baos) throws Exception {
        Vector<Jour> list = BddTransport.getInstance().getJourArchive(((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd"), ConversionTime.dateToString(this.finExport, "yyyy-MM-dd"), true);
        for (Jour tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeUpdatedDay(int x, FileOutputStream baos) throws Exception {
        Vector<Jour> list = BddTransport.getInstance().getJourArchive(((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd"), ConversionTime.dateToString(this.finExport, "yyyy-MM-dd"), false);
        for (Jour tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeService(int x, FileOutputStream baos) throws Exception {
        Vector<Service> list = Service.getService(0, ((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), null, null);
        for (Service tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeCardDownload(int x, FileOutputStream baos) throws Exception {
        Vector<CardDownload> list = CardDownload.getTelechargement(0, ((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd"), ConversionTime.dateToString(this.finExport, "yyyy-MM-dd"));
        for (CardDownload tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeVehicles(int x, FileOutputStream baos) throws Exception {
        Vector<VehicleUsed> list = VehicleUsed.loadListDriver(((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), 0, ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd"), ConversionTime.dateToString(this.finExport, "yyyy-MM-dd"));
        for (VehicleUsed tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeComment(int x, FileOutputStream baos) throws Exception {
        Vector<Comment> list = BddTransport.getInstance().getComment(((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), null);
        for (Comment tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeConflit(int x, FileOutputStream baos) throws Exception {
        Vector<Conflit> list = BddTransport.getInstance().getConflitList(((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), null, -1, false);
        for (Conflit tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeExpenses(int x, FileOutputStream baos) throws Exception {
        Vector<DriverExpenses> list = DriverExpenses.loadList(0, ((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), null, null);
        for (DriverExpenses tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeOffense(int x, FileOutputStream baos) throws Exception {
        Vector<Offense> list = BddTransport.getInstance().getInfractionConducteur(((Conducteur)this.driverstoExport.get(x)).getCleConducteur(), null, false);
        for (Offense tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private boolean createDirectory(String directoryName) {
        File tmp = new File(directoryName.replace("?", "_"));
        return tmp.mkdir();
    }

    private void deleteAll(Conducteur toSave) {
        toSave.delete();
    }

    private void saveArchive(String dir, Conducteur toSave, boolean delete) {
        String debut = ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd");
        String fin = ConversionTime.dateToString(this.finExport, "yyyy-MM-dd");
        Vector<CardDownload> tmp = CardDownload.getTelechargement(toSave.getCleAgence(), toSave.getCleConducteur(), debut, fin);
        TimsLogger.debug(String.valueOf(tmp.size()) + " fichiers");
        if (tmp.size() > 0) {
            new File(String.valueOf(dir) + "\\Fichiers C1B").mkdir();
        }
        int x = 0;
        while (x < tmp.size()) {
            String stringFichier = tmp.get(x).getFichier();
            String stringDestination = String.valueOf(dir) + "\\Fichiers C1B\\" + stringFichier;
            Fonctions.copyLocalFile(new File(stringFichier), new File(stringDestination), delete);
            ++x;
        }
    }

    public static File getFile(String title, String btnMsg, boolean repOnly, String defaultRep) {
        try {
            Preferences prefs = Preferences.userRoot().node("TIMS");
            String def = "";
            if (defaultRep != null && defaultRep != "") {
                def = prefs.node("DIRECTORY").get(defaultRep, System.getProperty("user.home"));
            }
            JFileChooser choix = new JFileChooser(def);
            if (repOnly) {
                choix.setFileSelectionMode(1);
            }
            choix.setMultiSelectionEnabled(false);
            choix.setDialogTitle(title);
            choix.setApproveButtonText(btnMsg);
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                if (defaultRep != null && defaultRep != "") {
                    prefs.node("DIRECTORY").put(defaultRep, choix.getCurrentDirectory().getAbsolutePath());
                }
                return choix.getSelectedFile();
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("transpo.system.util.Fonctions.getFile(  )  : " + ex);
            return null;
        }
        return null;
    }
}

