/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.exp;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.ClosePayPeriod;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.PayPeriod;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;

public abstract class PayPeriodCloser
extends Thread {
    public static final int PROCESS_DONE = 1;
    public static final int PROCESS_FAILURE = 16;
    public static final int TRANSFER_FAILURE = 32;
    ProgressBar pg = null;
    public int status = 256;
    public String result = null;
    protected Vector<Agence> notYetClosed = new Vector();
    protected HashMap<Conducteur, ArrayList<Date>> globalErrors = new HashMap();
    Vector<Agence> agencies = null;
    PayPeriod toClose = null;

    @Override
    public void run() {
        TimsLogger.warn("You should overrid this method ?");
    }

    public int getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public void setPeriod(PayPeriod toClose) {
        this.toClose = toClose;
    }

    public void setAgencies(Vector<Agence> agencies) {
        this.agencies = agencies;
    }

    public void init() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.pg = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("generics.initialization"));
            this.pg.setVisible(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PayPeriodCloser.this.pg = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("generics.initialization"));
                        PayPeriodCloser.this.pg.setVisible(true);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Agence agency : this.agencies) {
            TimsLogger.debug("#PayPeriodCloser.run# Checking " + agency.getDescription() + " from " + this.toClose.getBegin() + " to " + this.toClose.getEnd());
            boolean closed = ClosePayPeriod.isClosed(agency.getCleAgence(), this.toClose.getBegin());
            if (closed) {
                TimsLogger.debug("#PayPeriodCloser.run# La p\u00e9riode est d\u00e9j\u00e0 close pour " + agency.getDescription() + ", est-ce qu'on exporte les donn\u00e9es ??");
                continue;
            }
            this.notYetClosed.add(agency);
        }
    }
}

