/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.exp;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.UevActivity;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UevEventsFaults;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Fonctions;

public class VehicleExport {
    private Vector<Vehicule> vehiclestoExport;
    private Date debutExport;
    private Date finExport;
    boolean delete = false;
    boolean archive = false;
    private String savingPath = null;
    private BddTransport database = null;

    public VehicleExport(BddTransport database) {
        this.database = database;
    }

    public void setParameters(Vector<Vehicule> vehiclestoExport, Date debutExport, Date finExport, boolean delete, boolean archive) {
        this.vehiclestoExport = vehiclestoExport;
        this.debutExport = debutExport;
        this.finExport = finExport;
        this.delete = delete;
        this.archive = archive;
    }

    public boolean run() {
        int x = 0;
        while (x < this.vehiclestoExport.size()) {
            try {
                this.vehiclestoExport.get(x).loadById(this.vehiclestoExport.get(x).getCleVehicule());
                FileOutputStream baos = new FileOutputStream(String.valueOf(this.vehiclestoExport.get(x).getRegistrationNumber()) + "  " + this.vehiclestoExport.get(x).getDesignation() + "  2.8.0.taf");
                this.writeVehicle(x, baos);
                this.writeActivity(x, baos);
                this.writeEventsFaults(x, baos);
                this.writeSpeed(x, baos);
                this.writeIo(x, baos);
                this.writeUevDownload(x, baos);
                baos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++x;
        }
        return true;
    }

    private void writeVehicle(int x, FileOutputStream baos) throws Exception {
        byte[] b = this.vehiclestoExport.get(x).write(baos);
    }

    private void writeActivity(int x, FileOutputStream baos) throws Exception {
        Vector<UevActivity> list = UevActivity.load(this.vehiclestoExport.get(x).getCleVehicule(), ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd"), ConversionTime.dateToString(this.finExport, "yyyy-MM-dd"));
        for (UevActivity tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeEventsFaults(int x, FileOutputStream baos) throws Exception {
        ArrayList<UevEventsFaults> list = UevEventsFaults.load(this.vehiclestoExport.get(x).getCleVehicule(), ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd"), ConversionTime.dateToString(this.finExport, "yyyy-MM-dd"));
        for (UevEventsFaults uevEventsFaults : list) {
        }
    }

    private void writeSpeed(int x, FileOutputStream baos) throws Exception {
    }

    private void writeIo(int x, FileOutputStream baos) throws Exception {
        Vector<VehicleUsed> list = VehicleUsed.loadListVehicle(0, this.vehiclestoExport.get(x).getCleVehicule(), this.debutExport, this.finExport);
        for (VehicleUsed tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private void writeUevDownload(int x, FileOutputStream baos) throws Exception {
        Vector<UevDownload> list = UevDownload.getTelechargementUEV(0, this.vehiclestoExport.get(x).getCleVehicule(), ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd"), ConversionTime.dateToString(this.finExport, "yyyy-MM-dd"));
        for (UevDownload tmp : list) {
            byte[] byArray = tmp.write(baos);
        }
    }

    private boolean createDirectory(String directoryName) {
        File tmp = new File(directoryName.replace("?", "_"));
        return tmp.mkdir();
    }

    private void deleteAll(Vehicule toSave) {
        if (this.debutExport == null) {
            this.database.delUEVInformation(toSave);
        }
        this.database.delUEVActivity(toSave, this.debutExport, this.finExport);
        this.database.delUEVUsed(toSave, this.debutExport, this.finExport);
        this.database.delUEVEvents(toSave, this.debutExport, this.finExport);
        this.database.delUEVFaults(toSave, this.debutExport, this.finExport);
        this.database.delUEVTechnic(toSave, this.debutExport, this.finExport);
        this.database.delUEVSpeed(toSave, this.debutExport, this.finExport);
    }

    private void saveArchive(String dir, Vehicule toSave, boolean delete) {
        String debut = ConversionTime.dateToString(this.debutExport, "yyyy-MM-dd");
        String fin = ConversionTime.dateToString(this.finExport, "yyyy-MM-dd");
        Vector<UevDownload> tmp = UevDownload.getTelechargementUEV(toSave.getAgencyId(), toSave.getCleVehicule(), debut, fin);
        TimsLogger.debug(String.valueOf(tmp.size()) + " fichiers");
        if (tmp.size() > 0) {
            new File(String.valueOf(dir) + "\\Fichiers V1B").mkdir();
        }
        int x = 0;
        while (x < tmp.size()) {
            String stringFichier = tmp.get(x).getFichier();
            String stringDestination = String.valueOf(dir) + "\\Fichiers V1B\\" + stringFichier;
            Fonctions.copyLocalFile(new File(stringFichier), new File(stringDestination), delete);
            ++x;
        }
    }

    public static File getFile(String title, String btnMsg, boolean repOnly, String defaultRep) {
        try {
            Preferences prefs = Preferences.userRoot().node("TIMS");
            String def = "";
            if (defaultRep != null && defaultRep != "") {
                def = prefs.node("DIRECTORY").get(defaultRep, System.getProperty("user.home"));
            }
            JFileChooser choix = new JFileChooser(def);
            if (repOnly) {
                choix.setFileSelectionMode(1);
            }
            choix.setMultiSelectionEnabled(false);
            choix.setDialogTitle(title);
            choix.setApproveButtonText(btnMsg);
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                if (defaultRep != null && defaultRep != "") {
                    prefs.node("DIRECTORY").put(defaultRep, choix.getCurrentDirectory().getAbsolutePath());
                }
                return choix.getSelectedFile();
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("transpo.system.util.Fonctions.getFile(  )  : " + ex);
            return null;
        }
        return null;
    }
}

