/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jdbox;

import java.awt.GridLayout;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.jdbox.JDBoxNatif;
import transpo.system.jsmartcard.DriverCardSaving;
import transpo.system.uev.VuProcessingG1;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transpo.system.util.reader.FileReadManager;

public class JDBox {
    public static int CODE_OK_LECTURE = 0;
    public static int CODE_ERREUR_LECTURE = 1;
    public static int CODE_LIBRAIRIE_ERREUR = 2;
    public static int CODE_OK_DECOD = 0;
    public static int CODE_ERREUR_DECOD = 1;
    public static int CODE_ERREUR_ECRITURE = 2;
    public static int CODE_ERREUR_LECTURE_DECODAGE = 4;
    public static int CODE_ERREUR_VIDE = 3;
    public static String EXT_C1B = ".C1B";
    public static String EXT_V1B = ".V1B";
    private Vector<Integer> fileBeginOffset = null;
    private Vector<File> nomFichierCarte = new Vector();
    private Vector<File> nomFichierVehicule = new Vector();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmm");

    public void dechargerDBox() {
        if (JDBoxNatif.init()) {
            try {
                TimsLogger.info("#JDBox.dechargerDBox# Version de la dll JDboxNatif :" + JDBoxNatif.GetDllVersion());
            }
            catch (UnsatisfiedLinkError ex) {
                TimsLogger.warn("#JDBox.dechargerDBox# Impossible de d\u00e9terminer la version de la dll JDboxNatif (fonction non pr\u00e9sente dans la dll)");
            }
            String chemin = Transport.savePath;
            int retourLecture = JDBoxNatif.DechargementDBox(chemin);
            if (retourLecture == CODE_OK_LECTURE) {
                TimsLogger.warn("#JDBox.DechargerDbox# retourLecture : " + retourLecture);
                this.decodeFichier(String.valueOf(chemin) + "dbox.tmp");
            } else {
                final String[] param = new String[]{String.valueOf(String.valueOf(3)) + retourLecture};
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("dbox.unloading.error"), LanguageTranslator.getString("message.numberedError", param), 0);
                    }
                });
                File log = new File(String.valueOf(Transport.savePath) + "log.txt");
                if (log.exists()) {
                    try {
                        String ligne;
                        InputStreamReader in = new InputStreamReader(new FileInputStream(log));
                        BufferedReader br = new BufferedReader(in);
                        while ((ligne = br.readLine()) != null) {
                            TimsLogger.info(ligne);
                        }
                        br.close();
                    }
                    catch (Exception e) {
                        TimsLogger.warn(e.toString());
                    }
                }
            }
        }
    }

    public void decodeFichier(String cheminFichier) {
        int retourDecode = 0;
        retourDecode = this.decodeTmp(cheminFichier);
        if (retourDecode == CODE_OK_DECOD) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), JDBox.this.getReport(), LanguageTranslator.getString("dbox.unloading.succeed"), 1);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.lireFichier(this.nomFichierCarte, this.nomFichierVehicule);
            this.deleteTmp();
        } else if (retourDecode == CODE_ERREUR_DECOD) {
            final String[] param = new String[]{String.valueOf(String.valueOf(3)) + CODE_ERREUR_DECOD};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("dbox.unloading.readError"), LanguageTranslator.getString("message.numberedError", param), 0);
                }
            });
        } else if (retourDecode == CODE_ERREUR_ECRITURE) {
            final String[] param = new String[]{String.valueOf(String.valueOf(3)) + CODE_ERREUR_ECRITURE};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("dbox.unloading.writeError"), LanguageTranslator.getString("message.numberedError", param), 0);
                }
            });
        } else if (retourDecode == CODE_ERREUR_LECTURE_DECODAGE) {
            final String[] param = new String[]{String.valueOf(String.valueOf(3)) + CODE_ERREUR_LECTURE_DECODAGE};
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), "Certains fichiers ont une structure incorrect et ont provoqu\u00e9 une erreur.\nMerci d'enregistrer le fichier et de le faire parvenir \u00e0 PGH pour une analyse de celui ci.", LanguageTranslator.getString("message.numberedError", param), 0);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.saveFichier(cheminFichier);
        } else if (retourDecode == CODE_ERREUR_VIDE) {
            final String[] param = new String[]{String.valueOf(String.valueOf(3)) + CODE_ERREUR_VIDE};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("dbox.unloading.empty"), LanguageTranslator.getString("message.numberedError", param), 2);
                }
            });
            this.deleteTmp();
        }
    }

    public void lireFichier(Vector<File> cardToRead, Vector<File> uevToRead) {
        int[] response;
        int reponse;
        String[] param;
        GetFile tmpFile = new GetFile("O\u00f9 souhaitez vous sauvegarder les fichiers ?", LanguageTranslator.getString("button.save"), true, false, null);
        String message = "";
        if (uevToRead.size() != 0) {
            param = new String[]{String.valueOf(uevToRead.size())};
            message = LanguageTranslator.getString("dbox.unloading.vehicles", param);
            reponse = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), message, LanguageTranslator.getString("generics.reading"), 0);
            if (reponse == 0) {
                FileReadManager.getInstance().queueFiles(uevToRead);
                while (FileReadManager.getInstance().isReading()) {
                    Fonctions.pause(1);
                }
            } else {
                do {
                    tmpFile.run();
                    if (tmpFile.getSelectedPath() != null) continue;
                    response = new int[1];
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            response[0] = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("dbox.renunciationConfirm"), LanguageTranslator.getString("generics.warning"), 0);
                        }
                    });
                    if (response[0] == 0) break;
                } while (tmpFile.getSelectedPath() == null);
                if (tmpFile.getSelectedPath() != null) {
                    int x = 0;
                    while (x < uevToRead.size()) {
                        uevToRead.get(x).renameTo(new File(String.valueOf(tmpFile.getSelectedPath().getAbsolutePath()) + "\\" + cardToRead.get(x).getName()));
                        ++x;
                    }
                }
            }
        }
        if (cardToRead.size() != 0) {
            param = new String[]{String.valueOf(cardToRead.size())};
            message = LanguageTranslator.getString("dbox.unloading.drivers", param);
            reponse = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), message, LanguageTranslator.getString("generics.reading"), 0);
            if (reponse == 0) {
                FileReadManager.getInstance().queueFiles(cardToRead);
            } else {
                do {
                    tmpFile.run();
                    if (tmpFile.getSelectedPath() != null) continue;
                    response = new int[1];
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            response[0] = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("dbox.renunciationConfirm"), LanguageTranslator.getString("generics.warning"), 0);
                        }
                    });
                    if (response[0] == 0) break;
                } while (tmpFile.getSelectedPath() == null);
                if (tmpFile.getSelectedPath() != null) {
                    int x = 0;
                    while (x < cardToRead.size()) {
                        cardToRead.get(x).renameTo(new File(String.valueOf(tmpFile.getSelectedPath().getAbsolutePath()) + "\\" + cardToRead.get(x).getName()));
                        ++x;
                    }
                }
            }
        }
    }

    public void deleteTmp() {
        File fichierDBox = new File(String.valueOf(Transport.savePath) + "dbox.tmp");
        fichierDBox.delete();
        File fichierLog = new File(String.valueOf(Transport.savePath) + "log.txt");
        fichierLog.delete();
    }

    public boolean checkStructure(String file) {
        FileInputStream channel;
        BufferedInputStream fs;
        int offset;
        int lengthF0;
        int octetF0;
        byte[] buf;
        block8: {
            this.fileBeginOffset = new Vector();
            int sizeOfFile = 0;
            buf = null;
            octetF0 = 0;
            lengthF0 = 0;
            offset = 0;
            fs = null;
            try {
                channel = new FileInputStream(file);
                sizeOfFile = (int)channel.getChannel().size();
                buf = new byte[sizeOfFile];
                if (sizeOfFile != 0) break block8;
                return true;
            }
            catch (Exception ex) {
                System.err.println("#JDBox.checkStructure# Erreur de lecture du fichier tmp");
                return false;
            }
        }
        fs = new BufferedInputStream(channel);
        InputStreamReader in = new InputStreamReader(fs);
        fs.read(buf);
        in.close();
        lengthF0 = JDBox.unsignedByteToInt(buf[++offset]);
        if (lengthF0 > 127) {
            octetF0 = JDBox.unsignedByteToInt4Bits(buf[offset]);
            lengthF0 = JDBox.arrayByteToInt(buf, ++offset, octetF0);
            offset += octetF0;
        }
        TimsLogger.debug("#JDBox.checkStructure# Longueur F0 = " + lengthF0 + " on va jusqu'a " + (lengthF0 + octetF0 + 2));
        int z = 0;
        while (offset < lengthF0 + octetF0 + 2) {
            int offsetDebut = offset++;
            int octetF1 = 0;
            int lengthF1 = 0;
            ++z;
            if (String.format("%x", buf[offsetDebut]).equals("F1")) {
                TimsLogger.debug(String.valueOf(buf[offsetDebut]) + " != F1");
                return false;
            }
            lengthF1 = JDBox.unsignedByteToInt(buf[offset]);
            if (lengthF1 > 127) {
                octetF1 = JDBox.unsignedByteToInt4Bits(buf[offset]);
                lengthF1 = JDBox.arrayByteToInt(buf, ++offset, octetF1);
                offset += octetF1;
                TimsLogger.debug("#JDBox.checkStructure# *lengthF1 " + lengthF1);
            } else {
                TimsLogger.debug("#JDBox.checkStructure# **lengthF1 " + lengthF1);
                ++offset;
            }
            int limiteF1 = offset + lengthF1;
            this.fileBeginOffset.add(offsetDebut);
            TimsLogger.debug("#JDBox.checkStructure# Offset debut : " + offsetDebut + " on commence a " + offset + " => Longueur F1 = " + lengthF1 + ", fin = " + limiteF1);
            offset = limiteF1;
        }
        return true;
    }

    public int decodeTmp(String file) {
        if (!this.checkStructure(file)) {
            return CODE_ERREUR_LECTURE_DECODAGE;
        }
        Date date = new Date();
        String dateTelechargement = this.formatter.format(date);
        String tmpNameFile = String.valueOf(Transport.savePath) + dateTelechargement;
        int sizeOfFile = 0;
        byte[] buf = null;
        int offset = 0;
        BufferedInputStream fs = null;
        try {
            FileInputStream stream = new FileInputStream(file);
            sizeOfFile = (int)stream.getChannel().size();
            buf = new byte[sizeOfFile];
            if (sizeOfFile <= 200) {
                return CODE_ERREUR_VIDE;
            }
            TimsLogger.debug("#JDBox.DecodeTmp# La taille du fichier est : " + sizeOfFile);
            fs = new BufferedInputStream(stream);
            InputStreamReader in = new InputStreamReader(fs);
            fs.read(buf);
            stream.close();
            in.close();
        }
        catch (Exception ex) {
            System.err.println("#JDBox.DecodeTmp# Erreur de lecture du fichier tmp");
            return CODE_ERREUR_DECOD;
        }
        for (int offsetBegin : this.fileBeginOffset) {
            File finalFile;
            offset = offsetBegin + 1;
            int lengthF1 = JDBox.unsignedByteToInt(buf[offset]);
            if (lengthF1 > 127) {
                int octetF1 = JDBox.unsignedByteToInt4Bits(buf[offset]);
                lengthF1 = JDBox.arrayByteToInt(buf, ++offset, octetF1);
                offset += octetF1;
            } else {
                ++offset;
            }
            int limiteF1 = offset + lengthF1;
            TimsLogger.debug("\t#JDBox.DecodeTmp# Offset : " + offset + " => Longueur F1 = " + lengthF1 + ", fin = " + limiteF1);
            int type = JDBox.arrayByteToInt(buf, offset, 1);
            TimsLogger.debug("#JDBox.DecodeTmp# type = " + type);
            if (type == 167) {
                TimsLogger.debug("#JDBox.DecodeTmp# fichier C1B \u00e0 l'offset " + offsetBegin);
                finalFile = this.getC1BFile(buf, offset, limiteF1, tmpNameFile);
                if (finalFile == null) {
                    TimsLogger.warn("#JDBox.DecodeTmp# erreur de lecture du fichier ");
                    continue;
                }
                if (!this.nomFichierCarte.contains(finalFile)) {
                    TimsLogger.info("Ajout\u00e9 : " + finalFile.getName());
                    this.nomFichierCarte.add(finalFile);
                    continue;
                }
                TimsLogger.debug("Meme fichier deux fois : " + finalFile.getName());
                continue;
            }
            if (type < 167 && type > 160) {
                finalFile = this.getV1BFile(buf, offset, limiteF1, tmpNameFile);
                if (finalFile == null) {
                    TimsLogger.warn("#JDBox.DecodeTmp# erreur de lecture du fichier ");
                    continue;
                }
                if (!this.nomFichierVehicule.contains(finalFile)) {
                    TimsLogger.info("Ajout\u00e9 : " + finalFile.getName());
                    this.nomFichierVehicule.add(finalFile);
                    continue;
                }
                TimsLogger.debug("Meme fichier deux fois : " + finalFile.getName());
                continue;
            }
            TimsLogger.debug("#JDBox.DecodeTmp# fichier " + type + " (offset = " + offset + ") inconnu");
            return CODE_ERREUR_LECTURE_DECODAGE;
        }
        return CODE_OK_DECOD;
    }

    private File getC1BFile(byte[] buf, int offset, int limiteF1, String tmpNameFile) {
        block11: {
            int lengthA;
            int type = JDBox.arrayByteToInt(buf, offset, 1);
            if ((lengthA = JDBox.unsignedByteToInt(buf[++offset])) > 127) {
                int octetA = JDBox.unsignedByteToInt4Bits(buf[offset]);
                lengthA = JDBox.arrayByteToInt(buf, ++offset, octetA);
                offset += octetA;
            } else {
                ++offset;
            }
            try {
                FileOutputStream f = new FileOutputStream(tmpNameFile);
                int limiteA = offset + lengthA;
                TimsLogger.debug("\t\t#JDBox.getC1BFile# Offset : " + offset + ". On a longueur " + type + " = " + lengthA + " limitA =" + limiteA);
                while (offset < limiteA) {
                    f.write(buf[offset]);
                    ++offset;
                }
                f.close();
                if (lengthA <= 200) break block11;
                try {
                    File fichier = new File(tmpNameFile);
                    DriverCardSaving tmp = new DriverCardSaving(fichier);
                    String cardNumber = tmp.getCardNumber();
                    Date dateTel = tmp.getCardDownload();
                    String memberState = tmp.getMemberState();
                    String dateString = this.formatter.format(dateTel);
                    String nameFullFile = String.valueOf(Transport.savePath) + memberState + cardNumber.substring(0, 14) + dateString + ".C1B";
                    File fichierdes = new File(nameFullFile);
                    if (fichierdes.exists()) {
                        TimsLogger.debug("#JDBox.getC1BFile# file exists");
                    } else if (!fichier.renameTo(fichierdes)) {
                        TimsLogger.warn("#JDBox.getC1BFile# Une erreur est survenue lors du renommage : " + fichier.getAbsolutePath() + " to " + fichierdes.getAbsolutePath());
                        fichier.delete();
                    }
                    return fichierdes;
                }
                catch (Exception ex) {
                    System.err.println("Erreur d'\u00e9criture du fichier \u00e0 l'offset " + offset);
                    ex.printStackTrace();
                    return null;
                }
            }
            catch (Exception ex) {
                System.err.println("Erreur de lecture du fichier " + offset);
                ex.printStackTrace();
                return null;
            }
        }
        TimsLogger.warn("\t\t#JDBox.getC1BFile# Fichier corrompu");
        File fichier = new File(tmpNameFile);
        fichier.delete();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getV1BFile(byte[] buf, int offset, int limiteF1, String tmpNameFile) {
        TimsLogger.debug("#JDBox.getV1BFile# fichier V1B de l'offset " + offset + " \u00e0 " + limiteF1);
        int type = JDBox.arrayByteToInt(buf, offset, 1);
        try {
            FileOutputStream f = new FileOutputStream(tmpNameFile);
            block4: while (type < 167 && type > 160) {
                TimsLogger.debug("#JDBox.getV1BFile# offset : " + offset + " type : " + type + " .... ");
                int lengthA = JDBox.unsignedByteToInt(buf[++offset]);
                if (lengthA > 127) {
                    int octetA = JDBox.unsignedByteToInt4Bits(buf[offset]);
                    lengthA = JDBox.arrayByteToInt(buf, ++offset, octetA);
                    offset += octetA;
                } else {
                    ++offset;
                }
                int limiteA = offset + lengthA;
                TimsLogger.debug("longueur = " + lengthA + " .... on lit jusqu'\u00e0 " + limiteA + " .... ");
                while (true) {
                    if (offset >= limiteA) {
                        TimsLogger.debug(" end at " + offset);
                        if (offset >= limiteF1) break block4;
                        type = JDBox.arrayByteToInt(buf, offset, 1);
                        TimsLogger.debug(" next filetype " + type);
                        if (type < 167 && type > 160) continue block4;
                        TimsLogger.warn("#JDBox.getV1BFile# erreur type fichier inconnu");
                        f.close();
                        return null;
                    }
                    f.write(buf[offset]);
                    ++offset;
                }
            }
            f.close();
            TimsLogger.debug("#JDBox.getV1BFile# on sort : " + offset);
            try {
                File fichier = new File(tmpNameFile);
                VuProcessingG1 tmp = new VuProcessingG1(fichier);
                String uev = tmp.extractFileName();
                uev = uev.replace("?", "_");
                String nameFullFile = String.valueOf(Transport.savePath) + uev + ".V1B";
                File fichierdes = new File(nameFullFile);
                if (fichierdes.exists()) {
                    TimsLogger.debug("#JDBox.getV1BFile# file exists");
                    return fichierdes;
                }
                if (fichier.renameTo(fichierdes)) return fichierdes;
                TimsLogger.warn("#JDBox.getV1BFile# Une erreur est survenue lors du renommage : " + fichier.getAbsolutePath() + " to " + fichierdes.getAbsolutePath());
                fichier.delete();
                return fichierdes;
            }
            catch (Exception ex) {
                System.err.println("#JDBox.getV1BFile# Erreur d'\u00e9criture du fichier tmp");
                ex.printStackTrace();
                return null;
            }
        }
        catch (Exception ex) {
            System.err.println("#JDBox.getV1BFile# Erreur d'\u00e9criture du fichier v\u00e9hicule");
            ex.printStackTrace();
            return null;
        }
    }

    public void saveFichier(String cheminFichier) {
        GetFile tmp = new GetFile("O\u00f9 desirez-vous sauvegarder le fichier ?", LanguageTranslator.getString("button.save"), true, false, null);
        tmp.run();
        String cheminSave = tmp.getSelectedPath() + "\\dbox.tmp";
        if (cheminSave == null) {
            return;
        }
        File source = new File(cheminFichier);
        File destination = new File(cheminSave);
        if (!source.renameTo(destination)) {
            String[] param = new String[]{String.valueOf(String.valueOf(3)) + CODE_ERREUR_ECRITURE};
            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), "Erreur d'\u00e9criture des fichiers", "Echec d'acc\u00e8s", 0);
        } else {
            JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), "Enregistrement effectu\u00e9.", "Fichier enregistr\u00e9", 1);
        }
    }

    private Object[] getReport() {
        JPanel pnl1 = new JPanel(new GridLayout(1, 2));
        JPanel pnl2 = new JPanel(new GridLayout(1, 2));
        pnl1.add(new JLabel(LanguageTranslator.getString("generics.driver")));
        pnl1.add(new JLabel(LanguageTranslator.getString("generics.vehicle")));
        pnl2.add(new JScrollPane(new JList(new ComboBoxModel((Vector<?>)this.nomFichierCarte))));
        pnl2.add(new JScrollPane(new JList(new ComboBoxModel((Vector<?>)this.nomFichierVehicule))));
        Object[] message = new Object[]{LanguageTranslator.getString("dbox.unloading.done"), pnl1, pnl2};
        return message;
    }

    public static int arrayByteToInt(byte[] buf, int pos, int nb) {
        int i = 0;
        int x = 1;
        while (x <= nb) {
            i += JDBox.unsignedByteToInt(buf[pos++]) << (nb - x) * 8;
            ++x;
        }
        return i;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static int unsignedByteToInt4Bits(byte b) {
        return b & 0xF;
    }

    class GetFile
    implements Runnable {
        private String title = null;
        private String btnMsg = null;
        private boolean repOnly = false;
        private boolean multi = false;
        private String defaultRep = null;
        private File selectedPath = null;

        public GetFile(String title, String btnMsg, boolean repOnly, boolean multi, String defaultRep) {
            this.title = title;
            this.btnMsg = btnMsg;
            this.repOnly = repOnly;
            this.multi = multi;
            this.defaultRep = defaultRep;
        }

        @Override
        public void run() {
            try {
                Preferences prefs = Preferences.userRoot().node("TIMS");
                String def = "";
                if (this.defaultRep != null && this.defaultRep != "") {
                    def = prefs.node("DIRECTORY").get(this.defaultRep, System.getProperty("user.home"));
                }
                JFileChooser choix = new JFileChooser(def);
                if (this.repOnly) {
                    choix.setFileSelectionMode(1);
                }
                choix.setMultiSelectionEnabled(this.multi);
                choix.setDialogTitle(this.title);
                choix.setApproveButtonText(this.btnMsg);
                if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                    if (this.defaultRep != null && this.defaultRep != "") {
                        prefs.node("DIRECTORY").put(this.defaultRep, choix.getCurrentDirectory().getAbsolutePath());
                    }
                    this.selectedPath = choix.getSelectedFile();
                }
            }
            catch (Exception ex) {
                TimsLogger.error("transpo.system.util.Fonctions.getFile(  )  : " + ex);
            }
        }

        public File getSelectedPath() {
            return this.selectedPath;
        }
    }
}

