/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.jsmartcard.CardCommunicator;
import transpo.system.jsmartcard.JSmartException;
import transpo.system.jsmartcard.JSmartNatif;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class CCIDReader
extends CardCommunicator {
    protected static boolean init = false;
    protected static boolean dllInit = false;
    protected static String readerName;

    @Override
    public boolean connect() {
        block15: {
            String availableReaders;
            block14: {
                if (init) {
                    return true;
                }
                if (!dllInit && !JSmartNatif.init()) {
                    TimsLogger.warn("#CCIDReader.init# JSmartNatif: SmartCard not supported");
                    return false;
                }
                dllInit = true;
                try {
                    TimsLogger.info("#CCIDReader.init# Version de la dll JSmartCard :" + JSmartNatif.GetDllVersion());
                }
                catch (UnsatisfiedLinkError ex) {
                    TimsLogger.info("#CCIDReader.init# Impossible de d\u00e9terminer la version de la dll JSmartCard (fonction non pr\u00e9sente dans la dll)");
                }
                try {
                    availableReaders = JSmartNatif.initSession();
                    if (availableReaders != null && !availableReaders.startsWith("error")) break block14;
                    if (availableReaders != null) {
                        TimsLogger.warn("#CCIDReader.init# error on initSession : " + availableReaders);
                    }
                    return false;
                }
                catch (JSmartException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            String[] readerList = availableReaders.split(";");
            if (readerList.length >= 2) {
                Preferences prefs = Preferences.userRoot().node("TIMS");
                String defaultReader = prefs.get("preference.reader", null);
                if (defaultReader != null && availableReaders.contains(defaultReader)) {
                    TimsLogger.debug("#CCIDReader.init# Select user preferences reader " + defaultReader);
                    readerName = defaultReader;
                } else {
                    prefs.remove("preference.reader");
                    TimsLogger.debug("#CCIDReader.init# " + availableReaders);
                    SelectSource ss = new SelectSource(MainFrameTransport.getInstance(), readerList);
                    ss.setVisible(true);
                    if (!ss.isCanceled()) {
                        readerName = ss.getSrcName();
                    }
                }
            } else {
                readerName = readerList[0];
            }
            if (readerName != null) break block15;
            return false;
        }
        TimsLogger.info("#CCIDReader.init# readerName = " + readerName);
        init = true;
        return true;
    }

    @Override
    public boolean reset() {
        TimsLogger.warn("#CCIDReader.reset# send reset \n");
        try {
            int wfi = JSmartNatif.waitForInsertion(readerName);
            if (wfi != 0) {
                TimsLogger.warn("#CCIDReader.start# Unable to etablish contact " + wfi + "\n");
                if (wfi == -2146435026) {
                    init = false;
                }
                return false;
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("#CCIDReader.start# wait for insertion error \n");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void waitForWithdraw() {
        try {
            JSmartNatif.waitForWithdraw(readerName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String transmit(String command) {
        TimsLogger.debug("TRANSMIT " + command);
        try {
            this.buffer = JSmartNatif.OnReadFile(readerName, command);
            TimsLogger.debug("RECEIVE " + Fonctions.prettyHexify(this.buffer));
            String returnCode = Fonctions.returnIntCode(this.buffer);
            if (returnCode.startsWith("61")) {
                String getResponse = "00C00000" + returnCode.substring(2);
                TimsLogger.debug("Response startwith 61, call GET RESPONSE with length value - TRANSMIT " + getResponse);
                this.buffer = JSmartNatif.OnReadFile(readerName, getResponse);
                returnCode = Fonctions.returnIntCode(this.buffer);
                TimsLogger.debug("GET RESPONSE, new response " + returnCode);
            } else if (returnCode.startsWith("6C")) {
                int length = command.length();
                String ajustedCommand = command.substring(0, length - 2);
                TimsLogger.debug("Response startwith 6C, call ADJUST COMMAND with correct length - TRANSMIT " + ajustedCommand + returnCode.substring(2));
                this.buffer = JSmartNatif.OnReadFile(readerName, String.valueOf(ajustedCommand) + returnCode.substring(2));
                returnCode = Fonctions.returnIntCode(this.buffer);
                TimsLogger.debug("ADJUST COMMAND, new response " + returnCode);
            }
            return returnCode;
        }
        catch (JSmartException ex) {
            ex.printStackTrace();
            return "0000";
        }
    }

    public class SelectSource
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private String srcName;
        private boolean canceled;

        SelectSource(JFrame f, String[] defSrcName) {
            super(f, LanguageTranslator.getString("card.tranfer.reader"), true);
            Vector<String> srcNames = new Vector<String>();
            int i = 0;
            while (i < defSrcName.length) {
                srcNames.add(defSrcName[i]);
                ++i;
            }
            JPanel pnl = new JPanel(new BorderLayout());
            JPanel pnlBtn = new JPanel();
            JButton btnValid = new JButton(LanguageTranslator.getString("button.valid"));
            JButton btnCancel = new JButton(LanguageTranslator.getString("button.quit"));
            final JCheckBox cbPref = new JCheckBox(LanguageTranslator.getString("preference.save"));
            cbPref.setToolTipText(LanguageTranslator.getString("preference.explaination"));
            final JList list = new JList(srcNames);
            list.setSelectionMode(0);
            if (srcNames.size() != 0) {
                list.setSelectedValue(defSrcName, true);
            }
            pnl.add((Component)new JScrollPane(list), "Center");
            pnl.add((Component)cbPref, "North");
            pnlBtn.add(btnValid);
            pnlBtn.add(btnCancel);
            this.getRootPane().setDefaultButton(btnValid);
            pnl.add((Component)pnlBtn, "South");
            btnValid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectSource.this.canceled = false;
                    SelectSource.this.srcName = (String)list.getSelectedValue();
                    if (cbPref.isSelected()) {
                        Preferences prefs = Preferences.userRoot().node("TIMS");
                        prefs.put("preference.reader", SelectSource.this.srcName);
                    }
                    SelectSource.this.dispose();
                }
            });
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectSource.this.canceled = true;
                    SelectSource.this.dispose();
                }
            });
            this.getContentPane().add((Component)pnl, "South");
            this.pack();
            this.setLocationRelativeTo(f);
        }

        String getSrcName() {
            return this.srcName;
        }

        boolean isCanceled() {
            return this.canceled;
        }
    }
}

