/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import java.util.Arrays;

public abstract class CardCommunicator {
    protected byte[] buffer = null;
    public static final String SUCCESS = "9000";
    public static final String ERROR = "0000";
    public static final String PHOF_CMD = "802A9000";
    public static final String CDS_CMD = "002A9E9A";

    public abstract boolean connect();

    public abstract boolean reset();

    public String selectFile(String file) {
        String pe = "04";
        String le = "0" + file.length() / 2;
        if (le.equals("02")) {
            pe = "02";
        }
        return this.transmit("00A4" + pe + "0C" + le + file);
    }

    public String readBinary(String p1, String p2, String le) {
        return this.transmit("00B0" + p1 + p2 + le);
    }

    public String updateBinary(String data) {
        String le = String.valueOf(data.length() / 2);
        while (le.length() < 2) {
            le = "0" + le;
        }
        return this.transmit("00D60000" + le + data);
    }

    public String performHashOfFile() {
        return this.transmit(PHOF_CMD);
    }

    public String computeDigitalSignature(int size) {
        return this.transmit(CDS_CMD + Integer.toHexString(size == 0 ? 128 : size));
    }

    public abstract String transmit(String var1);

    public byte[] getLastResponse() {
        return this.buffer;
    }

    public byte[] getClearedLastResponse() {
        return Arrays.copyOfRange(this.buffer, 0, this.buffer.length - 2);
    }

    public abstract void waitForWithdraw();
}

