/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import be.fedict.commons.eid.client.CardAndTerminalManager;
import be.fedict.commons.eid.client.event.CardEventsListener;
import java.math.BigInteger;
import javax.smartcardio.Card;
import javax.smartcardio.CardTerminal;
import transpo.system.TimsLogger;
import transpo.system.jsmartcard.DriverCardAcquisition;
import transpo.system.jsmartcard.SmartCardCommunicator;

public class CardEventListenerLauncher {
    private final boolean automatic = "1".equals(System.getProperty("automatic.tools.detection", "0"));
    private final CardAndTerminalManager cardAndTerminalManager = new CardAndTerminalManager();
    private CardEventsListener listener = new CardEventsListener(){

        @Override
        public void cardInserted(CardTerminal cardTerminal, Card card) {
            if (card != null) {
                TimsLogger.debug("#CardEventListener.cardInserted# Card ATR[" + String.format("%x", new BigInteger(1, card.getATR().getBytes())) + "] Inserted Into Terminal [" + cardTerminal.getName() + "]");
                new DriverCardAcquisition(new SmartCardCommunicator(card)).launchCardReading();
            } else {
                System.err.println("Card present but failed to connect()");
            }
        }

        @Override
        public void cardRemoved(CardTerminal cardTerminal) {
            TimsLogger.debug("Card Removed From [" + cardTerminal.getName() + "]");
            if (!CardEventListenerLauncher.this.automatic) {
                TimsLogger.debug("remove listener");
                CardEventListenerLauncher.this.cardAndTerminalManager.removeCardListener(CardEventListenerLauncher.this.listener);
            }
        }

        @Override
        public void cardEventsInitialized() {
            TimsLogger.debug("From now on you'll see Cards being Inserted/Removed, automatic is " + CardEventListenerLauncher.this.automatic);
        }
    };

    public void listen() throws InterruptedException {
        this.cardAndTerminalManager.addCardListener(this.listener);
        TimsLogger.debug("First, you'll see Inserted events for Cards that were already inserted");
        this.cardAndTerminalManager.start();
    }
}

