/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;

public class CompanyCardProperty {
    public static final int CARD_TRANSFER_ERROR = 0;
    public static final int CARD_EVER_READ = 1;
    public static final int CARD_READ_SUCCESS = 2;
    public static final int CARD_INFORMATION_ERROR = 3;
    public static final int CARD_SAVE_ERROR = 4;
    public static final int CARD_ERROR = 5;
    public static final int CARD_NO_DATA = 6;
    public static final int CARD_WRITING_ERROR = 7;
    public static final int BAD_FILE = 8;
    public static final String ETAT_NON_INSERE = "NON INSEREE";
    public static final String ETAT_INSERE = "INSEREE";
    public static final String ETAT_SM = "S. MAN";
    public static final String ETAT_SEUL = "SEUL";
    public static final String ETAT_INCONNU = "INCONNU";
    public static final String ETAT_EQUIPAGE = "EQUIPAGE";
    public static final String LECTEUR_CONDUCTEUR = "CONDUCTEUR";
    public static final String LECTEUR_CONVOYEUR = "CONVOYEUR";
    public static final int idIcc = 512;
    public static final int idIc = 1280;
    public static final int idCardCertificate = 0xC10000;
    public static final int idCaCertificate = 12650496;
    public static final int idApplicationIdentification = 327936;
    public static final int idIdentification = 335872;
    public static final int idCompanyActivityData = 331008;
    public static final int idsCardCertificate = 0xC10001;
    public static final int idsCaCertificate = 12650497;
    public static final int idsApplicationIdentification = 327937;
    public static final int idsIdentification = 335873;
    public static final int idsCompanyActivityData = 331009;
    public static int iccSize = 25;
    public static int icSize = 8;
    public static int cardCertificateSize = 194;
    public static int caCertificateSize = 194;
    public static int applicationIdentificationSize = 5;
    public static int identificationSize = 139;
    public static int companyActivityDataSize = 23922;
    public static int signatureSize = 133;
    public static int numberOfCompanyActiviyRecord = 520;

    public static String getLecteur(String value) {
        String lecteur = "";
        if (value.equals("0")) {
            lecteur = LECTEUR_CONDUCTEUR;
        }
        if (value.equals("1")) {
            lecteur = LECTEUR_CONVOYEUR;
        }
        return lecteur;
    }

    public static String getEtatConduite(String value, String etatCarte) {
        if (etatCarte.equals("0")) {
            if (value.equals("1")) {
                return ETAT_EQUIPAGE;
            }
            return ETAT_SEUL;
        }
        if (value.equals("1")) {
            return ETAT_SM;
        }
        return ETAT_INCONNU;
    }

    public static String getEtatCarte(String value) {
        if (value.equals("0")) {
            return ETAT_INSERE;
        }
        return ETAT_NON_INSERE;
    }

    public static int getActivite(String value, String etatConduite, String etatCarte, String lecteur) {
        if (etatConduite.equals("0") && etatCarte.equals("1")) {
            return 7;
        }
        if (etatCarte.equals("0") && etatConduite.equals("1") && lecteur.equals("1")) {
            if (value.equals("00")) {
                return 4;
            }
            return 5;
        }
        if (value.equals("00")) {
            return 4;
        }
        if (value.equals("01")) {
            return 3;
        }
        if (value.equals("10")) {
            return 2;
        }
        return 1;
    }

    public static int getHeure(String binaryValue) {
        return Integer.parseInt(binaryValue, 2);
    }

    public static String getBinaryActivity(String octet) {
        while (octet.length() < 16) {
            octet = "0" + octet;
        }
        return octet;
    }

    public static int getOffsetFile(byte[] buf, int idOffset) {
        int offset = 0;
        boolean correctionDate = false;
        while (offset != buf.length) {
            if (Fonctions.bytesToInt(buf, offset, 3) == idOffset) {
                return offset;
            }
            int size = CompanyCardProperty.getOffsetSize(Fonctions.bytesToInt(buf, offset, 3));
            if (size == -1) {
                if (!correctionDate) {
                    size = 2;
                    correctionDate = true;
                } else {
                    return -1;
                }
            }
            offset += size;
        }
        return -1;
    }

    public static int getOffsetSize(int idOffset) {
        int retour = -1;
        if (idOffset == 327937 || idOffset == 335873 || idOffset == 0xC10001 || idOffset == 12650497) {
            return signatureSize;
        }
        switch (idOffset) {
            case 512: {
                retour = iccSize;
                break;
            }
            case 1280: {
                retour = icSize;
                break;
            }
            case 0xC10000: {
                retour = cardCertificateSize;
                break;
            }
            case 12650496: {
                retour = caCertificateSize;
                break;
            }
            case 327936: {
                retour = applicationIdentificationSize;
                break;
            }
            case 335872: {
                retour = identificationSize;
                break;
            }
            case 331008: {
                retour = companyActivityDataSize;
            }
        }
        return retour;
    }

    public static void setNumberOfCompanyActivityRecord(int numberOfCompanyActivityRecord) {
        int companyActivityDataSize = numberOfCompanyActivityRecord * 46;
        TimsLogger.debug("numberOfCompanyActivityRecord : " + numberOfCompanyActivityRecord + " => " + companyActivityDataSize + " (" + CompanyCardProperty.companyActivityDataSize + ")");
        CompanyCardProperty.companyActivityDataSize = companyActivityDataSize;
    }
}

