/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.Pays;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.jsmartcard.ElementaryFile;
import transpo.system.util.Fonctions;
import transpo.system.util.GenericFileFilter;

public class DriverCardProperty {
    public static final int CARD_TRANSFER_ERROR = 0;
    public static final int CARD_EVER_READ = 1;
    public static final int CARD_READ_SUCCESS = 2;
    public static final int CARD_INFORMATION_ERROR = 3;
    public static final int CARD_SAVE_ERROR = 4;
    public static final int CARD_ERROR = 5;
    public static final int CARD_NO_DATA = 6;
    public static final int CARD_WRITING_ERROR = 7;
    public static final int BAD_FILE = 8;
    public static final int CARD_ACTIVITY_ERROR = 9;
    public static final int CARD_MYSQLFILE_SAVE_ERROR = 10;
    public static final int CARD_STRUCTURE_ERROR = 11;
    public static final int CARD_READ_CANCELLED = 12;
    public static final int DRIVER_FOUND = 13;
    public static final int DRIVER_UNKNOW = 14;
    public static final int OFFENCE_CALCULATION_ERROR = 15;
    public static final int CARD_ERROR_DOWNLOAD_DATE_AFTER_DATE = 16;
    public static final int CARD_ERROR_DOWNLOAD_DATE_BEFORE_LAST_ACT = 17;
    public static final int CARD_RENEWAL_ERROR = 18;
    public static final int CARD_OLD_RENEWAL_ERROR = 19;
    public static final int CARD_GENERATION_ALL = 0;
    public static final int CARD_GENERATION_1 = 1;
    public static final int CARD_GENERATION_2 = 2;
    public static final int OFFSET_SIZE = 5;
    public static final String ETAT_NON_INSERE = "NON INSEREE";
    public static final String ETAT_INSERE = "INSEREE";
    public static final String ETAT_SM = "S. MAN";
    public static final String ETAT_SEUL = "SEUL";
    public static final String ETAT_INCONNU = "INCONNU";
    public static final String ETAT_EQUIPAGE = "EQUIPAGE";
    public static final String LECTEUR_CONDUCTEUR = "CONDUCTEUR";
    public static final String LECTEUR_CONVOYEUR = "CONVOYEUR";
    public static final int idIcc = 2;
    public static final int idIc = 5;
    public static final int idApplicationIdentificationG1 = 327936;
    public static final int idCardCertificateG1 = 0xC10000;
    public static final int idCaCertificateG1 = 12650496;
    public static final int idIdentificationG1 = 335872;
    public static final int idCardDownloadG1 = 331264;
    public static final int idDrivingLicenseInfoG1 = 336128;
    public static final int idEventsDataG1 = 328192;
    public static final int idFaultsDataG1 = 328448;
    public static final int idDriverActivityDataG1 = 328704;
    public static final int idVehiclesUsedG1 = 328960;
    public static final int idPlacesG1 = 329216;
    public static final int idCurrentUsageG1 = 329472;
    public static final int idControlActivityDataG1 = 329728;
    public static final int idSpecificConditionsG1 = 336384;
    public static final int idDir = 0x2F0000;
    public static final int idAtr = 3080448;
    public static final int idExtLen = 1536;
    public static final int idApplicationIdentificationG2 = 327938;
    public static final int idCardMACertificateG2 = 12648450;
    public static final int idCardSignCertificateG2 = 12648706;
    public static final int idCaCertificateG2 = 12650498;
    public static final int idLinkCertificateG2 = 12650754;
    public static final int idIdentificationG2 = 335874;
    public static final int idCardDownloadG2 = 331266;
    public static final int idDrivingLicenseInfoG2 = 336130;
    public static final int idEventsDataG2 = 328194;
    public static final int idFaultsDataG2 = 328450;
    public static final int idDriverActivityDataG2 = 328706;
    public static final int idVehiclesUsedG2 = 328962;
    public static final int idPlacesG2 = 329218;
    public static final int idCurrentUsageG2 = 329474;
    public static final int idControlActivityDataG2 = 329730;
    public static final int idSpecificConditionsG2 = 336386;
    public static final int idVehicleUnitsUsedG2 = 336642;
    public static final int idGNSSPlacesG2 = 336898;
    public static final int idApplicationIdentificationG2V2 = 337154;
    public static final int idPlacesAuthentication = 337410;
    public static final int idGNSSAuthentication = 337666;
    public static final int idBorderCrossings = 337922;
    public static final int idLoadUnloadOperations = 338178;
    public static final int idLoadTypeEntries = 339970;
    public static final int idVuConfiguration = 344066;
    public static final int idsCardCertificate = 0xC10001;
    public static final int idsCaCertificate = 12650497;
    public static final int idsApplicationIdentification = 327937;
    public static final int idsIdentification = 335873;
    public static final int idsCardDownload = 331265;
    public static final int idsDrivingLicenseInfo = 336129;
    public static final int idsEventsData = 328193;
    public static final int idsFaultsData = 328449;
    public static final int idsDriverActivityData = 328705;
    public static final int idsVehiclesUsed = 328961;
    public static final int idsPlaces = 329217;
    public static final int idsCurrentUsage = 329473;
    public static final int idsControlActivityData = 329729;
    public static final int idsSpecificConditions = 336385;
    public static final int sizeOfSignatureG2 = 64;
    public static final int sizeOfSignatureG1 = 128;
    public static int sizeOfEventsData = 1733;
    public static int sizeOfFaultsData = 1157;
    public static int sizeOfDriverActivityData = 13785;
    public static int sizeOfVehiclesUsedData = 6207;
    public static int sizeOfPlacesData = 1126;
    public static int sizeOfSpecificConditions = 285;
    public static int sizeOfPlacesAuthenticationData = 567;
    public static int sizeOfGNSSAuthenticationData = 1687;
    public static int sizeOfBorderCrossingData = 19047;
    public static int sizeOfLoadUnloadOperationData = 32487;
    public static int sizeOfLoadTypeEntryData = 1687;
    public static int sizeOfVuConfiguration = 3077;
    public static int sizeOfEventRecords = 6;
    public static int sizeOfEvent = 24;
    public static int sizeOfFault = 24;
    public static int sizeOfVehicleUsedG1 = 31;
    public static int sizeOfPlaceG1 = 10;
    public static int sizeOfVehicleUnitUsed = 10;
    public static int sizeOfGNSSG2 = 15;
    public static int sizeOfSpecificCondition = 5;
    public static int sizeOfPlaceG2 = 21;
    public static int sizeOfVehicleUsedG2 = 48;
    public static int sizeOfEventRecordsG2 = 11;
    public static int sizeOfPlacesAuthentication = 5;
    public static int sizeOfGNSSAuthentication = 5;
    public static int sizeOfBorderCrossing = 17;
    public static int sizeOfLoadUnloadOperation = 20;
    public static int sizeOfLoadTypeEntry = 5;
    public static int sizeOfATR = 7;
    public static int sizeOfVehicleUnitUsedData = 842;
    public static int sizeOfGNSSData = 3780;
    public static int specificConditionCount = 56;
    public static int cardStructureVersion = 0;
    public static int cardStructureUpdate = 0;
    private ArrayList<ElementaryFile> downloadList = null;

    public ArrayList<ElementaryFile> getDownloadList() {
        if (this.downloadList == null) {
            this.downloadList = new ArrayList();
            this.downloadList.add(new ElementaryFile("ICC", "0002", 25, false, 0));
            this.downloadList.add(new ElementaryFile("IC", "0005", 8, false, 0));
            this.downloadList.add(new ElementaryFile("Application_Identification", "0501", 10, true, 1));
            this.downloadList.add(new ElementaryFile("Card_Certificate", "C100", 194, false, 1));
            this.downloadList.add(new ElementaryFile("CA_Certificate", "C108", 194, false, 1));
            this.downloadList.add(new ElementaryFile("Identification", "0520", 143, true, 1));
            this.downloadList.add(new ElementaryFile("Card_Download", "050E", 4, false, 1));
            this.downloadList.add(new ElementaryFile("Driving_License_Info", "0521", 53, true, 1));
            this.downloadList.add(new ElementaryFile("Events_Data", "0502", 1728, true, 1));
            this.downloadList.add(new ElementaryFile("Fauts_Data", "0503", 1152, true, 1));
            this.downloadList.add(new ElementaryFile("Driver_Activity_Data", "0504", 13780, true, 1));
            this.downloadList.add(new ElementaryFile("Vehicles_Used", "0505", 6202, true, 1));
            this.downloadList.add(new ElementaryFile("Places", "0506", 1121, true, 1));
            this.downloadList.add(new ElementaryFile("Current_Usage", "0507", 19, true, 1));
            this.downloadList.add(new ElementaryFile("Control_Activity_Data", "0508", 46, true, 1));
            this.downloadList.add(new ElementaryFile("Specific_Conditions", "0522", 280, true, 1));
            this.downloadList.add(new ElementaryFile("Application_Identification", "0501", 17, true, 2));
            this.downloadList.add(new ElementaryFile("CardMA_Certificate", "C100", 204, false, 2));
            this.downloadList.add(new ElementaryFile("CardSign_Certificate", "C101", 204, false, 2));
            this.downloadList.add(new ElementaryFile("CA_Certificate", "C108", 204, false, 2));
            this.downloadList.add(new ElementaryFile("Link_Certificate", "C109", 204, false, 2));
            this.downloadList.add(new ElementaryFile("Identification", "0520", 143, true, 2));
            this.downloadList.add(new ElementaryFile("Card_Download", "050E", 4, false, 2));
            this.downloadList.add(new ElementaryFile("Driving_License_Info", "0521", 53, true, 2));
            this.downloadList.add(new ElementaryFile("Events_Data", "0502", 1728, true, 2));
            this.downloadList.add(new ElementaryFile("Fauts_Data", "0503", 1152, true, 2));
            this.downloadList.add(new ElementaryFile("Driver_Activity_Data", "0504", 13780, true, 2));
            this.downloadList.add(new ElementaryFile("Vehicles_Used", "0505", 6202, true, 2));
            this.downloadList.add(new ElementaryFile("Places", "0506", 1121, true, 2));
            this.downloadList.add(new ElementaryFile("Current_Usage", "0507", 19, true, 2));
            this.downloadList.add(new ElementaryFile("Control_Activity_Data", "0508", 46, true, 2));
            this.downloadList.add(new ElementaryFile("Specific_Conditions", "0522", 280, true, 2));
            this.downloadList.add(new ElementaryFile("VehicleUnits_Used", "0523", 280, true, 2));
            this.downloadList.add(new ElementaryFile("GNSS_Places", "0524", 280, true, 2));
            this.downloadList.add(new ElementaryFile("Application_Identification_V2", "0525", 17, false, 3));
            this.downloadList.add(new ElementaryFile("Places_Authentication", "0526", 562, true, 3));
            this.downloadList.add(new ElementaryFile("GNSS_Authentication", "0527", 1682, true, 3));
            this.downloadList.add(new ElementaryFile("Border_Crossing", "0528", 19042, true, 3));
            this.downloadList.add(new ElementaryFile("Load_Unload_Operations", "0529", 32482, true, 3));
            this.downloadList.add(new ElementaryFile("Load_Type_Entries", "0530", 1682, true, 3));
        }
        return this.downloadList;
    }

    public boolean setSize(String fichier, int dfTachograph, int size) {
        for (ElementaryFile ef : this.getDownloadList()) {
            if (!ef.getFileID().equals(fichier) || ef.getDfTachoType() != dfTachograph) continue;
            TimsLogger.verbose("#DCP.setSize# set size of " + ef.getFileName() + " on DF_Tachographe G" + dfTachograph + " to " + size);
            ef.setSize(size);
            return true;
        }
        return false;
    }

    public static String getLecteur(String value) {
        String lecteur = "";
        if (value.equals("0")) {
            lecteur = LECTEUR_CONDUCTEUR;
        }
        if (value.equals("1")) {
            lecteur = LECTEUR_CONVOYEUR;
        }
        return lecteur;
    }

    public static String getEtatConduite(String value, String etatCarte) {
        if (etatCarte.equals("0")) {
            if (value.equals("1")) {
                return ETAT_EQUIPAGE;
            }
            return ETAT_SEUL;
        }
        if (value.equals("1")) {
            return ETAT_SM;
        }
        return ETAT_INCONNU;
    }

    public static String getEtatCarte(String value) {
        if (value.equals("0")) {
            return ETAT_INSERE;
        }
        return ETAT_NON_INSERE;
    }

    public static int getActivite(String value, String etatConduite, String etatCarte, String lecteur) {
        if (etatConduite.equals("0") && etatCarte.equals("1")) {
            return 7;
        }
        if (etatCarte.equals("0") && etatConduite.equals("1") && lecteur.equals("1")) {
            if (value.equals("00")) {
                return 4;
            }
            return 5;
        }
        if (value.equals("00")) {
            return 4;
        }
        if (value.equals("01")) {
            return 3;
        }
        if (value.equals("10")) {
            return 2;
        }
        return 1;
    }

    public static int getHeure(String binaryValue) {
        return Integer.parseInt(binaryValue, 2);
    }

    public static String getBinaryActivity(String octet) {
        while (octet.length() < 16) {
            octet = "0" + octet;
        }
        return octet;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getOffsetFile(byte[] buf, int idOffset) {
        int offset = 0;
        boolean correctionDate = false;
        while (offset < buf.length - 3) {
            if (Fonctions.bytesToInt(buf, offset, 3) == idOffset) {
                TimsLogger.debug("#CP# offset " + Integer.toHexString(idOffset) + " found at " + offset + " / 0x" + Integer.toHexString(offset));
                return offset;
            }
            int size = Fonctions.bytesToInt(buf, offset + 3, 2) + 5;
            TimsLogger.verbose("#CP# offset found : " + Integer.toHexString(Fonctions.bytesToInt(buf, offset, 3)) + " at " + offset + " / 0x" + Integer.toHexString(offset) + " (" + size + ")");
            if (size == -1) {
                if (correctionDate) {
                    TimsLogger.verbose("#CP# offset : date correction ever done " + offset + " (" + size + ")");
                    return -1;
                }
                TimsLogger.verbose("#CP# offset : date correction at " + offset + " (" + size + ")");
                size = 2;
                correctionDate = true;
            } else {
                correctionDate = false;
            }
            offset += size;
        }
        return -1;
    }

    public int getEFSize(int idOffset) {
        int toReturn = -1;
        String sOffset = Integer.toHexString(idOffset);
        while (sOffset.length() < 6) {
            sOffset = "0" + sOffset;
        }
        if (sOffset.endsWith("01")) {
            toReturn = 133;
        } else if (sOffset.endsWith("03")) {
            toReturn = 69;
        } else {
            int dfTachograph = sOffset.substring(4, 6).equals("00") ? 1 : 2;
            for (ElementaryFile ef : this.getDownloadList()) {
                if (!ef.getFileID().equalsIgnoreCase(sOffset.substring(0, 4)) || ef.getDfTachoType() != 0 && dfTachograph != ef.getDfTachoType()) continue;
                toReturn = ef.getSize() + 5;
            }
        }
        return toReturn;
    }

    public static ChangementActivite getDetailActivite(byte[] activite, Date day, String source, String sourceName) {
        int tmpInt = Fonctions.bytesToInt(activite, 0, 2);
        String binaryActivite = DriverCardProperty.getBinaryActivity(Integer.toBinaryString(tmpInt));
        String s = binaryActivite.substring(0, 1);
        String c = binaryActivite.substring(1, 2);
        String p = binaryActivite.substring(2, 3);
        String a = binaryActivite.substring(3, 5);
        String t = binaryActivite.substring(5, 16);
        String lecteur = DriverCardProperty.getLecteur(s);
        String conduite = DriverCardProperty.getEtatConduite(c, p);
        String carte = DriverCardProperty.getEtatCarte(p);
        int typeActivite = DriverCardProperty.getActivite(a, c, p, s);
        int heure = DriverCardProperty.getHeure(t);
        ChangementActivite retour = new ChangementActivite(typeActivite, day, heure, lecteur, conduite, carte, source, sourceName);
        retour.affiche();
        return retour;
    }

    public void setNumberOfEventsData(int dfTachograph, int numberOfEventsPerType) {
        int tailleEventsData = (dfTachograph == 1 ? sizeOfEventRecords : sizeOfEventRecordsG2) * (numberOfEventsPerType * sizeOfEvent);
        this.setSize("0502", dfTachograph, tailleEventsData);
        TimsLogger.verbose("#DCP.setNumberOfEventsData# " + numberOfEventsPerType + " => " + tailleEventsData + " (" + sizeOfEventsData + ")");
        sizeOfEventsData = tailleEventsData + 5;
    }

    public void setNumberOfFaultsData(int dfTachograph, int numberOfFaultsPerType) {
        int tailleFaultsData = 2 * (numberOfFaultsPerType * sizeOfFault);
        this.setSize("0503", dfTachograph, tailleFaultsData);
        TimsLogger.verbose("#DCP.setNumberOfFaultsData# " + numberOfFaultsPerType + " => " + tailleFaultsData + " (" + sizeOfFaultsData + ")");
        sizeOfFaultsData = tailleFaultsData + 5;
    }

    public void setActiviteStructureLength(int dfTachograph, int activityStructureLength) {
        int tailleDriverActivityData = activityStructureLength + 2 + 2;
        this.setSize("0504", dfTachograph, tailleDriverActivityData);
        TimsLogger.verbose("#DCP.setActiviteStructureLength# " + activityStructureLength + " => " + tailleDriverActivityData + " (" + sizeOfDriverActivityData + ")");
        sizeOfDriverActivityData = tailleDriverActivityData + 5;
    }

    public void setNumberOfVehicleRecords(int dfTachograph, int numberOfCardVehicleRecords) {
        int tailleVehiclesUsedData = numberOfCardVehicleRecords * (dfTachograph == 1 ? sizeOfVehicleUsedG1 : sizeOfVehicleUsedG2) + 2;
        this.setSize("0505", dfTachograph, tailleVehiclesUsedData);
        TimsLogger.verbose("#DCP.setNumberOfVehicleRecords# " + numberOfCardVehicleRecords + " => " + tailleVehiclesUsedData + " (" + sizeOfVehiclesUsedData + ")");
        sizeOfVehiclesUsedData = tailleVehiclesUsedData + 5;
    }

    public void setNumberOfPlaceRecords(int dfTachograph, int numberOfCardPlaceRecords) {
        int taillePlacesData = dfTachograph == 1 ? numberOfCardPlaceRecords * sizeOfPlaceG1 + 1 : numberOfCardPlaceRecords * sizeOfPlaceG2 + 2;
        this.setSize("0506", dfTachograph, taillePlacesData);
        TimsLogger.verbose("#DCP.setNumberOfPlaceRecords# " + numberOfCardPlaceRecords + " => " + taillePlacesData + " (" + sizeOfPlacesData + ")");
        sizeOfPlacesData = taillePlacesData + 5;
    }

    public void setNumberOfSpecificConditionRecords(int dfTachograph, int numberOfSpecificConditionRecords) {
        if (dfTachograph != 2) {
            return;
        }
        int newSize = numberOfSpecificConditionRecords * sizeOfSpecificCondition + 2;
        this.setSize("0522", dfTachograph, newSize);
        TimsLogger.verbose("#DCP.setNumberOfSpecificConditionRecords# " + numberOfSpecificConditionRecords + " => " + newSize + " (" + sizeOfSpecificConditions + ")");
        sizeOfSpecificConditions = newSize + 5;
    }

    public void setNumberOfVehicleUnitUsedRecords(int dfTachograph, int numberOfVehicleUnitUsedRecords) {
        if (dfTachograph != 2) {
            return;
        }
        int newSize = numberOfVehicleUnitUsedRecords * sizeOfVehicleUnitUsed + 2;
        this.setSize("0523", dfTachograph, newSize);
        TimsLogger.verbose("#DCP.setNumberOfVehicleUnitUsed# " + numberOfVehicleUnitUsedRecords + " => " + newSize + " (" + sizeOfVehicleUnitUsedData + ")");
        sizeOfVehicleUnitUsedData = newSize + 5;
    }

    public void setNumberOfGNSSRecords(int dfTachograph, int numberOfGNSSRecords) {
        if (dfTachograph != 2) {
            return;
        }
        int newSize = numberOfGNSSRecords * sizeOfGNSSG2 + 2;
        this.setSize("0524", dfTachograph, newSize);
        TimsLogger.verbose("#DCP.setNumberOfGNSSRecords# " + numberOfGNSSRecords + " => " + newSize + " (" + sizeOfGNSSData + ")");
        sizeOfGNSSData = newSize + 5;
    }

    public void setNumberOfPlacesAuthenticationRecords(int numberOf) {
        this.setSize("0526", 2, numberOf * sizeOfPlacesAuthentication);
        TimsLogger.verbose("#DCP.setNumberOfPlacesAuthenticationRecords# " + numberOf + " => " + numberOf * sizeOfPlacesAuthentication + " (" + sizeOfPlacesAuthenticationData + ")");
        sizeOfPlacesAuthenticationData = numberOf * sizeOfBorderCrossing + 5;
    }

    public void setNumberOfGNSSAuthenticationRecords(int numberOf) {
        this.setSize("0527", 2, numberOf * sizeOfGNSSAuthentication);
        TimsLogger.verbose("#DCP.setNumberOfGNSSAuthenticationRecords# " + numberOf + " => " + numberOf * sizeOfGNSSAuthentication + " (" + sizeOfGNSSAuthenticationData + ")");
        sizeOfGNSSAuthenticationData = numberOf * sizeOfGNSSAuthentication + 5;
    }

    public void setNumberOfCrossingBordersRecords(int numberOf) {
        this.setSize("0528", 2, numberOf * sizeOfBorderCrossing);
        TimsLogger.verbose("#DCP.setNumberOfCrossingBordersRecords# " + numberOf + " => " + numberOf * sizeOfBorderCrossing + " (" + sizeOfBorderCrossing + ")");
        sizeOfBorderCrossingData = numberOf * sizeOfBorderCrossing + 5;
    }

    public void setNumberOfLoadUnloadOperationsRecords(int numberOf) {
        this.setSize("0529", 2, numberOf * sizeOfLoadUnloadOperation);
        TimsLogger.verbose("#DCP.setNumberOfLoadUnloadOperationsRecords# " + numberOf + " => " + numberOf * sizeOfLoadUnloadOperation + " (" + sizeOfLoadUnloadOperationData + ")");
        sizeOfLoadUnloadOperationData = numberOf * sizeOfLoadUnloadOperation + 5;
    }

    public void setNumberOfLoadTypeEntriesRecords(int numberOf) {
        this.setSize("0530", 2, numberOf * sizeOfLoadTypeEntry);
        TimsLogger.verbose("#DCP.setNumberOfLoadTypeEntriesRecords# " + numberOf + " => " + numberOf * sizeOfLoadTypeEntry + " (" + sizeOfLoadTypeEntryData + ")");
        sizeOfLoadTypeEntryData = numberOf * sizeOfLoadTypeEntry + 5;
    }

    public static String[] getFailedCard() {
        return new File(Transport.savePath).list(new GenericFileFilter(".C1B"));
    }

    public String extractFileName(byte[] fileBuffer, Date dlDate) throws Exception {
        return this.extractFileName(fileBuffer, ConversionTime.dateToString(dlDate == null ? new Date() : dlDate, "yyMMddHHmm"));
    }

    public String extractFileName(byte[] fileBuffer, String parsedDate) throws Exception {
        String result = "-1";
        int offset = this.getOffsetFile(fileBuffer, 335872) + 5;
        int cardIssuingMemberState = Fonctions.bytesToInt(fileBuffer, offset, 1);
        result = Pays.LIBELLE.length <= cardIssuingMemberState ? Pays.LIBELLE[0][0] : Pays.LIBELLE[cardIssuingMemberState][0];
        ++offset;
        byte[] cardNumber = new byte[14];
        int i = 0;
        while (i < cardNumber.length) {
            cardNumber[i] = fileBuffer[offset + i];
            ++i;
        }
        result = String.valueOf(result) + new String(cardNumber).trim() + parsedDate + ".C1B";
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkFile(byte[] fileBuffer) {
        int offset = 0;
        boolean correctionDate = false;
        while (offset < fileBuffer.length - 3) {
            int offsetId = Fonctions.bytesToInt(fileBuffer, offset, 3);
            int size = Fonctions.bytesToInt(fileBuffer, offset + 3, 2) + 5;
            TimsLogger.verbose("#CP# offset found : " + Integer.toHexString(offsetId) + " at " + offset + " / 0x" + Integer.toHexString(offset) + " (" + size + ")");
            if (size == -1) {
                if (correctionDate) {
                    TimsLogger.verbose("#CP# offset : date correction ever done " + offset + " (" + size + ")");
                    return false;
                }
                TimsLogger.verbose("#CP# offset : date correction at " + offset + " (" + size + ")");
                size = 2;
                correctionDate = true;
            } else {
                correctionDate = false;
            }
            if (!this.checkId(offsetId)) {
                return false;
            }
            offset += size;
        }
        return true;
    }

    private boolean checkId(int id) {
        for (ElementaryFile ef : this.downloadList) {
            String hexId = Integer.toHexString(id);
            while (hexId.length() < 4) {
                hexId = "0" + hexId;
            }
            if (!ef.getFileID().equals(hexId)) continue;
            return true;
        }
        return false;
    }
}

