/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.jsmartcard;

import com.sun.comm.Win32Driver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import org.apache.commons.lang.UnhandledException;
import transpo.system.TimsLogger;
import transpo.system.jsmartcard.CardCommunicator;

public class XiringRS232Reader
extends CardCommunicator {
    public SerialPort port;
    private InputStream fluxLecture;
    private OutputStream outStream;
    private final String portName = "COM15";
    protected static boolean init = false;

    @Override
    public boolean connect() {
        if (init) {
            return true;
        }
        Win32Driver w32Driver = new Win32Driver();
        w32Driver.initialize();
        CommPortIdentifier portId = null;
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)"COM15");
        }
        catch (NoSuchPortException ex) {
            TimsLogger.warn("No Port Name COM15");
            return false;
        }
        try {
            this.port = (SerialPort)portId.open("GM TIMS", 5000);
            this.port.setFlowControlMode(0);
            this.port.setSerialPortParams(9600, 8, 1, 0);
            this.outStream = this.port.getOutputStream();
            this.fluxLecture = this.port.getInputStream();
        }
        catch (PortInUseException ex) {
            TimsLogger.warn("Port Name COM15 in use");
            return false;
        }
        catch (Exception ex) {
            TimsLogger.warn("Error unknow");
            ex.printStackTrace();
            return false;
        }
        init = true;
        TimsLogger.info("Port Name COM15 open");
        return true;
    }

    @Override
    public boolean reset() {
        TimsLogger.debug("#RS232READER.start()# Send ATR");
        boolean toReturn = false;
        try {
            this.outStream.write("\u000201800081\u0003".getBytes());
            this.outStream.flush();
            Thread.sleep(1000L);
            String buffer = new String(this.readCommand());
            TimsLogger.debug("#RS232READER.start()# buffer " + buffer);
            if (buffer.startsWith("\u0002019000")) {
                TimsLogger.debug("#XiringUart.cardInsered# Connection etablish with the reader");
                toReturn = true;
            } else {
                TimsLogger.warn("#XiringUart.cardInsered# Error connection with the reader");
                toReturn = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public String transmit(String command) {
        String toReturn = "";
        String cardStatusReturn = "";
        try {
            String length = Integer.toHexString(command.length() / 2);
            while (length.length() < 2) {
                length = "0" + length;
            }
            String fullCmd = "\u000201A0" + length + command;
            int checkSum = XiringRS232Reader.getChecksum(fullCmd);
            String sCheckSum = Integer.toHexString(checkSum);
            while (sCheckSum.length() < 2) {
                sCheckSum = "0" + sCheckSum;
            }
            fullCmd = (String.valueOf(fullCmd) + sCheckSum + "\u0003").toUpperCase();
            TimsLogger.verbose("#XiringRS232.transmit# Send " + fullCmd);
            this.outStream.write(fullCmd.getBytes(), 0, fullCmd.length());
            String buffString = new String(this.readCommand());
            buffString.endsWith("\u000201FF0200FC\u0003");
            String readerStatusReturn = buffString.substring(3, 7);
            String dataLength = buffString.substring(7, 9);
            int contentBegin = 9;
            if (dataLength.equals("FF")) {
                contentBegin += 4;
            }
            TimsLogger.verbose("#XiringRS232READER.sendCommand# buffString = " + buffString);
            String content = buffString.substring(contentBegin, buffString.length() - 7);
            cardStatusReturn = buffString.substring(buffString.length() - 7, buffString.length() - 3);
            int x = 0;
            while (x < content.length()) {
                int check = Integer.parseInt(content.substring(x, x + 2), 16);
                toReturn = String.valueOf(toReturn) + String.valueOf((char)check);
                x += 2;
            }
            TimsLogger.debug(" readerStatusReturn => " + readerStatusReturn + " (cardStatusReturn => " + cardStatusReturn + ")" + " content => " + content + " return " + toReturn.length() + " char");
            TimsLogger.debug("");
            this.buffer = toReturn.getBytes();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cardStatusReturn;
    }

    public byte[] readCommand() {
        Vector<Byte> tmp = new Vector<Byte>();
        try {
            int readed = 0;
            while (readed != 3) {
                readed = this.fluxLecture.read();
                tmp.add((byte)readed);
            }
            byte[] toReturn = new byte[tmp.size()];
            int x = 0;
            for (Byte b : tmp) {
                toReturn[x] = b;
                ++x;
            }
            return toReturn;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getChecksum(String fullCmd) {
        byte[] tbl = fullCmd.getBytes();
        int resultat = 0;
        int i = 1;
        while (i < tbl.length) {
            int check = Integer.parseInt(fullCmd.substring(i, i + 2), 16);
            resultat ^= check;
            i += 2;
        }
        return resultat;
    }

    @Override
    public String computeDigitalSignature(int size) {
        String command = "002A9E9A" + Integer.toHexString(size);
        command = String.valueOf(command.substring(0, command.length() - 2)) + "00" + command.substring(command.length() - 2);
        return this.transmit(command);
    }

    @Override
    public String readBinary(String p1, String p2, String le) {
        return this.transmit("00B0" + p1 + p2 + "00" + le);
    }

    @Override
    public void waitForWithdraw() {
        throw new UnhandledException("Fonction non support\u00e9e", null);
    }
}

