/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.traitement;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.ActivityDetail;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.DriverNotFoundException;
import fr.pgh.exception.ServiceException;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;

public class CorrectionActiviteDetail {
    public static final int SEUIL_RJ = 540;
    Conducteur conducteur = null;
    String dateDebut = null;
    String dateFin = null;
    String dateDebutAnalyse = null;
    String dateFinAnalyse = null;
    Vector<ActiviteConducteur> vectActivite = null;
    Vector<Service> listeService = null;
    int indexActiviteCourante = 0;
    boolean lastActivityProcessed = false;
    int dureeC = 0;
    int dureeT = 0;
    int dureeD = 0;
    int dureeR = 0;
    int dureeDE = 0;
    int dureeI = 0;
    int dureeA = 0;
    static final int DAY_COUNT = 7;
    private int extraEndDay = 0;
    private int extraBeginDay = 0;
    private boolean noServiceBefore = false;
    private boolean noServiceAfter = false;
    public static int STOP_TIME_MINIMUM = 1;
    public static int DRIVE_TIME_MINIMUM = 5;
    Vector<VehicleUsed> vehicleUsed = null;
    ArrayList<ActivityDetail> activities = null;

    public CorrectionActiviteDetail(Conducteur cond, String dateD, String dateF) {
        this.conducteur = cond;
        this.dateDebut = dateD;
        this.dateFin = ConversionTime.addDay(dateF, "yyyy-MM-dd", 2).substring(0, 10);
        TimsLogger.debug("#TraitementTempsService# cond " + cond.getCleConducteur() + " dateD = " + this.dateDebut + " dateF = " + this.dateFin);
    }

    public CorrectionActiviteDetail(int cond, String dateD, String dateF) throws DriverNotFoundException {
        this(Conducteur.getDriver(null, cond), dateD, dateF);
    }

    private int getRepos() {
        int cumulInconnu = 0;
        int cumulRepos = 0;
        int dureeRepos = 0;
        ActiviteConducteur activite = this.vectActivite.get(this.indexActiviteCourante);
        while (activite.getCleType() == 4 || activite.getCleType() == 7) {
            if (this.indexActiviteCourante == this.vectActivite.size() - 1) {
                this.lastActivityProcessed = true;
            }
            if (activite.getCleType() == 4) {
                cumulRepos += activite.getDuree();
            }
            if (activite.getCleType() == 7) {
                cumulInconnu += activite.getDuree();
            }
            dureeRepos += activite.getDuree();
            ++this.indexActiviteCourante;
            if (this.lastActivityProcessed) break;
            activite = this.vectActivite.get(this.indexActiviteCourante);
        }
        if (dureeRepos < 540) {
            this.dureeI += cumulInconnu;
            this.dureeR += cumulRepos;
        }
        return dureeRepos;
    }

    private void loardMoreEndActivity() {
        this.extraEndDay += 7;
        this.loadActivite();
    }

    private void loadMoreBeginActivite() {
        this.extraBeginDay += 7;
        this.loadActivite();
    }

    public void loadActivite() {
        block12: {
            this.listeService = new Vector();
            this.vectActivite = new Vector();
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                GregorianCalendar calendrier = new GregorianCalendar();
                this.dateDebutAnalyse = Service.getPreviousService(this.conducteur.getCleConducteur(), this.dateDebut);
                this.dateFinAnalyse = Service.getNextService(this.conducteur.getCleConducteur(), this.dateFin);
                if (this.dateDebutAnalyse == null) {
                    this.dateDebutAnalyse = this.dateDebut;
                    this.noServiceBefore = true;
                }
                if (this.dateFinAnalyse == null) {
                    this.dateFinAnalyse = this.dateFin;
                    this.noServiceAfter = true;
                }
                Transport.ps.startOperation();
                Vector<ActiviteConducteur> calculActiviteTmp = Transport.bdd.getActivite(this.conducteur.getCleConducteur(), this.dateDebutAnalyse, this.dateFinAnalyse, -1, 0);
                String firstDay = calculActiviteTmp.size() != 0 ? calculActiviteTmp.get(0).getDateJour() : null;
                String lastDay = calculActiviteTmp.size() != 0 ? calculActiviteTmp.get(calculActiviteTmp.size() - 1).getDateJour() : null;
                Transport.ps.endOperation(PerformanceScanner.PROCESS, "#TTS.loadActivite# requ\u00eate getActiviteConducteurService : " + calculActiviteTmp.size() + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es", "#TTS.loadActivite# requ\u00eate getActiviteConducteurService : " + calculActiviteTmp.size() + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es entre le " + firstDay + " et le " + lastDay + " : %s", 1);
                if (calculActiviteTmp.size() != 0) {
                    Transport.ps.startOperation();
                    calendrier.setTime(dateFormat.parse(this.dateDebutAnalyse));
                    ActiviteConducteur act = null;
                    int i = 0;
                    int before = 0;
                    boolean after = false;
                    while (i <= calculActiviteTmp.size() - 1) {
                        act = calculActiviteTmp.get(i);
                        while (calendrier.getTime().compareTo(act.getDate()) < 0) {
                            this.vectActivite.add(new ActiviteConducteur(0, this.conducteur.getCleConducteur(), 0, 4, "REPOS", "", 0, 1440, 1440, dateFormat.format(calendrier.getTime()), "", "", "", "", "", 0, 0, 0));
                            ++before;
                            calendrier.add(5, 1);
                        }
                        while (act.getDate().equals(calendrier.getTime()) && i <= calculActiviteTmp.size() - 1) {
                            this.vectActivite.add(act);
                            if (++i > calculActiviteTmp.size() - 1) break;
                            act = calculActiviteTmp.get(i);
                        }
                        calendrier.add(5, 1);
                    }
                    if (!this.vectActivite.get(this.vectActivite.size() - 1).equals(act)) {
                        this.vectActivite.add(act);
                    }
                    firstDay = this.vectActivite.size() != 0 ? this.vectActivite.get(0).getDateJour() : null;
                    lastDay = this.vectActivite.size() != 0 ? this.vectActivite.get(this.vectActivite.size() - 1).getDateJour() : null;
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("Impossible de r\u00e9cup\u00e9rer les activit\u00e9s conducteurs." + ex);
                if (Transport.debug < 1) break block12;
                ex.printStackTrace();
            }
        }
        if (!this.noServiceBefore) {
            this.getBeginAnalysis();
        }
        if (!this.noServiceAfter) {
            this.getEndAnalysis();
        }
        this.activities = new ArrayList();
        this.vehicleUsed = VehicleUsed.loadListDriver(this.conducteur.getCleConducteur(), 0, this.dateDebutAnalyse, this.dateFinAnalyse);
        if (this.dateDebut.equals(this.dateDebutAnalyse)) {
            (String.valueOf(ConversionTime.addDay(this.dateFin, "yyyy-MM-dd", 1)) + " 00:00:00").equals(this.dateFinAnalyse);
        }
    }

    public void getBeginAnalysis() {
        if (this.vectActivite.size() == 0) {
            return;
        }
        ActiviteConducteur activite = this.vectActivite.get(0);
        String day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
        while (!day.equals(this.dateDebutAnalyse)) {
            this.vectActivite.remove(0);
            if (this.vectActivite.size() == 0) {
                return;
            }
            activite = this.vectActivite.get(0);
            day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
        }
    }

    public void getEndAnalysis() {
        if (this.vectActivite.size() == 0) {
            return;
        }
        ActiviteConducteur activite = this.vectActivite.get(0);
        String day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
        int offset = 0;
        while (offset < this.vectActivite.size()) {
            if (day.equals(this.dateFinAnalyse)) break;
            activite = this.vectActivite.get(offset);
            day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
            ++offset;
        }
        while (offset != this.vectActivite.size()) {
            activite = this.vectActivite.get(offset);
            day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
            this.vectActivite.remove(offset);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void calculService() throws ServiceException {
        if (this.vectActivite.size() != 0) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            ++this.indexActiviteCourante;
lbl4:
            // 2 sources

            ** while (this.vectActivite.get((int)this.indexActiviteCourante).getCleType() == 4 || this.vectActivite.get((int)this.indexActiviteCourante).getCleType() == 7)
        }
lbl5:
        // 1 sources

        try {
            rest = 0;
            firstWork = 0;
            lastWork = 0;
            firstWorkAfterRest = 0;
            secondWorkAfterRest = 0;
            firstRest = false;
            restFound = false;
            firstDrive = false;
            firstDriveAfterRest = false;
            secondDriveAfterRest = false;
            hardnessNight = 0;
            numActiviteDebut = this.indexActiviteCourante;
            numActiviteFin = this.vectActivite.size() - 1;
            amplitude = 0;
            heureNuit = 0;
            reposMax = 0;
            stop = 0;
            tmpStop = 0;
            distance = 0.0f;
            isDriving = true;
            while (this.indexActiviteCourante < this.vectActivite.size()) {
                repos = 0;
                if (this.indexActiviteCourante == this.vectActivite.size() - 1) {
                    this.lastActivityProcessed = true;
                }
                if ((activite = this.vectActivite.get(this.indexActiviteCourante)).getCleType() == 1) {
                    if (activite.getDuree() > CorrectionActiviteDetail.DRIVE_TIME_MINIMUM) {
                        if (!firstDrive) {
                            firstDrive = true;
                        } else if (restFound && !firstDriveAfterRest) {
                            firstDriveAfterRest = true;
                        } else if (firstDriveAfterRest && !secondDriveAfterRest) {
                            secondDriveAfterRest = true;
                        }
                        stop += tmpStop;
                        tmpStop = 0;
                        lastWork = 0;
                    } else if (!System.getProperty("company", "PGH").equals("salvesen")) {
                        if (!firstDrive) {
                            firstWork += activite.getDuree();
                        } else if (restFound && !firstDriveAfterRest) {
                            firstWorkAfterRest += activite.getDuree();
                        } else if (firstDriveAfterRest && !secondDriveAfterRest) {
                            secondWorkAfterRest += activite.getDuree();
                        }
                        lastWork += activite.getDuree();
                    }
                    isDriving = true;
                    this.dureeC += activite.getDuree();
                    heureNuit += Fonctions.getTempsNuit(activite);
                    hardnessNight += Fonctions.getTimeBetween(activite, 0, 300);
                    distance += activite.getAvgDistance();
                } else if (activite.getCleType() == 2) {
                    if (!firstDrive) {
                        firstWork += activite.getDuree();
                    } else if (restFound && !firstDriveAfterRest) {
                        firstWorkAfterRest += activite.getDuree();
                    } else if (firstDriveAfterRest && !secondDriveAfterRest) {
                        secondWorkAfterRest += activite.getDuree();
                    }
                    lastWork += activite.getDuree();
                    if (firstDrive && isDriving) {
                        isDriving = false;
                        ++tmpStop;
                    }
                    this.dureeT += activite.getDuree();
                    heureNuit += Fonctions.getTempsNuit(activite);
                    hardnessNight += Fonctions.getTimeBetween(activite, 0, 300);
                } else if (activite.getCleType() == 3) {
                    if (!firstDrive) {
                        firstWork += activite.getDuree();
                    } else if (restFound && !firstDriveAfterRest) {
                        firstWorkAfterRest += activite.getDuree();
                    } else if (firstDriveAfterRest && !secondDriveAfterRest) {
                        secondWorkAfterRest += activite.getDuree();
                    }
                    lastWork += activite.getDuree();
                    if (firstDrive && isDriving && activite.getDuree() >= CorrectionActiviteDetail.STOP_TIME_MINIMUM) {
                        isDriving = false;
                        ++tmpStop;
                    }
                    this.dureeD += activite.getDuree();
                    heureNuit += Fonctions.getTempsNuit(activite);
                    hardnessNight += Fonctions.getTimeBetween(activite, 0, 300);
                } else if (activite.getCleType() == 5) {
                    this.dureeDE += activite.getDuree();
                    heureNuit += Fonctions.getTempsNuit(activite);
                    hardnessNight += Fonctions.getTimeBetween(activite, 0, 300);
                } else if (activite.getCleType() == 4 || activite.getCleType() == 7) {
                    numActiviteFin = this.indexActiviteCourante - 1;
                    repos = this.getRepos();
                    if (!restFound && (!firstRest && repos >= 15 || firstRest && repos >= 30)) {
                        firstRest = true;
                        if ((rest += repos) >= 45) {
                            restFound = true;
                        }
                    }
                } else {
                    tmp = TypeActivite.getActivityType(activite.getCleType());
                    this.dureeA += activite.getDuree() * tmp.getPaidPercentage() / 100;
                    heureNuit += Fonctions.getTempsNuit(activite) * tmp.getPaidPercentage() / 100;
                }
                if (TypeActivite.getActivityType(activite.getCleType()).getPaidPercentage() != 0) {
                    beginTime = activite.getDate().getTime() + (long)(activite.getHeureDebut() * 60000);
                    endTime = activite.getDate().getTime() + (long)(activite.getHeureFin() * 60000);
                    used = this.findUsedVehicle(beginTime, endTime);
                    this.activities.add(new ActivityDetail(0, new Date(beginTime), new Date(endTime), this.conducteur.getCleConducteur(), used != null ? used.getCleVehicule() : 0, used != null ? used.getImmatriculation() : "INCONNU", activite.getCleType(), activite.getAvgDistance()));
                }
                if (repos >= 540 || this.indexActiviteCourante >= this.vectActivite.size() - 1) {
                    dateDebut = this.vectActivite.get(numActiviteDebut).getDateJour();
                    dateFin = this.vectActivite.get(numActiviteFin).getDateJour();
                    heureDebut = this.vectActivite.get(numActiviteDebut).getHeureDebut();
                    heureFin = this.vectActivite.get(numActiviteFin).getHeureFin();
                    if (heureFin == 1440) {
                        dateFin = ConversionTime.addDay(dateFin, "yyyy-MM-dd", 1);
                        heureFin = 0;
                    }
                    amplitude = heureFin - heureDebut;
                    amplitude += ConversionTime.getNbJourBetween(dateDebut, dateFin, "yyyy-MM-dd") * 1440;
                    cumulService = this.dureeC + this.dureeT + this.dureeD + this.dureeDE + this.dureeA;
                    if (this.indexActiviteCourante == this.vectActivite.size()) {
                        if (!this.lastActivityProcessed) {
                            --this.indexActiviteCourante;
                        }
                        repos = 9999;
                    }
                    if (!this.dateFinAnalyse.equals((tmp = new Service(this.conducteur.getCleConducteur(), dateDebut, dateFin, heureDebut, heureFin, this.dureeC, this.dureeT, this.dureeD, this.dureeR, this.dureeDE, this.dureeI, this.dureeA, cumulService, reposMax, repos, amplitude, heureNuit, hardnessNight, 0.0f, Math.round(distance), firstWork, lastWork, firstWorkAfterRest, secondWorkAfterRest, 0, 0, stop)).getBeginDate())) {
                        this.listeService.add(tmp);
                    }
                    if (!this.lastActivityProcessed) {
                        repos = 0;
                        this.dureeC = 0;
                        this.dureeT = 0;
                        this.dureeD = 0;
                        this.dureeR = 0;
                        this.dureeDE = 0;
                        this.dureeI = 0;
                        this.dureeA = 0;
                        this.calculService();
                    }
                    break;
                }
                if (repos > reposMax) {
                    reposMax = repos;
                }
                if (activite.getCleType() == 4 || activite.getCleType() == 7) {
                    --this.indexActiviteCourante;
                }
                ++this.indexActiviteCourante;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException();
        }
    }

    private VehicleUsed findUsedVehicle(long beginTime, long endTime) {
        if (this.vehicleUsed == null) {
            return null;
        }
        int x = 0;
        while (x < this.vehicleUsed.size()) {
            VehicleUsed vu = this.vehicleUsed.get(x);
            long begin = ConversionTime.clearSeconds(vu.getDateDebut()).getTime();
            long end = ConversionTime.clearSeconds(vu.getDateFin()).getTime();
            if (end < beginTime) {
                this.vehicleUsed.remove(x);
                --x;
            } else {
                if (begin <= beginTime) {
                    VehicleUsed next;
                    if (end >= endTime) {
                        return this.vehicleUsed.get(x);
                    }
                    VehicleUsed vehicleUsed = next = x < this.vehicleUsed.size() - 1 ? this.vehicleUsed.get(x + 1) : null;
                    if (next != null && next.getCleVehicule() == vu.getCleVehicule() && next.getDateFin().getTime() >= endTime) {
                        return this.vehicleUsed.get(x);
                    }
                }
                if (begin > endTime) break;
            }
            ++x;
        }
        return null;
    }

    public void afficheService() {
    }

    public boolean saveListe() throws ServiceException {
        this.afficheService();
        boolean toReturn = false;
        Transport.ps.startOperation();
        ActivityDetail.deleteAll(this.conducteur.getCleConducteur(), this.dateDebutAnalyse, this.dateFinAnalyse);
        try {
            int random = (int)(Math.random() * 1000.0);
            String actFn = String.valueOf(Transport.savePath) + "activity" + random + ".txt";
            while (new File(actFn).exists()) {
                random = (int)(Math.random() * 1000.0);
                actFn = String.valueOf(Transport.savePath) + "activity" + random + ".txt";
            }
            FileWriter fAct = new FileWriter(actFn);
            for (ActivityDetail act : this.activities) {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    act.insert();
                }
                if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                fAct.write(act.getSqlString());
                fAct.write("\n");
            }
            fAct.close();
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                boolean success = true;
                long time = Transport.ps.startAbsoluteTime();
                if (!Transport.bdd.loadActivityDetail(actFn)) {
                    success = false;
                }
                toReturn = success;
            }
            new File(actFn).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException();
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#CorrectionActiviteDetail.calsaveListe# saveliste time");
        return toReturn;
    }
}

