/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.traitement;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.ActivityDetail;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.ExpensesValidation;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.exception.DriverNotFoundException;
import fr.pgh.exception.ServiceException;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;

public class TraitementTempsService {
    public static final int SEUIL_RJ = 540;
    Conducteur conducteur = null;
    String dateDebut = null;
    String dateFin = null;
    String dateDebutAnalyse = null;
    String dateFinAnalyse = null;
    Vector<ActiviteConducteur> vectActivite = null;
    Vector<Service> listeService = null;
    Vector<DriverExpenses> listeFrais = null;
    int indexActiviteCourante = 0;
    boolean calculFrais = false;
    boolean lastActivityProcessed = false;
    int dureeC = 0;
    int dureeT = 0;
    int dureeD = 0;
    int dureeR = 0;
    int dureeDE = 0;
    int dureeI = 0;
    int dureeA = 0;
    static final int DAY_COUNT = 7;
    private int extraEndDay = 0;
    private int extraBeginDay = 0;
    private boolean noServiceBefore = false;
    private boolean noServiceAfter = false;
    public static int STOP_TIME_MINIMUM = 1;
    public static int DRIVE_TIME_MINIMUM = 5;
    boolean createData = true;
    Vector<ExpensesType> listeTypeFrais = null;
    boolean extendVehicleInformation = false;
    Vector<VehicleUsed> vehicleUsed = null;
    ArrayList<ActivityDetail> activities = null;

    public TraitementTempsService(Conducteur cond, String dateD, String dateF, boolean calcul) {
        this.conducteur = cond;
        this.dateDebut = dateD;
        this.dateFin = ConversionTime.addDay(dateF, "yyyy-MM-dd", 2).substring(0, 10);
        this.calculFrais = calcul;
        this.extendVehicleInformation = new Boolean(System.getProperty("activity.vehicle.detail", "false"));
        TimsLogger.debug("#TraitementTempsService# cond " + cond.getCleConducteur() + " dateD = " + this.dateDebut + " dateF = " + this.dateFin);
    }

    public TraitementTempsService(int cond, String dateD, String dateF, boolean calcul) throws DriverNotFoundException {
        this(Conducteur.getDriver(null, cond), dateD, dateF, calcul);
    }

    private int getRepos() {
        int cumulInconnu = 0;
        int cumulRepos = 0;
        int dureeRepos = 0;
        ActiviteConducteur activite = this.vectActivite.get(this.indexActiviteCourante);
        while (activite.getCleType() == 4 || activite.getCleType() == 7) {
            if (this.indexActiviteCourante == this.vectActivite.size() - 1) {
                TimsLogger.debug("#TTS.getRepos# on boucle sur la derni\u00e8re activit\u00e9");
                this.lastActivityProcessed = true;
            }
            if (activite.getCleType() == 4) {
                cumulRepos += activite.getDuree();
            }
            if (activite.getCleType() == 7) {
                cumulInconnu += activite.getDuree();
            }
            dureeRepos += activite.getDuree();
            ++this.indexActiviteCourante;
            if (this.lastActivityProcessed) break;
            activite = this.vectActivite.get(this.indexActiviteCourante);
        }
        if (dureeRepos < 540) {
            this.dureeI += cumulInconnu;
            this.dureeR += cumulRepos;
        }
        return dureeRepos;
    }

    private void loardMoreEndActivity() {
        this.extraEndDay += 7;
        this.loadActivite();
    }

    private void loadMoreBeginActivite() {
        this.extraBeginDay += 7;
        this.loadActivite();
    }

    public void loadActivite() {
        block15: {
            this.listeService = new Vector();
            this.listeFrais = new Vector();
            this.vectActivite = new Vector();
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                GregorianCalendar calendrier = new GregorianCalendar();
                this.dateDebutAnalyse = Service.getPreviousService(this.conducteur.getCleConducteur(), this.dateDebut);
                this.dateFinAnalyse = Service.getNextService(this.conducteur.getCleConducteur(), this.dateFin);
                if (this.dateDebutAnalyse == null) {
                    TimsLogger.debug("#TTS.loadActivite# pas de service avant");
                    this.dateDebutAnalyse = this.dateDebut;
                    this.noServiceBefore = true;
                }
                if (this.dateFinAnalyse == null) {
                    TimsLogger.debug("#TTS.loadActivite# pas de service apr\u00e8s");
                    this.dateFinAnalyse = this.dateFin;
                    this.noServiceAfter = true;
                }
                TimsLogger.debug("#TTS.loadActivite# on r\u00e9cup\u00e8re les informations entre le " + this.dateDebutAnalyse + " et le " + this.dateFinAnalyse);
                Transport.ps.startOperation();
                Vector<ActiviteConducteur> calculActiviteTmp = Transport.bdd.getActivite(this.conducteur.getCleConducteur(), this.dateDebutAnalyse, this.dateFinAnalyse, -1, 0);
                String firstDay = calculActiviteTmp.size() != 0 ? calculActiviteTmp.get(0).getDateJour() : null;
                String lastDay = calculActiviteTmp.size() != 0 ? calculActiviteTmp.get(calculActiviteTmp.size() - 1).getDateJour() : null;
                Transport.ps.endOperation(PerformanceScanner.PROCESS, "#TTS.loadActivite# requ\u00eate getActiviteConducteurService : " + calculActiviteTmp.size() + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es", "#TTS.loadActivite# requ\u00eate getActiviteConducteurService : " + calculActiviteTmp.size() + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es entre le " + firstDay + " et le " + lastDay + " : %s", 1);
                if (calculActiviteTmp.size() != 0) {
                    Transport.ps.startOperation();
                    calendrier.setTime(dateFormat.parse(this.dateDebutAnalyse));
                    ActiviteConducteur act = null;
                    int i = 0;
                    int before = 0;
                    int after = 0;
                    while (i <= calculActiviteTmp.size() - 1) {
                        act = calculActiviteTmp.get(i);
                        while (calendrier.getTime().compareTo(act.getDate()) < 0) {
                            this.vectActivite.add(new ActiviteConducteur(0, this.conducteur.getCleConducteur(), 0, 4, "REPOS", "", 0, 1440, 1440, dateFormat.format(calendrier.getTime()), "", "", "", "", "", 0, 0, 0));
                            ++before;
                            calendrier.add(5, 1);
                        }
                        while (act.getDate().equals(calendrier.getTime()) && i <= calculActiviteTmp.size() - 1) {
                            this.vectActivite.add(act);
                            if (++i > calculActiviteTmp.size() - 1) break;
                            act = calculActiviteTmp.get(i);
                        }
                        calendrier.add(5, 1);
                    }
                    if (!this.vectActivite.get(this.vectActivite.size() - 1).equals(act)) {
                        this.vectActivite.add(act);
                    }
                    firstDay = this.vectActivite.size() != 0 ? this.vectActivite.get(0).getDateJour() : null;
                    lastDay = this.vectActivite.size() != 0 ? this.vectActivite.get(this.vectActivite.size() - 1).getDateJour() : null;
                    Transport.ps.endOperation(PerformanceScanner.PROCESS, "#TTS.loadActivite# ajout des journ\u00e9es absentes : " + before + " avant, " + after + " apr\u00e8s", "#TTS.loadActivite# ajout des journ\u00e9es absentes : " + before + " avant, " + after + " apr\u00e8s entre le " + firstDay + " et le " + lastDay + " : %s", 1);
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("Impossible de r\u00e9cup\u00e9rer les activit\u00e9s conducteurs." + ex);
                if (Transport.debug < 1) break block15;
                ex.printStackTrace();
            }
        }
        if (!this.noServiceBefore) {
            this.getBeginAnalysis();
        } else {
            TimsLogger.debug("#TTS.loadActivite# pas besoin de trouver le d\u00e9but, on n'a pas de jours avant la date de d\u00e9but");
        }
        if (!this.noServiceAfter) {
            this.getEndAnalysis();
        } else {
            TimsLogger.debug("#TTS.loadActivite# pas besoin de trouver la fin, on n'a pas de service apr\u00e8s le jour");
        }
        TimsLogger.debug("#TTS.loadActivite# on a charg\u00e9 les activites pour calculer les services entre le " + this.dateDebut + " et le " + this.dateFin + ". dateDebutAnalyse : " + this.dateDebutAnalyse + " dateFinAnalyse : " + this.dateFinAnalyse + (this.extendVehicleInformation ? " (avec extension)" : " (sans extension)"));
        if (this.extendVehicleInformation) {
            this.activities = new ArrayList();
            this.vehicleUsed = VehicleUsed.loadListDriver(this.conducteur.getCleConducteur(), 0, this.dateDebutAnalyse, this.dateFinAnalyse);
            TimsLogger.debug(String.valueOf(this.vehicleUsed.size()) + " utilisations de v\u00e9hicules charg\u00e9s");
        }
        if (this.dateDebut.equals(this.dateDebutAnalyse) && (String.valueOf(ConversionTime.addDay(this.dateFin, "yyyy-MM-dd", 1)) + " 00:00:00").equals(this.dateFinAnalyse)) {
            TimsLogger.debug("#TTS.loadActivite# on n'a pas de d\u00e9bordement...");
        }
    }

    public void getBeginAnalysis() {
        TimsLogger.debug("#TTS.getBeginAnalysis# delete all activities before " + this.dateDebutAnalyse);
        if (this.vectActivite.size() == 0) {
            return;
        }
        ActiviteConducteur activite = this.vectActivite.get(0);
        String day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
        while (!day.equals(this.dateDebutAnalyse)) {
            TimsLogger.debug("#TTS.getBeginAnalysis# remove " + day);
            this.vectActivite.remove(0);
            if (this.vectActivite.size() == 0) {
                return;
            }
            activite = this.vectActivite.get(0);
            day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
        }
    }

    public void getEndAnalysis() {
        TimsLogger.debug("#TTS.getEndAnalysis# on cherche l'activit\u00e9 apr\u00e8s le " + this.dateFinAnalyse);
        if (this.vectActivite.size() == 0) {
            return;
        }
        ActiviteConducteur activite = this.vectActivite.get(0);
        String day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
        int offset = 0;
        while (offset < this.vectActivite.size()) {
            if (day.equals(this.dateFinAnalyse)) {
                TimsLogger.debug("#TTS.getEndAnalysis# on s'arrete \u00e0 " + day + "(offset " + offset + ")");
                break;
            }
            activite = this.vectActivite.get(offset);
            day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
            ++offset;
        }
        TimsLogger.debug("#TTS.getEndAnalysis# on supprime les activit\u00e9s \u00e0 partir de l'offset " + offset);
        while (offset != this.vectActivite.size()) {
            activite = this.vectActivite.get(offset);
            day = String.valueOf(activite.getDateJour()) + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), ":") + ":00";
            TimsLogger.debug("#TTS.getEndAnalysis# remove " + day);
            this.vectActivite.remove(offset);
        }
    }

    public void calculService() throws ServiceException {
        if (this.vectActivite.size() == 0) {
            TimsLogger.debug("#TTS.calculService# pas d'activit\u00e9, on devra donc simplement supprimer les services existants...");
            return;
        }
        TimsLogger.debug("#TTS.calculService# passage n\u00b0" + this.listeService.size());
        while (this.vectActivite.get(this.indexActiviteCourante).getCleType() == 4 || this.vectActivite.get(this.indexActiviteCourante).getCleType() == 7) {
            ++this.indexActiviteCourante;
            TimsLogger.warn("#TTS.calculService# activit\u00e9 de repos avant d\u00e9but du calcul : " + (this.indexActiviteCourante + 1));
        }
        try {
            int rest = 0;
            int firstWork = 0;
            int lastWork = 0;
            int firstWorkAfterRest = 0;
            int secondWorkAfterRest = 0;
            boolean firstRest = false;
            boolean restFound = false;
            boolean firstDrive = false;
            boolean firstDriveAfterRest = false;
            boolean secondDriveAfterRest = false;
            int hardnessNight = 0;
            int numActiviteDebut = this.indexActiviteCourante;
            int numActiviteFin = this.vectActivite.size() - 1;
            int amplitude = 0;
            int heureNuit = 0;
            int reposMax = 0;
            int stop = 0;
            int tmpStop = 0;
            float distance = 0.0f;
            boolean isDriving = true;
            while (this.indexActiviteCourante < this.vectActivite.size()) {
                int repos = 0;
                if (this.indexActiviteCourante == this.vectActivite.size() - 1) {
                    TimsLogger.debug("#TTS.calculService# on boucle sur la derni\u00e8re activit\u00e9");
                    this.lastActivityProcessed = true;
                }
                ActiviteConducteur activite = this.vectActivite.get(this.indexActiviteCourante);
                TimsLogger.debug("#TTS.calculService# " + (this.indexActiviteCourante + 1) + " on " + this.vectActivite.size() + " : " + activite.getDateJour() + " " + ConversionTime.heureIntToString(activite.getHeureDebut(), "h") + " " + ConversionTime.heureIntToString(activite.getHeureFin(), "h") + " " + activite.getCleType());
                if (activite.getCleType() == 1) {
                    if (activite.getDuree() > DRIVE_TIME_MINIMUM) {
                        if (!firstDrive) {
                            firstDrive = true;
                        } else if (restFound && !firstDriveAfterRest) {
                            firstDriveAfterRest = true;
                        } else if (firstDriveAfterRest && !secondDriveAfterRest) {
                            secondDriveAfterRest = true;
                        }
                        stop += tmpStop;
                        tmpStop = 0;
                        lastWork = 0;
                    } else if (!System.getProperty("company", "PGH").equals("salvesen")) {
                        if (!firstDrive) {
                            firstWork += activite.getDuree();
                        } else if (restFound && !firstDriveAfterRest) {
                            firstWorkAfterRest += activite.getDuree();
                        } else if (firstDriveAfterRest && !secondDriveAfterRest) {
                            secondWorkAfterRest += activite.getDuree();
                        }
                        lastWork += activite.getDuree();
                    }
                    isDriving = true;
                    this.dureeC += activite.getDuree();
                    heureNuit += Fonctions.getTempsNuit(activite);
                    hardnessNight += Fonctions.getTimeBetween(activite, 0, 300);
                    distance += activite.getAvgDistance();
                    TimsLogger.debug("#TTS.calculService# add distance " + activite.getAvgDistance() + " (" + activite.getDuree() + " min)");
                } else if (activite.getCleType() == 2) {
                    if (!firstDrive) {
                        firstWork += activite.getDuree();
                    } else if (restFound && !firstDriveAfterRest) {
                        firstWorkAfterRest += activite.getDuree();
                    } else if (firstDriveAfterRest && !secondDriveAfterRest) {
                        secondWorkAfterRest += activite.getDuree();
                    }
                    lastWork += activite.getDuree();
                    if (firstDrive && isDriving) {
                        isDriving = false;
                        ++tmpStop;
                    }
                    this.dureeT += activite.getDuree();
                    heureNuit += Fonctions.getTempsNuit(activite);
                    hardnessNight += Fonctions.getTimeBetween(activite, 0, 300);
                } else if (activite.getCleType() == 3) {
                    if (!firstDrive) {
                        firstWork += activite.getDuree();
                    } else if (restFound && !firstDriveAfterRest) {
                        firstWorkAfterRest += activite.getDuree();
                    } else if (firstDriveAfterRest && !secondDriveAfterRest) {
                        secondWorkAfterRest += activite.getDuree();
                    }
                    lastWork += activite.getDuree();
                    if (firstDrive && isDriving && activite.getDuree() >= STOP_TIME_MINIMUM) {
                        isDriving = false;
                        ++tmpStop;
                    }
                    this.dureeD += activite.getDuree();
                    heureNuit += Fonctions.getTempsNuit(activite);
                    hardnessNight += Fonctions.getTimeBetween(activite, 0, 300);
                } else if (activite.getCleType() == 5) {
                    this.dureeDE += activite.getDuree();
                    heureNuit += Fonctions.getTempsNuit(activite);
                    hardnessNight += Fonctions.getTimeBetween(activite, 0, 300);
                } else if (activite.getCleType() == 4 || activite.getCleType() == 7) {
                    numActiviteFin = this.indexActiviteCourante - 1;
                    repos = this.getRepos();
                    if (!restFound && (!firstRest && repos >= 15 || firstRest && repos >= 30)) {
                        firstRest = true;
                        if ((rest += repos) >= 45) {
                            TimsLogger.verbose("#TTS.calculService# rest >45 at " + (double)activite.getHeureDebut() / 60.0);
                            restFound = true;
                        }
                    }
                } else {
                    TypeActivite tmp = TypeActivite.getActivityType(activite.getCleType());
                    this.dureeA += activite.getDuree() * tmp.getPaidPercentage() / 100;
                    heureNuit += Fonctions.getTempsNuit(activite) * tmp.getPaidPercentage() / 100;
                }
                if (this.extendVehicleInformation && TypeActivite.getActivityType(activite.getCleType()).getPaidPercentage() != 0) {
                    long beginTime = activite.getDate().getTime() + (long)(activite.getHeureDebut() * 60000);
                    long endTime = activite.getDate().getTime() + (long)(activite.getHeureFin() * 60000);
                    VehicleUsed used = this.findUsedVehicle(beginTime, endTime);
                    this.activities.add(new ActivityDetail(0, new Date(beginTime), new Date(endTime), this.conducteur.getCleConducteur(), used != null ? used.getCleVehicule() : 0, used != null ? used.getImmatriculation() : "INCONNU", activite.getCleType(), activite.getAvgDistance()));
                }
                TimsLogger.debug("#TTS.calculService# " + this.indexActiviteCourante + ", " + repos + " minutes de repos");
                if (repos >= 540 || this.indexActiviteCourante >= this.vectActivite.size() - 1) {
                    String dateDebut = this.vectActivite.get(numActiviteDebut).getDateJour();
                    String dateFin = this.vectActivite.get(numActiviteFin).getDateJour();
                    int heureDebut = this.vectActivite.get(numActiviteDebut).getHeureDebut();
                    int heureFin = this.vectActivite.get(numActiviteFin).getHeureFin();
                    if (heureFin == 1440) {
                        dateFin = ConversionTime.addDay(dateFin, "yyyy-MM-dd", 1);
                        heureFin = 0;
                    }
                    amplitude = heureFin - heureDebut;
                    amplitude += ConversionTime.getNbJourBetween(dateDebut, dateFin, "yyyy-MM-dd") * 1440;
                    int cumulService = this.dureeC + this.dureeT + this.dureeD + this.dureeDE + this.dureeA;
                    if (this.indexActiviteCourante == this.vectActivite.size()) {
                        if (!this.lastActivityProcessed) {
                            --this.indexActiviteCourante;
                        }
                        repos = 9999;
                    }
                    TimsLogger.debug("#TTS.calculService# service de (" + numActiviteDebut + ") " + dateDebut + "  " + ConversionTime.heureIntToString(heureDebut, "h") + " au (" + numActiviteFin + ") " + dateFin + " " + ConversionTime.heureIntToString(heureFin, "h") + " added km = " + distance + " -> " + Math.round(distance) + " repos = " + repos);
                    Service tmp = new Service(this.conducteur.getCleConducteur(), dateDebut, dateFin, heureDebut, heureFin, this.dureeC, this.dureeT, this.dureeD, this.dureeR, this.dureeDE, this.dureeI, this.dureeA, cumulService, reposMax, repos, amplitude, heureNuit, hardnessNight, 0.0f, Math.round(distance), firstWork, lastWork, firstWorkAfterRest, secondWorkAfterRest, 0, 0, stop);
                    if (this.dateFinAnalyse.equals(tmp.getBeginDate())) {
                        TimsLogger.debug("#TTS.calculService# ce service est d\u00e9j\u00e0 inscrit dans la base");
                    } else {
                        this.listeService.add(tmp);
                    }
                    if (this.calculFrais) {
                        TimsLogger.debug("#TTS.calculService()# Check expenses in service " + dateDebut + " " + ConversionTime.heureIntToString(heureDebut, "h"));
                        boolean validated = false;
                        if (ConnexionSettings.getInstance().isConsultable("EXPENSES_VALIDATION")) {
                            validated = ExpensesValidation.checkLocked(ConversionTime.stringToDate(dateDebut, "yyyy-MM-dd"), this.conducteur.getCleConducteur());
                        }
                        if (!validated) {
                            Vector<DriverExpenses> servExpenses = new Vector<DriverExpenses>();
                            for (ExpensesType tf : ExpensesType.getList()) {
                                if (!tf.isActif() || tf.getEmployeeTypeId() != 0 && (tf.getEmployeeTypeId() != this.conducteur.getCleTypeConducteur() || repos >= 1440) || !Fonctions.shouldAddExpensesByBeginEnd(tf, this.vectActivite.get(numActiviteDebut).getDate(), heureDebut, heureFin) && !Fonctions.shouldAddExpensesByAmount(tf, this.vectActivite, numActiviteDebut, numActiviteFin) && (this.lastActivityProcessed || !Fonctions.shouldAddExpenseByPosition(tf, tmp, this.conducteur))) continue;
                                TimsLogger.debug("#TTS.calculService()# ExpensesType " + tf.getCode() + " found in service begining on " + dateDebut + " " + ConversionTime.heureIntToString(heureDebut, "h"));
                                Date date = ConversionTime.stringToDate(dateDebut, "yyyy-MM-dd");
                                float amount = tf.getMontant(date, 0);
                                if (!(tmp.getBeginDate().substring(0, 10).equals(tmp.getEndDate().substring(0, 10)) || heureDebut < tf.getHour() && tf.getHour() < 1440)) {
                                    date = ConversionTime.stringToDate(dateFin, "yyyy-MM-dd");
                                }
                                servExpenses.add(new DriverExpenses(0, this.conducteur.getCleConducteur(), date, tf.getCle(), true, 0.0f, 0.0f, amount, false, 1));
                            }
                            Fonctions.checkExpenseQuenchers(servExpenses);
                            this.listeFrais.addAll(servExpenses);
                        }
                    }
                    if (!this.lastActivityProcessed) {
                        repos = 0;
                        this.dureeC = 0;
                        this.dureeT = 0;
                        this.dureeD = 0;
                        this.dureeR = 0;
                        this.dureeDE = 0;
                        this.dureeI = 0;
                        this.dureeA = 0;
                        this.calculService();
                    }
                    break;
                }
                if (repos > reposMax) {
                    reposMax = repos;
                }
                if (activite.getCleType() == 4 || activite.getCleType() == 7) {
                    --this.indexActiviteCourante;
                }
                ++this.indexActiviteCourante;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException();
        }
    }

    private VehicleUsed findUsedVehicle(long beginTime, long endTime) {
        TimsLogger.debug("#TTS.findUsedVehicle# on cherche le vehicule entre " + beginTime + " et " + endTime);
        if (this.vehicleUsed == null) {
            return null;
        }
        int x = 0;
        while (x < this.vehicleUsed.size()) {
            VehicleUsed vu = this.vehicleUsed.get(x);
            long begin = ConversionTime.clearSeconds(vu.getDateDebut()).getTime();
            long end = ConversionTime.clearSeconds(vu.getDateFin()).getTime();
            if (end < beginTime) {
                TimsLogger.debug("#TTS.findUsedVehicle# on enleve " + this.vehicleUsed.get(x).getCleVehicule() + " (" + this.vehicleUsed.get(x).getImmatriculation() + " : " + this.vehicleUsed.get(x).getDateDebut() + " " + this.vehicleUsed.get(x).getDateFin());
                this.vehicleUsed.remove(x);
                --x;
            } else {
                if (begin <= beginTime) {
                    VehicleUsed next;
                    if (end >= endTime) {
                        TimsLogger.debug("#TTS.findUsedVehicle# on a trouv\u00e9 " + this.vehicleUsed.get(x).getCleVehicule() + " (" + this.vehicleUsed.get(x).getImmatriculation() + " : " + this.vehicleUsed.get(x).getDateDebut() + " " + this.vehicleUsed.get(x).getDateFin());
                        return this.vehicleUsed.get(x);
                    }
                    VehicleUsed vehicleUsed = next = x < this.vehicleUsed.size() - 1 ? this.vehicleUsed.get(x + 1) : null;
                    if (next != null && next.getCleVehicule() == vu.getCleVehicule() && next.getDateFin().getTime() >= endTime) {
                        TimsLogger.debug("#TTS.findUsedVehicle# on a trouv\u00e9 " + this.vehicleUsed.get(x).getCleVehicule() + " (" + this.vehicleUsed.get(x).getImmatriculation() + " : " + this.vehicleUsed.get(x).getDateDebut() + " " + this.vehicleUsed.get(x).getDateFin());
                        return this.vehicleUsed.get(x);
                    }
                }
                if (begin > endTime) break;
            }
            ++x;
        }
        TimsLogger.debug("#TTS.findUsedVehicle# rien trouv\u00e9");
        return null;
    }

    public void afficheService() {
        if (Transport.debug >= 1) {
            TimsLogger.debug("#TTS.afficheService# on doit supprimer les services entre " + this.dateDebutAnalyse + " et " + this.dateFinAnalyse);
            if (this.listeService.size() == 0) {
                TimsLogger.debug("#TTS.afficheService# no service");
            }
            Iterator<Service> iter = this.listeService.iterator();
            while (iter.hasNext()) {
                iter.next().affiche();
            }
        }
    }

    public boolean saveListe() throws ServiceException {
        this.afficheService();
        boolean toReturn = false;
        Transport.ps.startOperation();
        Transport.bdd.delPeriodeService(this.conducteur.getCleConducteur(), this.dateDebutAnalyse, this.dateFinAnalyse);
        if (this.extendVehicleInformation) {
            ActivityDetail.deleteAll(this.conducteur.getCleConducteur(), this.dateDebutAnalyse, this.dateFinAnalyse);
        }
        try {
            int random = (int)(Math.random() * 1000.0);
            String serviceFn = String.valueOf(Transport.savePath) + "service" + random + ".txt";
            while (new File(serviceFn).exists()) {
                random = (int)(Math.random() * 1000.0);
                serviceFn = String.valueOf(Transport.savePath) + "service" + random + ".txt";
            }
            String expFn = String.valueOf(Transport.savePath) + "frais" + random + ".txt";
            String actFn = String.valueOf(Transport.savePath) + "activity" + random + ".txt";
            FileWriter fexp = new FileWriter(expFn);
            FileWriter fService = new FileWriter(serviceFn);
            FileWriter fAct = new FileWriter(actFn);
            for (Service tmp : this.listeService) {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    tmp.insert();
                }
                if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                TimsLogger.debug("#TTS.saveListe#" + tmp.getInsertString());
                fService.write(tmp.getInsertString());
                fService.write("\n");
            }
            if (this.extendVehicleInformation) {
                TimsLogger.info("extendVehicleInformation is on");
                for (ActivityDetail act : this.activities) {
                    TimsLogger.debug(act.getSqlString());
                    if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                        act.insert();
                    }
                    if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                    fAct.write(act.getSqlString());
                    fAct.write("\n");
                }
            }
            if (this.calculFrais) {
                DriverExpenses.deleteExpenses(this.conducteur.getCleConducteur(), this.dateDebutAnalyse, this.dateFinAnalyse, 1);
                Vector<DriverExpenses> nonAuto = DriverExpenses.loadList(0, this.conducteur.getCleConducteur(), ConversionTime.stringToDate(this.dateDebutAnalyse, "yyyy-MM-dd"), ConversionTime.stringToDate(this.dateFinAnalyse, "yyyy-MM-dd"));
                for (DriverExpenses tmp : this.listeFrais) {
                    if (nonAuto.contains(tmp)) {
                        TimsLogger.debug("Frais d\u00e9j\u00e0 pr\u00e9sent en non auto ");
                        tmp.affiche();
                        continue;
                    }
                    if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                        tmp.insert();
                    }
                    if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                    fexp.write(tmp.getInsertString());
                    fexp.write("\n");
                }
            }
            fService.close();
            fexp.close();
            fAct.close();
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                boolean success = true;
                long time = Transport.ps.startAbsoluteTime();
                if (!Transport.bdd.loadDriverService(serviceFn)) {
                    success = false;
                }
                Transport.ps.endAbsoluteTime(PerformanceScanner.PROCESS, "#TTS.saveListe# loadDriverService time : ", time);
                if (!Transport.bdd.loadDriverExpenses(expFn)) {
                    success = false;
                }
                if (this.extendVehicleInformation && !Transport.bdd.loadActivityDetail(actFn)) {
                    success = false;
                }
                TimsLogger.debug("#TTS.saveListe# saving result : " + success);
                toReturn = success;
            }
            new File(serviceFn).delete();
            new File(expFn).delete();
            new File(actFn).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException();
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#TTS.calculService# saveliste time");
        return toReturn;
    }
}

