/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.CompanyCard;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourUEV;
import fr.pgh.data.bdd.UevActivity;
import fr.pgh.data.bdd.UevSession;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.Vector;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.uev.UEVProperty;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;

public class UEVCORRECTION {
    public static final int CANCEL = 0;
    public static final int SUCCESS = 1;
    public static final int UNKNOWN_VEHICLE = 2;
    public static final int OLDER_FILE = 6;
    private BddTransport refBDD = null;
    public Preferences prefs = Preferences.userRoot().node("TIMS");
    public File toRead = null;
    private byte[] fileBuffer = null;
    private boolean fileReaden = false;
    Vehicule currentVehicule = null;
    private Vector<VehicleUsed> io = new Vector();
    private Vector<ChangementActivite> activConducteur = new Vector();
    private Vector<ChangementActivite> activConvoyeur = new Vector();
    private Vector<JourUEV> day = new Vector();
    private DateFormat formatDatedb = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat formatDateHeuredb = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat formatdateCmp = new SimpleDateFormat("ddMM");
    private String vehicleMatricule = "";
    private boolean forbiddenChar = false;
    private String wrongRegistration = "";
    private String vehicleIdentification = "";
    private String vuSoftwareVersion = null;
    private String vuManufacturerName = null;
    private Date dateMin = null;
    private Date dateMax = null;
    private Date beginActivity = null;
    private Date endActivity = null;
    private Date previousDownload = null;
    private Vector<String> errors = null;
    private HashMap<Date, Integer> kmDay = new HashMap();
    private Date jourEteToHiver = null;
    private Date jourHiverToEte = null;
    private int lastKnownKm = 0;
    private int dayUsedCount = 0;
    private int totalKm = 0;
    private boolean olderActivity = false;
    private boolean missingActivity = false;
    private Date dateTelechargement = null;
    private Vector<String> unknownDriver = new Vector();
    private Vector<Conducteur> list = null;

    public UEVCORRECTION(File toRead) throws HeadlessException {
        this.toRead = toRead;
        this.errors = new Vector();
        this.formatDateHeuredb.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        this.refBDD = BddTransport.getInstance();
    }

    public void readFile() {
        BufferedInputStream fs = null;
        try {
            FileInputStream channel = new FileInputStream(this.toRead);
            fs = new BufferedInputStream(channel);
            int taille = fs.available();
            this.fileBuffer = new byte[taille];
            fs.read(this.fileBuffer, 0, taille);
            channel.close();
            fs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.fileReaden = true;
    }

    public boolean run() {
        TimsLogger.info("#UEVDP.run# Read uev file " + this.toRead.getName());
        Transport.ps.startOperation();
        int readingState = 0;
        if (readingState == 7) {
            MessageSystemManager.error(null, LanguageTranslator.getString("vehicle.badFile"), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(5)) + 7));
            TimsLogger.warn(LanguageTranslator.getString("#UEVDP.run# vehicle.badFile"));
            Transport.ps.endOperation(PerformanceScanner.INSERT, "total UEV process");
            return false;
        }
        if (readingState == 1) {
            TimsLogger.info("#UEVDP.run# File ever read");
            Transport.ps.endOperation(PerformanceScanner.INSERT, "total UEV process");
            return true;
        }
        this.readIdentification();
        boolean saved = false;
        readingState = this.checkVehicle();
        if (readingState == 1) {
            this.dateTelechargement = ConversionTime.stringToDate(this.currentVehicule.getDateTelechargement() == "" ? "1970-01-01" : this.currentVehicule.getDateTelechargement().substring(0, 10), "yyyy-MM-dd");
            try {
                BddTransport.getInstance().startTransaction();
                saved = this.dataProcess();
                if (saved) {
                    BddTransport.getInstance().commit();
                } else {
                    BddTransport.getInstance().rollback();
                }
            }
            catch (Exception exp) {
                TimsLogger.error("#UEVDP.run()# Exception in dataProcess()");
                exp.printStackTrace();
            }
        }
        if (saved) {
            TimsLogger.info("#UEVDP.run# File read success");
            return true;
        }
        return false;
    }

    private int checkVehicle() {
        if (this.vehicleMatricule.equals("")) {
            MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("uev.reading.error"), LanguageTranslator.getString("uev.reading.title", this.vehicleMatricule));
            return 2;
        }
        this.currentVehicule = new Vehicule();
        if (!this.currentVehicule.loadByImmat(this.vehicleMatricule, true)) {
            TimsLogger.error("unable to find" + this.vehicleMatricule);
            return 0;
        }
        return 1;
    }

    public boolean dataProcess() {
        int information = this.readInformation();
        if (information != 2) {
            TimsLogger.error("ERROR " + this.toRead);
            return false;
        }
        try {
            this.saveInfos();
        }
        catch (Exception exp) {
            TimsLogger.error("ERROR " + this.toRead);
            exp.printStackTrace();
            return false;
        }
        return true;
    }

    public Date getDlDate(String nomFichier) {
        String dateBDD = "";
        String tmp = nomFichier.substring(nomFichier.length() - 14, nomFichier.length() - 4);
        String jour = tmp.substring(4, 6);
        String mois = tmp.substring(2, 4);
        String year = "20";
        if (Integer.parseInt(tmp.substring(0, 2)) >= 70) {
            year = "19";
        }
        String annee = String.valueOf(year) + tmp.substring(0, 2);
        String heure = String.valueOf(tmp.substring(6, 8)) + ":" + tmp.substring(8, 10);
        dateBDD = String.valueOf(annee) + "-" + mois + "-" + jour + " " + heure;
        return ConversionTime.stringToDate(dateBDD, "yyyy-MM-dd HH:mm");
    }

    private void saveInfos() throws Exception {
        TimsLogger.debug("#UEVDP.saveInfos# d\u00e9but sauvegarde");
        Transport.ps.startOperation();
        int random = (int)(Math.random() * 1000.0);
        String dayFn = String.valueOf(Transport.savePath) + "uev" + random + ".txt";
        while (new File(dayFn).exists()) {
            random = (int)(Math.random() * 1000.0);
            dayFn = String.valueOf(Transport.savePath) + "service" + random + ".txt";
        }
        FileWriter fDay = new FileWriter(dayFn);
        String toDelete = "";
        boolean first = true;
        for (JourUEV toAdd : this.getDays()) {
            if (first && toAdd.getActivities().size() != 0) {
                JourUEV in = JourUEV.load(toAdd.getVehicleId(), toAdd.getDay());
                int added = 0;
                if (in != null && in.getActivities().size() != 0) {
                    UevActivity getUntil = toAdd.getActivities().get(0);
                    for (UevActivity toCheck : in.getActivities()) {
                        if (toCheck.getHeureDebut() >= getUntil.getHeureFin()) break;
                        toAdd.getActivities().add(added, toCheck);
                        ++added;
                        if (toCheck.getHeureFin() != getUntil.getHeureFin()) continue;
                        toAdd.getActivities().remove(added);
                    }
                }
                TimsLogger.debug("#UEVDP# premier journ\u00e9e trait\u00e9e " + added + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es");
                first = false;
            }
            toDelete = String.valueOf(toDelete) + ",\"" + ConversionTime.dateToStringDb(toAdd.getDay()) + "\"";
            if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
            fDay.write(toAdd.getSQLInsert());
            fDay.write("\n");
        }
        if (!toDelete.equals("")) {
            this.refBDD.delUEVActivityAndDay(this.currentVehicule, toDelete.substring(1));
        }
        fDay.close();
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            this.refBDD.loadVehicleDay(dayFn);
        }
        new File(dayFn).delete();
        Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
    }

    private Vector<JourUEV> getDays() {
        Vector<JourUEV> daysToReturn = new Vector<JourUEV>();
        int j = 0;
        int total = 0;
        Vector<UevActivity> dailyActivity = new Vector<UevActivity>();
        while (j < this.activConducteur.size()) {
            int heureFin = 1440;
            ChangementActivite tmp = this.activConducteur.get(j);
            if (j != this.activConducteur.size() - 1 && ConversionTime.dateToString(this.activConducteur.get(j + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(this.activConducteur.get(j).getDate(), "dd/MM/yyyy"))) {
                heureFin = this.activConducteur.get(j + 1).getHeure();
            }
            int dureeAct = heureFin - tmp.getHeure();
            if (tmp.getTypeActivite() == 1 || tmp.getTypeActivite() == 2 || tmp.getTypeActivite() == 3 || tmp.getTypeActivite() == 5) {
                total += dureeAct;
            }
            UevActivity toAdd = new UevActivity(this.currentVehicule.getCleVehicule(), tmp.getTypeActivite(), "", "", tmp.getHeure(), heureFin, dureeAct, tmp.getEtatCarte(), tmp.getEtatConduite(), tmp.getLecteur(), this.formatDatedb.format(tmp.getDate()));
            dailyActivity.add(toAdd);
            if (heureFin == 1440) {
                Integer kmI = this.kmDay.get(this.activConducteur.get(j).getDate());
                int km = kmI == null ? this.lastKnownKm : kmI;
                Integer previousKm = this.kmDay.get(ConversionTime.add(this.activConducteur.get(j).getDate(), 5, -1));
                int dailyKm = previousKm == null ? 0 : km - previousKm;
                JourUEV dayToAdd = new JourUEV(0, this.currentVehicule.getCleVehicule(), ConnexionSettings.getInstance().getUserCle(), this.activConducteur.get(j).getDate(), km, dailyKm, total, "", dailyActivity);
                daysToReturn.add(dayToAdd);
                dailyActivity = new Vector();
                total = 0;
            }
            ++j;
        }
        TimsLogger.debug("getDays # " + daysToReturn.size() + " jours a traiter");
        return daysToReturn;
    }

    private Vector<Conducteur> getDrivers() {
        if (this.list == null) {
            this.list = Conducteur.loadListWithArchive(new Integer[0]);
        }
        return this.list;
    }

    private JourUEV getDay(Vector<JourUEV> existingDays, Date day) {
        TimsLogger.debug("#UEVDP.getDay()# search day on " + day);
        JourUEV filtered = null;
        for (JourUEV tmp : existingDays) {
            if (!tmp.getDay().equals(ConversionTime.dateTruncate(day))) continue;
            filtered = tmp;
        }
        TimsLogger.debug("#UEVDP.getDay()# return " + (filtered == null ? "null" : filtered.getDay()));
        return filtered;
    }

    public int readInformation() {
        Transport.ps.startOperation();
        int status = this.readIdentification();
        Transport.ps.endOperation(PerformanceScanner.READING, "uev information");
        if (status != 2 && !this.printErrorAndContinue(status, LanguageTranslator.getString("vehicle.fault"))) {
            return status;
        }
        Transport.ps.startOperation();
        status = this.readActivity();
        Transport.ps.endOperation(PerformanceScanner.READING, "uev activity");
        if (status != 2 && !this.printErrorAndContinue(status, LanguageTranslator.getString("vehicle.fault"))) {
            return status;
        }
        return 2;
    }

    private boolean printErrorAndContinue(int status, String name) {
        if (status == 6) {
            this.errors.add(LanguageTranslator.getString("uev.noInformation", name));
            TimsLogger.info(LanguageTranslator.getString("uev.noInformation", name));
        } else if (status == 10) {
            TimsLogger.info("error structure");
            return false;
        }
        return true;
    }

    public int readIdentification() {
        int cardSlotsStatus;
        Date currentDate;
        SimpleDateFormat formatDate;
        int offset;
        block19: {
            if (!this.fileReaden) {
                this.readFile();
            }
            if ((offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_IDENTIFICATION)) <= -1) {
                if (offset != -1) {
                    return 10;
                }
                return 6;
            }
            formatDate = new SimpleDateFormat("dd/MM/yyyy HH'h'mm");
            this.vehicleIdentification = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 2 + UEVProperty.MemberStateCertificateSize + UEVProperty.VUCertificateSize, 17, 0);
            offset += 17;
            ++offset;
            ++offset;
            byte[] retour = new byte[13];
            int j = 0;
            while (j < 13) {
                if (this.fileBuffer[offset + j] >= 127 || this.fileBuffer[offset + j] < 0) {
                    this.forbiddenChar = true;
                } else {
                    retour[j] = this.fileBuffer[offset + j];
                }
                ++j;
            }
            if (this.forbiddenChar) {
                this.wrongRegistration = new String(retour).trim();
                j = 0;
                while (j < 13) {
                    retour[j] = this.fileBuffer[offset + j] >= 127 || this.fileBuffer[offset + j] < 0 ? 45 : this.fileBuffer[offset + j];
                    ++j;
                }
            }
            this.vehicleMatricule = new String(retour).trim();
            if (!Pattern.matches("[A-Z]{2}-[0-9]{3}-[A-Z]{2}", this.vehicleMatricule)) {
                if (Pattern.matches("[A-Z]{2}.?[0-9]{3}.?[A-Z]{2}.*", this.vehicleMatricule)) {
                    TimsLogger.debug(String.valueOf(this.vehicleMatricule) + " is not matching with - ");
                    TimsLogger.debug("corrected with " + this.vehicleMatricule);
                } else {
                    TimsLogger.debug(String.valueOf(this.vehicleMatricule) + " is not matching at all ");
                }
            } else {
                TimsLogger.debug(String.valueOf(this.vehicleMatricule) + " is OK !");
            }
            currentDate = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 13, 4));
            this.dateMin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
            this.dateMax = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
            cardSlotsStatus = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 1);
            this.previousDownload = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
            if (this.currentVehicule != null) break block19;
            return 2;
        }
        try {
            String cardNumberUpload = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 16, 2);
            String companyUpload = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 18, 35, 1);
            TimsLogger.info("#UDP.readRecap# identification du v\u00e9hicule : " + this.vehicleIdentification + " immatriculation : " + this.vehicleMatricule + " cardSlotsStatus : " + cardSlotsStatus + " (" + Integer.toHexString(cardSlotsStatus) + ")" + " date de l'UEV : " + formatDate.format(currentDate) + " p\u00e9riode t\u00e9l\u00e9chargeable : " + formatDate.format(this.dateMin) + " " + formatDate.format(this.dateMax) + " dernier t\u00e9l\u00e9chargement : " + formatDate.format(this.previousDownload) + " par " + cardNumberUpload + " (" + companyUpload + ")");
            Vector<CompanyCard> ccList = CompanyCard.loadList(new int[0]);
            int sessionNb = Fonctions.bytesToInt(this.fileBuffer, offset += 36, 1);
            ++offset;
            UevSession last = UevSession.getLastUevSession(this.currentVehicule.getCleVehicule());
            if (sessionNb > 0) {
                if (Transport.apiMode == 0) {
                    TimsLogger.debug("last session started " + (last == null ? "never" : last.getOpen() + " ends " + last.getClose() + " (id " + last.getId() + ")"));
                }
                int x = 0;
                while (x < sessionNb) {
                    Date debut = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset, 4));
                    Date fin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                    String company = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 35, 1);
                    String adress = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 36, 35, 1);
                    byte cardType = this.fileBuffer[offset += 36];
                    byte cardIssuingMemberState = this.fileBuffer[offset + 1];
                    String cardNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset, 16, 2);
                    offset += 18;
                    ++x;
                }
            }
            int controlNb = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
            ++offset;
            int x = 0;
            while (x < controlNb) {
                int controlType = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                Date controlTime = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
                String cardNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 16, 2);
                Date periodBegin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 18, 4));
                Date periodEnd = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                offset += 4;
                ++x;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 3;
        }
        return 2;
    }

    private int readActivity() {
        int offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_ACTIVITE);
        if (offset <= -1) {
            if (offset != -1) {
                return 10;
            }
            return 6;
        }
        TimsLogger.debug("#UDP.readActivity()# Begin at " + offset);
        try {
            int heure;
            SimpleDateFormat formatGMTDate = new SimpleDateFormat("yyyy-MM-dd");
            formatGMTDate.setTimeZone(TimeZone.getTimeZone("GMT"));
            boolean firstAct = true;
            boolean reportCond = false;
            int decalageHoraire = 0;
            int dailyKm = 0;
            Object lastDay = null;
            while (offset < this.fileBuffer.length && Fonctions.bytesToInt(this.fileBuffer, offset, 2) == UEVProperty.ID_ACTIVITE) {
                Date entryTime;
                Date dateJour = null;
                dateJour = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 2, 4));
                if (this.beginActivity == null) {
                    this.beginActivity = dateJour;
                }
                this.endActivity = dateJour;
                String date = formatGMTDate.format(dateJour);
                dateJour = formatGMTDate.parse(date);
                String dateCmp = this.formatdateCmp.format(dateJour);
                decalageHoraire = this.getDecalageHoraire(dateJour);
                dailyKm = this.lastKnownKm > 0 && Fonctions.bytesToInt(this.fileBuffer, offset, 3) < 10000000 ? Fonctions.bytesToInt(this.fileBuffer, offset += 4, 3) - this.lastKnownKm : 0;
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 3) < 10000000) {
                    this.lastKnownKm = Fonctions.bytesToInt(this.fileBuffer, offset, 3);
                }
                this.kmDay.put(dateJour, this.lastKnownKm);
                if (dailyKm >= 30) {
                    ++this.dayUsedCount;
                    this.totalKm += dailyKm;
                }
                int noOfCardIWRecords = Fonctions.bytesToInt(this.fileBuffer, offset += 3, 2);
                offset += 2;
                int i = 1;
                while (i <= noOfCardIWRecords) {
                    ++offset;
                    VehicleUsed tmp = new VehicleUsed();
                    tmp.setCleVehicule(this.currentVehicule.getCleVehicule());
                    tmp.setImmatriculation(this.currentVehicule.getRegistrationNumber());
                    byte[] nom = new byte[35];
                    int j = 0;
                    while (j < nom.length) {
                        nom[j] = this.fileBuffer[offset + j];
                        ++j;
                    }
                    tmp.setNom(new String(nom).trim());
                    offset += 35;
                    byte[] prenom = new byte[35];
                    int j2 = 0;
                    while (j2 < prenom.length) {
                        prenom[j2] = this.fileBuffer[offset + j2];
                        ++j2;
                    }
                    tmp.setPrenom(new String(prenom).trim());
                    offset = offset + 35 + 1;
                    byte cardIssuingMemberState = this.fileBuffer[++offset];
                    tmp.setNumeroCarte(this.getCardNumber(++offset));
                    offset = offset + 16 + 4;
                    tmp.setDateDebut(ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset, 4)));
                    SimpleDateFormat formatHeure = new SimpleDateFormat("HH'h'mm");
                    tmp.setKmDebut(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 3));
                    tmp.setLecteur(Fonctions.bytesToInt(this.fileBuffer, offset += 3, 1));
                    Date date_retrait = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
                    String dateRetraitCmp = this.formatdateCmp.format(date_retrait);
                    tmp.setDateFin(date_retrait);
                    int heureRetraitCmp = ConversionTime.heureStringToInt(formatHeure.format(date_retrait), "h");
                    tmp.setKmFin(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 3));
                    offset = offset + 3 + 19;
                    tmp.setKmEffectue(tmp.getKmFin() - tmp.getKmDebut());
                    tmp.setManualInput(Fonctions.bytesToInt(this.fileBuffer, offset, 1) != 0);
                    ++offset;
                    if (dateCmp.equals(dateRetraitCmp) || !dateCmp.equals(dateRetraitCmp) && heureRetraitCmp < 120) {
                        block30: {
                            Conducteur tmpC = null;
                            try {
                                tmpC = Conducteur.getDriver(this.getDrivers(), tmp.getNumeroCarte(), cardIssuingMemberState);
                                tmp.setCleConducteur(tmpC.getCleConducteur());
                            }
                            catch (Exception ex) {
                                if (Transport.debug < 2) break block30;
                                this.unknownDriver.add(tmp.getNumeroCarte());
                            }
                        }
                        this.io.add(tmp);
                    }
                    ++i;
                }
                int noOfActivChange = Fonctions.bytesToInt(this.fileBuffer, offset, 2);
                offset += 2;
                reportCond = false;
                boolean reportConv = false;
                int i2 = 1;
                while (i2 <= noOfActivChange) {
                    block35: {
                        ChangementActivite activityChange;
                        block31: {
                            block33: {
                                int nbJour;
                                ChangementActivite lastAct;
                                block34: {
                                    block32: {
                                        byte[] tmpbuf2bytes = new byte[]{this.fileBuffer[offset], this.fileBuffer[++offset]};
                                        ++offset;
                                        activityChange = UEVProperty.getDetailActivite(tmpbuf2bytes, dateJour, "V1B", this.toRead.getName());
                                        if (!activityChange.getLecteur().equals("CONDUCTEUR")) break block31;
                                        if (!activityChange.setHeure(activityChange.getHeure() + decalageHoraire) || reportCond) break block32;
                                        ChangementActivite tmp = (ChangementActivite)this.activConducteur.get(this.activConducteur.size() - 1).clone();
                                        tmp.setHeure(1440);
                                        this.activConducteur.add(tmp);
                                        reportCond = true;
                                        break block33;
                                    }
                                    if (activityChange.getHeure() != decalageHoraire || this.activConducteur.size() == 0) break block33;
                                    lastAct = this.activConducteur.get(this.activConducteur.size() - 1);
                                    nbJour = ConversionTime.getDaysBetween(lastAct.getDate(), activityChange.getDate());
                                    if (nbJour != 0) break block34;
                                    if (lastAct.getTypeActivite() != activityChange.getTypeActivite()) break block33;
                                    break block35;
                                }
                                if (nbJour == 1) {
                                    if (lastAct.getTypeActivite() == activityChange.getTypeActivite()) {
                                        activityChange.setHeure(activityChange.getHeure() - decalageHoraire);
                                    } else {
                                        ChangementActivite tmp = (ChangementActivite)this.activConducteur.get(this.activConducteur.size() - 1).clone();
                                        tmp.setHeure(1440);
                                        this.activConducteur.add(tmp);
                                    }
                                } else if (lastAct.getTypeActivite() == activityChange.getTypeActivite()) {
                                    activityChange.setHeure(activityChange.getHeure() - decalageHoraire);
                                }
                            }
                            this.activConducteur.add(activityChange);
                            if (firstAct) {
                                firstAct = false;
                                int nbJour = ConversionTime.getDaysBetween(this.dateTelechargement, activityChange.getDate());
                                if (nbJour < -2 && !this.olderActivity) {
                                    this.olderActivity = true;
                                } else if (nbJour > 1 && nbJour < 10000) {
                                    this.missingActivity = true;
                                }
                            }
                        }
                        if (activityChange.getLecteur().equals("CONVOYEUR")) {
                            if (!(activityChange.getHeure() == 0 && this.activConvoyeur.size() != 0 && this.activConvoyeur.get(this.activConvoyeur.size() - 1).getDate().before(dateJour) || this.activConvoyeur.size() == 0 || !activityChange.setHeure(activityChange.getHeure() + decalageHoraire) || reportConv)) {
                                ChangementActivite tmp = (ChangementActivite)this.activConvoyeur.get(this.activConvoyeur.size() - 1).clone();
                                tmp.setHeure(1440);
                                this.activConvoyeur.add(tmp);
                                reportConv = true;
                            }
                            this.activConvoyeur.add(activityChange);
                        }
                    }
                    ++i2;
                }
                int noOfPlaceRecords = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                ++offset;
                int i3 = 1;
                while (i3 <= noOfPlaceRecords) {
                    ++offset;
                    String card = this.getCardNumber(++offset);
                    entryTime = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 16, 4));
                    byte entryTypeDailyWorkPeriod = this.fileBuffer[offset += 4];
                    byte dailyWorkPeriodCountry = this.fileBuffer[++offset];
                    byte dailyWorkPeriodRegion = this.fileBuffer[++offset];
                    int vehicleOdometerValue = Fonctions.bytesToInt(this.fileBuffer, ++offset, 3);
                    offset += 3;
                    ++i3;
                }
                int noOfSpecificConditionRecords = Fonctions.bytesToInt(this.fileBuffer, offset, 2);
                offset += 2;
                int i4 = 1;
                while (i4 <= noOfSpecificConditionRecords) {
                    entryTime = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset, 4));
                    byte specificConditionType = this.fileBuffer[offset += 4];
                    ++offset;
                    ++i4;
                }
                offset += 128;
            }
            Date dlDate = this.getDlDate(this.toRead.getName());
            Date last = ConversionTime.dateTruncate(this.activConducteur.get(this.activConducteur.size() - 1).getDate());
            if (last.equals(ConversionTime.dateTruncate(dlDate)) && (heure = ConversionTime.heureStringToInt(ConversionTime.dateToString(dlDate, "HH:mm"), ":") + decalageHoraire) < 1440) {
                ChangementActivite tmp = new ChangementActivite(7, dlDate, heure, "CONDUCTEUR", "SEUL", "NON INSEREE", "", this.toRead.getName());
                this.activConducteur.add(tmp);
            }
            if (reportCond) {
                ChangementActivite tmp = (ChangementActivite)this.activConducteur.get(this.activConducteur.size() - 1).clone();
                tmp.setHeure(decalageHoraire);
                tmp.setTypeActivite(7);
                this.activConducteur.add(tmp);
            }
            TimsLogger.debug("#UEVDP.readActivity()# on a en tout " + this.io.size() + " insertions de carte");
            TimsLogger.debug("#UDP.readActivity()# End at " + offset);
        }
        catch (Exception ex) {
            return 3;
        }
        return 2;
    }

    public String getCardNumber(int offset) {
        byte[] cardNumber_char = new byte[16];
        int j = 0;
        while (j < cardNumber_char.length) {
            cardNumber_char[j] = this.fileBuffer[offset + j];
            ++j;
        }
        return new String(cardNumber_char).trim();
    }

    private int getDecalageHoraire(Date dateJour) {
        this.jourHiverToEte = Fonctions.getDateHeureEte(dateJour);
        this.jourEteToHiver = Fonctions.getDateHeureHiver(dateJour);
        if (dateJour.after(this.jourHiverToEte) && dateJour.before(this.jourEteToHiver)) {
            return 120;
        }
        if (this.jourHiverToEte.equals(dateJour)) {
            return 60;
        }
        return !this.jourEteToHiver.equals(dateJour) ? 60 : 120;
    }
}

