/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ChangementActivite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.uev.exception.VuFileStructureException;
import transpo.system.uev.object.ActivityInfo;
import transpo.system.uev.object.CardSlotStatus;
import transpo.system.uev.object.EventInfo;
import transpo.system.uev.object.IdentificationInfo;
import transpo.system.uev.object.SpeedInfo;
import transpo.system.uev.object.TechnicalInfo;
import transpo.system.uev.object.VehicleRegistrationNumber;
import transpo.system.uev.object.VuActivityDailyRecord;
import transpo.system.uev.object.VuBorderCrossing;
import transpo.system.uev.object.VuCalibration;
import transpo.system.uev.object.VuCardRecord;
import transpo.system.uev.object.VuCompanyLockData;
import transpo.system.uev.object.VuControlActivityData;
import transpo.system.uev.object.VuDetailedBlockSpeed;
import transpo.system.uev.object.VuDownloadActivityData;
import transpo.system.uev.object.VuDownloadablePeriod;
import transpo.system.uev.object.VuEventRecord;
import transpo.system.uev.object.VuFaultRecord;
import transpo.system.uev.object.VuFile;
import transpo.system.uev.object.VuGNSS;
import transpo.system.uev.object.VuITSConsent;
import transpo.system.uev.object.VuIdentification;
import transpo.system.uev.object.VuLoadUnload;
import transpo.system.uev.object.VuOverSpeedingControl;
import transpo.system.uev.object.VuOverSpeedingEvent;
import transpo.system.uev.object.VuPlaceDailyWorkPeriod;
import transpo.system.uev.object.VuPowerSupplyInterruption;
import transpo.system.uev.object.VuSensorExternalGNSSCoupled;
import transpo.system.uev.object.VuSensorPaired;
import transpo.system.uev.object.VuSpecificCondition;
import transpo.system.uev.object.VuTimeAdjustement;
import transpo.system.uev.object.VuTimeAdjustementGNSS;
import transpo.system.util.Fonctions;

public class VuFileParserG2 {
    public static final int EVER_READ = 1;
    public static final int READ_SUCCESS = 2;
    public static final int INFORMATION_ERROR = 3;
    public static final int SAVING_ERROR = 4;
    public static final int UNKNOWN_ERROR = 5;
    public static final int NO_DATA = 6;
    public static final int BAD_FILE = 7;
    public static final int WRITING_ERROR = 8;
    public static final int READ_CANCELLED = 9;
    public static final int DATA_ERROR = 10;
    public static final String ETAT_NON_INSERE = "NON INSEREE";
    public static final String ETAT_INSERE = "INSEREE";
    public static final String ETAT_SM = "S. MAN";
    public static final String ETAT_SEUL = "SEUL";
    public static final String ETAT_INCONNU = "INCONNU";
    public static final String ETAT_EQUIPAGE = "EQUIPAGE";
    public static final String LECTEUR_CONDUCTEUR = "CONDUCTEUR";
    public static final String LECTEUR_CONVOYEUR = "CONVOYEUR";
    public static int ID_IDENTIFICATION_G2 = 30241;
    public static int ID_ACTIVITY_G2 = 30242;
    public static int ID_EVENT_G2 = 30243;
    public static int ID_SPEED_G2 = 30244;
    public static int ID_TECHNICAL_G2 = 30245;
    public static int ID_IDENTIFICATION_G2V2 = 30257;
    public static int ID_ACTIVITY_G2V2 = 30258;
    public static int ID_EVENT_G2V2 = 30259;
    public static int ID_SPEED_G2V2 = 30260;
    public static int ID_TECHNICAL_G2V2 = 30261;
    public static int MemberStateCertificateSize = 194;
    public static int VUCertificateSize = 194;
    public static int vehicleIdentificationNumberSize = 17;
    public static int vehicleMemberStateSize = 1;
    public static final int RT_ActivityChangeInfo = 1;
    public static final int RT_CardSlotStatus = 2;
    public static final int RT_CurrentDateTime = 3;
    public static final int RT_MemberStateCertificate = 4;
    public static final int RT_OdometerValueMidnight = 5;
    public static final int RT_DateOfDayDonwloaded = 6;
    public static final int RT_SensorPaired = 7;
    public static final int RT_Signature = 8;
    public static final int RT_SpecificConditionRecord = 9;
    public static final int RT_VehicleIdentificationNumber = 10;
    public static final int RT_VehicleRegistrationNumber = 11;
    public static final int RT_VuCalibrationRecord = 12;
    public static final int RT_VuCardIWRecord = 13;
    public static final int RT_VuCardRecord = 14;
    public static final int RT_VuCertificate = 15;
    public static final int RT_VuCompanyLockRecord = 16;
    public static final int RT_VuControlActivityRecord = 17;
    public static final int RT_VuDetailedSpeedBlock = 18;
    public static final int RT_VuDownloadablePeriod = 19;
    public static final int RT_VuDownloadActivityData = 20;
    public static final int RT_VuEventRecord = 21;
    public static final int RT_VuGNSSCDRecord = 22;
    public static final int RT_VuITSConsentRecord = 23;
    public static final int RT_VuFaultRecord = 24;
    public static final int RT_VuIdentification = 25;
    public static final int RT_VuOverSpeedingControlData = 26;
    public static final int RT_VuOverSpeedingEventRecord = 27;
    public static final int RT_VuPlaceDailyWorkPeriodRecord = 28;
    public static final int RT_VuTimeAdjustmentGNSSRecord = 29;
    public static final int RT_VuTimeAdjustmentRecord = 30;
    public static final int RT_VuPowerSupplyInterruptionRecord = 31;
    public static final int RT_SensorPairedRecord = 32;
    public static final int RT_SensorExternalGNSSCoupledRecord = 33;
    public static final int RT_VuBorderCrossingRecord = 34;
    public static final int RT_VuLoadUnloadRecord = 35;
    public static final int RT_VehicleRegistrationIdentification = 36;

    public static void printOffsetRecords(byte[] toParse) {
        int x = 0;
        while (x < toParse.length) {
            int begin = x;
            byte recordType = toParse[x];
            if (recordType > 34) {
                if (recordType == 118) {
                    TimsLogger.debug("#UEVProperty.printOffsetRecords# Printing records of offset " + Integer.toHexString(Fonctions.bytesToInt(toParse, x, 2)));
                    recordType = toParse[x += 2];
                } else {
                    TimsLogger.debug("#UEVProperty.printOffsetRecords# Unrecognize recort type " + recordType);
                    break;
                }
            }
            int recordSize = Fonctions.bytesToInt(toParse, ++x, 2);
            int noOfRecords = Fonctions.bytesToInt(toParse, x += 2, 2);
            x += 2;
            if (noOfRecords != 0) {
                int y = 0;
                while (y < noOfRecords) {
                    VuFileParserG2.printRecord(recordType, Arrays.copyOfRange(toParse, x, x + recordSize));
                    ++y;
                }
            }
            TimsLogger.debug("#UEVProperty.printOffsetRecords# recordType: " + Integer.toHexString(recordType) + "(from " + Integer.toHexString(begin) + " to " + Integer.toHexString(x += recordSize * noOfRecords - 1) + "), recordSize: " + recordSize + " (" + Integer.toHexString(recordSize) + "), noOfRecords: " + noOfRecords);
            ++x;
        }
        if (Transport.debug >= 1) {
            System.exit(0);
        }
    }

    public static VuFile parseFile(byte[] toParse, String fileName) throws VuFileStructureException {
        VuFile toReturn = new VuFile();
        toReturn.setFileName(fileName);
        int x = 0;
        while (x < toParse.length) {
            int fileType = Fonctions.bytesToInt(toParse, x, 2);
            if (!Integer.toHexString(fileType).startsWith("76")) {
                TimsLogger.debug("#VuFileParser.parseFile# bad file type " + Integer.toHexString(fileType) + " at " + Integer.toHexString(x));
                return null;
            }
            int endOfFile = VuFileParserG2.searchEnd(toParse, x);
            byte[] dataFileToParse = Arrays.copyOfRange(toParse, x, endOfFile);
            try {
                switch (fileType) {
                    case 30208: {
                        TimsLogger.debug("#VuFileParser.parseFile# parseVersion from " + Integer.toHexString(x + 2) + " to " + Integer.toHexString(endOfFile));
                        break;
                    }
                    case 30241: 
                    case 30257: {
                        TimsLogger.debug("#VuFileParser.parseFile# parseIdentification from " + Integer.toHexString(x + 2) + " to " + Integer.toHexString(endOfFile));
                        toReturn.setIdentification(VuFileParserG2.parseIdentification(dataFileToParse));
                        break;
                    }
                    case 30242: 
                    case 30258: {
                        TimsLogger.debug("#VuFileParser.parseFile# parseActivity from " + Integer.toHexString(x + 2) + " to " + Integer.toHexString(endOfFile));
                        toReturn.addActivityInfo(VuFileParserG2.parseActivity(dataFileToParse, x));
                        break;
                    }
                    case 30243: 
                    case 30259: {
                        TimsLogger.debug("#VuFileParser.parseFile# parseEvent from " + Integer.toHexString(x + 2) + " to " + Integer.toHexString(endOfFile));
                        toReturn.setEvent(VuFileParserG2.parseEvent(dataFileToParse));
                        break;
                    }
                    case 30244: {
                        TimsLogger.debug("#VuFileParser.parseFile# parseSpeed from " + Integer.toHexString(x + 2) + " to " + Integer.toHexString(endOfFile));
                        toReturn.setSpeed(VuFileParserG2.parseSpeed(dataFileToParse));
                        break;
                    }
                    case 30245: 
                    case 30261: {
                        TimsLogger.debug("#VuFileParser.parseFile# parseTechnique from " + Integer.toHexString(x + 2) + " to " + Integer.toHexString(endOfFile));
                        toReturn.setTechnical(VuFileParserG2.parseTechnical(dataFileToParse));
                    }
                }
            }
            catch (VuFileStructureException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            x = endOfFile;
            ++x;
        }
        return toReturn;
    }

    private static int searchEnd(byte[] toParse, int x) {
        String searchedEnd = Integer.toHexString(Fonctions.bytesToInt(toParse, x, 2));
        String seachLog = "";
        byte recordType = toParse[x += 2];
        while (recordType < 37) {
            int recordSize = Fonctions.bytesToInt(toParse, ++x, 2);
            int noOfRecords = Fonctions.bytesToInt(toParse, x += 2, 2);
            x += 2;
            if ((x += recordSize * noOfRecords) >= toParse.length) {
                TimsLogger.debug("#VuFileParser.searchEnd# Reach the end of " + searchedEnd + " at 0x" + Integer.toHexString(x - 1));
                break;
            }
            seachLog = String.valueOf(seachLog) + Integer.toHexString(recordType) + " <" + Integer.toHexString(noOfRecords) + " * " + Integer.toHexString(recordSize) + "> // " + Integer.toHexString(x) + " // --- ";
            recordType = toParse[x];
        }
        TimsLogger.debug("#VuFileParser.searchEnd# end of " + searchedEnd + " is " + Integer.toHexString(x - 1) + " (" + seachLog + " " + Integer.toHexString(recordType) + ")");
        return x - 1;
    }

    private static void printRecord(int recordType, byte[] toPrint) {
        switch (recordType) {
            case 1: {
                VuFileParserG2.printActivityChangeInfo(toPrint);
                break;
            }
            case 2: {
                VuFileParserG2.printCardSlotStatus(toPrint);
                break;
            }
            case 3: {
                VuFileParserG2.printCurrentDateTime(toPrint);
                break;
            }
            case 4: {
                VuFileParserG2.printMemberStateCertificate(toPrint);
                break;
            }
            case 5: {
                VuFileParserG2.printOdometerValueMidnight(toPrint);
                break;
            }
            case 6: {
                VuFileParserG2.printDateOfDayDonwloaded(toPrint);
                break;
            }
            case 7: {
                VuFileParserG2.printSensorPaired(toPrint);
                break;
            }
            case 8: {
                VuFileParserG2.printSignature(toPrint);
                break;
            }
            case 9: {
                VuFileParserG2.printSpecificConditionRecord(toPrint);
                break;
            }
            case 10: {
                VuFileParserG2.printVehicleIdentificationNumber(toPrint);
                break;
            }
            case 11: {
                VuFileParserG2.printVehicleRegistrationNumber(toPrint);
                break;
            }
            case 12: {
                VuFileParserG2.printVuCalibrationRecord(toPrint);
                break;
            }
            case 13: {
                VuFileParserG2.printVuCardIWRecord(toPrint);
                break;
            }
            case 14: {
                VuFileParserG2.printVuCardRecord(toPrint);
                break;
            }
            case 15: {
                VuFileParserG2.printVuCertificate(toPrint);
                break;
            }
            case 16: {
                VuFileParserG2.printVuCompanyLockRecord(toPrint);
                break;
            }
            case 17: {
                VuFileParserG2.printVuControlActivityRecord(toPrint);
                break;
            }
            case 18: {
                VuFileParserG2.printVuDetailedSpeedBlock(toPrint);
                break;
            }
            case 19: {
                VuFileParserG2.printVuDownloadablePeriod(toPrint);
                break;
            }
            case 20: {
                VuFileParserG2.printVuDownloadActivityData(toPrint);
                break;
            }
            case 21: {
                VuFileParserG2.printVuEventRecord(toPrint);
                break;
            }
            case 22: {
                VuFileParserG2.printVuGNSSCDRecord(toPrint);
                break;
            }
            case 23: {
                VuFileParserG2.printVuITSConsentRecord(toPrint);
                break;
            }
            case 24: {
                VuFileParserG2.printVuFaultRecord(toPrint);
                break;
            }
            case 25: {
                VuFileParserG2.printVuIdentification(toPrint);
                break;
            }
            case 26: {
                VuFileParserG2.printVuOverSpeedingControlData(toPrint);
                break;
            }
            case 27: {
                VuFileParserG2.printVuOverSpeedingEventRecord(toPrint);
                break;
            }
            case 28: {
                VuFileParserG2.printVuPlaceDailyWorkPeriodRecord(toPrint);
                break;
            }
            case 29: {
                VuFileParserG2.printVuTimeAdjustmentGNSSRecord(toPrint);
                break;
            }
            case 30: {
                VuFileParserG2.printVuTimeAdjustmentRecord(toPrint);
                break;
            }
            case 31: {
                VuFileParserG2.printVuPowerSupplyInterruptionRecord(toPrint);
                break;
            }
            case 32: {
                VuFileParserG2.printSensorPairedRecord(toPrint);
                break;
            }
            case 33: {
                VuFileParserG2.printSensorExternalGNSSCoupledRecord(toPrint);
            }
        }
    }

    public static void printActivityChangeInfo(byte[] toPrint) {
    }

    public static void printCardSlotStatus(byte[] toPrint) {
    }

    public static void printCurrentDateTime(byte[] toPrint) {
        TimsLogger.debug("#currentDateTime# " + ConversionTime.getDate((long)Fonctions.bytesToInt(toPrint, 0, 4) * 1000L));
    }

    public static void printMemberStateCertificate(byte[] toPrint) {
        TimsLogger.debug("#MemberStateCertificate# ");
    }

    public static void printOdometerValueMidnight(byte[] toPrint) {
        TimsLogger.debug("#odometerValueMidnight# " + Fonctions.bytesToInt(toPrint, 0, 3));
    }

    public static void printDateOfDayDonwloaded(byte[] toPrint) {
        TimsLogger.debug("#dateOfDayDonwloaded# " + ConversionTime.getDate((long)Fonctions.bytesToInt(toPrint, 0, 4) * 1000L));
    }

    public static void printSensorPaired(byte[] toPrint) {
    }

    public static void printSignature(byte[] toPrint) {
        TimsLogger.debug("#printSignature#");
    }

    public static void printSpecificConditionRecord(byte[] toPrint) {
    }

    public static void printVehicleIdentificationNumber(byte[] toPrint) {
    }

    public static void printVehicleRegistrationNumber(byte[] toPrint) {
    }

    public static void printVuCalibrationRecord(byte[] toPrint) {
    }

    public static void printVuCardIWRecord(byte[] toPrint) {
    }

    public static void printVuCardRecord(byte[] toPrint) {
    }

    public static void printVuCertificate(byte[] toPrint) {
    }

    public static void printVuCompanyLockRecord(byte[] toPrint) {
        TimsLogger.debug("#printVuCompanyLockRecord#");
    }

    public static void printVuControlActivityRecord(byte[] toPrint) {
    }

    public static void printVuDetailedSpeedBlock(byte[] toPrint) {
    }

    public static void printVuDownloadablePeriod(byte[] toPrint) {
    }

    public static void printVuDownloadActivityData(byte[] toPrint) {
    }

    public static void printVuEventRecord(byte[] toPrint) {
    }

    public static void printVuGNSSCDRecord(byte[] toPrint) {
    }

    public static void printVuITSConsentRecord(byte[] toPrint) {
    }

    public static void printVuFaultRecord(byte[] toPrint) {
    }

    public static void printVuIdentification(byte[] toPrint) {
    }

    public static void printVuOverSpeedingControlData(byte[] toPrint) {
    }

    public static void printVuOverSpeedingEventRecord(byte[] toPrint) {
    }

    public static void printVuPlaceDailyWorkPeriodRecord(byte[] toPrint) {
    }

    public static void printVuTimeAdjustmentGNSSRecord(byte[] toPrint) {
    }

    public static void printVuTimeAdjustmentRecord(byte[] toPrint) {
    }

    public static void printVuPowerSupplyInterruptionRecord(byte[] toPrint) {
    }

    public static void printSensorPairedRecord(byte[] toPrint) {
    }

    public static void printSensorExternalGNSSCoupledRecord(byte[] toPrint) {
    }

    public static IdentificationInfo parseIdentification(byte[] toParse) throws VuFileStructureException {
        IdentificationInfo toReturn = null;
        if (Fonctions.bytesToInt(toParse, 0, 2) != ID_IDENTIFICATION_G2 && Fonctions.bytesToInt(toParse, 0, 2) != ID_IDENTIFICATION_G2V2) {
            TimsLogger.error("#VuFileParser.parseIdentification# bad identification file " + Integer.toHexString(Fonctions.bytesToInt(toParse, 0, 2)));
            return toReturn;
        }
        toReturn = new IdentificationInfo();
        int x = 2;
        while (x < toParse.length) {
            int begin = x;
            byte recordType = toParse[x];
            if (recordType > 36) {
                throw new VuFileStructureException("Unrecognize recordType " + recordType);
            }
            int recordSize = Fonctions.bytesToInt(toParse, ++x, 2);
            int noOfRecords = Fonctions.bytesToInt(toParse, x += 2, 2);
            TimsLogger.debug("#VuFileParser.parseIdentification# recordType: " + Fonctions.getVuRecordTypeLibelle(recordType) + "(" + Integer.toHexString(recordType) + " => from " + Integer.toHexString(begin) + " to " + Integer.toHexString((x += 2) + recordSize * noOfRecords - 1) + "), " + "recordSize: " + recordSize + " (" + Integer.toHexString(recordSize) + "), " + "noOfRecords: " + noOfRecords + " -> " + (noOfRecords != 0 ? Fonctions.parseHexAscii(Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords)) : ""));
            if (noOfRecords != 0) {
                byte[] tmp = Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords);
                switch (recordType) {
                    case 4: {
                        toReturn.setMemberStateCertificate(new String(tmp));
                        break;
                    }
                    case 15: {
                        toReturn.setVuCertificate(new String(tmp));
                        break;
                    }
                    case 10: {
                        toReturn.setVehicleIdentificationNumber(new String(tmp));
                        break;
                    }
                    case 11: {
                        toReturn.setVehicleRegistrationIdentification(new VehicleRegistrationNumber(tmp));
                        break;
                    }
                    case 3: {
                        toReturn.setCurrentDateTime(ConversionTime.getDate(Fonctions.bytesToInt(tmp)));
                        break;
                    }
                    case 19: {
                        toReturn.setVuDownloadablePeriod(new VuDownloadablePeriod(tmp));
                        break;
                    }
                    case 2: {
                        toReturn.setCardSlotStatus(new CardSlotStatus(tmp));
                        break;
                    }
                    case 20: {
                        toReturn.setVuDownloadActivityData(new VuDownloadActivityData(Arrays.copyOfRange(tmp, 0, VuDownloadActivityData.RECORD_SIZE)));
                        break;
                    }
                    case 16: {
                        toReturn.setVuCompanyLocksData(VuCompanyLockData.parse(tmp));
                        break;
                    }
                    case 17: {
                        toReturn.setVuControlActivityData(VuControlActivityData.parse(tmp));
                        break;
                    }
                    case 8: {
                        toReturn.setSignature(new String(tmp));
                        break;
                    }
                    case 36: {
                        toReturn.setVehicleRegistrationIdentification(new VehicleRegistrationNumber(tmp));
                        break;
                    }
                    case 34: {
                        TimsLogger.debug("RT_VuBorderCrossingRecord");
                        break;
                    }
                    case 35: {
                        TimsLogger.debug("RT_VuLoadUnloadRecord");
                        break;
                    }
                    default: {
                        TimsLogger.warn("#VuFileParser.parseIdentification# unknown recordType : " + recordType);
                    }
                }
            }
            x += recordSize * noOfRecords - 1;
            ++x;
        }
        return toReturn;
    }

    public static ActivityInfo parseActivity(byte[] toParse, int offsetBegin) throws VuFileStructureException, ParseException {
        ActivityInfo toReturn = null;
        SimpleDateFormat GMTFormat = new SimpleDateFormat("yyyy-MM-dd");
        GMTFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (Fonctions.bytesToInt(toParse, 0, 2) != ID_ACTIVITY_G2 && Fonctions.bytesToInt(toParse, 0, 2) != ID_ACTIVITY_G2V2) {
            TimsLogger.error("#VuFileParser.parseActivity# bad activity file " + Integer.toHexString(Fonctions.bytesToInt(toParse, 0, 2)));
            return toReturn;
        }
        toReturn = new ActivityInfo();
        int x = 2;
        while (x < toParse.length) {
            int begin = x;
            byte recordType = toParse[x];
            if (recordType > 36) {
                TimsLogger.error("Unrecognize recordType " + recordType);
                throw new VuFileStructureException("Unrecognize recordType " + recordType);
            }
            int recordSize = Fonctions.bytesToInt(toParse, ++x, 2);
            int noOfRecords = Fonctions.bytesToInt(toParse, x += 2, 2);
            TimsLogger.debug("#VuFileParser.parseActivity# recordType: " + Fonctions.getVuRecordTypeLibelle(recordType) + "(" + Integer.toHexString(recordType) + " from 0x" + Integer.toHexString(begin + offsetBegin) + " to 0x" + Integer.toHexString((x += 2) + recordSize * noOfRecords - 1 + offsetBegin) + "), ");
            TimsLogger.debug("#VuFileParser.parseActivity# recordSize: " + recordSize + " (0x" + Integer.toHexString(recordSize) + "), ");
            TimsLogger.debug("#VuFileParser.parseActivity# noOfRecords: " + noOfRecords + " -> " + (noOfRecords != 0 && recordSize * noOfRecords < 2000 ? Fonctions.parseHexAscii(Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords)) : "no record or too much car (" + recordSize * noOfRecords + ")"));
            if (noOfRecords != 0) {
                byte[] tmp = Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords);
                switch (recordType) {
                    case 6: {
                        String dateTruncated = GMTFormat.format(ConversionTime.getDate(Fonctions.bytesToInt(tmp)));
                        toReturn.setDay(GMTFormat.parse(dateTruncated));
                        TimsLogger.debug("#VuFileParser# dateofdaydownloaded = " + toReturn.getDay() + " " + ConversionTime.dateToString(ConversionTime.getDate(Fonctions.bytesToInt(tmp)), "dd/MM/yyyy HH:mm"));
                        break;
                    }
                    case 5: {
                        toReturn.setOdometerValueMidnight(Fonctions.bytesToInt(tmp, 0, 3));
                        break;
                    }
                    case 13: {
                        toReturn.setVuCardRecords(VuCardRecord.parse(tmp));
                        break;
                    }
                    case 1: {
                        toReturn.setActivities(new VuActivityDailyRecord(tmp));
                        break;
                    }
                    case 28: {
                        toReturn.setPlaces(VuPlaceDailyWorkPeriod.parse(tmp));
                        break;
                    }
                    case 22: {
                        toReturn.setGnss(VuGNSS.parse(tmp));
                        break;
                    }
                    case 9: {
                        toReturn.setSpecificConditions(VuSpecificCondition.parse(tmp));
                        break;
                    }
                    case 34: {
                        toReturn.setBorderCrossing(VuBorderCrossing.parse(tmp));
                        break;
                    }
                    case 35: {
                        toReturn.setLoadUnload(VuLoadUnload.parse(tmp));
                        break;
                    }
                    case 8: {
                        toReturn.setSignature(new String(tmp));
                        break;
                    }
                    default: {
                        TimsLogger.warn("#VuFileParser.parseActivity# unknown recordType : " + recordType);
                        throw new VuFileStructureException("Unrecognize recordType " + recordType);
                    }
                }
            }
            TimsLogger.debug("#VuFileParser.parseActivity# end of record (0x" + Integer.toHexString((x += recordSize * noOfRecords - 1) + offsetBegin) + ")");
            ++x;
        }
        TimsLogger.debug("#VuFileParser.parseActivity# end of parseActivity " + toReturn.getDay() + " : odometer value " + toReturn.getOdometerValueMidnight() + " - " + (toReturn.getActivities() == null ? "null" : Integer.valueOf(toReturn.getActivities().size())) + " activities");
        return toReturn;
    }

    public static EventInfo parseEvent(byte[] toParse) throws VuFileStructureException {
        EventInfo toReturn = null;
        if (Fonctions.bytesToInt(toParse, 0, 2) != ID_EVENT_G2 && Fonctions.bytesToInt(toParse, 0, 2) != ID_EVENT_G2V2) {
            TimsLogger.error("#VuFileParser.parseEvent# bad event file " + Integer.toHexString(Fonctions.bytesToInt(toParse, 0, 2)));
            return toReturn;
        }
        toReturn = new EventInfo();
        int x = 2;
        while (x < toParse.length) {
            int begin = x;
            byte recordType = toParse[x];
            if (recordType > 34) {
                throw new VuFileStructureException("Unrecognize recordType " + recordType);
            }
            int recordSize = Fonctions.bytesToInt(toParse, ++x, 2);
            int noOfRecords = Fonctions.bytesToInt(toParse, x += 2, 2);
            TimsLogger.debug("#VuFileParser.parseEvent# recordType: " + Fonctions.getVuRecordTypeLibelle(recordType) + "(from " + Integer.toHexString(begin) + " to " + Integer.toHexString((x += 2) + recordSize * noOfRecords - 1) + "), " + "recordSize: " + recordSize + " (" + Integer.toHexString(recordSize) + "), " + "noOfRecords: " + noOfRecords + " -> " + (noOfRecords != 0 ? Fonctions.parseHexAscii(Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords)) : ""));
            if (noOfRecords != 0) {
                byte[] tmp = Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords);
                switch (recordType) {
                    case 21: {
                        toReturn.setVuEvents(VuEventRecord.parse(tmp));
                        break;
                    }
                    case 24: {
                        toReturn.setVuFaults(VuFaultRecord.parse(tmp));
                        break;
                    }
                    case 26: {
                        toReturn.setVuOverSpeedingControl(new VuOverSpeedingControl(tmp));
                        break;
                    }
                    case 27: {
                        toReturn.setVuOverSpeeding(VuOverSpeedingEvent.parse(tmp));
                        break;
                    }
                    case 30: {
                        toReturn.setVuTimeAdjustements(VuTimeAdjustement.parse(tmp));
                        break;
                    }
                    case 29: {
                        toReturn.setVuTimeAdjustementGNSS(VuTimeAdjustementGNSS.parse(tmp));
                        break;
                    }
                    case 8: {
                        toReturn.setSignature(new String(tmp));
                        break;
                    }
                    default: {
                        TimsLogger.warn("#VuFileParser.parseEvent# unknown recordType : " + recordType);
                    }
                }
            }
            x += recordSize * noOfRecords - 1;
            ++x;
        }
        return toReturn;
    }

    public static SpeedInfo parseSpeed(byte[] toParse) throws VuFileStructureException {
        SpeedInfo toReturn = null;
        if (Fonctions.bytesToInt(toParse, 0, 2) != ID_SPEED_G2 && Fonctions.bytesToInt(toParse, 0, 2) != ID_SPEED_G2V2) {
            TimsLogger.error("#VuFileParser.parseSpeed# bad speed file " + Integer.toHexString(Fonctions.bytesToInt(toParse, 0, 2)));
            return toReturn;
        }
        toReturn = new SpeedInfo();
        int x = 2;
        while (x < toParse.length) {
            int begin = x;
            byte recordType = toParse[x];
            if (recordType > 34) {
                throw new VuFileStructureException("Unrecognize recordType " + recordType);
            }
            int recordSize = Fonctions.bytesToInt(toParse, ++x, 2);
            int noOfRecords = Fonctions.bytesToInt(toParse, x += 2, 2);
            TimsLogger.debug("#VuFileParser.parseSpeed# recordType: " + Fonctions.getVuRecordTypeLibelle(recordType) + "(from " + Integer.toHexString(begin) + " to " + Integer.toHexString((x += 2) + recordSize * noOfRecords - 1) + "), " + "recordSize: " + recordSize + " (" + Integer.toHexString(recordSize) + "), " + "noOfRecords: " + noOfRecords);
            if (noOfRecords != 0) {
                byte[] tmp = Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords);
                switch (recordType) {
                    case 18: {
                        toReturn.setVuDetailedBlockSpeed(VuDetailedBlockSpeed.parse(tmp));
                        break;
                    }
                    case 8: {
                        toReturn.setSignature(new String(tmp));
                        break;
                    }
                    default: {
                        TimsLogger.warn("#VuFileParser.parseSpeed# unknown recordType : " + recordType);
                    }
                }
            }
            x += recordSize * noOfRecords - 1;
            ++x;
        }
        return toReturn;
    }

    public static TechnicalInfo parseTechnical(byte[] toParse) throws VuFileStructureException {
        TechnicalInfo toReturn = null;
        if (Fonctions.bytesToInt(toParse, 0, 2) != ID_TECHNICAL_G2 && Fonctions.bytesToInt(toParse, 0, 2) != ID_TECHNICAL_G2V2) {
            TimsLogger.error("#VuFileParser.parseTechnical# bad technical file " + Integer.toHexString(Fonctions.bytesToInt(toParse, 0, 2)));
            return toReturn;
        }
        int vuVersion = Fonctions.bytesToInt(toParse, 0, 2) == ID_TECHNICAL_G2 ? 1 : 2;
        toReturn = new TechnicalInfo();
        int x = 2;
        while (x < toParse.length) {
            int begin = x;
            byte recordType = toParse[x];
            if (recordType > 34) {
                throw new VuFileStructureException("Unrecognize recordType " + recordType);
            }
            int recordSize = Fonctions.bytesToInt(toParse, ++x, 2);
            int noOfRecords = Fonctions.bytesToInt(toParse, x += 2, 2);
            TimsLogger.debug("#VuFileParser.parseTechnical# recordType: " + Fonctions.getVuRecordTypeLibelle(recordType) + "(" + Integer.toHexString(recordType) + " from " + Integer.toHexString(begin) + " to " + Integer.toHexString((x += 2) + recordSize * noOfRecords - 1) + "), " + "recordSize: " + recordSize + " (" + Integer.toHexString(recordSize) + "), " + "noOfRecords: " + noOfRecords + " -> " + (noOfRecords != 0 ? Fonctions.parseHexAscii(Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords)) : ""));
            if (noOfRecords != 0) {
                byte[] tmp = Arrays.copyOfRange(toParse, x, x + recordSize * noOfRecords);
                switch (recordType) {
                    case 25: {
                        toReturn.setVuIdentification(new VuIdentification(tmp));
                        break;
                    }
                    case 32: {
                        toReturn.setVuSensorPairedList(VuSensorPaired.parse(tmp));
                        break;
                    }
                    case 33: {
                        toReturn.setVuSensorExternalGNSSCoupledList(VuSensorExternalGNSSCoupled.parse(tmp));
                        break;
                    }
                    case 12: {
                        toReturn.setVuCalibrationList(VuCalibration.parse(tmp, vuVersion));
                        break;
                    }
                    case 14: {
                        TimsLogger.debug("VuCardRecord not used");
                        break;
                    }
                    case 23: {
                        toReturn.setVuITSConsentList(VuITSConsent.parse(tmp));
                        break;
                    }
                    case 31: {
                        toReturn.setVuPowerSupplyInterruptionList(VuPowerSupplyInterruption.parse(tmp));
                        break;
                    }
                    case 8: {
                        toReturn.setSignature(new String(tmp));
                        break;
                    }
                    default: {
                        TimsLogger.warn("#VuFileParser.parseTechnical# unprocessed recordType : " + recordType + " (" + Fonctions.getVuRecordTypeLibelle(recordType) + ")");
                    }
                }
            }
            x += recordSize * noOfRecords - 1;
            ++x;
        }
        return toReturn;
    }

    public static String getLecteur(String value) {
        String lecteur = "";
        if (value.equals("0")) {
            lecteur = LECTEUR_CONDUCTEUR;
        }
        if (value.equals("1")) {
            lecteur = LECTEUR_CONVOYEUR;
        }
        return lecteur;
    }

    public static String getEtatConduite(String value) {
        if (value.equals("0")) {
            return ETAT_SEUL;
        }
        return ETAT_EQUIPAGE;
    }

    public static String getEtatCarte(String value) {
        if (value.equals("0")) {
            return ETAT_INSERE;
        }
        return ETAT_NON_INSERE;
    }

    public static int getActivite(String value) {
        if (value.equals("00")) {
            return 4;
        }
        if (value.equals("01")) {
            return 3;
        }
        if (value.equals("10")) {
            return 2;
        }
        if (value.equals("11")) {
            return 1;
        }
        return 0;
    }

    public static int getHeure(String binaryValue) {
        return Integer.parseInt(binaryValue, 2);
    }

    public static String getBinaryActivity(String octet) {
        while (octet.length() < 16) {
            octet = "0" + octet;
        }
        return octet;
    }

    public static ChangementActivite getDetailActivite(byte[] activite, Date day, String source, String sourceName) {
        int tmpInt = Fonctions.bytesToInt(activite, 0, 2);
        String binaryActivite = VuFileParserG2.getBinaryActivity(Integer.toBinaryString(tmpInt));
        String s = binaryActivite.substring(0, 1);
        String c = binaryActivite.substring(1, 2);
        String p = binaryActivite.substring(2, 3);
        String aa = binaryActivite.substring(3, 5);
        String tttttttttt = binaryActivite.substring(5, 16);
        String lecteur = VuFileParserG2.getLecteur(s);
        String conduite = VuFileParserG2.getEtatConduite(c);
        String carte = VuFileParserG2.getEtatCarte(p);
        int typeActivite = VuFileParserG2.getActivite(aa);
        int heure = VuFileParserG2.getHeure(tttttttttt);
        ChangementActivite retour = new ChangementActivite(typeActivite, day, heure, lecteur, conduite, carte, source, sourceName);
        return retour;
    }
}

