/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.CompanyCard;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.JourUEV;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.UevActivity;
import fr.pgh.data.bdd.UevCalibration;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UevEventsFaults;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.data.bdd.UevSession;
import fr.pgh.data.bdd.UevSpeed;
import fr.pgh.data.bdd.VehicleError;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.uev.UEVProperty;
import transpo.system.uev.exception.VuFileNotFoundException;
import transpo.system.uev.exception.VuFileStructureException;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.ui.views.vehicule.DialogCreationVehicule;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.ListMessage;
import transpo.system.util.messaging.ListsMessage;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.system.util.reader.FileReadResult;

public class VuProcessingG1 {
    public static final int CANCEL = 0;
    public static final int SUCCESS = 1;
    public static final int UNKNOWN_VEHICLE = 2;
    public static final int OLDER_FILE = 6;
    public static final int SAVE_ERROR = 7;
    public static final int SET_ERROR = 9;
    private BddTransport refBDD = null;
    public Preferences prefs = Preferences.userRoot().node("TIMS");
    public File toRead = null;
    private byte[] fileBuffer = null;
    private boolean fileReaden = false;
    Vehicule currentVehicule = null;
    private Vector<VehicleUsed> io = new Vector();
    private Vector<ChangementActivite> activConducteur = new Vector();
    private Vector<ChangementActivite> activConvoyeur = new Vector();
    private Vector<JourUEV> day = new Vector();
    private Vector<UevCalibration> uevCalibration = null;
    private ArrayList<UevEventsFaults> eventsFaults = new ArrayList();
    private ArrayList<UevSpeed> speed = new ArrayList();
    private ArrayList<UevSpeed> speedOverview = new ArrayList();
    private DateFormat formatDatedb = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat formatDateHeuredb = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat formatdateCmp = new SimpleDateFormat("ddMM");
    private String vehicleRegistrationImmat = "";
    private boolean forbiddenChar = false;
    private String wrongRegistration = "";
    private String vehicleIdentification = "";
    private String vuSoftwareVersion = null;
    private String vuManufacturerName = null;
    private Date dateMin = null;
    private Date dateMax = null;
    private Date beginActivity = null;
    private Date endActivity = null;
    private Date previousDownload = null;
    private Vector<VehicleError> errors = null;
    private Vector<Date> emptyDay = null;
    private HashMap<Date, Integer> kmDay = new HashMap();
    private Date jourEteToHiver = null;
    private Date jourHiverToEte = null;
    private ProgressBar progression = null;
    private int lastKnownKm = 0;
    private int dayUsedCount = 0;
    private int totalKm = 0;
    private boolean olderActivity = false;
    private boolean missingActivity = false;
    private Date lastDownload = null;
    private Vector<String> unknownDriver = new Vector();
    private Vector<Conducteur> list = null;
    private Vector<VehicleUsed> vehiclesDB;

    public VuProcessingG1(File toRead) throws HeadlessException {
        this.toRead = toRead;
        this.errors = new Vector();
        this.formatDateHeuredb.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        this.refBDD = BddTransport.getInstance();
    }

    public void readFile() {
        BufferedInputStream fs = null;
        try {
            FileInputStream channel = new FileInputStream(this.toRead);
            fs = new BufferedInputStream(channel);
            int taille = fs.available();
            this.fileBuffer = new byte[taille];
            fs.read(this.fileBuffer, 0, taille);
            channel.close();
            fs.close();
            this.fileReaden = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FileReadResult run() {
        TimsLogger.debug("#VuPG1.run# Read uev file " + this.toRead.getName());
        Transport.ps.startOperation();
        int readingState = this.checkFileUEV();
        if (readingState == 7) {
            TimsLogger.warn("#VuPG1.run# " + LanguageTranslator.getString("vehicle.badFile"));
            Transport.ps.endOperation(PerformanceScanner.INSERT, "total UEV process");
            return new FileReadResult(this.toRead.getName(), 0, LanguageTranslator.getString("vehicle.badFile"), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(5)) + 7), this.toRead.getName());
        }
        if (readingState == 1) {
            TimsLogger.info("VuPG1P.run# File ever read");
            Transport.ps.endOperation(PerformanceScanner.INSERT, "total UEV process");
            if (Transport.apiMode == 1) {
                this.toRead.delete();
            }
            return new FileReadResult(this.toRead.getName(), 1, LanguageTranslator.getString("uev.everRead"), LanguageTranslator.getString("uev.everRead"), this.toRead.getName());
        }
        this.readIdentification();
        int saved = 1;
        readingState = this.checkVehicle();
        TimsLogger.debug("VuProgessingG1# Vehicule loaded " + this.currentVehicule.getCleVehicule() + " " + readingState);
        if (readingState == 1) {
            if (System.getProperty("check_missing", "0").equals("1")) {
                Fonctions.lookForFiles(this.currentVehicule);
            }
            this.lastDownload = ConversionTime.stringToDate(this.currentVehicule.getDateTelechargement() == "" ? "1970-01-01" : this.currentVehicule.getDateTelechargement().substring(0, 10), "yyyy-MM-dd");
            try {
                BddTransport.getInstance().startTransaction();
                saved = this.dataProcess();
                if (saved == 1) {
                    BddTransport.getInstance().commit();
                } else {
                    BddTransport.getInstance().rollback();
                }
            }
            catch (Exception exp) {
                BddTransport.getInstance().rollback();
                TimsLogger.error("#VuPG1.run()# Exception in dataProcess()");
                exp.printStackTrace();
                return new FileReadResult(this.toRead.getName(), 0, LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(5)) + 3), LanguageTranslator.getString("uev.informationError"), this.toRead.getName());
            }
            if (Transport.apiMode == 0) {
                MainFrameTransport.getInstance().refreshTree(2);
            }
        } else if (readingState == 0) {
            TimsLogger.info("#VuPG1.run# abandon cr\u00e9ation du v\u00e9hicule");
            new FileReadResult(this.toRead.getName(), 4, null, LanguageTranslator.getString("uev.readCancel"), this.toRead.getName());
        }
        if (saved == 1) {
            TimsLogger.info("#VuPG1.run# " + this.toRead.getName() + " reading succeed");
            long duration = Transport.ps.endOperation(PerformanceScanner.INSERT, "total UEV process");
            FileReadResult toReturn = new FileReadResult(this.toRead.getName(), 1, LanguageTranslator.getString("uev.activityFromTo", this.beginActivity == null ? "?" : ConversionTime.dateToString(this.beginActivity, "dd/MM/yyyy"), this.endActivity == null ? "?" : ConversionTime.dateToString(this.endActivity, "dd/MM/yyyy")), "", String.valueOf(this.toRead.getName()) + " : " + LanguageTranslator.getString("uev.activitySaved") + " (" + duration + " ms)");
            if (this.errors.size() != 0) {
                toReturn.setResume(this.toRead.getName());
                toReturn.setStatus(3);
                toReturn.setInfo(new ListsMessage(this.getErrorsWarningList()));
            }
            return toReturn;
        }
        return new FileReadResult(this.toRead.getName(), 0, LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(5)) + String.valueOf(saved)), "", this.toRead.getName());
    }

    private ListMessage getErrorsWarningList() {
        if (this.errors.size() == 0) {
            return null;
        }
        return new ListMessage(LanguageTranslator.getString("uev.missing.activity"), null, this.errors);
    }

    private int checkVehicle() {
        this.readTechnique();
        if (this.vehicleRegistrationImmat.equals("")) {
            return 2;
        }
        if (this.forbiddenChar) {
            MessageSystemManager.warning((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("uev.reading.registrationError"), LanguageTranslator.getString("uev.reading.title", this.vehicleRegistrationImmat));
        }
        this.currentVehicule = new Vehicule();
        if (!this.currentVehicule.loadByIdentification(this.vehicleIdentification) && !this.currentVehicule.loadByImmat(this.vehicleRegistrationImmat, false)) {
            TimsLogger.debug("#VuPG1.checkVehicle# " + this.vehicleRegistrationImmat + " (" + this.vehicleIdentification + ") doesn't exist");
            this.currentVehicule.setRegistrationNumber(this.vehicleRegistrationImmat);
            this.currentVehicule.setIdentificationNumber(this.vehicleIdentification);
            this.currentVehicule.setVuBrand(this.vuManufacturerName);
            this.currentVehicule.setVuVersion(this.vuSoftwareVersion);
            if (Transport.apiMode == 1) {
                this.currentVehicule.insert();
                return this.currentVehicule.loadByImmat(this.vehicleRegistrationImmat, false) ? 1 : 2;
            }
            if (JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("uev.unknownVehicle", this.vehicleRegistrationImmat), LanguageTranslator.getString("uev.reading.title", this.vehicleRegistrationImmat), 0, 3) == 0) {
                DialogCreationVehicule creation = new DialogCreationVehicule((Frame)MainFrameTransport.getInstance(), this.currentVehicule);
                creation.setVisible(true);
                if (creation.enregistrement) {
                    TimsLogger.debug("#VuProcessingG1# vehicle created");
                    return this.currentVehicule.loadByImmat(this.vehicleRegistrationImmat, false) ? 1 : 2;
                }
            }
            return 0;
        }
        this.currentVehicule.updateTechnical(this.vehicleIdentification, this.vehicleRegistrationImmat, this.currentVehicule.getBrand(), this.vuManufacturerName, this.vuSoftwareVersion);
        return 1;
    }

    public int dataProcess() {
        int information;
        if (Transport.apiMode == 0) {
            this.getProgression().setVisible(true);
            this.getProgression().getBar().setMinimum(0);
            this.getProgression().getBar().setMaximum(10);
        }
        if ((information = this.readInformation()) != 2) {
            return 20 + information;
        }
        try {
            this.setPbValue(3, null);
            this.saveInfos();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return 7;
        }
        try {
            if (!this.setTelechargement()) {
                throw new Exception();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return 9;
        }
        return 1;
    }

    public String extractFileName() {
        if (!this.fileReaden) {
            this.readFile();
        }
        SimpleDateFormat FormatdateNom = new SimpleDateFormat("yyMMddHHmm");
        String result = "-1";
        int offset = 0;
        offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_IDENTIFICATION);
        if (offset < -1) {
            return String.valueOf(offset);
        }
        int UEVIssuingMemberState = Fonctions.bytesToInt(this.fileBuffer, offset += UEVProperty.MemberStateCertificateSize + UEVProperty.VUCertificateSize + UEVProperty.vehicleIdentificationNumberSize + 2, 1);
        String memberState = Pays.LIBELLE[0][0];
        if (Pays.LIBELLE.length > UEVIssuingMemberState && UEVIssuingMemberState >= 0) {
            memberState = Pays.LIBELLE[UEVIssuingMemberState][0];
        }
        result = memberState;
        offset += UEVProperty.vehicleMemberStateSize + 1;
        byte[] vehicleRegistrationNumberchar = new byte[13];
        int j = 0;
        while (j < vehicleRegistrationNumberchar.length) {
            vehicleRegistrationNumberchar[j] = this.fileBuffer[offset + j];
            ++j;
        }
        result = String.valueOf(result) + new String(vehicleRegistrationNumberchar).trim();
        while (result.length() < 16) {
            result = String.valueOf(result) + "_";
        }
        Date date_UEV = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 13, 4));
        result = String.valueOf(result) + FormatdateNom.format(date_UEV);
        return result;
    }

    int checkFileUEV() {
        int retour = -1;
        if (this.toRead == null || !this.toRead.getName().substring(this.toRead.getName().lastIndexOf(".")).toUpperCase().equals(".V1B")) {
            return 7;
        }
        if (UevDownload.loadList("NOM_FICHIER='" + this.toRead.getName() + "'").size() != 0) {
            retour = 1;
        }
        return retour;
    }

    private boolean setTelechargement() {
        boolean toReturn = true;
        String fileName = FileManager.moveFile(this.currentVehicule, this.toRead);
        if (fileName == null) {
            return false;
        }
        UevDownload toAdd = new UevDownload(this.currentVehicule, ConnexionSettings.getInstance().getUserCle(), this.getDlDate(this.toRead.getName()), fileName, this.beginActivity, this.endActivity, this.previousDownload);
        if (!toAdd.insert()) {
            toReturn = false;
        }
        if (ConversionTime.stringToDateDb(this.currentVehicule.getDateTelechargement(), true).before(this.dateMax)) {
            this.currentVehicule.setDateTelechargement(this.formatDateHeuredb.format(this.dateMax));
        }
        this.currentVehicule.setLastKnownKm(this.lastKnownKm);
        TimsLogger.debug("#VuPG1.setTelechargement# km moyen avant : " + this.currentVehicule.getAverageDailyKm() + ", totalKm=" + this.totalKm + " sur " + this.dayUsedCount + " jours dans le fichier, nouvelle moyenne = " + this.getDailyKm());
        this.currentVehicule.setAverageDailyKm(this.getDailyKm());
        if (this.vuManufacturerName != null && !this.vuManufacturerName.equals(this.currentVehicule.getVuBrand())) {
            this.currentVehicule.setVuBrand(this.vuManufacturerName);
        }
        if (this.vuSoftwareVersion != null && !this.vuSoftwareVersion.equals(this.currentVehicule.getVuVersion())) {
            this.currentVehicule.setVuVersion(this.vuSoftwareVersion);
        }
        this.currentVehicule.update();
        return toReturn;
    }

    private int getDailyKm() {
        if (this.currentVehicule.getAverageDailyKm() == 0 || this.dayUsedCount >= 180) {
            return this.totalKm / (this.dayUsedCount == 0 ? 1 : this.dayUsedCount);
        }
        int kmBefore = (180 - this.dayUsedCount) * this.currentVehicule.getAverageDailyKm();
        int done = kmBefore + this.totalKm;
        return done / 180;
    }

    public Date getDlDate(String nomFichier) {
        String dateBDD = "";
        String tmp = nomFichier.substring(nomFichier.length() - 14, nomFichier.length() - 4);
        String jour = tmp.substring(4, 6);
        String mois = tmp.substring(2, 4);
        String year = "20";
        if (Integer.parseInt(tmp.substring(0, 2)) >= 70) {
            year = "19";
        }
        String annee = String.valueOf(year) + tmp.substring(0, 2);
        String heure = String.valueOf(tmp.substring(6, 8)) + ":" + tmp.substring(8, 10);
        dateBDD = String.valueOf(annee) + "-" + mois + "-" + jour + " " + heure;
        return ConversionTime.stringToDate(dateBDD, "yyyy-MM-dd HH:mm");
    }

    /*
     * WARNING - void declaration
     */
    private void saveInfos() throws Exception {
        void var14_23;
        Conducteur tmpC;
        MainElement toCheck;
        FileWriter fCalibration;
        FileWriter fSpeed;
        FileWriter fEventFault;
        FileWriter fDay;
        FileWriter fIOUEV;
        String calibrationFn;
        String speedFn;
        String eventFaultFn;
        String dayFn;
        String vehicleTFn;
        block42: {
            TimsLogger.debug("#VuPG1.saveInfos# d\u00e9but sauvegarde");
            Transport.ps.startOperation();
            int random = (int)(Math.random() * 1000.0);
            vehicleTFn = String.valueOf(Transport.savePath) + "vehicle" + random + ".txt";
            while (new File(vehicleTFn).exists()) {
                random = (int)(Math.random() * 1000.0);
                vehicleTFn = String.valueOf(Transport.savePath) + "service" + random + ".txt";
            }
            dayFn = String.valueOf(Transport.savePath) + "day_uev" + random + ".txt";
            eventFaultFn = String.valueOf(Transport.savePath) + "eventFault" + random + ".txt";
            speedFn = String.valueOf(Transport.savePath) + "speed" + random + ".txt";
            calibrationFn = String.valueOf(Transport.savePath) + "calibration" + random + ".txt";
            fIOUEV = new FileWriter(vehicleTFn);
            fDay = new FileWriter(dayFn);
            fEventFault = new FileWriter(eventFaultFn);
            fSpeed = new FileWriter(speedFn);
            fCalibration = new FileWriter(calibrationFn);
            Date begin = null;
            if (this.io.size() != 0) {
                begin = this.io.get(0).getDateDebut();
            }
            int i = 0;
            this.setPbValue(-1, LanguageTranslator.getString("uev.activityInsert"));
            if (begin == null) break block42;
            Vector<VehicleUsed> vector = VehicleUsed.loadListVehicle(0, this.currentVehicule.getCleVehicule(), begin, this.lastDownload);
            TimsLogger.verbose("#VuPG1.saveInfos# " + vector.size() + " utilisations du v\u00e9hicule d\u00e9j\u00e0 connues entre " + begin + " et " + this.lastDownload);
            while (i < this.io.size()) {
                block44: {
                    VehicleUsed tmp;
                    block47: {
                        block45: {
                            block46: {
                                block43: {
                                    tmp = this.io.get(i);
                                    TimsLogger.debug("IO check " + tmp.getDateDebut() + " " + tmp.getCleVehicule());
                                    if (tmp.getKmFin() != -1 || i == this.io.size() - 1) break block43;
                                    TimsLogger.debug("#VuPG1.saveInfos# " + tmp.getSQLInsert() + " on n'ins\u00e8re pas...");
                                    break block44;
                                }
                                VehicleUsed existing = VehicleUsed.exist(tmp, vector);
                                if (existing == null) break block45;
                                TimsLogger.debug("" + tmp.getDateFin().getTime());
                                if (existing.getDateFin() != null || tmp.getDateFin().getTime() <= 100000L) break block46;
                                existing.delete("vehicle_used");
                                TimsLogger.debug("#VuPG1.saveInfos# IO \u00e0 " + tmp.getDateDebut() + " existe d\u00e9j\u00e0 dans la base mais date de fin \u00e0 mettre \u00e0 jour pour " + tmp.getDateFin());
                                break block47;
                            }
                            TimsLogger.debug("#VuPG1.saveInfos# IO \u00e0 " + tmp.getDateDebut() + " existe d\u00e9j\u00e0 dans la base");
                            break block44;
                        }
                        TimsLogger.debug("#VuPG1.saveInfos# IO \u00e0 " + tmp.getDateDebut() + " " + tmp.getCleVehicule() + " inconnu");
                    }
                    if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                        tmp.insert("vehicle_used");
                    }
                    if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                        fIOUEV.write(tmp.getSQLInsert());
                        fIOUEV.write("\n");
                    }
                }
                ++i;
            }
            boolean first = true;
            String daysToDelete = "";
            Vector<JourUEV> days = this.getDays();
            for (JourUEV toAdd : days) {
                if (first && toAdd.getActivities().size() != 0) {
                    TimsLogger.debug("VuPG1.saveInfos # on v\u00e9rifie la premi\u00e8re journ\u00e9e " + toAdd.getDay());
                    JourUEV old = JourUEV.load(toAdd.getVehicleId(), toAdd.getDay());
                    int added = 0;
                    if (old != null && old.getTotal() != 0 && old.getActivities().get(0).getHeureFin() < 120) {
                        UevActivity getUntil = toAdd.getActivities().get(0);
                        TimsLogger.debug("#VuPG1# on a une journ\u00e9e avec " + old.getActivities().size() + " activit\u00e9s pr\u00e9sentes. on g\u00e8re jusqu'\u00e0 " + getUntil.getHeureDebut());
                        for (UevActivity toCheck2 : old.getActivities()) {
                            if (toCheck2.getHeureDebut() >= getUntil.getHeureFin()) break;
                            toAdd.getActivities().add(added, toCheck2);
                            ++added;
                            if (toCheck2.getHeureFin() != getUntil.getHeureFin()) continue;
                            toAdd.getActivities().remove(added);
                        }
                    }
                    TimsLogger.debug("#VuPG1# premier journ\u00e9e trait\u00e9e " + added + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es");
                    first = false;
                }
                daysToDelete = String.valueOf(daysToDelete) + ",\"" + ConversionTime.dateToStringDb(toAdd.getDay()) + "\"";
                if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
                fDay.write(toAdd.getSQLInsert());
                fDay.write("\n");
            }
            if (!daysToDelete.equals("")) {
                this.refBDD.delUEVActivityAndDay(this.currentVehicule, daysToDelete.substring(1));
            }
            for (JourUEV toAdd : days) {
                if (!System.getProperty("SGBDR", "mysql").equals("oracle")) continue;
                toAdd.insert();
            }
        }
        for (UevEventsFaults uevEventsFaults : this.eventsFaults) {
            toCheck = new UevEventsFaults();
            if (((UevEventsFaults)toCheck).load(this.currentVehicule.getCleVehicule(), uevEventsFaults.getBegin())) continue;
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                uevEventsFaults.insert();
            } else {
                fEventFault.write(uevEventsFaults.getSQLString());
                fEventFault.write("\n");
            }
            if (!Fonctions.getLibelleEventFault(uevEventsFaults.getTypeId()).equals(LanguageTranslator.getString("eventType.04"))) continue;
            long ms = uevEventsFaults.getEnd().getTime() - uevEventsFaults.getBegin().getTime();
            int length = (int)(ms / 60000L);
            new UevOffence(this.currentVehicule.getCleVehicule(), 0, uevEventsFaults.getBegin(), uevEventsFaults.getEnd(), length, length, 3, 1).insert();
        }
        this.setPbValue(-1, LanguageTranslator.getString("uev.speedInsert"));
        for (UevSpeed uevSpeed : this.speed) {
            int length;
            block40: {
                toCheck = new UevSpeed();
                if (((UevSpeed)toCheck).load(this.currentVehicule.getCleVehicule(), uevSpeed.getDateDebut())) continue;
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    uevSpeed.insert();
                } else {
                    fSpeed.write(uevSpeed.getSQLString());
                    fSpeed.write("\n");
                }
                long ms = uevSpeed.getDateFin().getTime() - uevSpeed.getDateDebut().getTime();
                length = (int)(ms / 60000L);
                tmpC = null;
                try {
                    if (uevSpeed.getNumeroCarteConducteur() != null) {
                        tmpC = Conducteur.getDriver(this.getDrivers(), uevSpeed.getNumeroCarteConducteur(), -1);
                    }
                }
                catch (Exception ex) {
                    if (Transport.debug < 2) break block40;
                    if (Transport.apiMode == 0) {
                        TimsLogger.debug("#VuPG1.saveInfos# unknow driver " + uevSpeed.getNumeroCarteConducteur());
                    }
                    this.unknownDriver.add(uevSpeed.getNumeroCarteConducteur());
                }
            }
            new UevOffence(this.currentVehicule.getCleVehicule(), tmpC != null ? tmpC.getCleConducteur() : 0, uevSpeed.getDateDebut(), uevSpeed.getDateFin(), length, uevSpeed.getVitesseMax(), 0, 2).insert();
        }
        for (UevSpeed uevSpeed : this.speedOverview) {
            int length;
            block41: {
                toCheck = new UevSpeed();
                if (((UevSpeed)toCheck).load(this.currentVehicule.getCleVehicule(), uevSpeed.getDateDebut())) continue;
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    uevSpeed.insert();
                } else {
                    fSpeed.write(uevSpeed.getSQLString());
                    fSpeed.write("\n");
                }
                long ms = uevSpeed.getDateFin().getTime() - uevSpeed.getDateDebut().getTime();
                length = (int)(ms / 60000L);
                tmpC = null;
                try {
                    if (uevSpeed.getNumeroCarteConducteur() != null) {
                        tmpC = Conducteur.getDriver(this.getDrivers(), uevSpeed.getNumeroCarteConducteur(), -1);
                    }
                }
                catch (Exception ex) {
                    if (Transport.debug < 2) break block41;
                    if (Transport.apiMode == 0) {
                        TimsLogger.debug("#VuPG1.saveInfos# unknow driver " + uevSpeed.getNumeroCarteConducteur());
                    }
                    this.unknownDriver.add(uevSpeed.getNumeroCarteConducteur());
                }
            }
            new UevOffence(this.currentVehicule.getCleVehicule(), tmpC != null ? tmpC.getCleConducteur() : 0, uevSpeed.getDateDebut(), uevSpeed.getDateFin(), length, uevSpeed.getVitesseMax(), 0, 2).insert();
        }
        this.setPbValue(-1, LanguageTranslator.getString("uev.technicInsert"));
        Object var14_21 = null;
        if (this.currentVehicule.getNbEtalonnage() >= 1) {
            Vector<UevCalibration> db = Transport.bdd.getEtalonnage(this.currentVehicule.getCleVehicule());
            UevCalibration uevCalibration = db.get(db.size() - 1);
        }
        int x = this.currentVehicule.getNbEtalonnage();
        if (var14_23 != null && this.uevCalibration != null && this.uevCalibration.size() != 0) {
            TimsLogger.debug("#VuPG1.saveInfos()# on cherche l'\u00e9talonnage " + var14_23.getSQLString());
            x = 1;
            while (!var14_23.equals(this.uevCalibration.get(x - 1))) {
                TimsLogger.debug("#VuPG1.saveInfos()# pas cette \u00e9talonnage  " + this.uevCalibration.get(x - 1).getSQLString());
                if (++x <= this.uevCalibration.size()) continue;
                TimsLogger.warn("#VuPG1.saveInfos()# impossible de trouver le dernier \u00e9talonnage de la base dans le fichier");
                x = 0;
                break;
            }
        }
        TimsLogger.debug("#VuPG1.saveInfos()# on enregistre \u00e0 partir de l'\u00e9talonnage " + (x + 1) + " sur " + this.uevCalibration.size() + " (" + this.currentVehicule.getNbEtalonnage() + " dans la base)");
        while (x < this.uevCalibration.size()) {
            int type = this.uevCalibration.get(x).getTypeEtalonnage();
            if (type != 4 && type != 3) {
                TimsLogger.debug("#VuPG1.saveInfos()# on saute l'\u00e9talonnage " + x + " (type=" + type + ")");
            } else {
                Object toAdd;
                void var14_24;
                if (var14_24 != null) {
                    Date futureCal = ConversionTime.add(ConversionTime.stringToDate(var14_24.getAncienneDate(), "yyyy-MM-dd"), 1, 1);
                    Date nextCal = ConversionTime.stringToDate(this.uevCalibration.get(x).getAncienneDate(), "yyyy-MM-dd");
                    TimsLogger.debug("#VuPG1.saveInfos# Le prochain \u00e9talonnage doit avoir lieu avant le " + futureCal + " (il a lieu le " + nextCal + ")");
                    if (futureCal.before(nextCal)) {
                        TimsLogger.debug("#VuPG1.saveInfos# infraction \u00e9talonnage le " + futureCal);
                        new UevOffence(this.currentVehicule.getCleVehicule(), 0, futureCal, futureCal, 0, 0, 3, 0).insert();
                    }
                }
                UevCalibration uevCalibration = this.uevCalibration.get(x);
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    this.uevCalibration.get(x).clone(this.uevCalibration.get(x));
                    this.uevCalibration.get(x).insert();
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    toAdd = String.valueOf(this.uevCalibration.get(x).getCleVehicule()) + "\t" + this.uevCalibration.get(x).getTypeEtalonnage() + "\t" + this.uevCalibration.get(x).getNom() + "\t" + this.uevCalibration.get(x).getAdresse() + "\t" + this.uevCalibration.get(x).getTypeCarte() + "\t" + this.uevCalibration.get(x).getNumeroCarte() + "\t" + this.uevCalibration.get(x).getExpirationCarte() + "\t" + this.uevCalibration.get(x).getIdentificationVehicule() + "\t" + this.uevCalibration.get(x).getClePays() + "\t" + this.uevCalibration.get(x).getEnregistrementVehicule() + "\t" + this.uevCalibration.get(x).getW() + "\t" + this.uevCalibration.get(x).getK() + "\t" + this.uevCalibration.get(x).getL() + "\t" + this.uevCalibration.get(x).getTyreSize() + "\t" + this.uevCalibration.get(x).getAuthorizedSpeed() + "\t" + this.uevCalibration.get(x).getAncienKM() + "\t" + this.uevCalibration.get(x).getNouveauKM() + "\t" + this.uevCalibration.get(x).getAncienneDate() + "\t" + this.uevCalibration.get(x).getNouvelleDate() + "\t" + this.uevCalibration.get(x).getProchainEtalonnage();
                    fCalibration.write((String)toAdd);
                    fCalibration.write("\n");
                }
                toAdd = new Intervention(0, 1, this.currentVehicule.getCleVehicule(), ConversionTime.stringToDate(this.uevCalibration.get(x).getAncienneDate(), "yyyy-MM-dd"), this.uevCalibration.get(x).getNouveauKM() > 10000000 ? this.uevCalibration.get(x).getAncienKM() : this.uevCalibration.get(x).getNouveauKM(), this.uevCalibration.get(x).getNom(), 0.0f, 0.0f, 0, null);
                ((Intervention)toAdd).update();
            }
            ++x;
        }
        fIOUEV.close();
        fDay.close();
        fEventFault.close();
        fSpeed.close();
        fCalibration.close();
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            Transport.ps.startOperation();
            this.setPbValue(4, LanguageTranslator.getString("uev.informationInsert"));
            this.refBDD.loadVehicleDay(dayFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
            Transport.ps.startOperation();
            this.setPbValue(5, LanguageTranslator.getString("uev.IOInsert"));
            this.refBDD.loadVehicleUsed(vehicleTFn, "vehicle_used");
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
            Transport.ps.startOperation();
            this.setPbValue(7, LanguageTranslator.getString("uev.activityInsert"));
            this.refBDD.loadVehicleEventsFaults(eventFaultFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
            Transport.ps.startOperation();
            this.setPbValue(8, LanguageTranslator.getString("uev.speedInsert"));
            this.refBDD.loadVehicleSpeed(speedFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
            Transport.ps.startOperation();
            this.setPbValue(9, LanguageTranslator.getString("uev.technicInsert"));
            this.refBDD.loadVehicleCalibration(calibrationFn);
            Transport.ps.endOperation(PerformanceScanner.INSERT, "uev calibration");
        }
        new File(vehicleTFn).delete();
        new File(dayFn).delete();
        new File(eventFaultFn).delete();
        new File(speedFn).delete();
        new File(calibrationFn).delete();
        if (Transport.apiMode == 0) {
            this.getProgression().dispose();
        }
        Transport.ps.endOperation(PerformanceScanner.INSERT, "uev activity");
    }

    private Vector<JourUEV> getDays() {
        Vector<JourUEV> daysToReturn = new Vector<JourUEV>();
        int j = 0;
        int total = 0;
        Vector<UevActivity> dailyActivity = new Vector<UevActivity>();
        while (j < this.activConducteur.size()) {
            int heureFin = 1440;
            ChangementActivite tmp = this.activConducteur.get(j);
            if (j != this.activConducteur.size() - 1 && ConversionTime.dateToString(this.activConducteur.get(j + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(this.activConducteur.get(j).getDate(), "dd/MM/yyyy"))) {
                heureFin = this.activConducteur.get(j + 1).getHeure();
            }
            int dureeAct = heureFin - tmp.getHeure();
            if (tmp.getTypeActivite() == 1 || tmp.getTypeActivite() == 2 || tmp.getTypeActivite() == 3 || tmp.getTypeActivite() == 5) {
                total += dureeAct;
            }
            UevActivity toAdd = new UevActivity(this.currentVehicule.getCleVehicule(), tmp.getTypeActivite(), "", "", tmp.getHeure(), heureFin, dureeAct, tmp.getEtatCarte(), tmp.getEtatConduite(), tmp.getLecteur(), this.formatDatedb.format(tmp.getDate()));
            dailyActivity.add(toAdd);
            if (heureFin == 1440) {
                TimsLogger.verbose("#VuPG1.saveInfos# en day (" + j + " sur " + this.activConducteur.size() + ") =>" + this.activConducteur.get(j).getDate() + " " + this.kmDay.get(this.activConducteur.get(j).getDate()));
                Integer kmI = this.kmDay.get(this.activConducteur.get(j).getDate());
                int km = kmI == null ? this.lastKnownKm : kmI;
                Integer previousKm = this.kmDay.get(ConversionTime.add(this.activConducteur.get(j).getDate(), 5, -1));
                int dailyKm = previousKm == null ? 0 : km - previousKm;
                JourUEV dayToAdd = new JourUEV(0, this.currentVehicule.getCleVehicule(), ConnexionSettings.getInstance().getUserCle(), this.activConducteur.get(j).getDate(), km, dailyKm, total, "", dailyActivity);
                daysToReturn.add(dayToAdd);
                dailyActivity = new Vector();
                total = 0;
            }
            ++j;
        }
        return daysToReturn;
    }

    private Vector<Conducteur> getDrivers() {
        if (this.list == null) {
            this.list = Conducteur.loadListWithArchive(new Integer[0]);
        }
        return this.list;
    }

    public int readInformation() {
        Transport.ps.startOperation();
        int status = this.readIdentification();
        Transport.ps.endOperation(PerformanceScanner.READING, "uev information");
        if (status != 2 && !this.printErrorAndContinue(status, LanguageTranslator.getString("vehicle.identification"))) {
            return status;
        }
        this.setPbValue(-1, LanguageTranslator.getString("uev.activityRead"));
        Transport.ps.startOperation();
        status = this.readActivity();
        Transport.ps.endOperation(PerformanceScanner.READING, "uev activity");
        if (status != 2 && !this.printErrorAndContinue(status, LanguageTranslator.getString("vehicle.activity"))) {
            return status;
        }
        if (this.missingActivity) {
            String begin = ConversionTime.dateToString(this.lastDownload, "dd/MM/yyyy");
            String end = ConversionTime.dateToString(this.activConducteur.get(0).getDate(), "dd/MM/yyyy");
            Date beginD = ConversionTime.stringToDateFr(begin);
            Date endD = ConversionTime.stringToDateFr(end);
            this.errors.add(new VehicleError(0, this.currentVehicule.getCleVehicule(), beginD, endD, 2, "", 0));
        }
        this.setPbValue(-1, LanguageTranslator.getString("uev.eventsRead"));
        Transport.ps.startOperation();
        status = this.readAnomalie();
        Transport.ps.endOperation(PerformanceScanner.READING, "uev faults");
        if (status != 2 && !this.printErrorAndContinue(status, LanguageTranslator.getString("vehicle.fault"))) {
            return status;
        }
        this.setPbValue(-1, LanguageTranslator.getString("uev.technicRead"));
        Transport.ps.startOperation();
        status = this.readTechnique();
        Transport.ps.endOperation(PerformanceScanner.READING, "uev calibration");
        this.readSpeedOverview();
        if (status != 2 && !this.printErrorAndContinue(status, LanguageTranslator.getString("vehicle.calibration"))) {
            return status;
        }
        return 2;
    }

    private boolean printErrorAndContinue(int status, String name) {
        if (status == 6) {
            if (Transport.apiMode == 0) {
                SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(LanguageTranslator.getString("uev.noInformation", name), LanguageTranslator.getString("generics.warning"));
                tmp.run();
                if (tmp.option == 1) {
                    if (Transport.apiMode == 0) {
                        this.getProgression().dispose();
                    }
                    return false;
                }
            } else {
                MessageSystemManager.warning(null, LanguageTranslator.getString("uev.noInformation", name), this.toRead.getName());
                TimsLogger.info(LanguageTranslator.getString("uev.noInformation", name));
            }
        } else if (status == 10) {
            MessageSystemManager.error(null, LanguageTranslator.getString("uev.structure.error"), LanguageTranslator.getString("generics.error"));
            return false;
        }
        return true;
    }

    public ArrayList<UevEventsFaults> getInterruption() {
        ArrayList<UevEventsFaults> toReturn = new ArrayList<UevEventsFaults>();
        int offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_EVT_ANOMALIE);
        if (offset <= -1) {
            return toReturn;
        }
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#VuPG1.readAnomalie()# Begin at " + Integer.toHexString(offset) + " " + this.toRead.getName());
        }
        try {
            int noOfVuFaults = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 1);
            ++offset;
            int i = 1;
            while (i <= noOfVuFaults) {
                int type = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                int purpose = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                Date begin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
                Date end = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                offset = offset + 4 + 2;
                byte[] cardNumberSlot = new byte[16];
                int j = 0;
                while (j < cardNumberSlot.length) {
                    cardNumberSlot[j] = this.fileBuffer[offset + j];
                    ++j;
                }
                String driverCardBegin = new String(cardNumberSlot);
                if (driverCardBegin.startsWith("\u00ff\u00ff\u00ff")) {
                    driverCardBegin = null;
                }
                offset = offset + 16 + 2;
                int j2 = 0;
                while (j2 < cardNumberSlot.length) {
                    cardNumberSlot[j2] = this.fileBuffer[offset + j2];
                    ++j2;
                }
                String codriverCardBegin = new String(cardNumberSlot);
                if (codriverCardBegin.startsWith("\u00ff\u00ff\u00ff")) {
                    codriverCardBegin = null;
                }
                offset = offset + 16 + 2;
                int j3 = 0;
                while (j3 < cardNumberSlot.length) {
                    cardNumberSlot[j3] = this.fileBuffer[offset + j3];
                    ++j3;
                }
                String driverCardEnd = new String(cardNumberSlot);
                if (driverCardEnd.startsWith("\u00ff\u00ff\u00ff")) {
                    driverCardEnd = null;
                }
                offset = offset + 16 + 2;
                int j4 = 0;
                while (j4 < cardNumberSlot.length) {
                    cardNumberSlot[j4] = this.fileBuffer[offset + j4];
                    ++j4;
                }
                String codriverCardEnd = new String(cardNumberSlot);
                if (codriverCardEnd.startsWith("\u00ff\u00ff\u00ff")) {
                    codriverCardEnd = null;
                }
                offset += 16;
                UevEventsFaults toAdd = new UevEventsFaults(0, 0, begin, end, type, purpose, driverCardBegin, codriverCardBegin, driverCardEnd, codriverCardEnd, 0);
                if (toAdd.getTypeId() == 8) {
                    toReturn.add(toAdd);
                }
                ++i;
            }
            int noOfVuEvents = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
            ++offset;
            int i2 = 1;
            while (i2 <= noOfVuEvents) {
                int type = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                int purpose = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                Date begin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
                Date end = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                offset = offset + 4 + 2;
                byte[] cardNumberSlot = new byte[16];
                int j = 0;
                while (j < cardNumberSlot.length) {
                    cardNumberSlot[j] = this.fileBuffer[offset + j];
                    ++j;
                }
                String driverCardBegin = new String(cardNumberSlot);
                if (driverCardBegin.startsWith("\u00ff\u00ff\u00ff")) {
                    driverCardBegin = null;
                }
                offset = offset + 16 + 2;
                int j5 = 0;
                while (j5 < cardNumberSlot.length) {
                    cardNumberSlot[j5] = this.fileBuffer[offset + j5];
                    ++j5;
                }
                String codriverCardBegin = new String(cardNumberSlot);
                if (codriverCardBegin.startsWith("\u00ff\u00ff\u00ff")) {
                    codriverCardBegin = null;
                }
                offset = offset + 16 + 2;
                int j6 = 0;
                while (j6 < cardNumberSlot.length) {
                    cardNumberSlot[j6] = this.fileBuffer[offset + j6];
                    ++j6;
                }
                String driverCardEnd = new String(cardNumberSlot);
                if (driverCardEnd.startsWith("\u00ff\u00ff\u00ff")) {
                    driverCardEnd = null;
                }
                offset = offset + 16 + 2;
                int j7 = 0;
                while (j7 < cardNumberSlot.length) {
                    cardNumberSlot[j7] = this.fileBuffer[offset + j7];
                    ++j7;
                }
                String codriverCardEnd = new String(cardNumberSlot);
                if (codriverCardEnd.startsWith("\u00ff\u00ff\u00ff")) {
                    codriverCardEnd = null;
                }
                int similar = Fonctions.bytesToInt(this.fileBuffer, offset += 16, 1);
                ++offset;
                UevEventsFaults toAdd = new UevEventsFaults(0, 0, begin, end, type, purpose, driverCardBegin, codriverCardBegin, driverCardEnd, codriverCardEnd, similar);
                if (toAdd.getTypeId() == 8) {
                    toReturn.add(toAdd);
                    TimsLogger.debug("... => add interruption " + toAdd.getSQLString());
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (Transport.apiMode == 0) {
            TimsLogger.debug(String.valueOf(toReturn.size()) + " interruption");
        }
        return toReturn;
    }

    public Vector<UevSession> getSessionList() {
        this.readFile();
        int offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_IDENTIFICATION);
        if (offset <= -1) {
            if (offset != -1) {
                return null;
            }
            return null;
        }
        Vector<UevSession> toReturn = new Vector<UevSession>();
        try {
            offset += 2 + UEVProperty.MemberStateCertificateSize + UEVProperty.VUCertificateSize;
            offset += 17;
            ++offset;
            ++offset;
            offset += 13;
            offset += 4;
            offset += 4;
            offset += 4;
            ++offset;
            offset += 4;
            offset += 18;
            int sessionNb = Fonctions.bytesToInt(this.fileBuffer, offset += 36, 1);
            ++offset;
            int x = 0;
            while (x < sessionNb) {
                Date debut = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset, 4));
                Date fin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                String company = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 35, 1);
                String adress = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 36, 35, 1);
                String cardNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 36, 16, 2);
                offset += 18;
                UevSession tmp = new UevSession(0, 0, debut, fin, company, cardNumber, adress.trim());
                toReturn.add(tmp);
                ++x;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return toReturn;
    }

    public int readIdentification() {
        int cardSlotsStatus;
        Date currentDate;
        SimpleDateFormat formatDate;
        int offset;
        block31: {
            if (!this.fileReaden) {
                this.readFile();
            }
            if ((offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_IDENTIFICATION)) <= -1) {
                if (offset != -1) {
                    return 10;
                }
                return 6;
            }
            formatDate = new SimpleDateFormat("dd/MM/yyyy HH'h'mm");
            this.vehicleIdentification = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 2 + UEVProperty.MemberStateCertificateSize + UEVProperty.VUCertificateSize, 17, 0);
            offset += 17;
            ++offset;
            ++offset;
            byte[] retour = new byte[13];
            int j = 0;
            while (j < 13) {
                if (this.fileBuffer[offset + j] >= 127 || this.fileBuffer[offset + j] < 0) {
                    this.forbiddenChar = true;
                } else {
                    retour[j] = this.fileBuffer[offset + j];
                }
                ++j;
            }
            if (this.forbiddenChar) {
                this.wrongRegistration = new String(retour).trim();
                j = 0;
                while (j < 13) {
                    retour[j] = this.fileBuffer[offset + j] >= 127 || this.fileBuffer[offset + j] < 0 ? 45 : this.fileBuffer[offset + j];
                    ++j;
                }
            }
            this.vehicleRegistrationImmat = new String(retour).trim();
            if (!Pattern.matches("[A-Z]{2}-[0-9]{3}-[A-Z]{2}", this.vehicleRegistrationImmat)) {
                if (Pattern.matches("[A-Z]{2}.?[0-9]{3}.?[A-Z]{2}.*", this.vehicleRegistrationImmat)) {
                    TimsLogger.warn("#VuPG1.readIdentification# " + this.vehicleRegistrationImmat + " is not matching");
                } else {
                    TimsLogger.warn("#VuPG1.readIdentification# " + this.vehicleRegistrationImmat + " is wrong");
                }
            } else {
                TimsLogger.debug("#VuPG1.readIdentification# " + this.vehicleRegistrationImmat + " is OK !");
            }
            currentDate = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 13, 4));
            this.dateMin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
            this.dateMax = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
            cardSlotsStatus = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 1);
            this.previousDownload = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
            if (this.currentVehicule != null) break block31;
            return 2;
        }
        try {
            if (this.currentVehicule.getDateTelechargement() != null && !this.currentVehicule.getDateTelechargement().startsWith("1970-01-01") && UevDownload.loadList(String.valueOf(BddTransport.getDateTruncation("DATE_TELECHARGEMENT")) + "='" + ConversionTime.dateToString(this.previousDownload, System.getProperty("SGBDR", "mysql").equals("mysql") ? "yyyy-MM-dd" : "dd/MM/yy") + "' AND v.CLE_VEHICULE=" + this.currentVehicule.getCleVehicule()).size() == 0) {
                TimsLogger.warn("#VuPG1.readRecap# rupture de continuit\u00e9 " + this.previousDownload + " manquant");
            } else if (this.currentVehicule.getDateTelechargement() == null || this.currentVehicule.getDateTelechargement().startsWith("1970-01-01")) {
                TimsLogger.debug("#VuPG1.readRecap# premier t\u00e9l\u00e9chargement on ne v\u00e9rifie pas la continuit\u00e9");
            } else {
                TimsLogger.debug("#VuPG1.readRecap# continuit\u00e9 respect\u00e9e");
            }
            String cardNumberUpload = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 16, 2);
            String companyUpload = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 18, 35, 1);
            offset += 36;
            if (Transport.apiMode == 0) {
                TimsLogger.info("#VuPG1.readRecap# identification du v\u00e9hicule : " + this.vehicleIdentification + " immatriculation : " + this.vehicleRegistrationImmat + " cardSlotsStatus : " + cardSlotsStatus + " (" + Integer.toHexString(cardSlotsStatus) + ")" + " date de l'UEV : " + formatDate.format(currentDate) + " p\u00e9riode t\u00e9l\u00e9chargeable : " + formatDate.format(this.dateMin) + " " + formatDate.format(this.dateMax) + " dernier t\u00e9l\u00e9chargement : " + formatDate.format(this.previousDownload) + " par " + cardNumberUpload + " (" + companyUpload + ")");
            }
            Vector<CompanyCard> ccList = CompanyCard.loadList(new int[0]);
            int sessionNb = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
            ++offset;
            TimsLogger.debug("#VuPG1.readIdentification# " + sessionNb + " sessions \u00e0 lire");
            UevSession last = UevSession.getLastUevSession(this.currentVehicule.getCleVehicule());
            if (sessionNb > 0) {
                if (Transport.apiMode == 0) {
                    TimsLogger.debug("last session started " + (last == null ? "never" : last.getOpen() + " ends " + last.getClose() + " (id " + last.getId() + ")"));
                }
                int x = 0;
                while (x < sessionNb) {
                    Date debut = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset, 4));
                    Date fin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                    String company = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 35, 1);
                    String adress = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 36, 35, 1);
                    byte cardIssuingMemberState = this.fileBuffer[(offset += 36) + 1];
                    String cardNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset, 16, 2);
                    offset += 18;
                    if (last == null || !debut.before(last.getOpen())) {
                        if (CompanyCard.find(ccList, cardNumber, cardIssuingMemberState) == null) {
                            new CompanyCard(0, this.currentVehicule.getAgencyId(), cardNumber, cardIssuingMemberState, null, null, null, company.trim(), adress.trim(), cardIssuingMemberState, false, null);
                            if (Transport.apiMode == 0) {
                                TimsLogger.info("carte entreprise inconnue " + cardNumber);
                            }
                        }
                        if (last != null && debut.equals(last.getOpen()) && !last.getClose().equals(fin)) {
                            last.setClose(fin);
                            last.update();
                        } else {
                            UevSession tmp = new UevSession(0, this.currentVehicule.getCleVehicule(), debut, fin, company, cardNumber, adress.trim());
                            tmp.insert();
                        }
                        if (Transport.apiMode == 0) {
                            TimsLogger.debug(String.valueOf(formatDate.format(debut)) + " ->  " + formatDate.format(fin) + " => " + company.trim() + " (" + adress.trim() + ") " + cardNumber);
                        }
                    }
                    ++x;
                }
            }
            int controlNb = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
            ++offset;
            TimsLogger.debug("#VuPG1.readIdentification# " + controlNb + " contr\u00f4les \u00e0 lire");
            int x = 0;
            while (x < controlNb) {
                int controlType = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                Date controlTime = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
                String cardNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 16, 2);
                Date periodBegin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 18, 4));
                Date periodEnd = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                offset += 4;
                if (Transport.apiMode == 0) {
                    TimsLogger.debug(String.valueOf(controlType) + " le  " + formatDate.format(controlTime) + " => " + cardNumber + ".\n" + "Du " + formatDate.format(periodBegin) + " au " + formatDate.format(periodEnd));
                }
                ++x;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 3;
        }
        return 2;
    }

    public HashMap<Date, Integer> getActiveDay() {
        if (!this.fileReaden) {
            this.readFile();
        }
        HashMap<Date, Integer> activeDay = new HashMap<Date, Integer>();
        int offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_ACTIVITE);
        if (offset <= -1) {
            return null;
        }
        try {
            SimpleDateFormat formatGMTDate = new SimpleDateFormat("yyyy-MM-dd");
            formatGMTDate.setTimeZone(TimeZone.getTimeZone("GMT"));
            while (offset < this.fileBuffer.length && Fonctions.bytesToInt(this.fileBuffer, offset, 2) == UEVProperty.ID_ACTIVITE) {
                Date dateJour = null;
                dateJour = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 2, 4));
                String date = formatGMTDate.format(dateJour);
                dateJour = formatGMTDate.parse(date);
                int km = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 3);
                int noOfCardIWRecords = Fonctions.bytesToInt(this.fileBuffer, offset += 3, 2);
                offset += 2;
                int i = 1;
                while (i <= noOfCardIWRecords) {
                    ++offset;
                    offset += 35;
                    offset = offset + 35 + 1;
                    ++offset;
                    ++offset;
                    offset = offset + 16 + 4;
                    int insertkm = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 3);
                    if (insertkm < km) {
                        km = insertkm;
                    }
                    offset += 3;
                    ++offset;
                    offset += 4;
                    offset = offset + 3 + 19;
                    ++offset;
                    ++i;
                }
                int noOfActivChange = Fonctions.bytesToInt(this.fileBuffer, offset, 2);
                if (noOfActivChange != 0) {
                    activeDay.put(ConversionTime.dateTruncate(dateJour), km);
                }
                offset += 2;
                int i2 = 1;
                while (i2 <= noOfActivChange) {
                    ++offset;
                    ++offset;
                    ++i2;
                }
                int noOfPlaceRecords = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                ++offset;
                int i3 = 1;
                while (i3 <= noOfPlaceRecords) {
                    ++offset;
                    ++offset;
                    offset += 16;
                    offset += 4;
                    ++offset;
                    ++offset;
                    ++offset;
                    offset += 3;
                    ++i3;
                }
                int noOfSpecificConditionRecords = Fonctions.bytesToInt(this.fileBuffer, offset, 2);
                offset += 2;
                int i4 = 1;
                while (i4 <= noOfSpecificConditionRecords) {
                    offset += 4;
                    ++offset;
                    ++i4;
                }
                offset += 128;
            }
        }
        catch (Exception ex) {
            return activeDay;
        }
        return activeDay;
    }

    private int readActivity() {
        int offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_ACTIVITE);
        if (offset <= -1) {
            if (offset != -1) {
                return 10;
            }
            return 6;
        }
        TimsLogger.debug("#VuPG1.readActivity()# Begin at " + offset);
        try {
            int heure;
            SimpleDateFormat formatGMTDate = new SimpleDateFormat("yyyy-MM-dd");
            formatGMTDate.setTimeZone(TimeZone.getTimeZone("GMT"));
            boolean firstAct = true;
            Date beginSessionMissing = null;
            boolean reportCond = false;
            int decalageHoraire = 0;
            int dailyKm = 0;
            while (offset < this.fileBuffer.length && Fonctions.bytesToInt(this.fileBuffer, offset, 2) == UEVProperty.ID_ACTIVITE) {
                Date entryTime;
                Date dateJour = null;
                dateJour = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 2, 4));
                TimsLogger.verbose("#UEVDateProcessing.readActivity()# date non format\u00e9e " + dateJour);
                String date = formatGMTDate.format(dateJour);
                dateJour = formatGMTDate.parse(date);
                if (this.beginActivity == null) {
                    this.beginActivity = dateJour;
                }
                this.endActivity = dateJour;
                TimsLogger.verbose("=> date format\u00e9e " + dateJour);
                String dateCmp = this.formatdateCmp.format(dateJour);
                decalageHoraire = this.getDecalageHoraire(dateJour);
                dailyKm = this.lastKnownKm > 0 && Fonctions.bytesToInt(this.fileBuffer, offset, 3) < 10000000 ? Fonctions.bytesToInt(this.fileBuffer, offset += 4, 3) - this.lastKnownKm : 0;
                if (Fonctions.bytesToInt(this.fileBuffer, offset, 3) < 10000000) {
                    this.lastKnownKm = Fonctions.bytesToInt(this.fileBuffer, offset, 3);
                }
                this.kmDay.put(dateJour, this.lastKnownKm);
                if (dailyKm >= 30) {
                    ++this.dayUsedCount;
                    this.totalKm += dailyKm;
                }
                TimsLogger.debug("#VuPG1.readActivity()# le " + date + " => km fin de journ\u00e9e : " + this.lastKnownKm + " (offset : " + (offset += 3) + "). Km journalier jour = " + dailyKm);
                int noOfCardIWRecords = Fonctions.bytesToInt(this.fileBuffer, offset, 2);
                TimsLogger.debug("#VuPG1.readActivity()# VuCardIWData => offset " + ((offset += 2) - 2) + " noOfCardIWRecords : " + noOfCardIWRecords);
                int i = 1;
                while (i <= noOfCardIWRecords) {
                    ++offset;
                    VehicleUsed tmp = new VehicleUsed();
                    tmp.setCleVehicule(this.currentVehicule.getCleVehicule());
                    tmp.setImmatriculation(this.currentVehicule.getRegistrationNumber());
                    byte[] nom = new byte[35];
                    int j = 0;
                    while (j < nom.length) {
                        nom[j] = this.fileBuffer[offset + j];
                        ++j;
                    }
                    tmp.setNom(new String(nom).trim());
                    offset += 35;
                    byte[] prenom = new byte[35];
                    int j2 = 0;
                    while (j2 < prenom.length) {
                        prenom[j2] = this.fileBuffer[offset + j2];
                        ++j2;
                    }
                    tmp.setPrenom(new String(prenom).trim());
                    offset = offset + 35 + 1;
                    byte cardIssuingMemberState = this.fileBuffer[++offset];
                    tmp.setNumeroCarte(this.getCardNumber(++offset));
                    offset = offset + 16 + 4;
                    tmp.setDateDebut(ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset, 4)));
                    SimpleDateFormat formatHeure = new SimpleDateFormat("HH'h'mm");
                    int heureInsertion = ConversionTime.heureStringToInt(formatHeure.format(ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset, 4))), "h");
                    tmp.setKmDebut(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 3));
                    tmp.setLecteur(Fonctions.bytesToInt(this.fileBuffer, offset += 3, 1));
                    Date date_retrait = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
                    String dateRetraitCmp = this.formatdateCmp.format(date_retrait);
                    tmp.setDateFin(date_retrait);
                    int heureRetraitCmp = ConversionTime.heureStringToInt(formatHeure.format(date_retrait), "h");
                    tmp.setKmFin(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 3));
                    offset = offset + 3 + 19;
                    tmp.setKmEffectue(tmp.getKmFin() - tmp.getKmDebut());
                    tmp.setManualInput(Fonctions.bytesToInt(this.fileBuffer, offset, 1) != 0);
                    ++offset;
                    if (Transport.debug >= 2) {
                        tmp.print();
                    }
                    if (dateCmp.equals(dateRetraitCmp) || !dateCmp.equals(dateRetraitCmp) && heureRetraitCmp < 120) {
                        Conducteur tmpC = null;
                        try {
                            tmpC = Conducteur.getDriver(this.getDrivers(), tmp.getNumeroCarte(), cardIssuingMemberState);
                            TimsLogger.verbose("set driver " + tmp.getNumeroCarte() + " => " + tmpC.getCleConducteur());
                            tmp.setCleConducteur(tmpC.getCleConducteur());
                        }
                        catch (Exception ex) {
                            if (Transport.debug >= 2) {
                                TimsLogger.debug("unknow driver " + tmp.getNumeroCarte() + " " + cardIssuingMemberState);
                            }
                            this.unknownDriver.add(tmp.getNumeroCarte());
                        }
                        this.io.add(tmp);
                    }
                    TimsLogger.debug("#VuPG1.readActivity# CARD FROM " + heureInsertion + " TO " + heureRetraitCmp);
                    ++i;
                }
                int noOfActivChange = Fonctions.bytesToInt(this.fileBuffer, offset, 2);
                TimsLogger.debug("#VuPG1.readActivity()# VuActivityDailyData => offset " + offset + " noOfActivChange : " + noOfActivChange);
                if (noOfActivChange == 0) {
                    if (beginSessionMissing == null) {
                        beginSessionMissing = dateJour;
                        TimsLogger.info("#VuPG1.readActivity# d\u00e9but session manquante " + dailyKm + " le " + dateJour);
                    }
                } else if (beginSessionMissing != null) {
                    TimsLogger.info("#VuPG1.readActivity# session manquante du " + beginSessionMissing + " au " + dateJour);
                    this.errors.add(new VehicleError(0, this.currentVehicule.getCleVehicule(), beginSessionMissing, dateJour, 1, "", 0));
                    beginSessionMissing = null;
                }
                offset += 2;
                reportCond = false;
                boolean reportConv = false;
                int i2 = 1;
                while (i2 <= noOfActivChange) {
                    block42: {
                        ChangementActivite activityChange;
                        block37: {
                            block39: {
                                block40: {
                                    int nbJour;
                                    ChangementActivite lastAct;
                                    block41: {
                                        block38: {
                                            byte[] tmpbuf2bytes = new byte[]{this.fileBuffer[offset], this.fileBuffer[++offset]};
                                            ++offset;
                                            activityChange = UEVProperty.getDetailActivite(tmpbuf2bytes, dateJour, "V1B", this.toRead.getName());
                                            if (!activityChange.getLecteur().equals("CONDUCTEUR")) break block37;
                                            if (!activityChange.setHeure(activityChange.getHeure() + decalageHoraire) || reportCond) break block38;
                                            ChangementActivite tmp = (ChangementActivite)this.activConducteur.get(this.activConducteur.size() - 1).clone();
                                            tmp.setHeure(1440);
                                            this.activConducteur.add(tmp);
                                            reportCond = true;
                                            break block39;
                                        }
                                        if (activityChange.getHeure() != decalageHoraire) break block39;
                                        if (this.activConducteur.size() == 0) break block40;
                                        lastAct = this.activConducteur.get(this.activConducteur.size() - 1);
                                        nbJour = ConversionTime.getDaysBetween(lastAct.getDate(), activityChange.getDate());
                                        if (nbJour != 0) break block41;
                                        if (lastAct.getTypeActivite() != activityChange.getTypeActivite()) break block39;
                                        break block42;
                                    }
                                    if (nbJour == 1) {
                                        if (lastAct.getTypeActivite() == activityChange.getTypeActivite()) {
                                            activityChange.setHeure(activityChange.getHeure() - decalageHoraire);
                                        } else {
                                            ChangementActivite tmp = (ChangementActivite)this.activConducteur.get(this.activConducteur.size() - 1).clone();
                                            tmp.setHeure(1440);
                                            TimsLogger.verbose(" ** " + tmp.getHeure() + " " + tmp.getTypeActivite() + " -> ");
                                            this.activConducteur.add(tmp);
                                        }
                                    } else if (lastAct.getTypeActivite() == activityChange.getTypeActivite()) {
                                        activityChange.setHeure(activityChange.getHeure() - decalageHoraire);
                                    }
                                    break block39;
                                }
                                TimsLogger.debug("VUPG1.readActivity# on v\u00e9rifie la premi\u00e8re journ\u00e9e ? " + activityChange.getDate());
                                activityChange.setHeure(activityChange.getHeure() - decalageHoraire);
                            }
                            this.activConducteur.add(activityChange);
                            if (firstAct) {
                                firstAct = false;
                                int nbJour = ConversionTime.getDaysBetween(this.lastDownload, activityChange.getDate());
                                if (nbJour < -2 && !this.olderActivity) {
                                    this.olderActivity = true;
                                } else if (nbJour > 1 && nbJour < 10000) {
                                    this.missingActivity = true;
                                }
                                TimsLogger.debug("#VuPG1.readActivity()# firstAct " + activityChange.getDate() + " last dl : " + this.lastDownload + " nbJour " + nbJour);
                            }
                        }
                        if (activityChange.getLecteur().equals("CONVOYEUR")) {
                            if (!(activityChange.getHeure() == 0 && this.activConvoyeur.size() != 0 && this.activConvoyeur.get(this.activConvoyeur.size() - 1).getDate().before(dateJour) || this.activConvoyeur.size() == 0 || !activityChange.setHeure(activityChange.getHeure() + decalageHoraire) || reportConv)) {
                                ChangementActivite tmp = (ChangementActivite)this.activConvoyeur.get(this.activConvoyeur.size() - 1).clone();
                                tmp.setHeure(1440);
                                this.activConvoyeur.add(tmp);
                                reportConv = true;
                            }
                            this.activConvoyeur.add(activityChange);
                        }
                    }
                    ++i2;
                }
                int noOfPlaceRecords = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                TimsLogger.debug("#VuPG1.readActivity()# VuPlaceRecords => offset " + offset + " noOfPlaceRecords : " + noOfPlaceRecords);
                ++offset;
                int i3 = 1;
                while (i3 <= noOfPlaceRecords) {
                    ++offset;
                    String card = this.getCardNumber(++offset);
                    entryTime = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 16, 4));
                    byte entryTypeDailyWorkPeriod = this.fileBuffer[offset += 4];
                    byte dailyWorkPeriodCountry = this.fileBuffer[++offset];
                    byte dailyWorkPeriodRegion = this.fileBuffer[++offset];
                    int vehicleOdometerValue = Fonctions.bytesToInt(this.fileBuffer, ++offset, 3);
                    offset += 3;
                    TimsLogger.verbose("#VuPG1.readActivity()# " + card + "\t" + this.formatDateHeuredb.format(entryTime) + "\t" + entryTypeDailyWorkPeriod + "\t" + dailyWorkPeriodCountry + "\t" + dailyWorkPeriodRegion + "\t" + vehicleOdometerValue);
                    ++i3;
                }
                int noOfSpecificConditionRecords = Fonctions.bytesToInt(this.fileBuffer, offset, 2);
                TimsLogger.debug("#VuPG1.readActivity()# VuSpecificConditionData => offset " + offset + " noOfSpecificConditionRecords : " + noOfSpecificConditionRecords);
                offset += 2;
                int i4 = 1;
                while (i4 <= noOfSpecificConditionRecords) {
                    entryTime = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset, 4));
                    byte specificConditionType = this.fileBuffer[offset += 4];
                    ++offset;
                    TimsLogger.verbose("#VuPG1.readActivity()# specificCondition Record at " + this.formatDateHeuredb.format(entryTime) + " " + specificConditionType);
                    ++i4;
                }
                if ((offset += 128) >= this.fileBuffer.length) continue;
                TimsLogger.debug("#VuPG1.readActivity()# FIN " + Integer.toHexString(offset) + " => " + Fonctions.bytesToInt(this.fileBuffer, offset, 2));
            }
            if (beginSessionMissing != null) {
                TimsLogger.info("#VuPG1.readActivity# fin des activit\u00e9s session manquante du " + beginSessionMissing + " au " + this.endActivity);
                this.errors.add(new VehicleError(0, this.currentVehicule.getCleVehicule(), beginSessionMissing, this.endActivity, 1, "", 0));
            }
            Date dlDate = this.getDlDate(this.toRead.getName());
            Date last = ConversionTime.dateTruncate(this.activConducteur.get(this.activConducteur.size() - 1).getDate());
            if (last.equals(ConversionTime.dateTruncate(dlDate)) && (heure = ConversionTime.heureStringToInt(ConversionTime.dateToString(dlDate, "HH:mm"), ":") + decalageHoraire) < 1440) {
                ChangementActivite tmp = new ChangementActivite(7, dlDate, heure, "CONDUCTEUR", "SEUL", "NON INSEREE", "", this.toRead.getName());
                this.activConducteur.add(tmp);
            }
            if (reportCond) {
                ChangementActivite tmp = (ChangementActivite)this.activConducteur.get(this.activConducteur.size() - 1).clone();
                tmp.setHeure(decalageHoraire);
                tmp.setTypeActivite(7);
                this.activConducteur.add(tmp);
            }
            TimsLogger.debug("#VuPG1.readActivity()# on a en tout " + this.io.size() + " insertions de carte");
            TimsLogger.debug("#VuPG1.readActivity()# End at " + offset);
        }
        catch (Exception ex) {
            return 3;
        }
        return 2;
    }

    public String getCardNumber(int offset) {
        byte[] cardNumber_char = new byte[16];
        int j = 0;
        while (j < cardNumber_char.length) {
            cardNumber_char[j] = this.fileBuffer[offset + j];
            ++j;
        }
        return new String(cardNumber_char).trim();
    }

    public int readAnomalie() {
        int offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_EVT_ANOMALIE);
        if (offset <= -1) {
            if (offset != -1) {
                return 10;
            }
            return 6;
        }
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#VuPG1.readAnomalie()# Begin at " + offset);
        }
        try {
            int noOfVuFaults = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 1);
            if (Transport.apiMode == 0) {
                TimsLogger.debug(String.valueOf(noOfVuFaults) + " faults");
            }
            ++offset;
            int i = 1;
            while (i <= noOfVuFaults) {
                TimsLogger.debug("#VuPG1.readAnomalie# fault at " + offset + " \"" + Fonctions.parseHexAscii(this.fileBuffer, offset, offset + 82) + "\" ...");
                int type = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                int purpose = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                Date begin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
                Date end = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                offset = offset + 4 + 2;
                byte[] cardNumberSlot = new byte[16];
                int j = 0;
                while (j < cardNumberSlot.length) {
                    cardNumberSlot[j] = this.fileBuffer[offset + j];
                    ++j;
                }
                String driverCardBegin = new String(cardNumberSlot);
                if (driverCardBegin.startsWith("\u00ff\u00ff\u00ff")) {
                    driverCardBegin = null;
                }
                offset = offset + 16 + 2;
                int j2 = 0;
                while (j2 < cardNumberSlot.length) {
                    cardNumberSlot[j2] = this.fileBuffer[offset + j2];
                    ++j2;
                }
                String codriverCardBegin = new String(cardNumberSlot);
                if (codriverCardBegin.startsWith("\u00ff\u00ff\u00ff")) {
                    codriverCardBegin = null;
                }
                offset = offset + 16 + 2;
                int j3 = 0;
                while (j3 < cardNumberSlot.length) {
                    cardNumberSlot[j3] = this.fileBuffer[offset + j3];
                    ++j3;
                }
                String driverCardEnd = new String(cardNumberSlot);
                if (driverCardEnd.startsWith("\u00ff\u00ff\u00ff")) {
                    driverCardEnd = null;
                }
                offset = offset + 16 + 2;
                int j4 = 0;
                while (j4 < cardNumberSlot.length) {
                    cardNumberSlot[j4] = this.fileBuffer[offset + j4];
                    ++j4;
                }
                String codriverCardEnd = new String(cardNumberSlot);
                if (codriverCardEnd.startsWith("\u00ff\u00ff\u00ff")) {
                    codriverCardEnd = null;
                }
                offset += 16;
                UevEventsFaults toCheck = new UevEventsFaults(0, this.currentVehicule.getCleVehicule(), begin, end, type, purpose, driverCardBegin, codriverCardBegin, driverCardEnd, codriverCardEnd, 0);
                if (begin.before(this.lastDownload) || this.eventsFaults.contains(toCheck)) {
                    if (Transport.apiMode == 0 && Transport.debug >= 1) {
                        TimsLogger.debug("... => ever known " + toCheck.getSQLString());
                    }
                } else {
                    if (Transport.apiMode == 0) {
                        TimsLogger.debug("... => add fault " + toCheck.getSQLString());
                    }
                    this.eventsFaults.add(toCheck);
                }
                ++i;
            }
            int noOfVuEvents = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
            if (Transport.apiMode == 0) {
                TimsLogger.debug(String.valueOf(noOfVuEvents) + " events");
            }
            ++offset;
            int i2 = 1;
            while (i2 <= noOfVuEvents) {
                TimsLogger.debug("#VuPG1.readAnomalie# event at " + offset + " \"" + Fonctions.parseHexAscii(this.fileBuffer, offset, offset + 82) + "\" ...");
                int type = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                int purpose = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                Date begin = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, ++offset, 4));
                Date end = ConversionTime.getDate(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4));
                offset = offset + 4 + 2;
                byte[] cardNumberSlot = new byte[16];
                int j = 0;
                while (j < cardNumberSlot.length) {
                    cardNumberSlot[j] = this.fileBuffer[offset + j];
                    ++j;
                }
                String driverCardBegin = new String(cardNumberSlot);
                if (driverCardBegin.startsWith("\u00ff\u00ff\u00ff")) {
                    driverCardBegin = null;
                }
                offset = offset + 16 + 2;
                int j5 = 0;
                while (j5 < cardNumberSlot.length) {
                    cardNumberSlot[j5] = this.fileBuffer[offset + j5];
                    ++j5;
                }
                String codriverCardBegin = new String(cardNumberSlot);
                if (codriverCardBegin.startsWith("\u00ff\u00ff\u00ff")) {
                    codriverCardBegin = null;
                }
                offset = offset + 16 + 2;
                int j6 = 0;
                while (j6 < cardNumberSlot.length) {
                    cardNumberSlot[j6] = this.fileBuffer[offset + j6];
                    ++j6;
                }
                String driverCardEnd = new String(cardNumberSlot);
                if (driverCardEnd.startsWith("\u00ff\u00ff\u00ff")) {
                    driverCardEnd = null;
                }
                offset = offset + 16 + 2;
                int j7 = 0;
                while (j7 < cardNumberSlot.length) {
                    cardNumberSlot[j7] = this.fileBuffer[offset + j7];
                    ++j7;
                }
                String codriverCardEnd = new String(cardNumberSlot);
                if (codriverCardEnd.startsWith("\u00ff\u00ff\u00ff")) {
                    codriverCardEnd = null;
                }
                int similar = Fonctions.bytesToInt(this.fileBuffer, offset += 16, 1);
                ++offset;
                UevEventsFaults toCheck = new UevEventsFaults(0, this.currentVehicule.getCleVehicule(), begin, end, type, purpose, driverCardBegin, codriverCardBegin, driverCardEnd, codriverCardEnd, similar);
                if (begin.before(this.lastDownload) || this.eventsFaults.contains(toCheck)) {
                    if (Transport.apiMode == 0) {
                        TimsLogger.debug("... => ever known " + toCheck.getSQLString());
                    }
                } else {
                    if (Transport.apiMode == 0) {
                        TimsLogger.debug("... => add event " + toCheck.getSQLString());
                    }
                    this.eventsFaults.add(toCheck);
                }
                ++i2;
            }
            offset = offset + 4 + 4 + 1;
            int noOfVuSpeed = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
            if (Transport.apiMode == 0) {
                TimsLogger.debug("VuPG1 # NB SPEED = " + noOfVuSpeed);
            }
            ++offset;
            int i3 = 1;
            while (i3 <= noOfVuSpeed) {
                TimsLogger.debug("#VuPG1.readAnomalie# speed at " + offset + " \"" + Fonctions.parseHexAscii(this.fileBuffer, offset, offset + 30) + "\" ...");
                int speedType = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                int speedRecordPurpose = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                long beginTime = Fonctions.bytesToInt(this.fileBuffer, ++offset, 4);
                long endTime = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 4);
                int maxSpeedValue = Fonctions.bytesToInt(this.fileBuffer, offset += 4, 1);
                int averageSpeedValue = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
                offset = offset + 1 + 2;
                byte[] cardNumberSlot = new byte[16];
                int j = 0;
                while (j < cardNumberSlot.length) {
                    cardNumberSlot[j] = this.fileBuffer[offset + j];
                    ++j;
                }
                String driverCardBegin = new String(cardNumberSlot);
                int similar = Fonctions.bytesToInt(this.fileBuffer, offset += 16, 1);
                ++offset;
                TimsLogger.debug("#VuPG1.readAnomalie# " + ConversionTime.getDate(beginTime));
                if (endTime - beginTime < 60L) {
                    beginTime -= 60L;
                }
                TimsLogger.debug("#VuPG1.readAnomalie# " + ConversionTime.getDate(beginTime));
                Date begin = ConversionTime.getDate(beginTime);
                Date end = ConversionTime.getDate(endTime);
                UevSpeed toCheck = new UevSpeed(0, this.currentVehicule.getCleVehicule(), begin, end, speedType, speedRecordPurpose, maxSpeedValue, averageSpeedValue, driverCardBegin, similar);
                if (begin.before(this.lastDownload) || this.speed.contains(toCheck)) {
                    if (Transport.apiMode == 0 && Transport.debug >= 1) {
                        TimsLogger.debug("#VuPG1.readAnomalie# Speed ever known " + toCheck.getSQLString());
                    }
                } else {
                    if (Transport.apiMode == 0) {
                        TimsLogger.debug("#VuPG1.readAnomalie# Add speed " + toCheck.getSQLString());
                    }
                    this.speed.add(toCheck);
                }
                ++i3;
            }
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#VuPG1.readAnomalie()# End at " + offset);
            }
        }
        catch (Exception ex) {
            return 3;
        }
        return 2;
    }

    public int readTechnique() {
        int offset;
        block11: {
            this.uevCalibration = new Vector();
            offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_TECHNIQUE);
            if (offset <= -1) {
                if (offset != -1) {
                    return 10;
                }
                return 6;
            }
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#VuPG1.readTechnique()# Begin at " + offset);
            }
            this.vuManufacturerName = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 2, 35, 1);
            String vuManufacturerAdress = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 36, 35, 1);
            String vuPartNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 36, 16, 0);
            int vuSerialNumber = Fonctions.bytesToInt(this.fileBuffer, offset += 16, 4);
            String vuSerialNumberMY = Integer.toHexString(Fonctions.bytesToInt(this.fileBuffer, offset += 4, 2)).length() == 3 ? "0" + Integer.toHexString(Fonctions.bytesToInt(this.fileBuffer, offset, 2)) : Integer.toHexString(Fonctions.bytesToInt(this.fileBuffer, offset, 2));
            int vuSerialNumberType = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 1);
            int vuSerialNumberManufacturerCode = Fonctions.bytesToInt(this.fileBuffer, ++offset, 1);
            this.vuSoftwareVersion = Fonctions.getStringFromBuffer(this.fileBuffer, ++offset, 4, 0);
            String vuSoftwareDate = this.getDateFromBuffer(this.fileBuffer, offset += 4);
            String vuDateInst = this.getDateFromBuffer(this.fileBuffer, offset += 4);
            String vuApprovalNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 8, 0);
            int sensorSerialNumber = Fonctions.bytesToInt(this.fileBuffer, offset += 8, 8);
            String sensorApprovalNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 8, 8, 0);
            String sensorPairingDateFirst = this.getDateFromBuffer(this.fileBuffer, offset += 8);
            offset += 4;
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#VuPG1.readTechnique # " + this.vehicleRegistrationImmat + " #VuPG1.readTechnique# manufacturerName : " + this.vuManufacturerName + " manufacturerAdress : " + vuManufacturerAdress + " partNumber : " + vuPartNumber + " serialNumber : " + vuSerialNumber + " serialNumberMonthYear : " + vuSerialNumberMY + " serialNumberType : " + vuSerialNumberType + " serialNumberManufacturerCode : " + vuSerialNumberManufacturerCode + " softwareVersion : " + this.vuSoftwareVersion + " softwareInstallationDate : " + vuSoftwareDate + " manufacturingDate : " + vuDateInst + " approvalNumber : " + vuApprovalNumber + " sensorSerialNumber : " + sensorSerialNumber + " sensorApprovalNumber : " + sensorApprovalNumber + " sensorPairingDateFirst : " + sensorPairingDateFirst);
            }
            if (this.currentVehicule != null) break block11;
            return 2;
        }
        try {
            int nbEtalonnage = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
            ++offset;
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#VuPG1.readTechnique# on a " + nbEtalonnage + " \u00e9talonnage");
            }
            int x = 1;
            while (x <= nbEtalonnage) {
                int calibration = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                String workShopName = Fonctions.getStringFromBuffer(this.fileBuffer, ++offset, 35, 1);
                String workShopAdresse = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 36, 35, 1);
                int cardType = Fonctions.bytesToInt(this.fileBuffer, offset += 36, 1);
                String workShopCardNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset, 16, 2);
                String workShopCardDateExpiry = this.getDateFromBuffer(this.fileBuffer, offset += 18);
                String vehicleIdentificationNumber = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 4, 17, 0);
                int vehicleRegistrationNation = Fonctions.bytesToInt(this.fileBuffer, offset += 17, 1);
                String vehicleRegistrationNumber = Fonctions.getStringFromBuffer(this.fileBuffer, ++offset, 13, 1);
                int wVehicleCharacteristicConstant = Fonctions.bytesToInt(this.fileBuffer, offset += 14, 2);
                int kConstantOfRecordingEquipement = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2);
                int lTyreCircumference = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2);
                String tyreSize = Fonctions.getStringFromBuffer(this.fileBuffer, offset += 2, 15, 0);
                int authorizedSpeed = Fonctions.bytesToInt(this.fileBuffer, offset += 15, 1);
                int oldOdometerValue = Fonctions.bytesToInt(this.fileBuffer, ++offset, 3);
                int newOdometerValue = Fonctions.bytesToInt(this.fileBuffer, offset += 3, 3);
                String oldTimeValue = this.getDateFromBuffer(this.fileBuffer, offset += 3);
                String newTimeValue = this.getDateFromBuffer(this.fileBuffer, offset += 4);
                String nextCalibrationDate = this.getDateFromBuffer(this.fileBuffer, offset += 4);
                offset += 4;
                this.uevCalibration.add(new UevCalibration(this.currentVehicule.getCleVehicule(), calibration, workShopName, workShopAdresse, cardType, workShopCardNumber, workShopCardDateExpiry, vehicleIdentificationNumber, vehicleRegistrationNation, vehicleRegistrationNumber, wVehicleCharacteristicConstant, kConstantOfRecordingEquipement, lTyreCircumference, tyreSize, authorizedSpeed, oldOdometerValue, newOdometerValue, oldTimeValue, newTimeValue, nextCalibrationDate));
                if (Transport.apiMode == 0) {
                    TimsLogger.debug("#VuPG1.readTechnique# Etalonnage : " + calibration + " / " + workShopName + " / " + workShopAdresse + " / " + cardType + " / " + workShopCardNumber + " / " + workShopCardDateExpiry + " / " + vehicleIdentificationNumber + " / " + vehicleRegistrationNation + " / " + vehicleRegistrationNumber + " / " + wVehicleCharacteristicConstant + " / " + kConstantOfRecordingEquipement + " / " + lTyreCircumference + " / " + tyreSize + " / " + authorizedSpeed + " / " + oldOdometerValue + " / " + newOdometerValue + " / " + oldTimeValue + " / " + newTimeValue + " / " + nextCalibrationDate);
                }
                ++x;
            }
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#VuPG1.readTechnique()# End at " + offset);
            }
        }
        catch (Exception ex) {
            return 3;
        }
        return 2;
    }

    public int readSpeedOverview() {
        int offset;
        if (!this.fileReaden) {
            this.readFile();
        }
        if ((offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_SPEED)) <= -1) {
            if (offset != -1) {
                TimsLogger.debug("#VUGP1.readSpeedOverview# speed structure not found");
            }
            return 2;
        }
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#VuPG1.readSpeed()# Begin at " + offset);
        }
        try {
            int speedBlockData = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2);
            offset += 2;
            Date begin = null;
            int max = 0;
            int second = 0;
            int x = 0;
            while (x < speedBlockData) {
                Date dateJour = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                offset += 4;
                TimsLogger.debug("VuPg1.Sort# check " + ConversionTime.dateToString(dateJour, "dd/MM/YYYY HH:mm:ss"));
                int y = 0;
                while (y <= 59) {
                    int vitesse = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                    if (vitesse > 90) {
                        if (begin == null) {
                            begin = ConversionTime.add(dateJour, 13, y);
                            TimsLogger.debug("VuPg1.Sort# debut exc\u00e8s " + ConversionTime.dateToString(dateJour, "dd/MM/YYYY HH:mm:ss") + " (" + y + " sec)");
                            second = y;
                        }
                        max = Math.max(max, vitesse);
                    } else if (begin != null) {
                        Date end = ConversionTime.add(dateJour, 13, y);
                        TimsLogger.debug("VuPg1.Sort# fin exc\u00e8s " + ConversionTime.dateToString(dateJour, "dd/MM/YYYY HH:mm:ss") + " (" + y + " sec)");
                        VehicleUsed input = this.searchDriverId(begin);
                        UevSpeed toCheck = new UevSpeed(0, this.currentVehicule.getCleVehicule(), begin, end, 99, 99, max, 0, input == null ? null : input.getNumeroCarte(), 0);
                        if (!this.isKnownOverSpeed(toCheck) && !toCheck.load(this.currentVehicule.getCleVehicule(), begin)) {
                            this.speedOverview.add(toCheck);
                        }
                        TimsLogger.debug("VuPg1.Sort# exc\u00e8s de " + ConversionTime.dateToString(begin, "dd/MM/YYYY HH:mm:ss") + " (" + second + " sec) / " + ConversionTime.dateToString(end, "dd/MM/YYYY HH:mm:ss") + " (" + y + " sec) => max constat\u00e9 " + max + " conducteur " + (input == null ? "?" : input.getNumeroCarte()));
                        begin = null;
                        max = 0;
                    }
                    ++offset;
                    ++y;
                }
                ++x;
            }
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#VuPG1.readSpeed()# End at " + offset);
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("#VUGP1.readSpeedOverview# speed structure error");
        }
        return 2;
    }

    private boolean isKnownOverSpeed(UevSpeed toCheck) {
        for (UevSpeed s : this.speed) {
            if (!s.like(toCheck)) continue;
            return true;
        }
        return false;
    }

    private VehicleUsed searchDriverId(Date begin) {
        TimsLogger.debug("search driver for " + begin);
        int i = this.io.size() - 1;
        while (i >= 0) {
            TimsLogger.debug("is " + this.io.get(i).getDateDebut() + " " + this.io.get(i).getDateFin() + " ?");
            if (this.io.get(i).getDateDebut().before(begin) && this.io.get(i).getDateFin().after(begin)) {
                TimsLogger.debug("YES !");
                return this.io.get(i);
            }
            if (this.io.get(i).getDateFin().before(begin)) {
                TimsLogger.debug("this is the end !!?");
                break;
            }
            --i;
        }
        i = this.getVehicleUsedDB().size() - 1;
        while (i >= 0) {
            VehicleUsed toCheck = this.getVehicleUsedDB().get(i);
            if (toCheck.getDateDebut().before(begin) && (toCheck.getDateFin().getTime() < 100000L || toCheck.getDateFin().after(begin))) {
                TimsLogger.debug("VuPg1.searchDriver# found in db " + toCheck.getNumeroCarte());
                return toCheck;
            }
            if (toCheck.getDateFin().getTime() >= 100000L && toCheck.getDateFin().before(begin)) break;
            --i;
        }
        return null;
    }

    private Vector<VehicleUsed> getVehicleUsedDB() {
        if (this.vehiclesDB == null) {
            this.vehiclesDB = VehicleUsed.loadListVehicle(0, this.currentVehicule.getCleVehicule(), ConversionTime.addDay(this.getDlDate(this.toRead.getName()), -45), this.getDlDate(this.toRead.getName()), true);
        }
        return this.vehiclesDB;
    }

    public TreeMap<String, Hashtable<Integer, String>> getDetailedSpeed() throws VuFileNotFoundException, VuFileStructureException {
        if (!this.fileReaden) {
            this.readFile();
        }
        TreeMap<String, Hashtable<Integer, String>> tmp = new TreeMap<String, Hashtable<Integer, String>>();
        SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formatHeure = new SimpleDateFormat("HH'h'mm");
        int offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_SPEED);
        if (offset <= -1) {
            if (offset != -1) {
                throw new VuFileNotFoundException(Integer.toHexString(UEVProperty.ID_SPEED));
            }
            return tmp;
        }
        if (Transport.apiMode == 0) {
            TimsLogger.debug("#VuPG1.readSpeed()# Begin at " + offset);
        }
        try {
            int speedBlockData = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2);
            offset += 2;
            int x = 0;
            while (x < speedBlockData) {
                Date dateJour = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                offset += 4;
                int y = 1;
                while (y <= 60) {
                    String ex;
                    Date sec = ConversionTime.add(dateJour, 13, y);
                    String date = formatDate.format(sec);
                    int min = ConversionTime.heureStringToInt(formatHeure.format(sec), "h");
                    int vitesse = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                    ++offset;
                    if (!tmp.containsKey(date)) {
                        tmp.put(date, new Hashtable());
                    }
                    if ((ex = tmp.get(date).get(min)) == null) {
                        tmp.get(date).put(min, String.valueOf(vitesse));
                    } else {
                        tmp.get(date).put(min, String.valueOf(ex) + ";" + vitesse);
                    }
                    ++y;
                }
                ++x;
            }
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#VuPG1.readSpeed()# End at " + offset);
            }
        }
        catch (Exception ex) {
            throw new VuFileStructureException(Integer.toHexString(UEVProperty.ID_SPEED));
        }
        return tmp;
    }

    private int getDecalageHoraire(Date dateJour) {
        this.jourHiverToEte = Fonctions.getDateHeureEte(dateJour);
        this.jourEteToHiver = Fonctions.getDateHeureHiver(dateJour);
        if (dateJour.after(this.jourHiverToEte) && dateJour.before(this.jourEteToHiver)) {
            return 120;
        }
        if (this.jourHiverToEte.equals(dateJour)) {
            return 60;
        }
        return !this.jourEteToHiver.equals(dateJour) ? 60 : 120;
    }

    private String getDateFromBuffer(byte[] buf, int offset) {
        return this.formatDateHeuredb.format(new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L));
    }

    public ProgressBar getProgression() {
        if (this.progression == null) {
            this.progression = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("uev.reading.title", this.vehicleRegistrationImmat));
            this.progression.setVisible(true);
        }
        return this.progression;
    }

    private void setPbValue(int value, String text) {
        if (Transport.apiMode == 1) {
            return;
        }
        if (value != -1) {
            this.getProgression().getBar().setValue(value);
        }
        if (text != null) {
            this.getProgression().getBar().setString(text);
        }
    }

    public ArrayList<UevSpeed> getSpeed(Vehicule v, Date since) {
        this.currentVehicule = v;
        this.lastDownload = since;
        this.readFile();
        this.readAnomalie();
        return this.speed;
    }

    public ArrayList<UevSpeed> getOverSpeed() {
        int offset;
        ArrayList<UevSpeed> toReturn = new ArrayList<UevSpeed>();
        this.readIdentification();
        this.checkVehicle();
        this.readActivity();
        if (!this.fileReaden) {
            this.readFile();
        }
        if ((offset = UEVProperty.getOffset(this.fileBuffer, UEVProperty.ID_SPEED)) <= -1) {
            if (offset != -1) {
                TimsLogger.debug("#VUGP1.getOverSpeed# speed structure not found");
            }
            return null;
        }
        try {
            int speedBlockData = Fonctions.bytesToInt(this.fileBuffer, offset += 2, 2);
            offset += 2;
            Date begin = null;
            int max = 0;
            int second = 0;
            int x = 0;
            while (x < speedBlockData) {
                Date dateJour = new Date((long)Fonctions.bytesToInt(this.fileBuffer, offset, 4) * 1000L);
                offset += 4;
                TimsLogger.debug("VuPg1.getOverSpeed# check " + ConversionTime.dateToString(dateJour, "dd/MM/YYYY HH:mm:ss"));
                int y = 0;
                while (y <= 59) {
                    int vitesse = Fonctions.bytesToInt(this.fileBuffer, offset, 1);
                    if (vitesse > 90) {
                        if (begin == null) {
                            begin = ConversionTime.add(dateJour, 13, y);
                            TimsLogger.debug("VuPg1.getOverSpeed# debut exc\u00e8s " + ConversionTime.dateToString(dateJour, "dd/MM/YYYY HH:mm:ss") + " (" + y + " sec)");
                            second = y;
                        }
                        max = Math.max(max, vitesse);
                    } else if (begin != null) {
                        Date end = ConversionTime.add(dateJour, 13, y);
                        TimsLogger.debug("VuPg1.getOverSpeed# fin exc\u00e8s " + ConversionTime.dateToString(dateJour, "dd/MM/YYYY HH:mm:ss") + " (" + y + " sec)");
                        VehicleUsed input = this.searchDriverId(begin);
                        UevSpeed toCheck = new UevSpeed(0, this.currentVehicule.getCleVehicule(), begin, end, 99, 99, max, 0, input == null ? null : input.getNumeroCarte(), 0);
                        toReturn.add(toCheck);
                        TimsLogger.debug("VuPg1.getOverSpeed# exc\u00e8s de " + ConversionTime.dateToString(begin, "dd/MM/YYYY HH:mm:ss") + " (" + second + " sec) / " + ConversionTime.dateToString(end, "dd/MM/YYYY HH:mm:ss") + " (" + y + " sec) => max constat\u00e9 " + max + " conducteur " + (input == null ? "?" : input.getNumeroCarte()));
                        begin = null;
                        max = 0;
                    }
                    ++offset;
                    ++y;
                }
                ++x;
            }
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#VuPG1.getOverSpeed()# End at " + offset);
            }
        }
        catch (Exception ex) {
            TimsLogger.debug("#VUGP1.getOverSpeed# speed structure error");
        }
        return toReturn;
    }
}

