/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.object;

import fr.pgh.conversion.ConversionTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.uev.object.FullCardNumberAndGeneration;
import transpo.system.uev.object.HolderName;
import transpo.system.uev.object.PreviousVehicleInformation;
import transpo.system.util.Fonctions;

public class VuCardRecord {
    public static final int RECORD_SIZE = 131;
    private HolderName cardHolder = null;
    private FullCardNumberAndGeneration card = null;
    private Date expiry = null;
    private Date insertion = null;
    private int odometerValueAtInsertion = 0;
    private int cardSlotNumber = 0;
    private Date withdraw = null;
    private int odometerValueAtWithdraw = 0;
    private PreviousVehicleInformation previousVehicle = null;
    private int manualInput = 0;

    public HolderName getCardHolder() {
        return this.cardHolder;
    }

    public void setCardHolder(HolderName cardHolder) {
        this.cardHolder = cardHolder;
    }

    public FullCardNumberAndGeneration getCard() {
        return this.card;
    }

    public void setCard(FullCardNumberAndGeneration card) {
        this.card = card;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Date expiry) {
        this.expiry = expiry;
    }

    public Date getInsertion() {
        return this.insertion;
    }

    public void setInsertion(Date insertion) {
        this.insertion = insertion;
    }

    public int getOdometerValueAtInsertion() {
        return this.odometerValueAtInsertion;
    }

    public void setOdometerValueAtInsertion(int odometerValueAtInsertion) {
        this.odometerValueAtInsertion = odometerValueAtInsertion;
    }

    public int getCardSlotNumber() {
        return this.cardSlotNumber;
    }

    public void setCardSlotNumber(int cardSlotNumber) {
        this.cardSlotNumber = cardSlotNumber;
    }

    public Date getWithdraw() {
        return this.withdraw;
    }

    public void setWithdraw(Date withdraw) {
        this.withdraw = withdraw;
    }

    public int getOdometerValueAtWithdraw() {
        return this.odometerValueAtWithdraw;
    }

    public void setOdometerValueAtWithdraw(int odometerValueAtWithdraw) {
        this.odometerValueAtWithdraw = odometerValueAtWithdraw;
    }

    public PreviousVehicleInformation getPreviousVehicle() {
        return this.previousVehicle;
    }

    public void setPreviousVehicle(PreviousVehicleInformation previousVehicle) {
        this.previousVehicle = previousVehicle;
    }

    public int getManualInput() {
        return this.manualInput;
    }

    public void setManualInput(int manualInput) {
        this.manualInput = manualInput;
    }

    public VuCardRecord(byte[] toParse) {
        this.cardHolder = new HolderName(Arrays.copyOfRange(toParse, 0, 72));
        this.card = new FullCardNumberAndGeneration(Arrays.copyOfRange(toParse, 72, 91));
        this.expiry = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 91, 4));
        this.insertion = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 95, 4));
        this.odometerValueAtInsertion = Fonctions.bytesToInt(toParse, 99, 3);
        this.cardSlotNumber = Fonctions.bytesToInt(toParse, 102, 1);
        this.withdraw = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 103, 4));
        this.odometerValueAtWithdraw = Fonctions.bytesToInt(toParse, 107, 3);
        this.previousVehicle = new PreviousVehicleInformation(Arrays.copyOfRange(toParse, 110, 130));
        this.manualInput = Fonctions.bytesToInt(toParse, 130, 1);
    }

    public static ArrayList<VuCardRecord> parse(byte[] tmp) {
        int start = 0;
        ArrayList<VuCardRecord> toReturn = new ArrayList<VuCardRecord>();
        while (start < tmp.length) {
            VuCardRecord toAdd = new VuCardRecord(Arrays.copyOfRange(tmp, start, start + 131));
            toReturn.add(toAdd);
            toAdd.print();
            start += 131;
        }
        return toReturn;
    }

    private void print() {
        TimsLogger.debug(String.valueOf(this.card.toString()) + " from " + ConversionTime.dateToString(this.insertion, "dd/MM/yyyy HH:mm") + " (" + this.odometerValueAtInsertion + ") to " + ConversionTime.dateToString(this.withdraw, "dd/MM/yyyy HH:mm") + " (" + this.odometerValueAtWithdraw + ") previous " + this.previousVehicle.getVri().getVrn());
    }
}

