/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.object;

import fr.pgh.conversion.ConversionTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.uev.object.FullCardNumberAndGeneration;
import transpo.system.util.Fonctions;

public class VuCompanyLockData {
    public static final int RECORD_SIZE = 99;
    private Date begin = null;
    private Date end = null;
    private String name = null;
    private String address = null;
    private FullCardNumberAndGeneration card = null;

    public VuCompanyLockData(byte[] toParse) {
        this.begin = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 0, 4));
        this.end = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 4, 4));
        this.name = Fonctions.getStringFromBuffer(toParse, 8, 36, 1);
        this.address = Fonctions.getStringFromBuffer(toParse, 44, 36, 1);
        this.card = new FullCardNumberAndGeneration(Arrays.copyOfRange(toParse, 80, 99));
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public FullCardNumberAndGeneration getCard() {
        return this.card;
    }

    public void setCard(FullCardNumberAndGeneration card) {
        this.card = card;
    }

    public static int getRecordSize() {
        return 99;
    }

    public String toString() {
        return String.valueOf(ConversionTime.dateToStringFr(this.begin)) + " " + ConversionTime.dateToStringFr(this.end) + " => " + this.card;
    }

    public static ArrayList<VuCompanyLockData> parse(byte[] tmp) {
        int start = 0;
        ArrayList<VuCompanyLockData> toReturn = new ArrayList<VuCompanyLockData>();
        while (start < tmp.length) {
            VuCompanyLockData toAdd = new VuCompanyLockData(Arrays.copyOfRange(tmp, start, start + 99));
            TimsLogger.debug("VuCompanyLockData.parse# " + toAdd.toString());
            toReturn.add(toAdd);
            start += 99;
        }
        return toReturn;
    }
}

