/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.object;

import fr.pgh.conversion.ConversionTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import transpo.system.uev.object.FullCardNumberAndGeneration;
import transpo.system.util.Fonctions;

public class VuControlActivityData {
    public static final int RECORD_SIZE = 32;
    private int controlType = 0;
    private Date controlTime = null;
    private FullCardNumberAndGeneration controlCardNumber = null;
    private Date downloadPeriodBegin = null;
    private Date downloadPeriodEnd = null;

    public VuControlActivityData(byte[] toParse) {
        this.controlType = toParse[0];
        this.controlTime = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 1, 5));
        this.controlCardNumber = new FullCardNumberAndGeneration(Arrays.copyOfRange(toParse, 5, 24));
        this.downloadPeriodEnd = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 24, 4));
        this.downloadPeriodBegin = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 28, 4));
    }

    public int getControlType() {
        return this.controlType;
    }

    public void setControlType(int controlType) {
        this.controlType = controlType;
    }

    public Date getControlTime() {
        return this.controlTime;
    }

    public void setControlTime(Date controlTime) {
        this.controlTime = controlTime;
    }

    public FullCardNumberAndGeneration getControlCardNumber() {
        return this.controlCardNumber;
    }

    public void setControlCardNumber(FullCardNumberAndGeneration controlCardNumber) {
        this.controlCardNumber = controlCardNumber;
    }

    public Date getDownloadPeriodBegin() {
        return this.downloadPeriodBegin;
    }

    public void setDownloadPeriodBegin(Date downloadPeriodBegin) {
        this.downloadPeriodBegin = downloadPeriodBegin;
    }

    public Date getDownloadPeriodEnd() {
        return this.downloadPeriodEnd;
    }

    public void setDownloadPeriodEnd(Date downloadPeriodEnd) {
        this.downloadPeriodEnd = downloadPeriodEnd;
    }

    public static int getRecordSize() {
        return 32;
    }

    public static ArrayList<VuControlActivityData> parse(byte[] tmp) {
        int start = 0;
        ArrayList<VuControlActivityData> toReturn = new ArrayList<VuControlActivityData>();
        while (start < tmp.length) {
            VuControlActivityData toAdd = new VuControlActivityData(Arrays.copyOfRange(tmp, start, start + 32));
            toReturn.add(toAdd);
            start += 32;
        }
        return toReturn;
    }
}

