/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.object;

import fr.pgh.conversion.ConversionTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;

public class VuDetailedBlockSpeed {
    public static final int RECORD_SIZE = 64;
    private Date minut = null;
    byte[] speed = new byte[60];

    public VuDetailedBlockSpeed(byte[] toParse) {
        this.minut = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 0, 4));
        this.speed = Arrays.copyOfRange(toParse, 4, 64);
    }

    public Date getMinut() {
        return this.minut;
    }

    public void setMinut(Date minut) {
        this.minut = minut;
    }

    public byte[] getSpeed() {
        return this.speed;
    }

    public void setSpeed(byte[] speed) {
        this.speed = speed;
    }

    public void print() {
        String toPrint = "";
        int x = 0;
        while (x < this.getSpeed().length) {
            toPrint = String.valueOf(toPrint) + this.speed[x] + "/";
            ++x;
        }
        TimsLogger.debug("#Speed block# " + ConversionTime.dateToString(this.minut, "dd/MM HH:mm") + " -> " + toPrint);
    }

    public int getSpeedAt(int sec) {
        return Fonctions.bytesToInt(this.speed, sec, 1);
    }

    public static ArrayList<VuDetailedBlockSpeed> parse(byte[] tmp) {
        int start = 0;
        ArrayList<VuDetailedBlockSpeed> toReturn = new ArrayList<VuDetailedBlockSpeed>();
        while (start < tmp.length) {
            VuDetailedBlockSpeed toAdd = new VuDetailedBlockSpeed(Arrays.copyOfRange(tmp, start, start + 64));
            toReturn.add(toAdd);
            start += 64;
        }
        return toReturn;
    }
}

